<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-07-06)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\controllers\addon\clientarea;
use MGModule\DomainAndEmailForwarding as main;
use MGModule\DomainAndEmailForwarding\models\Log;
/**
 * Forward Email Controler
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @version 1.0.0
 */
class ForwardEmail extends DomainControler {

    
    public function isActive() {
        if(!isset($_REQUEST['id']))
            return false;
        $this->setDomainId($_REQUEST['id']);
        return $this->domain()->domainPricing()->domainSetting()->isEmailForwarding();
    }
    
    public function indexHTML($input,$vars = array()){
        $this->checkSubmodule();
        $this->checkEnabledHosting();
        $this->dnsZonePolicy();
        $this->adjustSidebar();
        $this->setDomainId($input['id']);
        $vars['nameserversToSet'] = $this->nameserverPolicy();
        $this->domainPolicy();

        $vars['features'] = $this->submodule()->getFeatures();
        $vars['domain'] = $this->domain()->toArray(false);
        return array(
            'tpl'   => 'forwardEmail'
            ,'vars' => $vars
        );
        
    }
    
    private function domainPolicy(){
        
        if(!$this->domain()->domainPricing()->domainSetting()->isEmailForwarding())
            throw new main\mgLibs\exceptions\System("No access to 'Email Forwards' for that domain.");
        
    }
    
    public function listJSON($input, $vars = array()) {

        $this->setDomainId($input['id']);
        $this->domainPolicy();
        
        $params = array("domain" => $this->domain()->toArray(false));
        $data= array();
        try{
            $values =   $this->submodule()->listEmailRedirects( $params);
            foreach($values as $row){
                $data[] = $this->_formatRow($row);
            }
        } catch (\Exception $ex) {
            Log::error(sprintf("Email Forwarder list failed '%s' - User ID: %s - Domain ID: %s\r\n" ,$ex->getMessage() , $_SESSION['uid'] , $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
        
        return array(
            'data' => $data
            , 'recordsTotal' => count($data)
            , 'recordsFiltered' => count($data) 
        );

    }
    
    public function listEmailsJSON($input, $vars = array()) {

        $this->setDomainId($input['id']);
        $this->domainPolicy();
        
        $params = array("domain" => $this->domain()->toArray(false));
        $data= array();
        try{
            $values =   $this->submodule()->listEmailSingleRedirects($params);
            foreach($values as $row){
                $data[] = $this->_formatRow($row);
            }
        } catch (\Exception $ex) {
            Log::error(sprintf("Email Forwarder list failed '%s' - User ID: %s - Domain ID: %s\r\n" ,$ex->getMessage() , $_SESSION['uid'] , $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
        
        return array(
            'data' => $data
            , 'recordsTotal' => count($data)
            , 'recordsFiltered' => count($data) 
        );

    }
    
    private function _formatRow($row){
        return array(
            $row['dest'],
            $row['forward'],
            main\mgLibs\Smarty::I()->view("actionRow", array("row"=> $row))
        );
    }
    
    public function createJSON($input, $vars = array()) {
        
        $this->setDomainId($input['id']);
        $this->domainPolicy();
        
        $params = array("domain" => $this->domain()->toArray(false),
                       "forward" => $input['forward']
                  );
        try{
            $msg = $this->submodule()->createEmailRedirect($params);
            var_dump( $msg);
            if (is_string($msg))
                throw new \Exception ($msg);
            Log::success(sprintf("Email Forwarder has been created - User ID: %s - Domain ID: %s\r\n" ,$_SESSION['uid'] , $this->domain()->getId()));
            return array("success" => main\mgLibs\Lang::T( 'New Domain Forwarder created successfully') );
        } catch (\Exception $ex) {
            var_dump($ex);
            Log::error(sprintf("Email Forwarder creating failed '%s' - User ID: %s - Domain ID: %s\r\n" ,$ex->getMessage() , $_SESSION['uid'] , $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }
    
    public function createSingleEmailJSON($input, $vars = array()) {
        
        $this->setDomainId($input['id']);
        $this->domainPolicy();
        
        $params = array("domain" => $this->domain()->toArray(false),
                       "forward" => $input['forward']
                  );
        try{
            $msg = $this->submodule()->createEmailSingleRedirect($params);
            var_dump( $msg);
            if (is_string($msg))
                throw new \Exception ($msg);
            Log::success(sprintf("Email Forwarder has been created - User ID: %s - Domain ID: %s\r\n" ,$_SESSION['uid'] , $this->domain()->getId()));
            return array("success" => main\mgLibs\Lang::T( 'New Email Forwarder created successfully') );
        } catch (\Exception $ex) {
            var_dump($ex);
            Log::error(sprintf("Email Forwarder creating failed '%s' - User ID: %s - Domain ID: %s\r\n" ,$ex->getMessage() , $_SESSION['uid'] , $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }
    
    
    
    public function deleteJSON($input, $vars = array()) {
        
        $this->setDomainId($input['id']);
        $this->domainPolicy();
        $params = array("domain" => $this->domain()->toArray(false),
                       "forward" => $input['forward']
                  );
        try{
            if (filter_var($input['forward']['dest'], FILTER_VALIDATE_EMAIL)) {
                $msg = $this->submodule()->deleteEmailSingleRedirect($params);
            } else {
                $msg = $this->submodule()->deleteEmailRedirect($params);
            }
            if (is_string($msg))
                throw new \Exception ($msg);
            Log::success(sprintf("Email Forwarder has been deleted - User ID: %s - Domain ID: %s\r\n" ,$_SESSION['uid'] , $this->domain()->getId()));
            return array("success" => main\mgLibs\Lang::absoluteT( 'The Domain Forwarder has been deleted successfully') );
        } catch (\Exception $ex) {
            Log::error(sprintf("Email Forwarder deleting failed '%s' - User ID: %s - Domain ID: %s\r\n" ,$ex->getMessage() , $_SESSION['uid'] , $this->domain()->getId()));
            return array("error" => main\mgLibs\Lang::absoluteT("Module error: ") . $ex->getMessage());
        }
    }
    
    
    
}
