{include file="$template/pageheader.tpl" title=$LANG.invoices desc=$LANG.invoicesintro}
{include file="$template/includes/tablelist.tpl" tableName="InvoicesList" filterColumn="4" noSortColumns="5"}
<script type="text/javascript">
    jQuery(document).ready( function ()
    {
        var table = jQuery('#tableInvoicesList').removeClass('hidden').DataTable();
        {if $orderby == 'default'}
            table.order([4, 'desc'], [2, 'asc']);
        {elseif $orderby == 'invoicenum'}
            table.order(0, '{$sort}');
        {elseif $orderby == 'date'}
            table.order(1, '{$sort}');
        {elseif $orderby == 'duedate'}
            table.order(2, '{$sort}');
        {elseif $orderby == 'total'}
            table.order(3, '{$sort}');
        {elseif $orderby == 'status'}
            table.order(4, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').addClass('hidden');
    });
</script>


<div class="table-container clearfix">
    <div class="panel panel-default">
    <div class="panel-heading clearfix"> {include file="$template/includes/sidebar.tpl" sidebar=$primarySidebar}</div>
    <table id="tableInvoicesList" class="table table-list hidden">
        <thead>
            <tr>
                <th>Invoice ID</th>
                <th class="hidden-sm hidden-xs">Transaction No</th>
                <th class="hidden-xs">Client Namen</th>
                <th class="hidden-sm hidden-xs">Amount</th>
                <th>{$LANG.invoicesstatus}</th>
                <th>Date</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            {foreach key=num item=$transaction from=$transactions}
                <tr>
                    <td><a href="viewinvoice.php?id={$transaction->invoice_id}">{$transaction->invoice_id}</a>

                    <ul class="cell-inner-list visible-sm visible-xs small">
                    <li><span class="item-title">{$LANG.invoicestotal}: </span>{$transaction->transaction_amount}</li>
                    <li><span class="item-title">Transaction date: </span>{$transaction->created_at}</li>                                       
                    <li class="hidden-sm"><span class="item-title">{$LANG->invoicesdatedue}: </span>{$transaction->created_at}</li>
                    </ul>
                    </td>

                    <td class="hidden-sm hidden-xs"><span class="hidden">{$transaction->transaction_ref}</span>{$transaction->transaction_ref}</td>
                    <td class="hidden-xs">{$transaction->firstname} {$transaction->lastname}</td>
                    <td class="hidden-sm hidden-xs">{$transaction->transaction_amount}</td>
                    <td><span class="label label-{$transaction->transaction_status}">{$transaction->transaction_status}</span></td>
                    <td><span class="label label-{$transaction->transaction_status}">{$transaction->created_at}</span></td>
                    <td class="text-right"><button class="do-requery" data-trans_ref="{$transaction->transaction_ref}" class="btn btn-default"> Query
                    <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                        </button>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
        <p><i class="fa fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>	
    </div>

</div>
{literal}
<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click",".do-requery",function(e){
            var selection = $(this);
            var trans_ref = $(this).data('trans_ref');
            console.log(trans_ref);
            $(this).html("<span class='fa fa-spinner fa-spin' aria-hidden='true'></span>");
            $.post('https://domains.upperlink.ng/clients/modules/gateways/callback/interswitchnew_api.php',{'trans_ref':trans_ref},function(response){
                console.log(selection);
                
                selection.html(response.message);
            },'json');
        })
    })
</script>
{/literal}


