jQuery(document).ready(function() {

    /**
     * Code will loop through each element that has the class markdown-editor and
     * enable the Markdown editor.
     */
    var count = 0,
        editorName = 'clientMDE',
        counter = 0;
    jQuery(".markdown-editor").each(function( index ) {
        count++;
        var autoSaveName = jQuery(this).data('auto-save-name'),
            footerId = jQuery(this).attr('id') + '-footer';
        if (typeof autoSaveName == "undefined") {
            autoSaveName = 'client_area';
        }
        window[editorName + count.toString()] = jQuery(this).markdown(
        {
            footer: '<div id="' + footerId + '" class="markdown-editor-status"></div>',
            autofocus: false,
            savable: false,
            resize: 'vertical',
            iconlibrary: 'fa',
            language: locale,
            onShow: function(e){
                var content = '',
                    save_enabled = false;
                if(typeof(Storage) !== "undefined") {
                    // Code for localStorage/sessionStorage.
                    content = localStorage.getItem(autoSaveName);
                    save_enabled = true;
                    if (content && typeof(content) !== "undefined") {
                        e.setContent(content);
                    }
                }
                jQuery("#" + footerId).html(parseMdeFooter(content, save_enabled, saved));
            },
            onChange: function(e){
                var content = e.getContent(),
                    save_enabled = false;
                if(typeof(Storage) !== "undefined") {
                    counter = 3;
                    save_enabled = true;
                    localStorage.setItem(autoSaveName, content);
                    doCountdown();
                }
                jQuery("#" + footerId).html(parseMdeFooter(content, save_enabled));
            },
            onPreview: function(e){
                var originalContent = e.getContent(),
                    parsedContent;

                jQuery.ajax({
                    url: 'clientarea.php',
                    async: false,
                    data: {token: csrfToken, action: 'parseMarkdown', content: originalContent},
                    dataType: 'json',
                    success: function (data) {
                        parsedContent = data;
                    }
                });

                return parsedContent.body ? parsedContent.body : '';
            },
            additionalButtons: [
                [{
                    name: "groupCustom",
                    data: [{
                        name: "cmdHelp",
                        title: "Help",
                        hotkey: "Ctrl+F1",
                        btnClass: "btn open-modal",
                        icon: {
                            glyph: 'glyphicons glyphicons-question-sign',
                            fa: 'fa fa-question-circle',
                            'fa-3': 'icon-question-sign'
                        },
                        callback: function(e) {
                            e.$editor.removeClass("md-fullscreen-mode");
                        }
                    }]
                }]
            ],
            hiddenButtons: [
                'cmdImage'
            ]
        });
        jQuery('button[data-handler="bootstrap-markdown-cmdHelp"]')
            .attr('data-modal-title', markdownGuide)
            .attr('href', 'submitticket.php?action=markdown');

        jQuery(this).closest("form").bind({
            submit: function() {
                if(typeof(Storage) !== "undefined") {
                    localStorage.removeItem(autoSaveName);
                }
            }
        });
    });

    // Email verification
    jQuery('#btnResendVerificationEmail').click(function() {
        jQuery.post('clientarea.php',
            {
                'token': csrfToken,
                'action': 'resendVerificationEmail'
            }).done(function(data) {
                jQuery('#btnResendVerificationEmail').html('Email Sent').prop('disabled', true);
            });
    });

    /**
     * Parse the content to populate the markdown editor footer.
     *
     * @param {string} content
     * @param {bool} auto_save
     * @param {string} [saveText]
     * @returns {string}
     */
    function parseMdeFooter(content, auto_save, saveText)
    {
        saveText = saveText || saving;
        var pattern = /[a-zA-Z0-9_\u0392-\u03c9]+|[\u4E00-\u9FFF\u3400-\u4dbf\uf900-\ufaff\u3040-\u309f\uac00-\ud7af]+/g,
            m = [],
            word_count = 0,
            line_count = 0;
        if (content) {
            m = content.match(pattern);
            line_count = content.split(/\\r\\n|\\r|\\n/).length;
        }
        for(var i = 0; i < m.length; i++) {
            if(m[i].charCodeAt(0) >= 0x4E00) {
                word_count += m[i].length;
            } else {
                word_count += 1;
            }
        }
        return '<div class="small-font">lines: ' + line_count
            + '&nbsp;&nbsp;&nbsp;words: ' + word_count + ''
            + (auto_save ? '&nbsp;&nbsp;&nbsp;<span class="markdown-save">' + saveText + '</span>' : '')
            + '</div>';
    }

    /**
     * Countdown the save timeout. When zero, the span will update to show saved.
     */
    function doCountdown()
    {
        if (counter >= 0) {
            if (counter == 0) {
                jQuery("span.markdown-save").html(saved);
            }
            counter--;
            setTimeout(doCountdown, 1000);
        }
    }

    // Two-Factor Activation Process Modal Handler.
    var frmTwoFactorActivation = jQuery('input[name=2fasetup]').parent('form');
    frmTwoFactorActivation.submit(function(e) {
        e.preventDefault();
        openModal(frmTwoFactorActivation.attr('action'), frmTwoFactorActivation.serialize(), 'Loading...');
    });

    jQuery('#frmPayment').find('#btnSubmit').on('click', function(){
        jQuery(this).find('span').toggleClass('hidden');
    });
    // SSL Manage Action Button.
jQuery('.btn-resend-approver-email').click(function () {
    jQuery.post(
        jQuery(this).data('url'),
        {
            addonId: jQuery(this).data('addonid'),
            serviceId: jQuery(this).data('serviceid'),
        },
        function(data) {
            if (data.success == true) {
                jQuery('.alert-table-ssl-manage').addClass('alert-success').text('Approver Email Resent').removeClass('hidden');
            } else {
                jQuery('.alert-table-ssl-manage').addClass('alert-danger').text('Error: ' + data.message).removeClass('hidden');
            }
        }
    );
});
});

// Default catch for all other popovers
jQuery('[data-toggle="popover"]').popover({
    html: true
});

// Logic to dismiss popovers on click outside
jQuery('body').on('click', function (e) {
    jQuery('[data-toggle="popover"]').each(function () {
        if (!jQuery(this).is(e.target) && jQuery(this).has(e.target).length === 0 && jQuery('.popover').has(e.target).length === 0) {
            jQuery(this).popover('hide');
        }
    });
});

  // Checkboxes Toggle
  // ===============================

  function toggleCheckboxes(classname) {
    jQuery("."+classname).attr('checked',!jQuery("."+classname+":first").is(':checked'));
  }

  // Disable Field Class
  // ===============================

  function disableFields(classname,disable) {
    if (disable) jQuery("."+classname).attr("disabled","disabled");
    else jQuery("."+classname).removeAttr("disabled");
  }

/**
 * Used to toggle display of editable billing address fields.
 */
function editBillingAddress() {
    jQuery("#billingAddressSummary").hide();
    jQuery(".cc-billing-address").hide().removeClass('hidden').fadeIn();
  }


/**
 * Show new credit card input fields.
 */
function showNewCardInputFields() {
    if (jQuery(".cc-details").hasClass("hidden")) {
        jQuery(".cc-details").hide().removeClass("hidden");
    }
    jQuery(".cc-details").slideDown();
    jQuery("#btnEditBillingAddress").removeAttr("disabled");
}

  /**
  * Hide new credit card input fields.
  */
  function hideNewCardInputFields() {
    jQuery(".cc-billing-address").slideUp();
    jQuery(".cc-details").slideUp();
    jQuery("#btnEditBillingAddress").attr("disabled", "disabled");
    if (jQuery("#billingAddressSummary").hasClass('hidden')) {
      jQuery("#billingAddressSummary").hide().removeClass('hidden').slideDown();
    } else {
      jQuery("#billingAddressSummary").slideDown();
    }
  }

  // Open Centered Popup
  // ===============================

  function popupWindow(addr,popname,w,h,features) {
    var winl = (screen.width-w)/2;
    var wint = (screen.height-h)/2;
    if (winl < 0) winl = 0;
    if (wint < 0) wint = 0;
    var settings = 'height=' + h + ',';
    settings += 'width=' + w + ',';
    settings += 'top=' + wint + ',';
    settings += 'left=' + winl + ',';
    settings += features;
    win = window.open(addr,popname,settings);
    win.window.focus();
  }

  // Count Active Notifications
  // ===============================
  jQuery(function() {
    jQuery(".noti").text(jQuery("#noti li").length-1)
  });

  // Support Tickets
  // ===============================

  function extraTicketAttachment() {
    jQuery("#fileuploads").append('<p><div class="input-group"><span class="input-group-btn"><span class="btn btn-default btn-sm btn-file"><span class="glyphicon glyphicon-folder-open"></span> <input type="file" name="attachments[]" multiple=""></span></span><input type="text" class="form-control input-sm" readonly=""></div></p>');

    jQuery(document).ready( function() {
      jQuery('.btn-file :file').on('fileselect', function(event, numFiles, label) {

        var input = jQuery(this).parents('.input-group').find(':text'),
        log = numFiles > 1 ? numFiles + ' files selected' : label;

        if( input.length ) {
          input.val(log);
        } else {
          if( log ) alert(log);
        }

      });
    });
  }

  function rating_hover(id) {
    var selrating=id.split('_');
    for(var i=1; i<=5; i++){
      if(i<=selrating[1]) document.getElementById(selrating[0]+'_'+i).childNodes[0].className="glyphicon glyphicon-star";
      if(i>selrating[1]) document.getElementById(selrating[0]+'_'+i).childNodes[0].className="glyphicon glyphicon-star-empty";
    }
  }
  function rating_leave(id){
    for(var i=1; i<=5; i++){
      document.getElementById(id+'_'+i).childNodes[0].className="glyphicon glyphicon-star-empty";
    }
  }
  function rating_select(tid,c,id){
    window.location='viewticket.php?tid='+tid+'&c='+c+'&rating='+id;
  }

  // Server List
  // ===============================

  jQuery(function(){
    jQuery('.server-list').tooltip({
      selector: "a",
      container: "body",
      placement: "top"
    });


    jQuery( "img.menu-avatar[data-name], img.user-avatar[data-name]" ).each(function( index ) {

      var em = "hasgavatar";
      var r;
      var gavatar;
      var elem = jQuery( this );
      gavatar = jQuery( this ).attr('alt');
      em = em+jQuery( this ).attr('alt');

      r = getCookie(em);

      if(r){
        if (r==0) setboxavatar(elem);
      }else{
        jQuery.ajax({
          url: window.location,
          data: 'checkgavatar='+gavatar,
          context: document.body
        }).done(function() {
          var r = getCookie(em);
          if (r==0) setboxavatar(elem);
        });
      }
    });


  });

  function setboxavatar(elem){
    var n = jQuery(elem).attr('data-name');
    var bg = jQuery(elem).attr('data-bg');
    jQuery(elem).replaceWith( "<span class='menu-avatar menu-avatar-box' style='background-color:"+bg+"'>"+n+"</span>");
  }

  function getCookie(name) {
    var matches = document.cookie.match(new RegExp(
      "(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
    ));
    return matches ? decodeURIComponent(matches[1]) : null;
  }

  function getavatar(){
    jQuery.ajax({
      url: "test.html",
      context: document.body
    }).done(function() {
      jQuery( this ).addClass( "done" );
    });
  }

  // Enable Switches for Checkboxes
  if (jQuery.prototype.bootstrapSwitch) {
    jQuery(".toggle-switch-success").bootstrapSwitch({
      onColor: 'success'
    });
  }

  // Handle Single Sign-On Toggle Setting
  jQuery("#inputAllowSso").on('switchChange.bootstrapSwitch', function(event, isChecked) {
    if (isChecked) {
      jQuery("#ssoStatusTextEnabled").removeClass('hidden').show();
      jQuery("#ssoStatusTextDisabled").hide();
    } else {
      jQuery("#ssoStatusTextDisabled").removeClass('hidden').show();
      jQuery("#ssoStatusTextEnabled").hide();
    }
    jQuery.post("clientarea.php", jQuery("#frmSingleSignOn").serialize());
  });


    // Single Sign-On call for Product/Service
    jQuery('.btn-service-sso').on('click', function(e) {
        e.preventDefault();
        var button = jQuery(this);

        var form = button.parents('form');

        if (form.length == 0) {
            form = button.find('form');
        }
        if (form.hasClass('disabled')) {
            return;
        }

        button.find('.loading').removeClass('hidden').show().end()
            .attr('disabled', 'disabled');
        jQuery.post(
            window.location.href,
            form.serialize(),
            function (data) {
                button.find('.loading').hide().end().removeAttr('disabled');
                form.find('.login-feedback').html('');
                if (data.error) {
                    form.find('.login-feedback').html(data.error);
                }
                if (data.redirect !== undefined && data.redirect.substr(0, 7) === 'window|') {
                    window.open(data.redirect.substr(7), '_blank');
                }
            },
            'json'
        );
    });
    jQuery('.btn-sidebar-form-submit').on('click', function(e) {
        e.preventDefault();
        jQuery(this).find('.loading').removeClass('hidden').show().end()
            .attr('disabled', 'disabled');

        var form = jQuery(this).parents('form');

        if (form.length == 0) {
            form = jQuery(this).find('form');
        }

        if (form.length !== 0 && form.hasClass('disabled') === false) {
            form.submit();
        } else {
            jQuery(this).find('.loading').hide().end().removeAttr('disabled');
        }
    });

    // Email verification close
    jQuery('.email-verification .btn.close').click(function(e) {
        e.preventDefault();
        jQuery.post('clientarea.php', 'action=dismiss-email-banner&token=' + csrfToken);
        jQuery('.email-verification').hide();
    });

    // Back to top animated scroll
    jQuery('.back-to-top').click(function(e) {
        e.preventDefault();
        jQuery('body,html').animate({scrollTop: 0}, 500);
    });

    // Prevent page scroll on language choose click
    jQuery('.choose-language').click(function(e) {
        e.preventDefault();
    });



// Sub-Account Activation Toggle
    jQuery("#inputSubaccountActivate").click(function () {
        if (jQuery("#inputSubaccountActivate:checked").val() != null) {
            jQuery("#subacct-container").removeClass('hidden');
        } else {
            jQuery("#subacct-container").addClass('hidden');
        }
    });

/**
 * Add domain renewal to shopping cart.
 *
 * @param {number} renewalID    The domain ID to be added
 * @param {domElement} selfThis The object triggering the add
 */
function addRenewalToCart(renewalID, selfThis) {
    jQuery("#domainRow" + renewalID).attr('disabled', 'disabled');
    jQuery("#domainRow" + renewalID).find("select,button").attr("disabled", "disabled");
    jQuery(selfThis).html('<span class="glyphicon glyphicon-shopping-cart"></span> Adding...');
    var renewalPeriod = jQuery("#renewalPeriod" + renewalID).val();
    jQuery.post(
      "clientarea.php",
      "addRenewalToCart=1&token=" + csrfToken + "&renewID="+ renewalID + "&period=" + renewalPeriod,
      function( data ) {
        jQuery("#cartItemCount").html(((jQuery("#cartItemCount").html() * 1) + 1));
        jQuery(selfThis).html('<span class="glyphicon glyphicon-shopping-cart"></span> Added');
        jQuery("#btnCheckout").fadeIn();
      }
    );
  }


  // Mass Domain Management Bulk Action Handling
  jQuery(".setBulkAction").click(function(event) {
    event.preventDefault();
    var id = jQuery(this).attr('id').replace("Link", "");
    if (jQuery("#" + id).length != 0) {
      var action = jQuery("#domainForm").attr("action");
      jQuery("#domainForm").attr("action", action + "#" + id);
    }
    jQuery("#bulkaction").val(id);
    jQuery("#domainForm").submit();
  });

  /**
  * Submit the first form that exists within a given container.
  *
  * @param {string} containerId The ID name of the container
  */
  function autoSubmitFormByContainer(containerId) {
    jQuery("#" + containerId).find("form:first").submit();
  }

  /**
  * Submit default whois info and disable custom fields.
  *
  * @param {string} regType The contact registration type
  */
  function useDefaultWhois(regType) {
    jQuery("." + regType.substr(0, regType.length - 1) + "customwhois").attr("disabled", true);
    jQuery("." + regType.substr(0, regType.length - 1) + "defaultwhois").attr("disabled", false);
    jQuery('#' + regType.substr(0, regType.length - 1) + '1').attr("checked", "checked");
  }

  /**
  * Submit custom fields and disable default whois info.
  *
  * @param {string} regType The contact registration type
  */
  function useCustomWhois(regType) {
    jQuery("." + regType.substr(0, regType.length - 1) + "customwhois").attr("disabled", false);
    jQuery("." + regType.substr(0, regType.length - 1) + "defaultwhois").attr("disabled", true);
    jQuery('#' + regType.substr(0, regType.length - 1) + '2').attr("checked", "checked");
  }


  /**
  * Confirm that the contact should be deleted and redirect.
  *
  * @param {string} confirmQuestion
  * @param {int} contactId
  */
  function deleteContact(confirmQuestion, contactId)
  {
    if (confirm(confirmQuestion)) {
      window.location = 'clientarea.php?action=contacts&delete=true&id=' + contactId + '&token=' + csrfToken;
    }
  }
