<?php
/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-06-30)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\service;
use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of IntegrationModule
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 */
abstract class IntegrationModule implements IntegrationAdapter {

    private $className;
    protected  $options;

    public function getClassName() {
        return $this->className;
    }

    public function setClassName($className) {
        $this->className = $className;
        return $this;
    }
    
    public function loadOptions(main\models\SubmoduleConfiguration $submoduleConfiguration){
        $options = $submoduleConfiguration->getOptions();
        if(empty($options))
            return;
        foreach($this->getOptions() as $fieldName => $option){
            $this->options[$fieldName] = $options[$fieldName];
            if($option['type']=="password")
                $this->options[$fieldName] = decrypt($this->options[$fieldName]);
        }
    }
    
    public function getOptionValue($fieldName){
        return isset($this->options[$fieldName]) ? $this->options[$fieldName]: null ;
    }

    function toArray(){
        $className = get_called_class();
        
        $fields = get_class_vars($className);

        foreach(explode('\\', $className) as $className);
        
        $data = array();
        
        foreach($fields as $name => $default)
        {
            if(isset($this->{$name}))
            {
                $data[$name] = $this->{$name};
            }
        }

        return $data;
    }
    
    
    
}
