<?php

namespace MGModule\DomainAndEmailForwarding;
use MGModule\DomainAndEmailForwarding as main;

/**
 * Module Configuration
 *
 * @author Michal Czech <michael@modulesgarden.com>
 */
class Configuration extends main\mgLibs\process\AbstractConfiguration{
    //todo 
    public $debug = false;
    
    public $systemName = 'DomainAndEmailForwarding';
    public $shortName = 'Domain & Email Forward';
    public $name = 'Domain & Email Forwarding';
    
    public $description = 'Activate the module and let your clients forward emails and domains within configured in the addon external server.<br>For more info visit our <a href="http://www.docs.modulesgarden.com/Domain_And_Email_Forwarding_For_WHMCS" style="color: #4169E1;" target="_blank">Wiki</a>.';
    
    public $clientareaName = 'Domain & Email Forwarding';

    public $encryptHash = 'uUc1Y8cWxDOAzlq11lBwelqzo6PGMTA0dbHaKQ109psefoJgIFMOgmReKCZbpCYpDSnrtfjmCIUyplaBJaUh40auDALprOHtj1g92ZRBS6S94IbZWaeZRYkG1f81h6qLMYEOr016RurCnmodFCWdMkTqrlVBvH249gzXPduKQVXpN9hooComaRPY5jZD6s8GdfR5E_BNP3v8Ui8RrdqMPST_8quMW48LhHY88xCvSWwDNjkC2tCAaK67Id2NjzIdoNTHUMISRg81nHX8ZGcbP74mxixo_ASd8YoWnDCAs8yiT4t0PwKRO_y3C1kDo69Nxz1YYt4tY1VzOD_DFBulAA5NCJLfogroo';
        
    public $version = '1.0.0';
    
    public $author = '<a href="http://www.modulesgarden.com" targer="_blank">ModulesGarden</a>';

    public $tablePrefix = 'mgdomforw_';
        
    public $modelRegister = array(
        'models\Log'
    );
    
    function __construct() {
        $file = dirname(__FILE__).DIRECTORY_SEPARATOR.'moduleVersion.php';
        if(file_exists($file)) {
            include $file;
            $this->version = $moduleVersion;
            //$this->description .= '<br/>For more info visit our Wiki: <a href="'.$moduleWikiUrl.'">'.$moduleWikiUrl.'</a>';
        }
        /*
        models\whmcs\product\configOptions\Repository::setConfiguration(array(
            
        ));

        $product = new models\whmcs\product\product($id);*/
    }
            
    function getAddonMenu(){
        return array(
            'home'        => array(
                'icon'          =>  'glyphicon glyphicon-home'
            ),
            'domains'  =>  array
            (
                'icon'          =>  'glyphicon glyphicon-globe',
            ),
            'settings'        => array( 
                'icon'          =>  'glyphicon glyphicon-cog',
                'submenu'           =>  array(
                     "general" =>  array(),
                     "modules" =>  array(),
                 )
            ),
            'logs'  =>  array
            (
                'icon'          =>  'glyphicon glyphicon-th-list',
            ),
            'documentation' => array (
              'icon' => 'glyphicon glyphicon-book',
              'externalUrl' => "http://www.docs.modulesgarden.com/Domain_And_Email_Forwarding_For_WHMCS"
            )
        );
    }
    
    function getClientMenu(){
        return array(
//            'home'        => array(
//                'icon'          =>  'glyphicon glyphicon-home'
//            ),
            'forwardDomains'        => array(
                'icon'          =>  'fa-share'
            ),
            'forwardEmail'        => array(
                'icon'          =>  'fa-envelope'
            ),
            
            
        );
    }
    
    function getClientSidebar(){
        return array(
            'actions' => array(
                'uri' => '#',
                'order' => 3,
                'icon' => 'fa-plus',
                'children' => array(
                    'renew' => array(
                        'uri' => 'clientarea.php?action=domains#tabRenew',
                        'icon' => 'fa-refresh fa-fw',
                        'order' => 1,
                    ),
                    'register' => array(
                        'uri' => 'cart.php?a=add&domain=register',
                        'icon' => 'fa-globe fa-fw',
                        'order' => 2,
                    ),
                    'transfer' => array(
                        'uri' => 'cart.php?a=add&domain=transfer',
                        'icon' => 'fa-share fa-fw',
                        'order' => 3,
                    )
                )
            ),
            'manage' => array(
                'uri' => '#',
                'order' => 1,
                'icon' => 'fa-gear',
                'withId' => true,
                'children' => array(
                    'overview' => array(
                        'uri' => 'clientarea.php?action=domaindetails&id=%d#tabOverview',
                        'order' => 1,
                    ),
                    'autoRenew' => array(
                        'uri' => 'clientarea.php?action=domaindetails&id=%d#tabAutorenew',
                        'order' => 2,
                    ),
                    'nameservers' => array(
                        'uri' => 'clientarea.php?action=domaindetails&id=%d#tabNameservers',
                        'order' => 3,
                    ),
                    'addons' => array(
                        'uri' => 'clientarea.php?action=domaindetails&id=%d#tabAddons',
                        'order' => 4,
                    ),
                )
            )
        );
    }
    
    function getServerMenu(){
        return array(
            'configuration' => array(
                'icon'          =>  'glyphicon glyphicon-cog'
            )
        );
    }
    
    /**
     * Return names of WHMCS product config fields
     * required if you want to use default WHMCS product configuration
     * max 20 fields
     * 
     * if you want to use own product configuration use example 
     * /models/customWHMCS/product to define own configuration model
     * 
     * @return type
     */
    public function getServerWHMCSConfig() {
        return array(
            'text_name'
            ,'text_name2'
            ,'checkbox_name'
            ,'onoff'
            ,'pass'
            ,'some_option'
            ,'some_option2'
            ,'radio_field'
        );
    }
    
    public function getAddonWHMCSConfig(){
        return array();
    }
    
    /**
     * Run When Module Install
     * 
     * @author Michal Czech <michael@modulesgarden.com>
     */
    function activate(){
        
        //Configuration
        $table = models\Registry::tableName();
        mgLibs\MySQL\Query::query("          
            CREATE TABLE IF NOT EXISTS `{$table}` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `setting` varchar(200) NOT NULL,
              `value` text,
              PRIMARY KEY (`id`),
              UNIQUE KEY `setting` (`setting`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;
          ");

        $table = models\DomainSetting::tableName();
        mgLibs\MySQL\Query::query("          
            CREATE TABLE IF NOT EXISTS `{$table}` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `domain_pricing_id` int(11) NOT NULL,
              `url_forwarding` tinyint(1) DEFAULT 0,
              `email_forwarding` tinyint(1) DEFAULT 0,
              `subfolders_redirect` tinyint(1) DEFAULT 0,
              `submodule` int(11) NOT NULL,
              `nameserver1` varchar(200) NOT NULL,
              `nameserver2` varchar(200) NOT NULL,
              `nameserver3` varchar(200) NOT NULL,
              `nameserver4` varchar(200) NOT NULL,
              `nameserver5` varchar(200) NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;
          ");
                    
        $table = models\SubmoduleConfiguration::tableName();
        mgLibs\MySQL\Query::query("          
            CREATE TABLE IF NOT EXISTS `{$table}` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `name` varchar(200) NOT NULL,
              `class` varchar(200) NOT NULL,
              `version` varchar(10) NOT NULL,
              `active` tinyint(1) DEFAULT 0,
              `options` text,
              PRIMARY KEY (`id`),
              UNIQUE KEY `name` (`name`),
              UNIQUE KEY `class` (`class`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;
          ");
            
        $constructor = new mgLibs\models\TableContructor(__NAMESPACE__,$this->tablePrefix);
        $constructor->createDBModels($this->modelRegister);
        
        return true;
    }
    
    function deactivate() {
        $table = models\DomainSetting::tableName();
        mgLibs\MySQL\Query::query("DROP TABLE `{$table}`");
        
        return array(
            'status'=>'success'
        );
    }
    
    function upgrade($version) {
//        if(version_compare($version, '1.2.0', '<=')) {
//        }
        
    }
    
}