<?php
//phpinfo();
/**
 * Upperlink Interswitch WebPay Payment Gateway Module 
 *
 * Payment Gateway modules allow you to integrate payment solutions with the
 * WHMCS platform.
 *
 * This sample file demonstrates how a payment gateway module for WHMCS should
 * be structured and all supported functionality it can contain.
 *
 * Within the module itself, all functions must be prefixed with the module
 * filename, followed by an underscore, and then the function name. For this
 * example file, the filename is "gatewaymodule" and therefore all functions
 * begin "gatewaymodule_".
 *
 * If your module or third party API does not support a given function, you
 * should not define that function within your module. Only the _config
 * function is required.
 *
 * For more information, please refer to the online documentation.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Developer_Docs
 *
 * @copyright Copyright (c) WHMCS Limited 2015
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */

use Illuminate\Database\Capsule\Manager as Capsule;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Define module related meta data.
 *
 * Values returned here are used to determine module related capabilities and
 * settings.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Meta_Data_Parameters
 *
 * @return array
 */
function interswitchwebpay_MetaData()
{
    return array(
        'DisplayName' => 'Interswitch WebPay Gateway Module',
        'APIVersion' => '1.0', // Use API Version 1.1
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

/**
 * Define gateway configuration options.
 *
 * The fields you define here determine the configuration options that are
 * presented to administrator users when activating and configuring your
 * payment gateway module for use.
 *
 * Supported field types include:
 * * text
 * * password
 * * yesno
 * * dropdown
 * * radio
 * * textarea
 *
 * Examples of each field type and their possible configuration parameters are
 * provided in the sample function below.
 *
 * @return array
 */
function interswitchwebpay_config()
{
    return array(
        // the friendly display name for a payment gateway should be
        // defined here for backwards compatibility
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'Interswitch WebPay',
        ),
        // a text field type allows for single line text input
        'merchantID' => array(
            'FriendlyName' => 'Merchant ID',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Enter your merchant ID here',
        ),
        // a text field type allows for single line text input
        'cadPID' => array(
            'FriendlyName' => 'CADPID',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Enter your CADPID here',
        ),
        // a text field type allows for single line text input
        'tranType' => array(
            'FriendlyName' => 'TRANTYPE',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '00',
            'Description' => 'Enter your TRANTYPE here',
        ),
        // the yesno field type displays a single checkbox option
        'testMode' => array(
            'FriendlyName' => 'Test Mode',
            'Type' => 'yesno',
            'Description' => 'Tick to enable test mode',
        ),
    );
}

/**
 * Payment link.
 *
 * Required by third party payment gateway modules only.
 *
 * Defines the HTML output displayed on an invoice. Typically consists of an
 * HTML form that will take the user to the payment gateway endpoint.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see http://docs.whmcs.com/Payment_Gateway_Module_Parameters
 *
 * @return string
 */
function interswitchwebpay_link($params)
{
    // Gateway Configuration Parameters
    $merchantId = $params['merchantID'];
    $cadPid = $params['cadPID'];
    $tranType = $params['tranType'];
    $testMode = $params['testMode'];
    $url = 'https://webpay.interswitchng.com/webpay/purchase.aspx';
    $demoUrl = 'https://sandbox.interswitchng.com/webpay/pay';
    
   

    /** Log this transaction */
    // Check if the tbltransactions table exists
    if(!Capsule::schema()->hasTable('tbltransactions')) {
       try {
            Capsule::schema()->create(
                'tbltransactions',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->integer('client_id')->unsigned();
                    $table->string('invoice_id', 50);
                    $table->string('transaction_ref', 50);
                    $table->string('response_code', 10)->nullable();
                    $table->string('response_description', 10)->nullable();
                    $table->string('first_data_response_description')->nullable();
                    $table->decimal('transaction_rate', 10, 5)->unsigned();
                    $table->string('transaction_description')->nullable();
                    $table->string('transaction_currency', 50);
                    $table->decimal('transaction_amount', 20, 5)->unsigned();
                    $table->string('first_data_transaction_tag', 50)->nullable();
                    $table->enum('transaction_status', ['pending', 'paid', 'failed'])->default("pending");
                    $table->string('payment_method', 50);
                    $table->string('whmcs_version', 10);
                    $table->timestamps();
                }
            );
        } catch (\Exception $e) {
            echo "Unable to create transactions table, please contact the administrator: {$e->getMessage()}";
        }
    }
    
    

    // Invoice Parameters
    $amount_multiplier = 100;
    $invoiceId = $params['invoiceid'];
    $description = $params["description"];
    $amount = $params['amount'] * $amount_multiplier;
    $db_amount = $params['amount'];
    $currencyCode = $params['currency'];
    $transaction_ref = "WHM" . interswitchWebPayGenerateTransactionNumber();

    // System Parameters
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];

    //log the transaction in the database 
    try {
       $id = Capsule::table('tbltransactions')->insert([ "client_id" => $params['clientdetails']['userid'],
                                                         "invoice_id" => $invoiceId,
                                                         "transaction_ref" => $transaction_ref,
                                                         "transaction_description" => $description,
                                                         "transaction_currency" => $currencyCode,
                                                         "transaction_amount" => $db_amount,
                                                         "payment_method" => $moduleName,
                                                         "whmcs_version" => $whmcsVersion,
                                                         "created_at" => date('Y-m-d H:i:s'),
                                                         "updated_at" => date('Y-m-d H:i:s')
                                                      ]);
    }
    catch(\Exception $e) {
        echo "Unable to log transaction details, please try again: {$e->getMessage()}";
    }

    //log parameters
    try {
        file_put_contents('./debug/whmcs-error-trace.txt', 'Form Parameters: ' . json_encode($params) . "\n", FILE_APPEND);
    }
    catch(Exception $e) {
        echo "Unable to log form parameters";
    }

    $postfields = array();
    $postfields['CADPID'] = $cadPid;
    $postfields['MERTID'] = $merchantId;
    $postfields['TXNREF'] = $transaction_ref;
    $postfields['AMT'] = $amount;
    $meth = 'get';
    $postfields['TRANTYPE'] = $tranType;
    if($testMode == 'on'){
    	$postfields = array();
    	$url = $demoUrl;
    	$meth = 'post';
    	$postfields['product_id'] = '6205';
    	$postfields['amount'] = $amount;
    	$postfields['currency'] = '566';
    	$postfields['site_redirect_url'] = 'https://domains.upperlink.ng/clients/modules/gateways/callback/interswitchwebpay.php';
    	$postfields['site_name'] = 'https://domains.upperlink.ng';
    	$postfields['cust_id'] = $cadPid;
    	$postfields['txn_ref'] = $transaction_ref;
    	$postfields['pay_item_id'] = '101';
    	$hash_key = 'D3D1D05AFE42AD50818167EAC73C109168A0F108F32645C8B59E897FA930DA44F9230910DAC9E20641823799A107A02068F7BC0F4CC41D2952E249552255710F';
	$hash_v = $postfields['txn_ref'].$postfields['product_id'].$postfields['pay_item_id'].$postfields['amount'].$postfields['site_redirect_url'].$hash_key;
    	$postfields['hash'] = hash('sha512',$hash_v);
    }
    $langPayNow = "Pay with WebPay";

    $htmlOutput = '<form method="'.$meth.'" action="' . $url . '">';
    $htmlOutput .= '<input type="hidden" name="hash_v" value="' .$hash_v. '" />';
    foreach ($postfields as $k => $v) {
        $htmlOutput .= '<input type="hidden" name="' . $k . '" value="' .$v. '" />';
    }
    /*
    <input name="product_id" type="hidden" value="XX" />
    <input name="amount" type="hidden" value="XXXXXXX" />
    <input name="currency" type="hidden" value="566" />
    <input name="site_redirect_url" type="hidden" value="http://abc.com/new_page/getresponse.aspx?echo=" />
    <input name="site_name" type="hidden" value="http://www.abc.com" />
    <input name="cust_id" type="hidden" value="a" />
    <input name="cust_id_desc" type="hidden" value="Value Name" />
    <input name="cust_name" type="hidden" value="Name <B>Surname</B>" />
    <input name="cust_name_desc" type="hidden" value="Full name" />
    <input name="txn_ref" type="hidden" value=" XXXAFTXXX”" />
    <input name="pay_item_id" type="hidden" value="XXXXX" />
    <input name="pay_item_name" type="hidden" value="Name of Fees/Payment" />
    <input name="hash" type="hidden" value="BB292DF9268F05CB9CBBC5E0C13CC1B13ACA34DC" />
*/
    $htmlOutput .= '<input class="btn btn-danger btn-block" type="submit" value="' . $langPayNow . '" />';
    $htmlOutput .= '</form>';

    return $htmlOutput;
}

/**
 * Generate Transaction
 *
 * @return string
 * @param int $randStringLength
 * 
 */
function interswitchWebPayGenerateTransactionNumber($randStringLength = 12) {
    $timestring = microtime();
    $secondsSinceEpoch=(integer) substr($timestring, strrpos($timestring, " "), 100);
    $microseconds=(double) $timestring;
    $seed = mt_rand(0,1000000000) + 10000000 * $microseconds + $secondsSinceEpoch;
    mt_srand($seed);
    $randstring = "";

    for($i=0; $i < $randStringLength; $i++){
    $randstring .= mt_rand(0, 9);
    }
    
    //return code
    return (string) $randstring;
}
