{if $inactive}
{include file="$template/pageheader.tpl" title=$LANG.affiliatestitle}
<div class="alert alert-warning">
  <p>{$LANG.affiliatesdisabled}</p>
</div>
{else}

<div class="row">
  <div class="col-md-4">
    <div class="well well-lg clearfix">
      {$LANG.affiliatesvisitorsreferred}
      <span class="label label-success pull-right flip">{$visitors}</span>
    </div>
  </div>
  <div class="col-md-4">
    <div class="well well-lg clearfix">
      {$LANG.affiliatessignups}
      <span class="label label-success pull-right flip">{$signups}</span>
    </div>
  </div>
    <div class="col-md-4">
    <div class="well well-lg clearfix">
      {$LANG.affiliatesconversionrate}
      <span class="label label-info pull-right flip">{$conversionrate}%</span>
    </div>
  </div>
</div>

<div class="well">
         <blockquote class="page-information hidden">
          <p>{$LANG.affiliatesrealtime}</p>
        </blockquote>      
<div class="row">
  <div class="col-md-12">
    <h3>{$LANG.affiliatesreferallink}</h3>
    <div class="form-group">
      <input type="text" value="{$referrallink}" class="input-lg form-control" />
    </div>
  </div>
</div>
<div class="row">


  <div class="col-md-6">
    <div class="well well-lg clearfix">
     {$LANG.affiliatescommissionspending}
      <span class="label label-default pull-right flip">{$pendingcommissions}</span>
    </div>
  </div>


  <div class="col-md-6">
    <div class="well well-lg clearfix">
      {$LANG.affiliatescommissionsavailable}
      <span class="label label-success pull-right flip">{$balance}</span>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-6 col-md-offset-6">
    <div class="well well-lg clearfix">
     {$LANG.affiliateswithdrawn}
      <span class="label label-info pull-right flip">{$withdrawn}</span>
    </div>
  </div>
</div>

</div>

{if $withdrawrequestsent}
<div class="alert alert-success">
  <p>{$LANG.affiliateswithdrawalrequestsuccessful}</p>
</div>
{else}
{if $withdrawlevel}
<input type="button" class="btn btn-default" value="{$LANG.affiliatesrequestwithdrawal}" onclick="window.location='{$smarty.server.PHP_SELF}?action=withdrawrequest'" />
{/if}
{/if}

<div class="well">
<h3>{$LANG.affiliatesreferals}</h3>
{include file="$template/includes/tablelist.tpl" tableName="AffiliatesList"}
    <script type="text/javascript">
        jQuery(document).ready( function ()
        {
            var table = jQuery('#tableAffiliatesList').removeClass('hidden').DataTable();
            {if $orderby == 'regdate'}
                table.order(0, '{$sort}');
            {elseif $orderby == 'product'}
                table.order(1, '{$sort}');
            {elseif $orderby == 'amount'}
                table.order(2, '{$sort}');
            {elseif $orderby == 'status'}
                table.order(4, '{$sort}');
            {/if}
            table.draw();
            jQuery('#tableLoading').addClass('hidden');
        });
    </script>

<div class="panel panel-default">
<div class="panel-heading clearfix">
  <div class="filter_top panel panel-default panel-actions view-filter-btns" >
      <div class="elemetsholder ">
        <a class="btn btn-link btn-xs" href="#" ></a>
      </div>

  </div>

</div>
<table class="table table-striped table-framed" id="tableAffiliatesList">
  <thead>
    <tr>
                    <th class="hidden-sm hidden-xs">{$LANG.affiliatessignupdate}</th>
                    <th>{$LANG.orderproduct}</th>
                    <th class="hidden-sm hidden-xs">{$LANG.affiliatesamount}</th>
                    <th class="hidden-xs">{$LANG.affiliatescommission}</th>
                    <th>{$LANG.affiliatesstatus}</th>
    </tr>
  </thead>
            {foreach from=$referrals item=referral}
                <tr>
                    <td class="hidden-sm hidden-xs">{$referral.date}</td>
                    <td>{$referral.service}

                    <ul class="cell-inner-list visible-sm visible-xs small">
                    <li><span class="item-title">{$LANG.affiliatessignupdate}: </span>{$referral.date}</li>
                    <li><span class="item-title">{$LANG.affiliatesamount}: </span>{$referral.amountdesc}</li>
                    <li class="hidden-sm"><span class="item-title">{$LANG.affiliatescommission}: </span>{$referral.commission}</li>
                    </ul>

      </td>
      <td data-order="{$referral.amountnum}" class="hidden-sm hidden-xs">{$referral.amountdesc}</td>
      <td data-order="{$referral.commissionnum}" class="hidden-xs">{$referral.commission}</td>
      <td><span class='label status status-{$referral.rawstatus|strtolower}'>{$referral.status}</span></td>
    </tr>
    {/foreach}
  </table>
  <div class="text-center" id="tableLoading">
    <p><i class="fa fa-spinner fa-spin"></i> {$LANG.loading}</p>
  </div>
</div>
</div>
{if $affiliatelinkscode}
{include file="$template/subheader.tpl" title=$LANG.affiliateslinktous}
<div class="textcenter">
  {$affiliatelinkscode}
</div>
{/if}

{/if}
