<?php
/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-06-29)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\submodules;

use MGModule\DomainAndEmailForwarding\service\IntegrationModule;
use MGModule\DomainAndEmailForwarding\service\IntegrationAdapter;
use MGModule\DomainAndEmailForwarding\service\InterfaceDomainForward;
use MGModule\DomainAndEmailForwarding\service\InterfaceEmailSingleForward;
use MGModule\DomainAndEmailForwarding\service\InterfaceDomainEmailForward;
/**
 * CPanel Submodule. Allow you to automatically set domain forwarding into cPanel.
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @version 1.0.0
 */
class CPanel extends IntegrationModule implements IntegrationAdapter, InterfaceDomainEmailForward, InterfaceEmailSingleForward, InterfaceDomainForward {
    
    /**
     * Module Options
     * @var array
     */
    protected  $options;
    
    private $api;
    
    public function getName() {
        return 'cPanel';
    }
    
    public function getDescription() {
        
        return 'Leverage cPanel server to handle domain and email forwarding created by your clients.';
    }
    
    public function getVersion(){
        return '1.0.0';
    }
    
    public function getFeatures(){
        return array(
            "domainForward" => array(
                "type" => true,
                "rdwww" => true,
                "wildcard" => true,
            ),
            "emailForward" => array(
                "domain" => true,
                "single" => true,
            )
        );
    }
    
    public function getTypes(){
        return array(
            'pernament' => 'lbl_pernament',
            'temp' => 'lbl_temporary',
        );
    }
    
    public function getOptions() {
        return array(
                   "host"=> array (
                       "type"=> "text",
                       "label" => "Host",
                       "default" => "",
                       "description" => "Provide your cPanel URL, i.e: example.com",
                        'labelcolWidth' => 3,
                        'colWidth' => 9,
                       ),
                   "username"=> array (
                       "type"=> "text",
                       "label" => "WHM Username",
                       "default" => "",
                       "description" => "Enter your username here",
                        'labelcolWidth' => 3,
                        'colWidth' => 9,
                       ),
                    "password"=> array (
                       "type"=> "password",
                       "label" => "WHM Password",
                       "default" => "",
                       "description" => "Enter your password here",
                        'labelcolWidth' => 3,
                        'colWidth' => 8,
                       ),
                    "ssl"=> array (
                        "type" => 'checkbox',
                        "label" => "SSL Mode",
                        'options' => array('on'),
                        'value' => array(),
                        'default' => 1,
                        'labelcolWidth' => 3,
                        'colWidth' => 9,
                       ),
                    "reseller"=> array (
                       "type"=> "text",
                       "label" => "Account",
                       "default" => "",
                       "description" => "Enter your account username here",
                       "enableTooltip" => true,
                        'labelcolWidth' => 3,
                        'colWidth' => 9,
                       ),
            );
    }

    public function activate() {
        return true;
    }

    public function deactivate() {
        
    }

    public function testConnection(array $options) {

        $this->options = $options;      
        $this->api()->api2->Mime->listredirects(array(), 'sobj');
        
        return true;        
        
    }
    
    /**
     * 
     * @return \MGModule\DomainAndEmailForwarding\submodules\cpanel\Api
     */
    private function api(){
        if(!empty($this->api))
            return $this->api;
        return  $this->api = new cpanel\Api($this->options['host'], $this->options['username'], $this->options['password'], $this->options['reseller'], isset($this->options['ssl'])?true:false);
    }

    public function createDomainRedirect($params) {
        $result = $this->api()->api2->Park->listparkeddomains(array(), 'sobj');
        $isParked =false;
        foreach($result->cpanelresult->data as $data){
            if($data->domain ==$params['forward']['domain']){
                $isParked =true;
                break;
            }
        }

        if(!$isParked){
            $args = array(
                'domain'     => $params['forward']['domain'],
            );
            $res = $this->api()->api2->Park->park( $args, 'sobj');
        }
        
        if(!$this->getStatusParkDomain($params['domain']['domain'])) {
            $this->parkDomain($params['domain']['domain']);
        }
        
        $args = array(
            'src'      => $params['forward']['src'],
            'type'     => $params['forward']['type'],
            'url'      => $params['forward']['url'],
            'domain'   => $params['forward']['domain'],
            'wildcard' => (int) $params['forward']['wildcard'],
            'rdwww'    => $params['forward']['rdwww']
        );
        
        $this->api()->api1->Mime->add_redirect($args,'sobj'); 
        
    }

    public function deleteDomainRedirect($params) {
        
        $args = array(
            'src'     => $params['forward']['sourceurl'],
            'domain'  => $params['domain']['domain'],
            'docroot' => $params['forward']['docroot'],
        );
        $this->api()->api1->Mime->del_redirect($args); 
        
        
    }

    public function listDomainRedirects($params) {
        
        $result = $this->api()->api2->Mime->listredirects(array(), 'sobj');
        $values= array();
        foreach($result->cpanelresult->data as $data){
            if($data->domain !=$params['domain']['domain'])
                continue;
            $values[] = (array) $data;
        }
        return $values;
        
    }

    public function createEmailRedirect($params) {
        if(!$this->getStatusParkDomain($params['domain']['domain'])) {
            $this->parkDomain($params['domain']['domain']);
        }
        $args = array(
            'domain'     => $params['domain']['domain'],
            'destdomain' => $params['forward']['destdomain'],
        );

        $this->api()->api1->Email->adddforward($args);
        
    }

    public function deleteEmailRedirect($params) {

        $args = array(
            'domain'     => $params['domain']['domain']
        );
        
        $this->api()->api1->Email->deldforward($args);
    }

    public function listEmailRedirects($params) {
                
        $result = $this->api()->api2->Email->listdomainforwards(array(), 'sobj');
        $values= array();
        foreach($result->cpanelresult->data as $data){
            if($data->dest != $params['domain']['domain'])
                continue;
            $values[] = (array) $data;
        }
        return $values;
        
    }
    
    public function createEmailSingleRedirect($params) {
        if(!$this->getStatusParkDomain($params['domain']['domain'])) {
            $this->parkDomain($params['domain']['domain']);
        }
        $args = array(
            'domain'     => $params['domain']['domain'],
            'email'      => $params['forward']['source_email'],
            'fwdopt'     => 'fwd',
            'fwdemail'   => $params['forward']['dest_email'],
        );

        $this->api()->api2->Email->addforward($args,'obj');
        
    }

    public function deleteEmailSingleRedirect($params) {

        $args = array('email' => $params['forward']['dest'], 'emaildest' => $params['forward']['sourceurl']);
        $this->api()->api2->Email->delforward($args);
    }

    public function listEmailSingleRedirects($params) {
                
        $result = $this->api()->api2->Email->listforwards(array(), 'sobj');
                
        $values= array();

        foreach($result->cpanelresult->data as $data){
            list(,$domain) = explode('@', $data->dest);
            if($domain != $params['domain']['domain']) {
                continue;
            }
            $values[] = (array) $data;
        }
        return $values;
        
    }
    
    public function parkDomain($domain) {

        $args = array(
            'domain'     => $domain,
        );
        $this->api()->api2->Park->park( $args, 'sobj');
    }

    public function unparkDomain($domain) {

        $args = array(
            'domain'     => $domain,
        );
        $this->api()->api2->Park->unpark( $args, 'sobj');

    }
    
    public function getStatusParkDomain($domain) {
        $result = $this->api()->api2->Park->listparkeddomains(array(), 'sobj');
        $isParked = false;
        

        foreach($result->cpanelresult->data as $data){
            if($data->domain == $domain){
                $isParked = true;
                break;
            }
        }

        return $isParked;
    }
    
}