<?php

/* * ********************************************************************
 * DiscountCenter product developed. (2016-06-23)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\models\whmcs;
use MGModule\DomainAndEmailForwarding as main;
/**
 * Description of Domain
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 * @Table(name=tbldomains,preventUpdate,prefixed=false)
 */
class Domain extends main\mgLibs\models\Orm{
    /**
     * @Column()
     * @var int
     */
    protected $id;
    
    /**
     * @Column(name=userid,as=userId)
     * @var int
     */
    protected $userId;
    
    /**
     * @Column(name=orderid,as=orderId)
     * @var int
     */
    protected $orderId;
    
    /**
     * @Column(name=type)
     * @var string
     */
    protected $type;
    
    /**
     * @Column(name=registrationdate,as=registrationDate)
     * @var string
     */
    protected $registrationDate;
    
    /**
     * @Column(name=domain)
     * @var string
     */
    protected $domain;
    
    /**
     * @Column(name=firstpaymentamount,as=firstPaymentAmount)
     * @var string
     */
    protected $firstPaymentAmount;
    
    /**
     * @Column(name=recurringAmount,as=recurringAmount)
     * @var string
     */
    protected $recurringAmount;
     	
    /**
     * @Column(name=registrar)
     * @var string
     */
    protected $registrar;
    
    /**
     * @Column(name=registrationperiod,as=registrationPeriod)
     * @var string
     */
    protected $registrationPeriod;
    
    /**
     * @Column(name=expirydate,as=expiryDate)
     * @var string
     */
    protected $expiryDate;
    
     /**
     * @Column(name=status)
     * @var string
     */
    protected $status;
    
    private $domainPricing;

    public function getId() {
        return $this->id;
    }

    public function getUserId() {
        return $this->userId;
    }

    public function getOrderId() {
        return $this->orderId;
    }

    public function getType() {
        return $this->type;
    }

    public function getRegistrationDate() {
        return $this->registrationDate;
    }

    public function getDomain() {
        return $this->domain;
    }

    public function getFirstPaymentAmount() {
        return $this->firstPaymentAmount;
    }

    public function getRecurringAmount() {
        return $this->recurringAmount;
    }

    public function getRegistrar() {
        return $this->registrar;
    }

    public function getRegistrationPeriod() {
        return $this->registrationPeriod;
    }

    public function getStatus() {
        return $this->status;
    }

    public function setId($id) {
        $this->id = $id;
        return $this;
    }

    public function setUserId($userId) {
        $this->userId = $userId;
        return $this;
    }

    public function setOrderId($orderId) {
        $this->orderId = $orderId;
        return $this;
    }

    public function setType($type) {
        $this->type = $type;
        return $this;
    }

    public function setRegistrationDate($registrationDate) {
        $this->registrationDate = $registrationDate;
        return $this;
    }

    public function setDomain($domain) {
        $this->domain = $domain;
        return $this;
    }

    public function setFirstPaymentAmount($firstPaymentAmount) {
        $this->firstPaymentAmount = $firstPaymentAmount;
        return $this;
    }

    public function setRecurringAmount($recurringAmount) {
        $this->recurringAmount = $recurringAmount;
        return $this;
    }

    public function setRegistrar($registrar) {
        $this->registrar = $registrar;
        return $this;
    }

    public function setRegistrationPeriod($registrationPeriod) {
        $this->registrationPeriod = $registrationPeriod;
        return $this;
    }

    public function setStatus($status) {
        $this->status = $status;
        return $this;
    }

    public function getTLD(){
        
         $ex   = explode(".", $this->getDomain());
         return str_replace($ex['0'], "", $this->getDomain());
            
    }
    
    /**
     * 
     * @return DomainPricing
     */
    public function domainPricing(){
        
        if(!empty($this->domainPricing))
            return $this->domainPricing;
        
        $rep = new main\repository\whmcs\DomainPricingRepository();
        $rep->whereExtension($this->getTLD());
                
        return  $this->domainPricing = $rep->fetchOne();
        
        
    }

    public function getExpiryDate() {
        return $this->expiryDate;
    }

    public function setExpiryDate($expiryDate) {
        $this->expiryDate = $expiryDate;
        return $this;
    }


}
