<?php

namespace MGModule\DomainAndEmailForwarding\controllers\addon\clientarea;
use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of home
 *
 * @author Michal Czech <michael@modulesgarden.com>
 */
class Home extends main\mgLibs\process\AbstractController{
    
    public function indexHTML($input,$vars = array()){
        @ob_clean();
        header('Location: clientarea.php?action=domains');
        exit();
        return array(
           'tpl'    => 'home'
           ,'vars'  => $vars
        );
        
    }
    
    public function listJSON($input, $vars = array()) {
        
        $repository = new main\repository\whmcs\DomainRepository();
        $repository->whereStatus(array('Active'))
                   ->andUser($_SESSION['uid']);
        $data = array();
        foreach($repository->fetch() as $entity){
            
            if($entity->domainPricing()->domainSetting()->isUrlForwarding() || $entity->domainPricing()->domainSetting()->isEmailForwarding())
                $data[] = $this->_formatRow($entity);
        }
        return array(
            'data' => $data
            , 'recordsTotal' => count($data)
            , 'recordsFiltered' => count($data) 
        );
        
    }
    
    private function _formatRow(main\models\whmcs\Domain $entity){
        
        $urlForwarding = $entity->domainPricing()->domainSetting()->isUrlForwarding();
        $emailForwarding = $entity->domainPricing()->domainSetting()->isEmailForwarding();
        
        return array(
            'DT_RowData' => array('id' => $entity->getId()),
            $entity->getDomain(),
            fromMySQLDate($entity->getRegistrationDate()),
            fromMySQLDate($entity->getExpiryDate()),
            main\mgLibs\Smarty::I()->view('rowAction', array("entity" => $entity ->toArray(false), "urlForwarding" => $urlForwarding, "emailForwarding" => $emailForwarding ))
        );
        
    }

}
