<?php

/* * ********************************************************************
 * DiscountCenter product developed. (2015-11-16)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\controllers\addon\admin;
use MGModule\DomainAndEmailForwarding as main;


/**
 * Domains management (park/unpark/check)
 *
 * @author Mateusz Tomaszewski <mateusz.to@modulesgarden.com>
 */
class Domains {
    
    function indexHTML($input, $vars = array()){

        return array(
            'tpl'   => 'domains'
            ,'vars' => $vars
        );
        
    }
    
    public function  listJSON($input, $vars = array()){

        $repository = new main\repository\whmcs\DomainRepository();
        $repository->whereStatus(array('Active'));
        $data = array();
           
        foreach($repository->get() as $domain){
            try { 
                $domainSettings = new main\repository\DomainSettingRepository();
                $domainSettings->whereDomainPricingId($domain->domainPricing()->getId() )
                            ->andURLforwardingOrEmailForwarding();
            } catch (\Exception $e) {
                continue;
            }
            
            $enabledHosting = false;
            
            $manager = new main\service\IntegrationManager();
            $activeSubmodule = $manager->getActiveModule($domain);
           
            if(\WHMCS\Service\Service::where('domain', $domain->getDomain())->count() > 0) {
                $registry = main\models\Registry::getInstance();
                $enabledHosting = $registry->getEnabledHosting();
            }
            try {
            $zone = main\mgLibs\MySQL\Query::query("SELECT name FROM dns_manager2_zone WHERE name LIKE '{$domain->getDomain()}'")->fetch();
            } catch (\Exception $e) {
                
            } 
            if($domainSettings->count() > 0 && !$enabledHosting && $activeSubmodule && empty($zone)) {       
                $data[] = $this->_formatLogRow($domain);
            }
            
        }
        return array(
            'data' => $data
            , 'recordsTotal' => count($data)
            , 'recordsFiltered' => count($data) 
        );
        
    }
    
    private function _formatLogRow(main\models\whmcs\Domain $domain){
        
        return array(
            'DT_RowData' => array('id' => $domain->getId()),
            $domain->getId(),
            $domain->getDomain(),
            main\mgLibs\Smarty::I()->view('rowAction', array('id' => $domain->getId()))

        );
        
    }
    
    public function deleteJSON($input, $vars = array()){
        
        $log = new main\models\Log($input['id']);
        $log ->delete();
        return array(
            'deleted' => $this->_formatLogRow($log),
            'success' => sprintf(main\mgLibs\lang::T('Log %s has been deleted'),$log->getId())
            );
        
    }
    
    public function deleteAllLogsJSON($input, $vars = array()){
        $repository =  new main\repository\LogRepository();
        $repository->truncate();
        return array('success' => sprintf(main\mgLibs\lang::T('Logs have been deleted')));
    }
    
    public function parkJSON($input, $vars = array()){
        $domain = new main\models\whmcs\Domain($input['id']);
        $manager = new main\service\IntegrationManager();
        $submodule = $manager->getActiveModule($domain);

        $isParked = $submodule->getStatusParkDomain($domain->getDomain());
  
        if($isParked) {
            return array('error' => sprintf(main\mgLibs\lang::T('Domain is already parked')));
        }
        
        $submodule->parkDomain($domain->getDomain());
        
        return array('success' => sprintf(main\mgLibs\lang::T('Domain has been parked')));
    }
    
    public function unparkJSON($input, $vars = array()){
        $domain = new main\models\whmcs\Domain($input['id']);
        $manager = new main\service\IntegrationManager();
        $submodule = $manager->getActiveModule($domain);
        
        $submodule->unparkDomain($domain->getDomain());
        return array('success' => sprintf(main\mgLibs\lang::T('Domain has been unparked')));
    }
    
    public function checkStatusJSON($input, $vars = array()){
        $domain = new main\models\whmcs\Domain($input['id']);
        $manager = new main\service\IntegrationManager();
        $submodule = $manager->getActiveModule($domain);
        
        $isParked = $submodule->getStatusParkDomain($domain->getDomain());
        if($isParked) {
            return array('success' => sprintf(main\mgLibs\lang::T('Domain is parked')));
        } else {
            return array('success' => sprintf(main\mgLibs\lang::T('Domain is unparked')));
        }
        
    }
}
