<h3>{$_lang.projectsoverview}</h3>
<hr>

{include file="$template/includes/tablelist.tpl" tableName="ProjectsList" noSortColumns="5"}

<div class="table-container clearfix">
    <table id="tableProjectsList" class="table table-list">
        <thead>
            <tr>
                <th>{$_lang.title}</th>
                <th class="hidden-sm hidden-xs">{$_lang.created}</th>
                <th class="hidden-xs">{$_lang.duedate}</th>
                <th>{$_lang.status}</th>
                <th class="hidden-sm hidden-xs">{$_lang.lastmodified}</th>
                <th class="hidden-xs"></th>
            </tr>
        </thead>
        <tbody>
            {foreach from=$projects item=project}
                <tr>
                    <td><a href="?m=project_management&a=view&id={$project.id}">{$project.title}</a>

                    <ul class="cell-inner-list visible-sm visible-xs small">
                    <li><span class="item-title">{$_lang.lastmodified}: </span>{$project.lastmodified}</li>
                    <li><span class="item-title">{$_lang.created}: </span>{$project.created}</li>                                                            
                    <li class="hidden-sm"><span class="item-title">{$_lang.duedate}: </span>{$project.duedate}</li>
                    </ul>    
                    </td>
                    <td class="hidden-sm hidden-xs"><span class="hidden">{$project.normalisedCreated}</span>{$project.created}</td>
                    <td class="hidden-xs"><span class="hidden">{$project.normalisedDueDate}</span>{$project.duedate}</td>
                    <td><span class="label label-{$project.status|strtolower|replace:' ':''}">{$project.status}</span></td>
                    <td class="hidden-sm hidden-xs"><span class="hidden">{$project.normalisedLastModified}</span>{$project.lastmodified}</td>
                    <td class="text-right hidden-xs"><a class="btn btn-link" href="?m=project_management&a=view&id={$project.id}"><i class="fa fa-chevron-right fa-lg pull-right flip"></i></a>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
</div>
