<?php

use WHMCS\ClientArea;
use WHMCS\Database\Capsule;

define('CLIENTAREA', true);
//define('FORCESSL', true); // Uncomment to force the page to use https://

require __DIR__ . '/init.php';

$ca = new ClientArea();

$ca->setPageTitle('Pay with UPL Credit Wallet');

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb('upl-pay-by-wallet.php', 'UPL Credit Wallet');

$ca->initPage();

//$ca->requireLogin(); // Uncomment this line to require a login to access this page
// To assign variables to the template system use the following syntax.
// These can then be referenced using {$variablename} in the template.
//print_r($_REQUEST);
if(!empty($_POST)){
//print_r($_POST);
	$value = $postfields = $_POST;
	$ca->assign('variablename', $value);
}elseif(!empty($_REQUEST)){
	$value = $postfields = $_REQUEST;
	$ca->assign('variablename', $value);
}else{
	$value =  $_REQUEST;
	$ca->assign('variablename', $value);
	$postfields = $_REQUEST;
}
//----- put into hidden field ------------ //
$htmlOutput = "";
foreach ($postfields as $k => $v) {
    $htmlOutput .= '<input type="hidden" name="' . $k . '" value="' . $v . '" />';
}
$ca->assign('htmlOutput', $htmlOutput);

// Check login status
if ($ca->isLoggedIn()) {

    /**
     * User is logged in - put any code you like here
     *
     * Here's an example to get the currently logged in clients first name
     */
    // $clientName = Capsule::table('tblclients')
    //    ->where('id', '=', $ca->getUserID())->pluck('firstname');
    // 'pluck' was renamed within WHMCS 7.0.  Replace it with 'value' instead.
    // ->where('id', '=', $ca->getUserID())->value('firstname');
    // $ca->assign('clientname', $clientName);
    
    //---- get client details ------ //
    $client = Capsule::table('tblclients')
                    ->where('id', '=', $ca->getUserID())->get();
    $ca->assign('clientcredit', $client[0]->credit);
    $ca->assign('clientname', $client[0]->firstname);

    # Get Currency
    $Currency = Capsule::table('tblcurrencies')->where('id', $client[0]->currency)->get();
    $Currency = $Currency[0];
    $ca->assign('currency_prefix', $Currency->prefix);
    $ca->assign('currency_suffix', $Currency->suffix);
} else {

    // User is not logged in
    $ca->assign('clientname', 'Random User');
    header("Location: clientarea.php");
}

/**
 * Set a context for sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
Menu::addContext();

/**
 * Setup the primary and secondary sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
//Menu::primarySidebar('announcementList');
//Menu::secondarySidebar('announcementList');
# Define the template filename to be used without the .tpl extension

$ca->setTemplate('upl-pay-by-wallet');

$ca->output();
