<?php

# Logo
$logoFilename = 'placeholder.png';
if (file_exists(ROOTDIR . '/assets/img/logo.png')) {
    $logoFilename = 'logo.png';
} elseif (file_exists(ROOTDIR . '/assets/img/logo.jpg')) {
    $logoFilename = 'logo.jpg';
}
$pdf->Image(ROOTDIR . '/assets/img/' . $logoFilename, 15, 25, 75);

# Invoice Status
$pdf->SetXY(0, 0);
$pdf->SetFont($pdfFont, 'B', 28);
$pdf->SetTextColor(255);
$pdf->SetLineWidth(0.75);
$pdf->StartTransform();
$pdf->Rotate(-35, 100, 225);
if ($status == 'Draft') {
    $pdf->SetFillColor(200);
    $pdf->SetDrawColor(140);
} elseif ($status == 'Paid') {
    $pdf->SetFillColor(151, 223, 74);
    $pdf->SetDrawColor(110, 192, 70);
} elseif ($status == 'Cancelled') {
    $pdf->SetFillColor(200);
    $pdf->SetDrawColor(140);
} elseif ($status == 'Refunded') {
    $pdf->SetFillColor(131, 182, 218);
    $pdf->SetDrawColor(91, 136, 182);
} elseif ($status == 'Collections') {
    $pdf->SetFillColor(3, 3, 2);
    $pdf->SetDrawColor(127);
} else {
    $pdf->SetFillColor(223, 85, 74);
    $pdf->SetDrawColor(171, 49, 43);
}
$pdf->Cell(100, 18, strtoupper(Lang::trans('invoices' . strtolower($status))), 'TB', 0, 'C', '1');
$pdf->StopTransform();
$pdf->SetTextColor(0);

# Company Details
$pdf->SetXY(15, 42);
$pdf->SetFont($pdfFont, '', 13);
foreach ($companyaddress as $addressLine) {
    $pdf->Cell(180, 4, trim($addressLine), 0, 1, 'R');
    $pdf->SetFont($pdfFont, '', 9);
}
$pdf->Ln(5);

# Header Bar

/**
 * Invoice header
 *
 * You can optionally define a header/footer in a way that is repeated across page breaks.
 * For more information, see http://docs.whmcs.com/PDF_Invoice#Header.2FFooter
 */

$pdf->SetFont($pdfFont, 'B', 15);
$pdf->SetFillColor(239);
$pdf->Cell(0, 8, $pagetitle, 0, 1, 'L', '1');
$pdf->SetFont($pdfFont, '', 10);
$pdf->Cell(0, 6, Lang::trans('invoicesdatecreated') . ': ' . $datecreated, 0, 1, 'L', '1');
$pdf->Cell(0, 6, Lang::trans('invoicesdatedue') . ': ' . $duedate, 0, 1, 'L', '1');
$pdf->Ln(10);

$startpage = $pdf->GetPage();

# Clients Details
$addressypos = $pdf->GetY();
$pdf->SetFont($pdfFont, 'B', 10);
$pdf->Cell(0, 4, Lang::trans('invoicesinvoicedto'), 0, 1);
$pdf->SetFont($pdfFont, '', 9);
if ($clientsdetails["companyname"]) {
    $pdf->Cell(0, 4, $clientsdetails["companyname"], 0, 1, 'L');
    $pdf->Cell(0, 4, Lang::trans('invoicesattn') . ': ' . $clientsdetails["firstname"] . ' ' . $clientsdetails["lastname"], 0, 1, 'L');
} else {
    $pdf->Cell(0, 4, $clientsdetails["firstname"] . " " . $clientsdetails["lastname"], 0, 1, 'L');
}
$pdf->Cell(0, 4, $clientsdetails["address1"], 0, 1, 'L');
if ($clientsdetails["address2"]) {
    $pdf->Cell(0, 4, $clientsdetails["address2"], 0, 1, 'L');
}
$pdf->Cell(0, 4, $clientsdetails["city"] . ", " . $clientsdetails["state"] . ", " . $clientsdetails["postcode"], 0, 1, 'L');
$pdf->Cell(0, 4, $clientsdetails["country"], 0, 1, 'L');
if ($customfields) {
    $pdf->Ln();
    foreach ($customfields as $customfield) {
        $pdf->Cell(0, 4, $customfield['fieldname'] . ': ' . $customfield['value'], 0, 1, 'L');
    }
}
$pdf->Ln(10);

# Invoice Items
$tblhtml = '<table width="100%" bgcolor="#ccc" cellspacing="1" cellpadding="2" border="0">
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;text-align:center;">
        <td width="80%">' . Lang::trans('invoicesdescription') . '</td>
        <td width="20%">' . Lang::trans('quotelinetotal') . '</td>
    </tr>';
foreach ($invoiceitems as $item) {
    $tblhtml .= '
    <tr bgcolor="#fff">
        <td align="left">' . nl2br($item['description']) . '<br /></td>
        <td align="center">' . $item['amount'] . '</td>
    </tr>';
}
$tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td align="right">' . Lang::trans('invoicessubtotal') . '</td>
        <td align="center">' . $subtotal . '</td>
    </tr>';
if ($taxname) {
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td align="right">' . $taxrate . '% ' . $taxname . '</td>
        <td align="center">' . $tax . '</td>
    </tr>';
}
if ($taxname2) {
    $tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td align="right">' . $taxrate2 . '% ' . $taxname2 . '</td>
        <td align="center">' . $tax2 . '</td>
    </tr>';
}
$tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td align="right">' . Lang::trans('invoicescredit') . '</td>
        <td align="center">' . $credit . '</td>
    </tr>
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td align="right">' . Lang::trans('invoicestotal') . '</td>
        <td align="center">' . $total . '</td>
    </tr>
</table>';

$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(5);

# Transactions
$pdf->SetFont($pdfFont, 'B', 12);
$pdf->Cell(0, 4, Lang::trans('invoicestransactions'), 0, 1);

$pdf->Ln(5);

$pdf->SetFont($pdfFont, '', 9);

$tblhtml = '<table width="100%" bgcolor="#ccc" cellspacing="1" cellpadding="2" border="0">
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;text-align:center;">
        <td width="25%">' . Lang::trans('invoicestransdate') . '</td>
        <td width="25%">' . Lang::trans('invoicestransgateway') . '</td>
        <td width="30%">' . Lang::trans('invoicestransid') . '</td>
        <td width="20%">' . Lang::trans('invoicestransamount') . '</td>
    </tr>';

if (!count($transactions)) {
    $tblhtml .= '
    <tr bgcolor="#fff">
        <td colspan="4" align="center">' . Lang::trans('invoicestransnonefound') . '</td>
    </tr>';
} else {
    foreach ($transactions AS $trans) {
        $tblhtml .= '
        <tr bgcolor="#fff">
            <td align="center">' . $trans['date'] . '</td>
            <td align="center">' . $trans['gateway'] . '</td>
            <td align="center">' . $trans['transid'] . '</td>
            <td align="center">' . $trans['amount'] . '</td>
        </tr>';
    }
}
$tblhtml .= '
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td colspan="3" align="right">' . Lang::trans('invoicesbalance') . '</td>
        <td align="center">' . $balance . '</td>
    </tr>
</table>';

$pdf->writeHTML($tblhtml, true, false, false, false, '');

# Notes
if ($notes) {
    $pdf->Ln(5);
    $pdf->SetFont($pdfFont, '', 8);
    $pdf->MultiCell(170, 5, Lang::trans('invoicesnotes') . ': ' . $notes);
}

# Generation Date
$pdf->SetFont($pdfFont, '', 8);
$pdf->Ln(5);
$pdf->Cell(180, 4, Lang::trans('invoicepdfgenerated') . ' ' . getTodaysDate(1), '', '', 'C');

/**
 * Invoice footer
 */



 
 /**
 * Terms of service
 */
$pdf->AddPage();
$html = "";
$client_name = $clientsdetails["firstname"] . ' ' . $clientsdetails["lastname"];
$html = "<div class=\"\">
    <h2 class=\"modal-title\" id=\"myModalLabel\">A: REGISTRANT AGREEMENT</h2>
</div>
<div class=\"\">



    By clicking on the “I AGREE” button or a similar affirmation, or by acknowledging acceptance of these Terms and Conditions by any other method allowed by Upperlink, or by using or accessing the Domain Registration Services through any means permissible including, without limitation via a computer or a mobile application, <br>

<p>You, <strong>$client_name</strong>, acknowledge and agree that: <br>
(i) you have reviewed and understand these Terms and Conditions;  <br>
(ii) you agree to be legally bound by these Terms and Conditions; and  <br>
(iii) your use of the Domain, Hosting and any related products or services will be governed by these Terms and Conditions.
</p>
If you do not agree or are not willing to be bound by these terms and conditions, you should not click on the “I AGREE” button and should not seek to obtain or use the Services. <br />&nbsp;<br />

    \"You\" in this context refers to the Registered Name Holder of a Registered Name
    Upperlink refers to the Registrar

    <br />
    1. <strong>Domain Registration and Documentation</strong><br />
    You agree to adhere to the requirements of and provide all documentation for the registration of any closed domain listed in Schedule A to this Agreement. Failure to do so may result in deactivation, cancellation, suspension, transfer of the domain without liability to Upperlink.<br />
    .b) Intention to defraud Upperlink by making a false claim of failed transactions. An excessive request for refunds after a refund has already been made to an account, this may result in future denials of refunds. Failure to provide the required documentation for closed domains, misspelling of a domain registered, mere dissatisfaction with a domain name registered. Computer hardware and/or software failure (e.g., computer crash), including Internet connection, of the Upperlink customer. Upperlink refuses to accept fault for customer hardware/software issues and will not honor refunds associated with these issues.
    &nbsp;<br />

    2. <strong>Payments</strong><br />
    Upperlink shall not activate any Registered Name unless it is satisfied that it has received a reasonable assurance of payment of its registration fee. For this purpose, a charge to your credit card, general commercial terms extended to creditworthy customers, or other mechanism providing a similar level of assurance of payment shall be sufficient, provided that the obligation to pay becomes final and non-revocable by you upon activation of the registration. <br />&nbsp;<br />

    3. <strong>Renewals</strong><br />
    At the conclusion of the registration period, failure by you or on your behalf of to consent that the registration be renewed within the time specified in a second notice or reminder shall, in the absence of extenuating circumstances, result in cancellation of the registration by the end of the auto-renew grace period (although Upperlink may choose to cancel the name earlier).<br />

    Extenuating circumstances are defined as: UDRP action, valid court order, failure of Upperlink's renewal process (which does not include your failure to respond), the domain name is used by a nameserver that provides DNS service to third-parties (additional time may be required to migrate the records managed by the nameserver), you are subject to bankruptcy proceedings, payment dispute (where you claim to have paid for a renewal, or a discrepancy in the amount paid), billing dispute (where you dispute the amount on a bill), domain name subject to litigation in a court of competent jurisdiction, or other circumstance as approved specifically by ICANN.<br />&nbsp;<br />
    4. <strong>Privacy Policy</strong>
    <p>We take your privacy seriously and will take all measures to protect your personal information. Any personal information received will only be used to fill your order. We will not sell or redistribute your information to anyone.</p>
    5. <strong>Premium Domains</strong>
    <p>Irrespective of the above, the Registry Operator shall reserve the right to maintain the following list of domains that SHALL NOT be available for registration or will be withdrawn if registered already</p>
    <ul>
    <li>Offensive Names: This list shall contain words as determined by the Registry Operator board to be offensive first to the Nigerian community and then to the global community. ALL requests for domains under this list would be rejected.</li>
    <li>Restricted Names: This shall be a list of domains that may give a wrong impression if used. This could pertain to military, government or other related words. ALL applications for these domains would be rejected.</li>
    <li>Premium Names: These are domains with generic words ONLY but command premium value. Brand names cannot also be registered by anyone but the licensed registrars with name rights (copyright/trademarks) to such names. Where brand names are registered such names can be retrieved and transferred to the lawful owner. Premium domains would however be made available to registrants though a competitive bidding and auction process. Premium names are limited to the names listed in Registry Operator’s list as ‘premium’. This list shall contain words as determined by the Registry Operator.</li></ul>
        
        <strong>NIRA's Premium Domain</strong>
        <ul>
        <li><a href=\"http://nira.org.ng/images/Policies/Premium_Domain_Names.pdf\">Premium list</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NIRA_Domain_Names_Policy.pdf\">Trademarks</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NIRA_Domain_Names_Policy.pdf\">2 letter words</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NIRA_AUCTION_PROCESS_AND_PROCEDURE.pdf\">Fee for Premium Domains</a></li><br/>
        </ul>
    6. <strong>Data Provision</strong><br />
    a. You shall provide to Upperlink accurate and reliable contact details and correct and
    update them within seven (7) days of any change during the term of the Registered
    Name registration, including:
    <ul>
        <li>the full name,</li>
        <li>postal address, e-mail address,</li>
        <li>voice telephone number,</li>
        <li>fax number if available</li>
        <li>name of authorized person for contact purposes</li>
        <li>In the case of a Registered Name Holder that is an organization, association, or corporation; the data elements listed below shall apply:</li>
        <li>The names of the primary nameserver and secondary nameserver(s) for the Registered Name;</li>
        <li>The name, postal address, e-mail address, voice telephone number, and (where available) fax number of the technical contact for the Registered Name; and</li>
        <li>The name, postal address, e-mail address, voice telephone number, and (where available) fax number of the administrative contact for the Registered Name.</li>
    </ul><br />
    b. Your willful provision of inaccurate or unreliable information, your willful failure to update information provided to Upperlink within seven (7) days of any change, or your failure to respond for over fifteen (15) days to inquiries by Upperlink concerning the accuracy of contact details associated with your registration shall constitute a material breach of your contract and be a basis for suspension and/or cancellation of the Registered Name registration.<br />&nbsp;<br />

    c. Where you intend to license use of a domain name to a third party, you are nonetheless the Registered Name Holder of record and are responsible for providing your own full contact information and for providing and updating accurate technical and administrative contact information adequate to facilitate timely resolution of any problems that arise in connection with the Registered Name. Where you license the use of a Registered Name according to this provision, you shall accept liability for harm caused by wrongful use of the Registered Name, unless you disclose the current contact information provided by the licensee and the identity of the licensee within seven (7) days to a party providing the Registered Name Holder reasonable evidence of actionable harm.<br />&nbsp;<br />

    d. Upperlink will take reasonable precautions to protect your Personal Data from loss, misuse, unauthorized access or disclosure, alteration, or destruction. Any personal information received will only be used to fill your order. We will not sell or redistribute your information to anyone.<br />&nbsp;<br />

    e. You represent that, to the best of your knowledge and belief, neither the registration of the Registered Name nor the manner in which it is directly or indirectly used infringes the legal rights of any third party.<br />&nbsp;<br />

    7. <strong>Dispute Resolution</strong><br />
    Disputes will be categorized as Domain Registration Disputes and Registrar Services Dispute<br/>
    a. Domain Dispute Resolution<br/>
    You agree to be bound by ICANN's UDRP on all domains subject to the UDRP and its related policies and NIRA's Dispute Resolution Procedure/Policy for Nigerian CCTLDs
    b. Registrar Service Dispute<br/>
    If you are dissatisfied with the resolution of a complaint treated in accordance with our Complaints Handling Process, if any dispute, claim, controversy or difference of any kind whatsoever arising out of or in connection with this AGREEMENT, or breach thereof (the \"Dispute\"), the parties shall attempt to settle such dispute in the first instance within thirty (30) Days from the date upon which one party has given written notice of the Dispute to the other party, by discussions between or among the parties (\"Discussion Period\"). If the Dispute cannot be settled within the discussion period, then the matter may be referred to arbitration to be conducted pursuant to the Nigerian Arbitration and Conciliation Act. Cap A18, Laws of the Federation of Nigeria, 2004.<br />&nbsp;<br />

    8. <strong>Governing Law; Jurisdiction</strong><br />
    This Agreement and any controversy arising out of or in relation to it shall be governed by the laws of the Federal Republic of Nigeria you agree to submit to the jurisdiction of the State and Federal courts of the Nigeria which shall have exclusive jurisdiction over all controversies in connection. You hereby waive any right to assert any rights or defenses within any other jurisdiction or to require that litigation regarding this Agreement take place elsewhere. For the adjudication of disputes concerning or arising from use of the Registered Name \"intellectual property infringements or violations.\" , you shall submit, without prejudice to other potentially applicable jurisdictions, to the jurisdiction of the courts (1) of the Registered Name Holder's domicile and (2) the Federal Republic of Nigeria.<br />&nbsp;<br />

    9. <strong>Indemnity</strong><br />
    You shall indemnify and hold harmless Upperlink, the Registry Operator and its
    directors, officers, employees, and agents from and against any and all claims, damages, liabilities, costs, and expenses (including reasonable legal fees and expenses) arising out of or related to your domain name registration. Any liability of Upperlink under this Agreement is expressly limited to the price paid by you for the domains involved. Your sole remedy against Upperlink in any dispute concerning this Agreement shall be to seek recovery of that amount, upon payment of which Upperlink shall be released from all further obligations and liability to you. You shall indemnify and hold harmless Upperlink against any and all claims, legal actions, losses, damages, liabilities, costs and expenses asserted against, imposed upon or incurred by Upperlink arising out of or relating to (i) any misrepresentation or breach of warranty or covenant by you under this Agreement; (ii) your actual or alleged act or omission in the course of the registration of your domain; (iii) any claim of infringement arising from the registration of domain. THIS INDEMNITY IS UPPERLINK'S SOLE LIABILITY AND YOUR SOLE REMEDY FOR INFRINGEMENT OF ANY PATENT, COPYRIGHT, TRADEMARK, TRADE SECRET OR OTHER INTELLECTUAL PROPERTY RIGHT.<br />&nbsp;<br />

    10. <strong>Domain Registry</strong><br />
    You agree that Upperlink Limited is not lending You access to its registrar connections or its registry access, nor will You be deemed to be a registrar in Your own right. Furthermore, You agree You will not attempt to gain access to Upperlink Limiteds registrar connections or registry access. You agree to provide complete, accurate and current data for each registrant to be added to a registry in accordance with the Registry Operators requirements for inclusion in the Whois database.<br />&nbsp;<br />

    11. <strong>Suspension, Cancellation, Transfer</strong><br />
    You agree that, in addition to other events set forth in this Agreement your registration of the Registered Name.\"Intellectual property infringements or violations\"  shall be subject to suspension, cancellation, or transfer pursuant to any Specification or Policy, or pursuant to any registrar or registry procedure not inconsistent with any Specification or Policy, (1) to correct mistakes by Registrar or the Registry Operator in registering the name or (2) for the resolution of disputes concerning the Registered Name. Your ability to use any of the services provided by Upperlink Limited is also subject to cancellation or suspension in the event that there is an unresolved breach of this Agreement and/or suspension or cancellation is required by any policy now in effect or adopted later by the Registry Operator;<br/>
    o You agree that Your failure to comply completely with the terms and conditions of this Agreement and any Upperlink Limited rule or policy may be considered by Upperlink Limited to be a material breach of this Agreement and Upperlink Limited may provide You with notice of such breach either in writing or electronically (i.e. email).<br/>
    o In the event You do not provide Upperlink Limited with material evidence that You have not breached Your obligations to Upperlink Limited within ten (10) working days, Upperlink Limited may terminate its relationship with You and take any remedial action available to Upperlink Limited under the applicable laws.<br />&nbsp;<br />

    12. <strong>Force Majeure</strong><br />
    Upperlink shall not be liable for any failure to perform due to causes beyond its control, including but not limited to fire, flood, earthquake, explosion, accident, acts of public enemy, war, rebellion, insurrection, sabotage, epidemic, quarantine, labor disputes, acts of God or government, any such event of force majeure affecting Upperlink 's third-party partners, or judicial action.<br />&nbsp;<br />

    13. <strong>Severability</strong><br />
    If any provision of this Agreement shall be declared void, invalid, or illegal, the validity or legality of all other provisions of the Agreement shall not be affected thereby.

    <h2 >B: HOSTING </h2>

    <p>
        1. <strong>Change in Pricing</strong><br>
        Prices are subject to review from time to time with or without notice. The prices take effect from the date posted on our website.
    </p><p>
        2. <strong>Late Payment</strong><br>
        Full payment must be made prior to the expiry of your hosting service. If renewal for the service is made post expiry the service will still count from the date of expiry and not the date of renewal. If the account is not renewed up to 3 months post expiry, the account will be deleted.
    </p><p>
        3. <strong>Spamming  </strong><br>
        We take a zero tolerance stance against the sending of unsolicited e-mail, bulk emailing, and spam. \"Safe lists,\" purchased lists, and selling of lists will be treated as spam. We may terminate the account of any User who sends out spam with or without notice.
    </p><p>
        4. <strong>CPU, Bandwidth and Disk Usage</strong><br>
        Permitted CPU and Disk Usage.<br>
        (i) Shared hosting space may only be used for web files, active email and content of User Websites. Shared hosting space may not be used for storage (whether of media, emails, or other data), including, as offsite storage of electronic files, email or FTP hosts. Upperlink expressly reserves the right to review every shared account for excessive usage of CPU, disk space and other resources that may be caused by a violation of this Agreement.<br>
        (ii) Upperlink may, in our sole discretion, suspend, terminate access to the Services, apply additional fees for cleaning up the account, or remove or delete User Content for those accounts that are found to be in violation of Upperlink's terms and conditions.<br>
        (iii) Dedicated and VPS usage is limited by the resources allocated to the specific plan that you have purchased.
    </p><p>
        5. <strong>Bandwidth Usage</strong><br>
        (i) Shared servers are limited in their monthly bandwidth allowance. Once an account exceeds its bandwidth usage, the account will be suspended without notice. On payment for upgrade, the account will be unsuspended however,  without payment for the upgrade the account will remain unsuspended, to be deleted 3 months after suspension. <br>
        (ii) If an account is unsuspended, the term will continue to run from the date of suspension. For example, an account is suspended in March to expire in June, if the account is unsuspended in June, it would have expired and the account should be renewed for another term of one year.
    </p><p>
        6. <strong>File Back-up</strong><br>
        Upperlink is not responsible for back-up of files and databases residing on our servers. You are solely responsible for independent back-up of data you store on our servers.
    </p><p>
        7. <strong>Reseller Terms and Client Responsibility</strong><br>
        Resellers shall ensure that each of their clients complies with this Agreement. Resellers are responsible for supporting their clients. Upperlink does not provide support to clients of Upperlink's resellers. If a reseller's client contacts Upperlink, Upperlink reserves the right to place a reseller client account on hold until the reseller can assume responsibility for the reseller's client. All support requests must be made by the reseller on its client's behalf for security purposes.
    </p><p>
        8. Resellers are also responsible for all content stored or transmitted under their reseller account and the actions of their clients. Upperlink will hold any reseller responsible for any of their client's actions that violate the law or this Agreement.<br>
        (i) Upperlink is not responsible for the acts or omissions of our resellers. The reseller hereby agrees to indemnify Upperlink from and against any and all claims made by any User arising from the reseller's acts or omissions.<br>
        (ii) Upperlink reserves the right to revise our Reseller Program at any time. Changes shall take effect when posted online or on any subsequent date as may be set forth by Upperlink.<br>
        Resellers in the Upperlink Reseller Program assume all responsibility for billing and technical support for each of the Users signed up by the reseller.
    </p><p>
        9. <strong>Shared (non-reseller accounts)</strong><br>
        Shared accounts may not be used to resell web hosting to others. If you wish to resell hosting you must use a reseller account.
    </p><p>
        10. <strong>Support for Third Party services</strong><br>
        Upperlink does not provide support for third party hosting related services, Staff may advise on third party installations. Our blog, knowledge base and other resources will contain detailed information on setting up third party software. Upperlink can however, provide these services at a fee.
    </p><p>
        11. <strong>Suspension of accounts</strong><br>
        An account may be suspended with or without notice for the following reasons:<br>
        (i) Failure to renew an expired account <br>
        (ii) Illegal Activity (account will be deleted 3 months after suspension) <br>
        (iii) Violation of applicable law - Nigerian other jurisdictions that may apply.
    </p><p>
        12. <strong>Termination</strong><br>
        Upperlink may terminate your access to the Services, in whole or in part, without notice in the event that: <br>
        (i) you fail to pay any fees due; <br>
        (ii) you violate this Agreement; <br>
        (iii) your conduct may harm Upperlink or others or cause Upperlink or others to incur liability, as determined by Upperlink in our sole discretion; or <br>
        (iv) as otherwise specified in this Agreement. <br>
        In such event, Upperlink shall not refund to you any fees paid in advance of such termination, and you shall be obligated to pay all fees and charges accrued prior to the effectiveness of such termination. Additionally, Upperlink may charge you for all fees due for the Services for the remaining portion of the then current term.<br>
        UPON TERMINATION OF THE SERVICES FOR ANY REASON, USER CONTENT, USER WEBSITES, AND OTHER DATA WILL BE DELETED.
    </p><p>
        13. <strong>Compliance with the Law</strong><br>
        You agree to use services offered by Upperlink in a manner consistent with all applicable law. Accounts are subject to suspension with or without notice if investigated and found to be in contravention of the law, violation of trademark, copyright laws is abusive or used for illegal activity.
    </p><p>
        14. <strong>Limitation/Disclaimer of Liability</strong><br>
        (i) Upperlink does not represent or warrant that You will receive continual (100%) fail proof and uninterrupted service. In no event shall Upperlink be liable for damages resulting from or related to any failure or delay of Upperlink to provide service under this Agreement if such delays or failures are due to causes beyond Upperlink's control, as defined by standard practices in the industry, except those caused by Upperlink's negligence such failure or delay shall not constitute a default under this Agreement.
    </p><p>
        15.  <strong>Indemnity</strong><br>
        You agree to defend, indemnify and hold Upperlink harmless from and against any and all claims, losses, liabilities related to or arising out of the services provided by Upperlink under this Agreement, including without limitation, claims made by third parties, liability claims for content uploaded by you, claims due to disruption or malfunction of services provided hereunder.
    </p>

    <br>

    <h2>C: FEES REFUND POLICY</h2>
    <p class=\"c6\"><span class=\"c7\"></span></p>
    <ol class=\"c4 lst-kix_list_2-0 start\" start=\"1\">
        <li class=\"c1\"><span class=\"c0\">Upperlink wants to ensure your satisfaction with your account. If, for any reason, you are not satisfied, please contact us at </span><span>support</span><span
                class=\"c0\">@upperlink.ng Provide us with a brief explanation of the nature of your dissatisfaction and we will move quickly to process your refund. The following reasons warrant a 100% refund:</span>
        </li>
    </ol>
    <ul class=\"c4 lst-kix_list_3-0 start\" start=\"1\" style=\"margin-left:20px; \">
        <li class=\"c3\"><span class=\"c0\">The listed purchase price of the content and the actual amount Upperlink debited varies. Reasons that your account/ewallet will not be refunded:</span>
        </li>
        <li class=\"c3\"><span class=\"c0\">Intention to defraud Upperlink by making a false claim of failed transactions. An excessive request for refunds after a refund has already been made to an account. This may result in future denials of refunds. Computer hardware and/or software failure (e.g., computer crash), including Internet connection, of the Upperlink customer. Upperlink refuses to accept fault for customer hardware/software issues and will not honor refunds associated with these issues.</span>
        </li>
        <li class=\"c3\"><span class=\"c0\">A refund for funds in ewallet unused for transactions for more than 6 months.</span>
        </li>
    </ul><p class=\"c8\"><span class=\"c0\"></span></p>
    <ol class=\"c4 lst-kix_list_2-0\" start=\"2\">
        <li class=\"c1\"><span class=\"c0\">You also acknowledge and agree that where refunds are issued to your Payment Method, Upperlink&rsquo;s issuance of a refund is only confirmation that Upperlink has submitted your refund to the Payment Method charged at the time of the original sale, and that Upperlink has absolutely no control over when the refund will be applied towards your Payment Methods available balance. You further acknowledge and agree that the payment provider and/or individual issuing bank associated with your Payment Method establish and regulate the time frames for posting your refund, and that such refund posting time frames may range from five (5) business days to a full billing cycle, or longer.</span>
        </li>
    </ol><p class=\"c2\"><span class=\"c0\"></span></p>
    <ol class=\"c4 lst-kix_list_2-0\" start=\"3\">
        <li class=\"c1\"><span class=\"c0\">In the event a refund is issued to your Payment Method and the payment provider, payment processor or individual issuing bank associated with your Payment Method imposes any limitations on refunds, including but not limited to, limitations as to the timing of the refund or the number of refunds allowed, then Upperlink, in its sole and absolute discretion, reserves the right to issue the refund either in the form of an in-store credit; or via refund to your originating account, through a reversal of the transaction.</span>
        </li>
    </ol><p class=\"c2\"><span class=\"c0\"></span></p>
    <ol class=\"c4 lst-kix_list_2-0\" start=\"4\">
        <li class=\"c1\"><span class=\"c0\">Upperlink also has the right, but not the obligation, to offer an in-store credit for customers seeking refunds, even if there are no limitations on refunds imposed by the Payment Method. For the avoidance of doubt, any and all refunds processed via the issuance of either in-store credits or a reversal are solely within Upperlink&rsquo;s discretion and are not available at customer request.</span>
        </li>
    </ol><p class=\"c11\"><span class=\"c0\"></span></p>
    <ol class=\"c4 lst-kix_list_2-0\" start=\"5\">
        <li class=\"c1\"><span class=\"c0\">Refunds for unused funds will be made after taxes have been deducted.</span></li>
    </ol><p class=\"c9\"><span class=\"c0\"></span></p>

    <h3 style=\"text-align: center;\"><span style=\"text-decoration: underline;\">SCHEDULE A</span></h3>


    <h3 style=\"text-align: left;\">1.<span style=\"text-decoration: underline;\">PROHIBITION ON REGISTRATION OF GEOGRAPHICAL (\"GEO NAMES\") </span></h3>
    <p>Registration of Geographical names as domain names is now prohibited by the Nigeria Internet Registration Association (NIRA) effective 1st November, 2016 some examples of geonames as domain names are lagos.com.ng, ibadan.org.ng, ajeromi.ng. Upperlink will not be liable for loss, retrieval, deletion nor refund payments for such registrations where the domains are successfully registered.</p>

    <h3 style=\"text-align: left;\">2.<span style=\"text-decoration: underline;\">DOCUMENTATION FOR CLOSED DOMAINS</span></h3>
    <p>Highlighted below are the requirements of some of NIRA's Closed Domains<br/>
    1. <strong>gov.ng</strong><br />
    The .gov.ng SLD is a closed and limited only to the following
    - Governments at all levels and Ministries, Department and Parastatals at all levels as well.<br/>

    a. <strong>Federal</strong><br />
    Registrants in the .gov.ng SLD are required to be full government agencies and also have the approval of each tier of government. For Federal government registrations, applicants are expected to also obtain clearance from the federal government entity setup for such approval, and present same during registration. In this case Galaxy Backbone.
    Registrations for Federal MDAs are handled strictly by Galaxy Backbone and not NITDA.
    <span style=\"color: #ff0000;\">Registration Procedure - Contact Galaxy Backbone directly for registration. Details are below.</span>
    <blockquote>The Managing Director,
        Galaxy Backbone
        61, Adetokunbo Ademola Crescent
        Wuse2
        Abuja</blockquote>
    b. <strong>State and Local Government</strong>
    For State government registration, applicants are expected to also obtain clearance from the state government entity setup or designated for such approval, and present same during registration. For Local government registration, applicants are expected to attach a valid authorization from the local government, and present same during registration.<br />&nbsp;<br />

    <strong>Registrations for State and Local Governments are approved by NITDA through Upperlink</strong>
    <span style=\"color: #ff0000;\">Documentation Requirement - Authorization Letter</span>
    <span style=\"color: #ff0000;\">Registration Procedure</span>
    Authorization Letter on the Agency's Letterhead to be addressed to (NIRA)
    <blockquote>Nigeria Internet Registration Association
        8, Funsho Williams Avenue, Iponri, Surulere, Lagos, Nigeria</blockquote>
    The letter should state your authorization to register the domain on behalf of the Agency, stating clearly what the Agency is into, the domain they want to register and the nameservers of the domain. The letter should be scanned and sent to domains@upperlink.ng.
    It should also contain the details of the Point of Contact (from the Agency) as listed below:
    Position
    Contact Address,
    Phone Numbers,
    Postal Code
    Email
    On approval by NITDA, payment can then be made to our Account for the registration<br />&nbsp;<br />

    2.<strong> .edu.ng</strong><br />
    The .edu.ng SLD is a closed one and reserved for ONLY tertiary academic institutions as approved and accredited by the relevant authorities like Nigerian Universities Commission (NUC), National Board for Technical Education (NBTE), NCCE and any other body as recognized by the constitution of the Federal Republic of Nigeria.<br />&nbsp;<br />

    <span style=\"color: #ff0000;\">Documentation Requirement - Authorization Letter, Evidence of Accreditation </span><br />
    <span style=\"color: #ff0000;\">Registration Procedure</span>
    Authorization Letter on the Institution's Letterhead to be addressed to (NIRA)
    <blockquote>Nigeria Internet Registration Association
        8, Funsho Williams Avenue, Iponri, Surulere, Lagos, Nigeria</blockquote>
    The letter should state your authorization to register the domain on behalf of the Institution, the domain they want to register and the nameservers of the domain. The letter should be scanned and sent to domains@upperlink.ng.
    It should also contain the details of the Admin Point of Contact (from the Institution) as listed below:
    Name<br />
    Position<br />
    Contact Address,<br />
    Phone Numbers,<br />
    Postal Code<br />
    Email<br />&nbsp;<br />

    <span style=\"color: #ff0000;\">Universities - NUC Accreditation Letter</span><br />
    <span style=\"color: #ff0000;\">Polytechnics and Federal Colleges of Education - NBTE Accreditation Letter</span><br />&nbsp;<br />

    On approval, payment can then be made to us for registration.<br />&nbsp;<br />
    </p>
    For more information on <strong>NIRA's Domains Policies</strong> which are incorporated by reference. Please see below
    <ol>

        <li><a href=\"http://nira.org.ng/images/Policies/NIRA-GENERAL-REGISTRATION-POLICY.pdf\" target=\"_blank\">NiRA General Registration Policy</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NIRA_DISPUTE_RESOLUTION_POLICY.pdf\" target=\"_blank\">NiRA Dispute Resolution Policy</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NIRA_COMPLAINTS_POLICY.pdf\" target=\"_blank\">NIRA Complaint Policy</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/Nira_Privacy_Policy.pdf\" target=\"_blank\">NiRA Privacy Policy </a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NIRA_Domain_Names_Policy.pdf\" target=\"_blank\">NIRA Domain Names Policy</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NG_Domain_Name_Life_Cycle_Policy.pdf\" target=\"_blank\">NG Domain Name Life Cycle Policy</a></li>
        <li><a href=\"http://nira.org.ng/images/Policies/NIRA_AUCTION_PROCESS_AND_PROCEDURE.pdf\" target=\"_blank\">NIRA Auction Process & Procedure</a></li>
    </ol>


    For more inquiries, send a mail to <a href=\"mailto:support@upperlink.ng\" target=\"_blank\">support@upperlink.ng</a> or <a href=\"mailto:domains@upperlink.ng\" target=\"_blank\">domains@upperlink.ng</a>



</div>
";

// output the HTML content
$pdf->writeHTML($html, true, 0, true, 0);

// reset pointer to the last page
$pdf->lastPage();
