<?php
/**
 * Created by PhpStorm.
 * User: Daniel Babatunde
 * Date: 4/20/2017
 * Time: 9:15 AM
 */
use WHMCS\ClientArea;
use WHMCS\Database\Capsule as Capsule;

require __DIR__ . '/init.php';

class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        if (file_exists(ROOTDIR . '/assets/img/logo.png')) {
            $logoFilename = 'logo.png';
            $image_file = ROOTDIR.'/assets/img/'.$logoFilename;
            $this->Image($image_file, 10, 10, 15, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        } elseif (file_exists(ROOTDIR . '/assets/img/logo.jpg')) {
            $logoFilename = 'logo.jpg';
            $image_file = ROOTDIR.'/assets/img/'.$logoFilename;
            $this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        }
        //$image_file = ROOTDIR.'/assets/img/'.$logoFilename;
        //$this->Image($image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 14);
        // Title
        $this->Cell(0, 15, '--Upperlink Registrar--', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}
$ca = new ClientArea();

$ca->setPageTitle('Reseller Center');

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb('reseller_api.php', 'Reseller API Credientials');

$ca->initPage();

$request = $_GET;
//dd($request);

$ca->requireLogin(); // Uncomment this line to require a login to access this page

// To assign variables to the template system use the following syntax.
// These can then be referenced using {$variablename} in the template.

//$ca->assign('variablename', $value);

// Check login status
if ($ca->isLoggedIn()) {
    $client = Capsule::table('tblclients')
        ->where('tblclients.id', $ca->getUserID())->first();
    //dd($client);
    
    /**
     * User is logged in - put any code you like here
     *
     * Here's an example to get the currently logged in clients first name
     */
    //file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder Page userID: ' . json_encode($ca->getUserID()) . "\n", FILE_APPEND);
//file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder REQYEST: ' . json_encode($_POST) . "\n", FILE_APPEND);
    $clientname = $client->firstname." ".$client->lastname;
    $ca->assign('clientname', $client->firstname." ".$client->lastname);
    
} else {

    // User is not logged in
    $ca->assign('clientname', 'Random User');

}

/**
 * Set a context for sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
Menu::addContext();

/**
 * Setup the primary and secondary sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
Menu::primarySidebar('announcementList');
Menu::secondarySidebar('announcementList');

# Define the template filename to be used without the .tpl extension
        $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
         $ca->assign('pdf', $pdf);
         include_once "agreements/reselleragreementindividual.php" or die('Not around');
         //dd($html);
        if (file_exists(ROOTDIR . '/assets/img/logo.png')) {
            $logoFilename = 'logo.png';
        } elseif (file_exists(ROOTDIR . '/assets/img/logo.jpg')) {
            $logoFilename = 'logo.jpg';
        }
        $pdf->Image(ROOTDIR . '/assets/img/' . $logoFilename, 15, 25, 75);
        
        
        // set document information
        $pdf->SetCreator("UPPERLINK LIMITED");
        $pdf->SetAuthor('Upperlink Limited');
        $pdf->SetTitle('Reseller Agreement');
        
        $pdf->SetKeywords('Reseller, PDF, Upperlink, test, guide');
        
        // set default header data
        //$pdf->Image(ROOTDIR . '/assets/img/' . $logoFilename, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
        $pdf->setFooterData(array(0,64,0), array(0,64,128));
        
        // set header and footer fonts
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        
        // set default monospaced font
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        
        // set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        
        // set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        
        // set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        
        // set some language-dependent strings (optional)
        if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
            require_once(dirname(__FILE__).'/lang/eng.php');
            $pdf->setLanguageArray($l);
        }
        
        // ---------------------------------------------------------
        
        // set default font subsetting mode
        $pdf->setFontSubsetting(true);
        
        // Set font
        // dejavusans is a UTF-8 Unicode font, if you only need to
        // print standard ASCII chars, you can use core fonts like
        // helvetica or times to reduce file size.
        $pdf->SetFont('dejavusans', '', 11, '', true);
        
        // Add a page
        // This method has several options, check the source code documentation for more information.
        $pdf->AddPage();
        
        // set text shadow effect
        $pdf->setTextShadow(array('enabled'=>true, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));
        
if($request['type'] == 'individual'){
        
        $pdf->SetSubject('RESELLER AGREEMENT FOR INDIVIDUALS');
        $html = "<p><strong>RESELLER AGREEMENT FOR INDIVIDUALS</strong></p>
        <p>This Reseller Agreement (the &ldquo;Agreement&rdquo;) is effective this 25th day of June, 2018.</p>
        <p>BETWEEN: Upperlink Limited (the \"Registrar\"), a company duly incorporated and existing under the laws of the Federal Republic of Nigeria with its head office located at ASSBIFI House, 4 ASSBIFI Road, Alausa, CBD, Ikeja, Lagos, Nigeria.</p>
        <p>AND: $clientname, an individual with residential address located at &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.&hellip;&hellip;&hellip;&hellip;.</p>
        <p><strong>1.</strong></p>
        <p>1.1<strong>Preamble</strong></p>
        <p>Whereas, Reseller by virtue of the volume of transactions or pricing the client is categorized as an independent non-exclusive Reseller to market its domains on all its available extensions or purchase domains on behalf of another. Reseller shall at all times adhere to the standard terms, conditions, rules and policies of Upperlink as may be issued by Upperlink from time to time, and shall be solely responsible for all its acts and omissions in the course of acting as an Authorized Reseller of Upperlink&rsquo;s domains. Upperlink Services means the services agreed to between the parties from time to time with any exclusions, additions or discounts Upperlink may make.</p>
        <p>1.2<strong>Sub-Resellers </strong></p>
        <p>Reseller may appoint sub-resellers, resellers or agents (\"Sub-resellers\") to market, domains provided that the reseller incorporates these terms and conditions in its agreement with the sub reseller. Reseller shall be liable for the acts and omissions of any such Sub-resellers.</p>
        <ol start=\"2\">
        <li><strong> OBLIGATIONS OF RESELLER</strong></li>
        </ol>
        <p>2.1 Reseller Program</p>
        <p>Resellers can benefit from Upperlink&rsquo;s reseller program which allows movement from one level to another with access to higher levels of discount. Reseller should aim to increase its registration volume to benefit from the program.</p>
        <p>2.2. <strong>Marketing and Service Support</strong></p>
        <p>Reseller shall use reasonable efforts to market and sell domains and shall comply with the policies, programs, and requirements regarding marketing and support as may be communicated by Upperlink to Reseller from time to time. Reseller shall provide first level support to her clients while Upperlink will then provide second level technical support to the Reseller.</p>
        <p>2.3<strong>Registration Confirmation</strong></p>
        <p>Reseller may request for registration via electronic mail or its API. Upperlink will also provide Reseller with the capacity to register directly into Upperlink's software. Acceptance by Upperlink of the registration shall occur (a) when the registration is entered into Upperlink's software, (b) when a registration request is provided to Reseller via electronic mail, if requested by Reseller. Reseller is obliged to ensure that domain orders made on the platform are registered and confirmed in his account on completion of registration.</p>
        <p>2.4 <strong>Reseller as Registrant</strong></p>
        <p>Where you as a reseller register a domain name as the Registered Name Holder, you agree to be bound by the same terms in Upperlink&rsquo;s Registrant Agreement as a Registered Name Holder and shall comply with the terms of the Agreement.</p>
        <p>2.5 <strong>Whois Data Reminder</strong></p>
        <p>At least annually, a Reseller must present to the registrant the current Whois information, and remind the registrant that provision of false Whois information can be grounds for cancellation of their domain name registration. Registrants must review their Whois data, and make any corrections.</p>
        <p>2.6. <strong>Registrant Educational Information</strong></p>
        <p>Reseller must publish on their website Registrants Educational Information in Annexure B.</p>
        <p>2.7. <strong>Obligations Related to Proxy and Privacy Services.</strong></p>
        <p>Where the Reseller uses a Privacy Proxy Service, the Reseller must ensure that it adheres to the Specification on Privacy and Proxy Registrations in Annexure A to this Agreement. Reseller must provide through the Privacy/Proxy Service Provider the identity of the Registrant for Registry Data Escrow Purposes in accordance to ICANN&rsquo;s regulations.</p>
        <p>2.8. <strong>Archiving/Information Request</strong></p>
        <p>Reseller shall ensure it archives records of its client&rsquo;s registrations and transactions for record/dispute resolution purposes. Reseller shall not withhold Registrar&rsquo;s information upon request by the Registrant of its Sponsoring Registrar details.</p>
        <p>2.9. <strong>Requirements for Technical Expertise/Experience</strong></p>
        <p>Reseller must ensure that they have the requisite technical expertise/experience required for the domain business.</p>
        <p>2.10 <strong>Observance of Upperlink Policies and Effects of Non Compliance</strong></p>
        <p>Upperlink will keep Reseller informed of Upperlink's domain registration policies and procedures, and Reseller agrees to follow such policies and procedures. Failure to comply with the provisions of this agreement may result in termination of this Agreement pursuant to Section 8 and 9 of this Agreement.</p>
        <p>2.11 <strong>Duty to Communicate</strong></p>
        <p>Reseller agrees to have an active means of communication both via phone and email for emergencies through which Upperlink can reach the Reseller regarding domain management issues. Where the Reseller fails to do so, Upperlink after exhausting all means of communication may communicate with the registrant at no liability to Upperlink.</p>
        <p>2.12 <strong>Domain Ownership </strong></p>
        <p>When registering domain(s) on behalf of another, Reseller agrees to use the name of the owner as the Registrant or Administrative contact while retaining reseller&rsquo;s name as Technical/Billing contact in order to reduce as much as possible domain ownership disputes..</p>
        <ol start=\"3\">
        <li><strong>OBLIGATIONS OF UPPERLINK</strong></li>
        </ol>
        <p>3.1. Where the Reseller requests for a registration by Upperlink on her behalf, Upperlink is obliged to fulfill the request however, where the registration is not completed Upperlink will inform the Reseller of the reason for the failure. Reseller will inform the client of its failure to do so immediately and Upperlink will not be liable for failure to register such domain.</p>
        <p>3.2. Upperlink will not sell domains directly or willfully poach any of its Reseller&rsquo;s clients.</p>
        <ol start=\"4\">
        <li><strong>PRICES, PAYMENTS AND REFUNDS</strong></li>
        </ol>
        <p>4.1.Reseller's Purchase Price and Price changes</p>
        <p>Payment channels are available to the Client including Bank Deposits, Online Transfer and Account Credits. Upperlink may at any time change pricing or the Reseller's purchase price with notice and without liability, but any registration request accepted by Upperlink before a price change takes effect shall be invoiced at the previous price. No refunds will be made for domain registration except where a reversal is automatically done from the payment channel.</p>
        <ol start=\"5\">
        <li><strong>TRADEMARKS, TRADE NAMES</strong></li>
        </ol>
        <p>Reseller acknowledges that Upperlink and/or its parent or affiliates are the sole and exclusive owners of the name \"Upperlink\" and any abbreviations or variations thereof, and of any and all of Upperlink's trademarks and trade names, service marks, trade logos and trade dress (collectively \"Trademarks\") as Upperlink may unilaterally amend periodically (registered or not). Reseller agrees not to register or use any mark(s) that are similar enough to be construed as Upperlink Trademarks. Reseller acquires no rights to the Trademarks.</p>
        <ol start=\"6\">
        <li><strong>HANDLING DOMAIN REGISTRATION ABUSE</strong></li>
        </ol>
        <p>Domain Registration abuse includes and is not limited to domains registered for phishing, malware, botnets and domains advertised in spam, Intellectual property infringement, copyright violations, and certain types of highly offensive content display.</p>
        <p>Reseller agrees to take reasonable and prompt steps to investigate and respond appropriately. keep records and treat any reports of abuse.</p>
        <ol start=\"7\">
        <li><strong>TERM</strong></li>
        </ol>
        <p>This Agreement's term (\"Term\") shall be effective on the date the client is categorized as a Reseller and shall be automatically renewed annually, provided that either party hereto may terminate this Agreement at any time with or without notice, and further provided that this Agreement shall terminate automatically if Reseller makes no purchases from Upperlink hereunder for a period of 90 calendar days, such termination to be effective as of the next calendar day after such period elapses.</p>
        <ol start=\"8\">
        <li><strong>TERMINATION</strong></li>
        </ol>
        <p>8.1. Either party can terminate this Agreement without cause by giving 30 days' written notice to the other.</p>
        <p>8.2.This Agreement may be terminated for cause upon written notice:</p>
        <ol>
        <li>a)By either party upon 5 days' written notice if the other commits a material breach of the Agreement and fails to cure it within the 5 days;</li>
        <li>b)By Upperlink immediately if Reseller files for or has instituted against Upperlink any proceedings as to its bankruptcy, insolvency, reorganization, liquidation, receivership, or dissolution or there is an assignment for the benefit of creditors;</li>
        </ol>
        <p><strong>9</strong><strong>EFFECT OF TERMINATION</strong></p>
        <p>9.1Upon termination of this Agreement, Upperlink may terminate any or all registration requests.</p>
        <p>9.2Upon termination, Reseller may transfer its domains and clients to Upperlink or as may be agreed by both parties.</p>
        <p>9.3Termination will discharge and release Upperlink from all obligations and liability under this Agreement, except as it expressly accepts for prior registration requests. The sole fact of this Agreement's termination shall not make either party liable to the other for any compensation, reimbursement, losses or damages whatsoever, though Reseller shall remain obliged to pay all outstanding balances on its domain transactions.</p>
        <p>9.4 Termination will not absolve the Reseller from performing all outstanding obligations due to Upperlink prior to termination.</p>
        <ol start=\"10\">
        <li><strong>CONFIDENTIALITY</strong></li>
        </ol>
        <p>.Confidential Information</p>
        <p>Prior to and during the Term hereof, Upperlink may convey to Reseller proprietary and confidential information about Upperlink Products, services, strategy and analysis. For the Term of this Agreement (including renewals) and for 2 years thereafter, Reseller shall not disclose to any third party any such information marked CONFIDENTIAL, PROPRIETARY, STRICTLY PRIVATE, or INTERNAL DATA, or which, though not so marked, could reasonably be construed as confidential or sensitive, such as the terms of this Agreement (all collectively \"Confidential Information\"), nor shall it use any such Confidential Information for its own benefit, except as provided herein. Any reliance on such Confidential Information is at Reseller's own risk. Nothing in this Section grants or implies any rights by license, estoppel, or otherwise. Confidential Information does not include information (i) in the public domain at the time of disclosure or which enters the public domain after such disclosure through no fault of Reseller, (ii) generally disclosed to third parties by Upperlink without restriction, (iii) communicated to Reseller by a third party with the unrestricted right to do so, or (iv) approved for release by Upperlink in writing.</p>
        <ol start=\"11\">
        <li><strong>LIMITATION OF LIABILITY AND REMEDIES; INDEMNITY</strong></li>
        </ol>
        <p>Limitation of Liability; Sole Remedy</p>
        <p>Any liability of Upperlink under this Agreement is expressly limited to the price paid by Reseller for the domains involved. Reseller's sole remedy against Upperlink in any dispute concerning this Agreement shall be to seek recovery of that amount, upon payment of which Upperlink shall be released from all further obligations and liability to Reseller.</p>
        <ol start=\"12\">
        <li><strong>12</strong>.<strong>INDEMNITY</strong></li>
        </ol>
        <p>Except as otherwise stated herein, Reseller shall indemnify and hold harmless Upperlink against any and all claims, legal actions, losses, damages, liabilities, costs and expenses asserted against, imposed upon or incurred by Upperlink arising out of or relating to:</p>
        <p>(i) any misrepresentation or breach of warranty or covenant by Reseller under this Agreement;</p>
        <p>(ii) any actual or alleged act or omission of Reseller in the course of its performance of its business;</p>
        <p>(iii) any claim of infringement arising from the registration of domain.</p>
        <p>THIS INDEMNITY IS UPPERLINK'S SOLE LIABILITY AND RESELLER'S SOLE REMEDY FOR INFRINGEMENT OF</p>
        <p>ANY PATENT, COPYRIGHT, TRADEMARK, TRADE SECRET OR OTHER INTELLECTUAL PROPERTY RIGHT. In</p>
        <p>addition to this clause, Reseller will also ensure they provide an indemnity on their letterhead to Upperlink</p>
        <p>with the content outlined in Annexure C.</p>
        <ol start=\"13\">
        <li><strong>FORCE MAJEURE</strong></li>
        </ol>
        <p>Upperlink shall not be liable for any failure to perform due to causes beyond its control, including but not limited to fire, flood, earthquake, explosion, accident, acts of public enemy, war, rebellion, insurrection, sabotage, epidemic, quarantine, labor disputes, acts of God or government, any such event of force majeure affecting Upperlink 's third-party partners, or judicial action.</p>
        <ol start=\"14\">
        <li><strong>14</strong>.<strong>Governing Law; Jurisdiction</strong></li>
        </ol>
        <p>This Agreement and any controversy arising out of or in relation to it shall be governed by the laws of the Federal Republic of Nigeria and, subject to Section 16 below, the parties hereby submit to the jurisdiction of the State and Federal courts of the Nigeria which shall have exclusive jurisdiction over all controversies in connection herewith. Reseller hereby waives any right to assert any rights or defenses within any other jurisdiction or to require that litigation regarding this Agreement take place elsewhere.</p>
        <ol start=\"15\">
        <li><strong>Severability </strong></li>
        </ol>
        <p>If any provision of this Agreement shall be declared void, invalid, or illegal, the validity or legality of all other provisions of the Agreement shall not be affected thereby.</p>
        <ol start=\"16\">
        <li><strong>16</strong>.<strong>Dispute Resolution </strong></li>
        </ol>
        <p>Disputes will be categorized as Domain Registration Disputes and Registrar Services Dispute</p>
        <p>Domain Dispute Resolution</p>
        <p>Reseller agrees to be bound by Uniform Dispute Resolution Procedure/Policies on all domains subject to the UDRP and Nigeria Internet Registration Association&rsquo;s NDRP for Nigerian Country Code Top Level Domains.</p>
        <p>16.1. If a Reseller is dissatisfied with the resolution of a complaint treated in accordance with the Complaints</p>
        <p>Handling Process, if any dispute, claim, controversy or difference of any kind whatsoever arising out of</p>
        <p>connection with this AGREEMENT, or breach thereof (the &ldquo;Dispute&rdquo;), the parties shall attempt to settle such dispute in the first instance within thirty (30) Days from the date upon which one party has given written notice of the Dispute to the other party, by discussions between or among the parties (&ldquo;Discussion Period&rdquo;). If the Dispute cannot be settled within the discussion period, then the matter may be referred to arbitration to be conducted pursuant to the Nigerian Arbitration and Conciliation Act. Cap A18, Laws of the Federation of Nigeria, 2004.</p>
        <ol start=\"17\">
        <li><strong>17</strong>.<strong>No Waiver </strong></li>
        </ol>
        <p>Any failure of either party to enforce at any time, or for any period of time, any provision of this Agreement, shall not constitute a waiver of such provision or in any way affect the validity of this Agreement.</p>
        <ol start=\"18\">
        <li><strong>18</strong>.<strong>Complete Agreement</strong></li>
        </ol>
        <p>This Agreement with its Annexure contains the parties' entire Agreement and supersedes all previous communications, representations or agreements, oral or written, regarding its subject matter. No addition to or modification hereof shall bind either party unless reduced to writing and duly executed by the parties as this Agreement was, subject, however, to revisions in Annexure A, which Upperlink may revise at any time..</p>
        <ol start=\"19\">
        <li><strong>19</strong>.<strong>Annexure</strong></li>
        </ol>
        <p>The Annexures attached hereto are incorporated herein by this reference, and Upperlink has the right to amend in writing any of those Annexures in its sole discretion.</p>
        <p><strong>IN WITNESS WHEREOF,</strong> the parties have executed this AGREEMENT effective as of the date first above written.</p>
        <p><strong>THE COMMON SEAL OF THE WITHIN NAMED UPPERLINK LIMITED </strong>was duly affixed in the presence of:</p>
        <p>_____________________________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;_____________________________________</p>
        <p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Director&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Secretary</p>
        <p><br /><br /></p>
        <p><strong>SIGNED, SEALED AND DELIVERED BY:</strong> <strong>WITNESS</strong></p>
        <p>Signature:__________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Signature::__________________</p>
        <p>Name:__________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Name:__________________</p>
        <p>Address:__________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Address:__________________</p>
        <p>Occupation:__________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Occupation:__________________</p>
        <p><strong>ANNEXURE A</strong></p>
        <p><strong>SPECIFICATION ON PRIVACY AND PROXY REGISTRATIONS</strong></p>
        <p>Until the earlier to occur of (i) January 1, 2017, and (ii) the date ICANN establishes and implements a Privacy and Proxy Accreditation Program, Reseller agrees to comply, with the terms of this Specification, provided that ICANN and the Working Group may mutually agree to extend the term of this Specification. This Specification may not be modified by ICANN or Registrar.</p>
        <ol>
        <li><strong> Definitions. </strong></li>
        </ol>
        <p>For the purposes of this Specification, the following definitions shall apply.</p>
        <p>1.1 &ldquo;P/P Customer&rdquo; means, regardless of the terminology used by the P/P Provider, the licensee, customer, beneficial user, beneficiary, or other recipient of Privacy Services and Proxy Services.</p>
        <p>1.2 &ldquo;Privacy Service&rdquo; is a service by which a Registered Name is registered to its beneficial user as the Registered Name Holder, but for which alternative, reliable contact information is provided by the P/P Provider for display of the Registered Name Holder&rsquo;s contact information in the Registration Data Service (Whois) or equivalent services.</p>
        <p>1.3 &ldquo;Proxy Service&rdquo; is a service through which a Registered Name Holder licenses use of a Registered Name to the P/P Customer in order to provide the P/P Customer use of the domain name, and the Registered Name Holder's contact information is displayed in the Registration Data Service (Whois) or equivalent services rather than the P/P Customer&rsquo;s contact information.</p>
        <p>1.4 &ldquo;P/P Provider&rdquo; or &ldquo;Service Provider&rdquo; is the provider of Privacy/Proxy Services, including Registrar and its Affiliates, as applicable.</p>
        <ol start=\"2\">
        <li><strong> Obligations of Reseller</strong>.</li>
        </ol>
        <p>For any Proxy Service or Privacy Service offered by the Reseller or its Affiliates, and used in connection with Registered Names Sponsored by the Reseller and its Affiliates, Reseller must require all P/P Providers to follow the requirements described in this Specification and to abide by the terms and procedures published pursuant to this Specification.</p>
        <p>2.1 Disclosure of Service Terms.</p>
        <p>P/P Provider shall publish the terms and conditions of its service (including pricing), on its website and/or Reseller&rsquo;s website.</p>
        <p>2.2 Abuse/Infringement Point of Contact.</p>
        <p>P/P Provider shall publish a point of contact for third parties wishing to report abuse or infringement of trademarks</p>
        <p>(or other rights).</p>
        <p>2.3 Disclosure of Identity of P/P Provider.</p>
        <p>P/P Provider shall publish its business contact information on Resellers website.</p>
        <p>2.4 Terms of service and description of procedures.</p>
        <p>The P/P Provider shall publish on its website and/or Reseller&rsquo;s website a copy of the P/P Provider service agreement and description of P/P Provider&rsquo;s procedures for handling the following:</p>
        <p>2.4.1 The process or facilities to report abuse of a domain name registration managed by the P/P Provider;</p>
        <p>2.4.2 The process or facilities to report infringement of trademarks or other rights of third parties;</p>
        <p>2.4.3 The circumstances under which the P/P Provider will relay communications from third parties to the P/P Customer;</p>
        <p>2.4.4 The circumstances under which the P/P Provider will terminate service to the P/P Customer;</p>
        <p>2.4.5 The circumstances under which the P/P Provider will reveal and/or publish in the Registration Data Service (Whois) or equivalent service the P/P Customer&rsquo;s identity and/or contact data; and</p>
        <p>2.4.6 A description of the support services offered by P/P Providers to P/P Customers, and how to access these services.</p>
        <ol start=\"3\">
        <li><strong> Exemptions. </strong></li>
        </ol>
        <p>Reseller is under no obligation to comply with the requirements of this specification if it can be shown that:</p>
        <p>3.1 Registered Name Holder employed the services of a P/P Provider that is not provided by Reseller, or any of its Affiliates;</p>
        <p>3.2 Registered Name Holder licensed a Registered Name to another party (i.e., is acting as a Proxy Service) without Reseller&rsquo;s knowledge; or</p>
        <p>3.3 Registered Name Holder has used P/P Provider contact data without subscribing to the service or accepting the P/P Provider terms and conditions.</p>
        <p><strong>ANNEXURE B</strong></p>
        <p><strong>Registrants' Benefits and Responsibilities</strong></p>
        <p><strong><em>Domain Name Registrants' Rights:</em></strong></p>
        <ol>
        <li>Your domain name registration and any privacy/proxy services you may use in conjunction with it must be subject to a Registration Agreement with {Reseller name}.</li>
        <ul>
        <li>You are entitled to review this Registration Agreement at any time, and download a copy for your records.</li>
        </ul>
        <li>You are entitled to accurate and accessible information about:</li>
        <ul>
        <li>{Reseller name};</li>
        <li>The identity of any proxy or privacy service provider affiliated with your {Reseller name};</li>
        <li>{Reseller name}'s terms and conditions, including pricing information, applicable to domain name registrations;</li>
        <li>The terms and conditions, including pricing information, applicable to any privacy services offered by {Reseller name};</li>
        <li>The customer support services offered by {Reseller name} and the privacy services provider, and how to access them;</li>
        <li>How to raise concerns and resolve disputes with {Reseller name} and any privacy services offered by {Reseller name}; and</li>
        <li>Instructions that explain {Reseller name}'s processes for registering, managing, transferring, renewing, and restoring your domain name registrations, including through any proxy or privacy services made available by {Reseller name}.</li>
        </ul>
        <li>You shall not be subject to false advertising or deceptive practices by {Reseller name} or through any proxy or privacy services made available by {Reseller name}. This includes deceptive notices, hidden fees, and any practices that are illegal under the consumer protection law of your residence.</li>
        </ol>
        <p><strong><em>Domain Name&nbsp;Registrants' Responsibilities:</em></strong></p>
        <ol>
        <li>You must comply with the terms and conditions posted by {Reseller name}, including applicable policies from {Reseller name} and Affiliates.</li>
        <li>You must review {Reseller name}'s current Registration Agreement, along with any updates.</li>
        <li>You will assume sole responsibility for the registration and use of your domain name.</li>
        <li>You must provide accurate information for publication in directories such as&nbsp;WHOIS, and promptly update this to reflect any changes.</li>
        <li>You must respond to inquiries from {Reseller name} within fifteen (15) days, and keep your account data current. If you choose to have your domain name registration renewed automatically, you must also keep your payment information current.</li>
        </ol>
        <p><strong>ANNEXURE C</strong></p>
        <p><strong><em>To be printed and signed</em></strong></p>
        <p>Your Address</p>
        <p>The Managing Director</p>
        <p>Upperlink Limited</p>
        <p>ASSBIFI House</p>
        <p>4 ASSBIFI Road</p>
        <p>Alausa, CBD</p>
        <p>Ikeja</p>
        <p>Lagos.</p>
        <p><strong>INDEMNITY</strong></p>
        <p>I, {Name}. of {Address}. (hereinafter called the &ldquo;Reseller&rdquo;) hereby issue this Indemnity to Upperlink Limited. (hereinafter called the &ldquo;Registrar&rdquo;).<br /><br />WHEREAS:<br /><br />1.The Reseller and Registrar have entered into an agreement for the provision of domain registration and related services.</p>
        <ol start=\"2\">
        <li><br />It is a condition of the said Agreement that the Reseller shall indemnify Registrar against any loss, claims damages, suffered by Registrar which may arise as a result of the Reseller&rsquo;s default, acts, omissions, failure, negligence under the Agreement. Registrar shall also in turn shall indemnify Reseller against any loss, claims damages, suffered by Reseller which may arise as a result of the default, acts, omissions, failure, or negligence of the Registrar under the Agreement.</li>
        <li><br />Reseller hereby issues this Indemnity in favour of the Registrar.<br />I, &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;. hereby agree to indemnify Upperlink Limited upon its first demand, without argument or cavil in full against all losses, costs and expenses suffered or incurred by Registrar arising from and in connection with Reseller&rsquo;s default, acts, omissions, failure, negligence under the said Agreement. <br /><br />Without prejudice to the foregoing paragraph, I further agree as follows:<br />3.1.That I shall pay to the Registrar upon its first demand without argument or cavil:<br /><br />(i)lawful amounts paid by the Registrar to third parties pursuant to the indemnity provisions of the Agreement;</li>
        </ol>
        <p><br />(ii)attorney&rsquo;s fees, court costs and all other lawful expenses incurred by the Registrar in connection with this indemnity or the enforcement of its rights under the Agreement and/or Indemnity.</p>
        <p>(iii) In any action, arbitration or proceeding for which indemnification is sought, I reserve the right to participate in the defense of Upperlink and to retain its own counsel at its own expense. I agree to use reasonable efforts to keep Upperlink reasonably apprised of the status of the defense. Both parties agree to cooperate in good faith with each other with respect to the defense of any such domain name legal action.<br /><br />3.2.That I shall immediately reimburse the Registrar for any and all lawful amounts paid to third parties under a lawful demand, regardless of and without set-off or deduction for any claims which we may have against the Registrar, NIRA/ICANN or any other party to the Agreement.<br /><br />3.3.That in the event of my failure to make timely payment of any lawful amount due hereunder, the Registrar may set off such amount against any of my sums/monies with the Reseller or the indebtedness owing from the Reseller. This right may be exercised in addition to any other legal rights the Registrar may have.</p>
        <p><br />AND IT IS HEREBY DECLARED that this Indemnity shall not be construed to take away the right of action in any court of law if any, that the Parties may have.<br /><br />This Indemnity shall be construed in accordance with the Laws of the Federal Republic of Nigeria.<br /><br />IN WITNESS WHEREOF, I have executed this Indemnity in the manner set out hereunder.<br /><br /><br /><strong>IN WITNESS WHEREOF,</strong> the parties have executed this AGREEMENT effective as of the date first above written.</p>
        <p><strong>THE COMMON SEAL OF THE WITHIN NAMED UPPERLINK LIMITED </strong>was duly affixed in the presence of:</p>
        <p>__________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;__________________</p>
        <p>&nbsp; &nbsp; &nbsp; &nbsp; Director&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Secretary</p>
        <p><br /><br /></p>
        <p><strong>SIGNED, SEALED AND DELIVERED BY:</strong> <strong>WITNESS</strong></p>
        <p>Signature:__________________ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Signature::__________________</p>
        <p>Name:__________________ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Name:__________________</p>
        <p>Address:__________________ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Address:__________________</p>
        <p>Occupation:__________________ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Occupation:__________________</p>";

        $pdf->writeHTML($html, true, 0, true, 0);
        
        // reset pointer to the last page
        $pdf->lastPage();
        $pdf->Output('reselleragreement.pdf', 'D');
        //$pdf->AddPage();
        //$ca->setTemplate('reselleragreementpdf');
}elseif($request['type'] == 'corporate'){
    $pdf->SetSubject('RESELLER AGREEMENT FOR CORPORATE');
    $html = "
<p><strong>RESELLER AGREEMENT FOR CORPORATE ENTITY</strong></p>
<p>This Reseller Agreement (the &ldquo;Agreement&rdquo;) is effective this 25th day of June, 2018.</p>
<p>BETWEEN: Upperlink Limited (the \"Registrar\"), a company duly incorporated and existing under the laws of the Federal Republic of Nigeria with its head office located at ASSBIFI House, 4 ASSBIFI Road, Alausa, CBD, Ikeja, Lagos, Nigeria.</p>
<p>AND: (the \"Reseller\"), an individual/company incorporated and existing under the laws of the Federal republic of Nigeria with his/its head office/resident address located at &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.&hellip;&hellip;&hellip;&hellip;.</p>
<p><strong>1.</strong></p>
<p>1.1<strong>Preamble</strong></p>
<p>Whereas, Reseller by virtue of the volume of transactions or pricing the client is categorized as an independent non-exclusive Reseller to market its domains on all its available extensions or purchase domains on behalf of another. Reseller shall at all times adhere to the standard terms, conditions, rules and policies of Upperlink as may be issued by Upperlink from time to time, and shall be solely responsible for all its acts and omissions in the course of acting as an Authorized Reseller of Upperlink&rsquo;s domains. Upperlink Services means the services agreed to between the parties from time to time with any exclusions, additions or discounts Upperlink may make.</p>
<p>1.2<strong>Sub-Resellers </strong></p>
<p>Reseller may appoint sub-resellers, resellers or agents (\"Sub-resellers\") to market, domains provided that the reseller incorporates these terms and conditions in its agreement with the sub reseller. Reseller shall be liable for the acts and omissions of any such Sub-resellers.</p>
<ol start=\"2\">
<li><strong> OBLIGATIONS OF RESELLER</strong></li>
</ol>
<p>2.1 Reseller Program</p>
<p>Resellers can benefit from Upperlink&rsquo;s reseller program which allows movement from one level to another with access to higher levels of discount. Reseller should aim to increase its registration volume to benefit from the program.</p>
<p>2.2. <strong>Marketing and Service Support</strong></p>
<p>Reseller shall use reasonable efforts to market and sell domains and shall comply with the policies, programs, and requirements regarding marketing and support as may be communicated by Upperlink to Reseller from time to time. Reseller shall provide first level support to her clients while Upperlink will then provide second level technical support to the Reseller.</p>
<p>2.3<strong>Registration Confirmation</strong></p>
<p>Reseller may request for registration via electronic mail or its API. Upperlink will also provide Reseller with the capacity to register directly into Upperlink's software. Acceptance by Upperlink of the registration shall occur (a) when the registration is entered into Upperlink's software, (b) when a registration request is provided to Reseller via electronic mail, if requested by Reseller. Reseller is obliged to ensure that domain orders made on the platform are registered and confirmed in his account on completion of registration.</p>
<p>2.4 <strong>Reseller as Registrant</strong></p>
<p>Where you as a reseller register a domain name as the Registered Name Holder, you agree to be bound by the same terms in Upperlink&rsquo;s Registrant Agreement as a Registered Name Holder and shall comply with the terms of the Agreement.</p>
<p>2.5 <strong>Whois Data Reminder</strong></p>
<p>At least annually, a Reseller must present to the registrant the current Whois information, and remind the registrant that provision of false Whois information can be grounds for cancellation of their domain name registration. Registrants must review their Whois data, and make any corrections.</p>
<p>2.6. <strong>Registrant Educational Information</strong></p>
<p>Reseller must publish on their website Registrants Educational Information in Annexure B.</p>
<p>2.7. <strong>Obligations Related to Proxy and Privacy Services.</strong></p>
<p>Where the Reseller uses a Privacy Proxy Service, the Reseller must ensure that it adheres to the Specification on Privacy and Proxy Registrations in Annexure A to this Agreement. Reseller must provide through the Privacy/Proxy Service Provider the identity of the Registrant for Registry Data Escrow Purposes in accordance to ICANN&rsquo;s regulations.</p>
<p>2.8. <strong>Archiving/Information Request</strong></p>
<p>Reseller shall ensure it archives records of its client&rsquo;s registrations and transactions for record/dispute resolution purposes. Reseller shall not withhold Registrar&rsquo;s information upon request by the Registrant of its Sponsoring Registrar details.</p>
<p>2.9. <strong>Requirements for Technical Expertise/Experience</strong></p>
<p>Reseller must ensure that they have the requisite technical expertise/experience required for the domain business.</p>
<p>2.10 <strong>Observance of Upperlink Policies and Effects of Non Compliance</strong></p>
<p>Upperlink will keep Reseller informed of Upperlink's domain registration policies and procedures, and Reseller agrees to follow such policies and procedures. Failure to comply with the provisions of this agreement may result in termination of this Agreement pursuant to Section 8 and 9 of this Agreement.</p>
<p>2.11 <strong>Duty to Communicate</strong></p>
<p>Reseller agrees to have an active means of communication both via phone and email for emergencies through which Upperlink can reach the Reseller regarding domain management issues. Where the Reseller fails to do so, Upperlink after exhausting all means of communication may communicate with the registrant at no liability to Upperlink.</p>
<ol start=\"3\">
<li><strong>OBLIGATIONS OF UPPERLINK</strong></li>
</ol>
<p>3.1. Where the Reseller requests for a registration by Upperlink on her behalf, Upperlink is obliged to fulfill the request however, where the registration is not completed Upperlink will inform the Reseller of the reason for the failure. Reseller will inform the client of its failure to do so immediately and Upperlink will not be liable for failure to register such domain.</p>
<p>3.2. Upperlink will not sell domains directly or willfully poach any of its Reseller&rsquo;s clients.</p>
<ol start=\"4\">
<li><strong>PRICES, PAYMENTS AND REFUNDS</strong></li>
</ol>
<p>4.1.Reseller's Purchase Price and Price changes</p>
<p>Payment channels are available to the Client including Bank Deposits, Online Transfer and Account Credits. Upperlink may at any time change pricing or the Reseller's purchase price with notice and without liability, but any registration request accepted by Upperlink before a price change takes effect shall be invoiced at the previous price. No refunds will be made for domain registration except where a reversal is automatically done from the payment channel.</p>
<ol start=\"5\">
<li><strong>TRADEMARKS, TRADE NAMES</strong></li>
</ol>
<p>Reseller acknowledges that Upperlink and/or its parent or affiliates are the sole and exclusive owners of the name \"Upperlink\" and any abbreviations or variations thereof, and of any and all of Upperlink's trademarks and trade names, service marks, trade logos and trade dress (collectively \"Trademarks\") as Upperlink may unilaterally amend periodically (registered or not). Reseller agrees not to register or use any mark(s) that are similar enough to be construed as Upperlink Trademarks. Reseller acquires no rights to the Trademarks.</p>
<ol start=\"6\">
<li><strong>HANDLING DOMAIN REGISTRATION ABUSE</strong></li>
</ol>
<p>Domain Registration abuse includes and is not limited to domains registered for phishing, malware, botnets and domains advertised in spam, Intellectual property infringement, copyright violations, and certain types of highly offensive content display.</p>
<p>Reseller agrees to take reasonable and prompt steps to investigate and respond appropriately. keep records and treat any reports of abuse.</p>
<ol start=\"7\">
<li><strong>TERM</strong></li>
</ol>
<p>This Agreement's term (\"Term\") shall be effective on the date the client is categorized as a Reseller and shall be automatically renewed annually, provided that either party hereto may terminate this Agreement at any time with or without notice, and further provided that this Agreement shall terminate automatically if Reseller makes no purchases from Upperlink hereunder for a period of 90 calendar days, such termination to be effective as of the next calendar day after such period elapses.</p>
<ol start=\"8\">
<li><strong>TERMINATION</strong></li>
</ol>
<p>8.1. Either party can terminate this Agreement without cause by giving 30 days' written notice to the other.</p>
<p>8.2.This Agreement may be terminated for cause upon written notice:</p>
<ol>
<li>a)By either party upon 5 days' written notice if the other commits a material breach of the Agreement and fails to cure it within the 5 days;</li>
<li>b)By Upperlink immediately if Reseller files for or has instituted against Upperlink any proceedings as to its bankruptcy, insolvency, reorganization, liquidation, receivership, or dissolution or there is an assignment for the benefit of creditors;</li>
</ol>
<p><strong>9</strong><strong>EFFECT OF TERMINATION</strong></p>
<p>9.1Upon termination of this Agreement, Upperlink may terminate any or all registration requests.</p>
<p>9.2Upon termination, Reseller may transfer its domains and clients to Upperlink or as may be agreed by both parties.</p>
<p>9.3Termination will discharge and release Upperlink from all obligations and liability under this Agreement, except as it expressly accepts for prior registration requests. The sole fact of this Agreement's termination shall not make either party liable to the other for any compensation, reimbursement, losses or damages whatsoever, though Reseller shall remain obliged to pay all outstanding balances on its domain transactions.</p>
<p>9.4 Termination will not absolve the Reseller from performing all outstanding obligations due to Upperlink prior to termination.</p>
<ol start=\"10\">
<li><strong>CONFIDENTIALITY</strong></li>
</ol>
<p>.Confidential Information</p>
<p>Prior to and during the Term hereof, Upperlink may convey to Reseller proprietary and confidential information about Upperlink Products, services, strategy and analysis. For the Term of this Agreement (including renewals) and for 2 years thereafter, Reseller shall not disclose to any third party any such information marked CONFIDENTIAL, PROPRIETARY, STRICTLY PRIVATE, or INTERNAL DATA, or which, though not so marked, could reasonably be construed as confidential or sensitive, such as the terms of this Agreement (all collectively \"Confidential Information\"), nor shall it use any such Confidential Information for its own benefit, except as provided herein. Any reliance on such Confidential Information is at Reseller's own risk. Nothing in this Section grants or implies any rights by license, estoppel, or otherwise. Confidential Information does not include information (i) in the public domain at the time of disclosure or which enters the public domain after such disclosure through no fault of Reseller, (ii) generally disclosed to third parties by Upperlink without restriction, (iii) communicated to Reseller by a third party with the unrestricted right to do so, or (iv) approved for release by Upperlink in writing.</p>
<ol start=\"11\">
<li><strong>LIMITATION OF LIABILITY AND REMEDIES; INDEMNITY</strong></li>
</ol>
<p>Limitation of Liability; Sole Remedy</p>
<p>Any liability of Upperlink under this Agreement is expressly limited to the price paid by Reseller for the domains involved. Reseller's sole remedy against Upperlink in any dispute concerning this Agreement shall be to seek recovery of that amount, upon payment of which Upperlink shall be released from all further obligations and liability to Reseller.</p>
<ol start=\"12\">
<li><strong>12</strong>.<strong>INDEMNITY</strong></li>
</ol>
<p>Except as otherwise stated herein, Reseller shall indemnify and hold harmless Upperlink against any and all claims, legal actions, losses, damages, liabilities, costs and expenses asserted against, imposed upon or incurred by Upperlink arising out of or relating to:</p>
<p>(i) any misrepresentation or breach of warranty or covenant by Reseller under this Agreement;</p>
<p>(ii) any actual or alleged act or omission of Reseller in the course of its performance of its business;</p>
<p>(iii) any claim of infringement arising from the registration of domain.</p>
<p>THIS INDEMNITY IS UPPERLINK'S SOLE LIABILITY AND RESELLER'S SOLE REMEDY FOR INFRINGEMENT OF</p>
<p>ANY PATENT, COPYRIGHT, TRADEMARK, TRADE SECRET OR OTHER INTELLECTUAL PROPERTY RIGHT. In</p>
<p>addition to this clause, Reseller will also ensure they provide an indemnity on their letterhead to Upperlink</p>
<p>with the content outlined in Annexure C.</p>
<ol start=\"13\">
<li><strong>FORCE MAJEURE</strong></li>
</ol>
<p>Upperlink shall not be liable for any failure to perform due to causes beyond its control, including but not limited to fire, flood, earthquake, explosion, accident, acts of public enemy, war, rebellion, insurrection, sabotage, epidemic, quarantine, labor disputes, acts of God or government, any such event of force majeure affecting Upperlink 's third-party partners, or judicial action.</p>
<ol start=\"14\">
<li><strong>14</strong>.<strong>Governing Law; Jurisdiction</strong></li>
</ol>
<p>This Agreement and any controversy arising out of or in relation to it shall be governed by the laws of the Federal Republic of Nigeria and, subject to Section 16 below, the parties hereby submit to the jurisdiction of the State and Federal courts of the Nigeria which shall have exclusive jurisdiction over all controversies in connection herewith. Reseller hereby waives any right to assert any rights or defenses within any other jurisdiction or to require that litigation regarding this Agreement take place elsewhere.</p>
<ol start=\"15\">
<li><strong>Severability </strong></li>
</ol>
<p>If any provision of this Agreement shall be declared void, invalid, or illegal, the validity or legality of all other provisions of the Agreement shall not be affected thereby.</p>
<ol start=\"16\">
<li><strong>16</strong>.<strong>Dispute Resolution </strong></li>
</ol>
<p>Disputes will be categorized as Domain Registration Disputes and Registrar Services Dispute</p>
<p>Domain Dispute Resolution</p>
<p>Reseller agrees to be bound by Uniform Dispute Resolution Procedure/Policies on all domains subject to the UDRP and Nigeria Internet Registration Association&rsquo;s NDRP for Nigerian Country Code Top Level Domains.</p>
<p>16.1. If a Reseller is dissatisfied with the resolution of a complaint treated in accordance with the Complaints</p>
<p>Handling Process, if any dispute, claim, controversy or difference of any kind whatsoever arising out of</p>
<p>connection with this AGREEMENT, or breach thereof (the &ldquo;Dispute&rdquo;), the parties shall attempt to settle such dispute in the first instance within thirty (30) Days from the date upon which one party has given written notice of the Dispute to the other party, by discussions between or among the parties (&ldquo;Discussion Period&rdquo;). If the Dispute cannot be settled within the discussion period, then the matter may be referred to arbitration to be conducted pursuant to the Nigerian Arbitration and Conciliation Act. Cap A18, Laws of the Federation of Nigeria, 2004.</p>
<ol start=\"17\">
<li><strong>17</strong>.<strong>No Waiver </strong></li>
</ol>
<p>Any failure of either party to enforce at any time, or for any period of time, any provision of this Agreement, shall not constitute a waiver of such provision or in any way affect the validity of this Agreement.</p>
<ol start=\"18\">
<li><strong>18</strong>.<strong>Complete Agreement</strong></li>
</ol>
<p>This Agreement with its Annexure contains the parties' entire Agreement and supersedes all previous communications, representations or agreements, oral or written, regarding its subject matter. No addition to or modification hereof shall bind either party unless reduced to writing and duly executed by the parties as this Agreement was, subject, however, to revisions in Annexure A, which Upperlink may revise at any time..</p>
<ol start=\"19\">
<li><strong>19</strong>.<strong>Annexure</strong></li>
</ol>
<p>The Annexures attached hereto are incorporated herein by this reference, and Upperlink has the right to amend in writing any of those Annexures in its sole discretion.</p>
<p><strong>IN WITNESS WHEREOF,</strong> the parties have executed this AGREEMENT effective as of the date first above written.</p>
<p><strong>THE COMMON SEAL OF THE WITHIN NAMED UPPERLINK LIMITED </strong>was duly affixed in the presence of:</p>
<p>__________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; __________________</p>
<p>&nbsp; &nbsp; &nbsp; Director&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Secretary</p>
<p><br /><br /></p>
<p><strong>IN WITNESS WHEREOF,</strong> the parties have executed this AGREEMENT effective as of the date first above written.</p>
<p><strong>THE COMMON SEAL OF THE WITHIN NAMED &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip; </strong>was duly affixed in the presence of:</p>
<p>__________________&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; __________________</p>
<p>&nbsp; &nbsp; &nbsp; &nbsp;Director&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Secretary&nbsp;</p>
<p><strong>ANNEXURE A</strong></p>
<p><strong>SPECIFICATION ON PRIVACY AND PROXY REGISTRATIONS</strong></p>
<p>Until the earlier to occur of (i) January 1, 2017, and (ii) the date ICANN establishes and implements a Privacy and Proxy Accreditation Program, Reseller agrees to comply, with the terms of this Specification, provided that ICANN and the Working Group may mutually agree to extend the term of this Specification. This Specification may not be modified by ICANN or Registrar.</p>
<ol>
<li><strong> Definitions. </strong></li>
</ol>
<p>For the purposes of this Specification, the following definitions shall apply.</p>
<p>1.1 &ldquo;P/P Customer&rdquo; means, regardless of the terminology used by the P/P Provider, the licensee, customer, beneficial user, beneficiary, or other recipient of Privacy Services and Proxy Services.</p>
<p>1.2 &ldquo;Privacy Service&rdquo; is a service by which a Registered Name is registered to its beneficial user as the Registered Name Holder, but for which alternative, reliable contact information is provided by the P/P Provider for display of the Registered Name Holder&rsquo;s contact information in the Registration Data Service (Whois) or equivalent services.</p>
<p>1.3 &ldquo;Proxy Service&rdquo; is a service through which a Registered Name Holder licenses use of a Registered Name to the P/P Customer in order to provide the P/P Customer use of the domain name, and the Registered Name Holder's contact information is displayed in the Registration Data Service (Whois) or equivalent services rather than the P/P Customer&rsquo;s contact information.</p>
<p>1.4 &ldquo;P/P Provider&rdquo; or &ldquo;Service Provider&rdquo; is the provider of Privacy/Proxy Services, including Registrar and its Affiliates, as applicable.</p>
<ol start=\"2\">
<li><strong> Obligations of Reseller</strong>.</li>
</ol>
<p>For any Proxy Service or Privacy Service offered by the Reseller or its Affiliates, and used in connection with Registered Names Sponsored by the Reseller and its Affiliates, Reseller must require all P/P Providers to follow the requirements described in this Specification and to abide by the terms and procedures published pursuant to this Specification.</p>
<p>2.1 Disclosure of Service Terms.</p>
<p>P/P Provider shall publish the terms and conditions of its service (including pricing), on its website and/or Reseller&rsquo;s website.</p>
<p>2.2 Abuse/Infringement Point of Contact.</p>
<p>P/P Provider shall publish a point of contact for third parties wishing to report abuse or infringement of trademarks</p>
<p>(or other rights).</p>
<p>2.3 Disclosure of Identity of P/P Provider.</p>
<p>P/P Provider shall publish its business contact information on Resellers website.</p>
<p>2.4 Terms of service and description of procedures.</p>
<p>The P/P Provider shall publish on its website and/or Reseller&rsquo;s website a copy of the P/P Provider service agreement and description of P/P Provider&rsquo;s procedures for handling the following:</p>
<p>2.4.1 The process or facilities to report abuse of a domain name registration managed by the P/P Provider;</p>
<p>2.4.2 The process or facilities to report infringement of trademarks or other rights of third parties;</p>
<p>2.4.3 The circumstances under which the P/P Provider will relay communications from third parties to the P/P Customer;</p>
<p>2.4.4 The circumstances under which the P/P Provider will terminate service to the P/P Customer;</p>
<p>2.4.5 The circumstances under which the P/P Provider will reveal and/or publish in the Registration Data Service (Whois) or equivalent service the P/P Customer&rsquo;s identity and/or contact data; and</p>
<p>2.4.6 A description of the support services offered by P/P Providers to P/P Customers, and how to access these services.</p>
<ol start=\"3\">
<li><strong> Exemptions. </strong></li>
</ol>
<p>Reseller is under no obligation to comply with the requirements of this specification if it can be shown that:</p>
<p>3.1 Registered Name Holder employed the services of a P/P Provider that is not provided by Reseller, or any of its Affiliates;</p>
<p>3.2 Registered Name Holder licensed a Registered Name to another party (i.e., is acting as a Proxy Service) without Reseller&rsquo;s knowledge; or</p>
<p>3.3 Registered Name Holder has used P/P Provider contact data without subscribing to the service or accepting the P/P Provider terms and conditions.</p>
<p><strong>ANNEXURE B</strong></p>
<p><strong>Registrants' Benefits and Responsibilities</strong></p>
<p><strong><em>Domain Name Registrants' Rights:</em></strong></p>
<ol>
<li>Your domain name registration and any privacy/proxy services you may use in conjunction with it must be subject to a Registration Agreement with {Reseller name}.</li>
<ul>
<li>You are entitled to review this Registration Agreement at any time, and download a copy for your records.</li>
</ul>
<li>You are entitled to accurate and accessible information about:</li>
<ul>
<li>{Reseller name};</li>
<li>The identity of any proxy or privacy service provider affiliated with your {Reseller name};</li>
<li>{Reseller name}'s terms and conditions, including pricing information, applicable to domain name registrations;</li>
<li>The terms and conditions, including pricing information, applicable to any privacy services offered by {Reseller name};</li>
<li>The customer support services offered by {Reseller name} and the privacy services provider, and how to access them;</li>
<li>How to raise concerns and resolve disputes with {Reseller name} and any privacy services offered by {Reseller name}; and</li>
<li>Instructions that explain {Reseller name}'s processes for registering, managing, transferring, renewing, and restoring your domain name registrations, including through any proxy or privacy services made available by {Reseller name}.</li>
</ul>
<li>You shall not be subject to false advertising or deceptive practices by {Reseller name} or through any proxy or privacy services made available by {Reseller name}. This includes deceptive notices, hidden fees, and any practices that are illegal under the consumer protection law of your residence.</li>
</ol>
<p><strong><em>Domain Name&nbsp;Registrants' Responsibilities:</em></strong></p>
<ol>
<li>You must comply with the terms and conditions posted by {Reseller name}, including applicable policies from {Reseller name} and Affiliates.</li>
<li>You must review {Reseller name}'s current Registration Agreement, along with any updates.</li>
<li>You will assume sole responsibility for the registration and use of your domain name.</li>
<li>You must provide accurate information for publication in directories such as&nbsp;WHOIS, and promptly update this to reflect any changes.</li>
<li>You must respond to inquiries from {Reseller name} within fifteen (15) days, and keep your account data current. If you choose to have your domain name registration renewed automatically, you must also keep your payment information current.</li>
</ol>
<p><strong>ANNEXURE C</strong></p>
<p><strong><em>To be drafted on the Resellers letterhead</em></strong></p>
<p>Date</p>
<p>The Managing Director</p>
<p>Upperlink Limited</p>
<p>ASSBIFI House</p>
<p>4 ASSBIFI Road</p>
<p>Alausa, CBD</p>
<p>Ikeja</p>
<p>Lagos.</p>
<p><strong>INDEMNITY</strong><br />We, &hellip;&hellip;&hellip;&hellip;&hellip;.. Limited of &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.. (hereinafter called the &ldquo;Reseller&rdquo;) hereby issue this Indemnity to Upperlink Limited. (hereinafter called the &ldquo;Registrar&rdquo;).<br /><br />WHEREAS:<br /><br />1.The Reseller and Registrar have entered into an agreement for the provision of domain registration and related services.</p>
<ol start=\"2\">
<li><br />It is a condition of the said Agreement that the Reseller shall indemnify Registrar against any loss, claims damages, suffered by Registrar which may arise as a result of the Reseller&rsquo;s default, acts, omissions, failure, negligence under the Agreement. Registrar shall also in turn shall indemnify Reseller against any loss, claims damages, suffered by Reseller which may arise as a result of the default, acts, omissions, failure, or negligence of the Registrar under the Agreement.</li>
<li><br />Reseller hereby issues this Indemnity in favour of the Registrar.<br /><br />We, &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.Limited, hereby agree to indemnify Upperlink Limited upon its first demand, without argument or cavil in full against all losses, costs and expenses suffered or incurred by Registrar arising from and in connection with Reseller&rsquo;s default, acts, omissions, failure, negligence under the said Agreement. <br /><br />Without prejudice to the foregoing paragraph, we further agree as follows:<br />3.1.That we shall pay to the Registrar upon its first demand without argument or cavil:<br /><br />(i)lawful amounts paid by the Registrar to third parties pursuant to the indemnity provisions of the Agreement;</li>
</ol>
<p><br />(ii)attorney&rsquo;s fees, court costs and all other lawful expenses incurred by the Registrar in connection with this indemnity or the enforcement of its rights under the Agreement and/or Indemnity.</p>
<p>(iii) In any action, arbitration or proceeding for which indemnification is sought, we &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.. reserve the right to participate in the defense of Upperlink and to retain its own counsel at its own expense. &hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;... agrees to use reasonable efforts to keep Upperlink reasonably apprised of the status of the defense. Both parties agree to cooperate in good faith with each other with respect to the defense of any such domain name legal action.<br /><br />3.2.That we shall immediately reimburse the Registrar for any and all lawful amounts paid to third parties under a lawful demand, regardless of and without set-off or deduction for any claims which we may have against the Registrar, NIRA/ICANN or any other party to the Agreement.<br /><br />3.3.That in the event of our failure to make timely payment of any lawful amount due hereunder, the Registrar may set off such amount against any of our sums/monies with the Reseller or the indebtedness owing from the Reseller. This right may be exercised in addition to any other legal rights the Registrar may have.</p>
<p><br />AND IT IS HEREBY DECLARED that this Indemnity shall not be construed to take away the right of action in any court of law if any, that the Parties may have.<br /><br />This Indemnity shall be construed in accordance with the Laws of the Federal Republic of Nigeria.<br /><br />IN WITNESS WHEREOF, we have executed this Indemnity in the manner set out hereunder.<br /><br /><br />THE COMMON SEAL of <br />&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;. Limited was affixed in the presence of:<br /><br /><br /><br />________________________ _____________________<br />DIRECTOR DIRECTOR</p>
";
        $pdf->writeHTML($html, true, 0, true, 0);
        
        // reset pointer to the last page
        $pdf->lastPage();
        $pdf->Output('reselleragreement.pdf', 'D');
        //$ca->setTemplate('reselleragreementpdf');
}else{
    $ca->setTemplate('reselleragreement');
}


$ca->output();

function randStrGen($len){
    $result = "";
    $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_?!-0123456789=";
    $charArray = str_split($chars);
    for($i = 0; $i < $len; $i++){
	    $randItem = array_rand($charArray);
	    $result .= "".$charArray[$randItem];
    }
    return $result;
}

