<?php
/**
 * Created by PhpStorm.
 * User: Daniel Babatunde
 * Date: 4/20/2017
 * Time: 9:15 AM
 */
use WHMCS\ClientArea;
use WHMCS\Database\Capsule as Capsule;

require __DIR__ . '/init.php';

$ca = new ClientArea();

$ca->setPageTitle('Reseller Center');

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb('reseller_api.php', 'Reseller API Credientials');

$ca->initPage();

$ca->requireLogin(); // Uncomment this line to require a login to access this page

// To assign variables to the template system use the following syntax.
// These can then be referenced using {$variablename} in the template.

//$ca->assign('variablename', $value);

// Check login status
if ($ca->isLoggedIn()) {
    $client = Capsule::table('tblclients')->join('tblusers_api', 'tblclients.id', '=', 'tblusers_api.user_id')
        ->where('tblclients.id', $ca->getUserID())->first();
    if(isset($_POST['generate_keys'])){
        $api_key = randStrGen(200);
        $api_keyid = randStrGen(12);
        
        if(count($client) > 0 ){
            $respp = Capsule::table('tblusers_api')
            ->where('id', $client->id)
            ->update(['userapi_enabled' => 1,'userapi_key'=>$api_key,'userapi_keyid'=>$api_keyid]);
        }else{
            $respp = Capsule::table('tblusers_api')->insert(
                ['user_id' => $ca->getUserID(), 'userapi_enabled' => 1,'userapi_key'=>$api_key,'userapi_keyid'=>$api_keyid]
            );
        }
        if($respp){
             $ca->assign('keyGenerated', true);
        }else{
            $ca->assign('keyGenerated', false);
        }
    }
    
    if(isset($_POST['save_ip'])){
        
        if(count($client) > 0 ){
            //print_r($_POST);
            //print_r($client);
            $resp = Capsule::table('tblusers_api')
            ->where('id', $client->id)
            ->update(
                [
                    'userapi_enabled' => 1,
                    'userapi_ip1'=>$_POST['ip1'],
                    'userapi_ip2'=>$_POST['ip2'],
                    'userapi_ip3'=>$_POST['ip3'],
                    'userapi_ip4'=>$_POST['ip4'],
                    'userapi_ip5'=>$_POST['ip5']
                ]
                );
        }else{
            $resp = Capsule::table('tblusers_api')->insert(
                [
                    'user_id' => $ca->getUserID(), 
                    'userapi_enabled' => 1,
                    'userapi_ip1'=>$_POST['ip1'],
                    'userapi_ip2'=>$_POST['ip2'],
                    'userapi_ip3'=>$_POST['ip3'],
                    'userapi_ip4'=>$_POST['ip4'],
                    'userapi_ip5'=>$_POST['ip5']
                ]
            );
        }
        if($resp){
             $ca->assign('ipStored', true);
        }else{
            $ca->assign('ipStored', false);
        }
    }
    /**
     * User is logged in - put any code you like here
     *
     * Here's an example to get the currently logged in clients first name
     */
    //file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder Page userID: ' . json_encode($ca->getUserID()) . "\n", FILE_APPEND);
//file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder REQYEST: ' . json_encode($_POST) . "\n", FILE_APPEND);

    $client = Capsule::table('tblclients')->join('tblusers_api', 'tblclients.id', '=', 'tblusers_api.user_id')
        ->where('tblclients.id', $ca->getUserID())->first();
    file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder Page client: ' . json_encode($client) . "\n", FILE_APPEND);


    $ca->assign('client', $client->firstname." ".$client->lastname);
    $ca->assign('api_key', $client->userapi_key);
    $ca->assign('api_keyid', $client->userapi_keyid);
    $ca->assign('ip1', $client->userapi_ip1);
     $ca->assign('ip2', $client->userapi_ip2);
      $ca->assign('ip3', $client->userapi_ip3);
       $ca->assign('ip4', $client->userapi_ip4);
        $ca->assign('ip5', $client->userapi_ip5);

} else {

    // User is not logged in
    $ca->assign('clientname', 'Random User');

}

/**
 * Set a context for sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
Menu::addContext();

/**
 * Setup the primary and secondary sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
Menu::primarySidebar('announcementList');
Menu::secondarySidebar('announcementList');

# Define the template filename to be used without the .tpl extension

$ca->setTemplate('reseller_api');

$ca->output();

function randStrGen($len){
    $result = "";
    $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_?!-0123456789=";
    $charArray = str_split($chars);
    for($i = 0; $i < $len; $i++){
	    $randItem = array_rand($charArray);
	    $result .= "".$charArray[$randItem];
    }
    return $result;
}

