<?php
/**
 * WHMCS Sample Payment Callback File
 *
 * This sample file demonstrates how a payment gateway callback should be
 * handled within WHMCS.
 *
 * It demonstrates verifying that the payment gateway module is active,
 * validating an Invoice ID, checking for the existence of a Transaction ID,
 * Logging the Transaction for debugging and Adding Payment to an Invoice.
 *
 * For more information, please refer to the online documentation.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Developer_Docs
 *
 * @copyright Copyright (c) WHMCS Limited 2015
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */
use WHMCS\Database\Capsule;
use WHMCS\ClientArea;
define('CLIENTAREA', true);

define('DEFAULT_HOST_PATH', 'https://domains.upperlink.ng/clients');
define("PATH_ROOT", dirname(__FILE__));
error_reporting(E_ALL);
// Require libraries needed for gateway module functions.
require_once __DIR__ . '/init.php';
require_once __DIR__ . '/includes/gatewayfunctions.php';
require_once __DIR__ . '/includes/invoicefunctions.php';
 
// Detect module name from filename.
$gatewayModuleName = basename(__FILE__, '.php');

$ca = new ClientArea();

$ca->setPageTitle('Interswitch Requery');

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb('requery_interswitch.php', 'Interswitch Requery');
$ca->initPage();

/**
 * This function will handle the processing of the returned records
 *
 * @return void
 * 
 */
 
 
// Check login status
if ($ca->isLoggedIn()) {

    /**
     * User is logged in - put any code you like here
     *
     * Here's an example to get the currently logged in clients first name
     */

    $clientName = Capsule::table('tblclients')
        ->where('id', '=', $ca->getUserID())->value('firstname');
    // 'pluck' was renamed within WHMCS 7.0.  Replace it with 'value' instead.
    // ->where('id', '=', $ca->getUserID())->value('firstname');
    $ca->assign('clientname', $clientName);

} else {
    $ca->assign('incorrect', null);

    // User is not logged in
    if(isset($_POST)){
        $password = hash('sha256', $_POST['password']);
        $clientEmail = Capsule::table('users_login')
            ->where([
                ['userlog_username', '=', $_POST['username']],
                ['userlog_password','=', $password]
            ])
            ->value('userlog_email');
        // 'pluck' was renamed within WHMCS 7.0.  Replace it with 'value' instead.
        // ->where('id', '=', $ca->getUserID())->value('firstname');
        //print_r($clientEmail);
        if($clientEmail){
            $ca->assign('clientemail', $clientEmail);
        }else{
            $ca->assign('incorrect', true);
        }

    }

    $ca->assign('clientname', 'Random User');

}
 //print_r($_SERVER);
 //echo '<pre>';
 foreach (Capsule::table('tbltransactions')->join('tblclients','tblclients.id','=','tbltransactions.client_id')
 ->where([['transaction_status','pending'],['payment_method','interswitchwebpaynew']])
 ->latest('tbltransactions.created_at')
 ->first() as $transaction) {
    //print_r($transaction);
}
$transactions = Capsule::table('tbltransactions')->select('tbltransactions.*','tblclients.firstname','tblclients.lastname')->join('tblclients','tblclients.id','=','tbltransactions.client_id')
 ->where([['transaction_status','pending'],['payment_method','interswitchwebpaynew']])->latest('tbltransactions.created_at')->take(100)->get();
 //dd($transactions);
$ca->assign('transactions', $transactions);
$ca->setTemplate('requery_interswitch');

$ca->output();
