<?php

use \ModulesGarden\GSuite\App\Models\GSuiteToken;

$autoloaderPath = __DIR__ . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';
if (!file_exists($autoloaderPath))
{
    echo 'Module Files Incomplete';
    die();    
}

require_once $autoloaderPath;



function hookGSuiteProductSettingsUpdate($params)
{
    $tokenModel = new GSuiteToken();
    $productId = $params['pid'];
    
    if(isset($_REQUEST['logout']) || isset($_REQUEST['revoke']))
    {
        $path = $_SERVER['REQUEST_URI'];
        if (isset($_REQUEST['logout'])) 
        {
            $tokenModel->unsetAccessToken($productId);
            $path = str_replace('&amp;logout=1', '', $path);
            unset($_REQUEST['logout']);
        }

        if (isset($_REQUEST['revoke'])) 
        {
            $tokenModel->unsetRefreshToken($productId);
            $path = str_replace('&amp;revoke=1', '', $path);
            unset($_REQUEST['revoke']);
        }

        $tmpPos = stripos($path, '&amp;code=');
        if($tmpPos)
        {
            $path = substr($path, 0, $tmpPos);
        }
        
        $path = str_replace('&amp;', '&', $path);
        header("Location: ".$path);
        die();        
    }    
    
    if (isset($_REQUEST['oauth_clientid']) && isset($_REQUEST['oauth_clientsecret']) && isset($_REQUEST['oauth_callbackurl']))
    {
        global $CONFIG;
        $callback_url   = $CONFIG['SystemURL'].'/oauth_callback.php';
        $scope          = "https://www.googleapis.com/auth/userinfo.profile%20https://www.googleapis.com/auth/apps.order%20https://www.googleapis.com/auth/apps.order.readonly%20https://www.googleapis.com/auth/admin.directory.user";
        $state          = "whmcs";
        $access_type    = "offline";        
                
        $tokenModel->updateOauthClientDetails($productId, $_REQUEST['oauth_clientid'], $_REQUEST['oauth_clientsecret']);

        $loginUrl = sprintf($callback_url."?whmcsproductid=%s&scope=%s&state=%s&redirect_uri=%s&response_type=code&client_id=%s&access_type=%s&approval_prompt=force",$_REQUEST['id'],$scope,$state,$_REQUEST['oauth_callbackurl'],$_REQUEST['oauth_clientid'],$access_type);
     
        header("Location: ".$loginUrl);
        die();
    }    
    elseif(isset($_REQUEST['oauth_clientid']) && isset($_REQUEST['oauth_clientsecret']) && $productId)
    {
        $tokenModel->updateOauthClientDetails($productId, $_REQUEST['oauth_clientid'], $_REQUEST['oauth_clientsecret']);
    }
    
    if(isset($_REQUEST['code']))
    {
        $tokenModel->updateRefreshToken($productId, $_REQUEST['code']);
        $token = $tokenModel->scopeWhereProductId($productId);
        $result         = gSuiteGetOauth2Token($token, "online");
        $accessToken   = $result->access_token;
        $tokenLife     = $result->expires_in;

        $tokenModel->updateAccessToken($productId, $accessToken, $tokenLife);        
    }    
}
add_hook("AdminProductConfigFields", 1, "hookGSuiteProductSettingsUpdate");
