<?php

use \ModulesGarden\GSuite\App\PDOWrapper;
use \ModulesGarden\GSuite\App\Models\GSuiteToken;
use \ModulesGarden\GSuite\App\Utilities;
use \ModulesGarden\GSuite\App\GSuiteApi;

/**********************************************************************
 *  GSuite Reseller Module. Custom developed. (21.11.12)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->        http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 * 
 *
 **********************************************************************/
/**
 * @version 1.3.0 (22.01.2018)
 * @author <pawel@modulesgarden.com>
 */

$autoloaderPath = __DIR__ . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';
if (!file_exists($autoloaderPath))
{
    echo 'Module Files Incomplete';
    die();    
}

require_once $autoloaderPath;



/**
 * FUNCTION gSuite_isWHMCS6()
 * Check if whmcs version is 6.0.0 of higher
 * @return true|false
 */
function gSuite_isWHMCS6() 
{
    if(isset($GLOBALS['CONFIG']['Version']))
    {
        $tmpVersion = explode('-', $GLOBALS['CONFIG']['Version']);
        return version_compare($tmpVersion[0], '6.0.0', '>=');
    }

    global $whmcs;
    return (version_compare($whmcs->getVersion()->getRelease(), '6.0.0', '>='));
}

/**
 * FUNCTION gSuite_ConfigOptions
 * Besides basic configuration, checks OAuth 2.0 authorization
 * and allows to generate access key. Echoes additional HTML content.
 * @return array
 */
function gSuite_ConfigOptions()
{
    global $CONFIG; 
    $tokenModel = new \ModulesGarden\GSuite\App\Models\GSuiteToken();
    $tokenModel->createTableIfNotExists();    
    
    $productId = $_REQUEST['id'] ? : null;

    Utilities::gSuite_updateCustomFields($productId);

    $callback_url   = $CONFIG['SystemURL'].'/oauth_callback.php';
    $hostp = parse_url($CONFIG['SystemURL']);
    $selfurl = 'http'.($_SERVER['SERVER_PORT']=='443' ? 's' : '').'://' . $hostp['host'] 
            . $_SERVER['SCRIPT_NAME'] . '?action=edit&id=' . $productId;

    $iswhmcs6 = gSuite_isWHMCS6();
    $styles = gSuiteGetInternalStyles($iswhmcs6);

    $data = array();
    $data['mode']= "advanced";    

    $token = $tokenModel->scopeWhereProductId($productId);
    
    $authenticaded = false;
    if($access_token = gSuiteGetAccessToken($token))
    {
	$authenticaded = true;
    }

    if(!$authenticaded)
    {
        $refreshToken = is_object($token) ? $token->refresh_token : false;
        if($refreshToken)
        {
            $result         = gSuiteGetOauth2Token($token, "offline");
            $accessToken   = $result->access_token;
            $tokenLife     = $result->expires_in;
            $tokenModel->updateAccessToken($productId, $accessToken, $tokenLife);
            $authenticaded  = true;
        }
        else
        {
            $tokenOauthCid = is_object($token) ? $token->oauth_clientid : false;
            $tokenOauthCsc = is_object($token) ? $token->oauth_clientsecret : false;
            $data['content'] = gSuiteGetAuthContentHtml($tokenOauthCid, $tokenOauthCsc, $callback_url, $selfurl, $styles);
            if($_REQUEST['action'] != 'save')
            {
                gSuiteConfigOptionReturn($data);
            }
            return false;
        }
    }

    if($_REQUEST['action'] == 'save')
    {
        return gSuiteGetConfigArrayAsArray($styles);
    }    
    else
    {    
        if($authenticaded)
        {
            $data['content'] = gSuiteGetConfigHtml();
            gSuiteConfigOptionReturn($data);
            return false;
        }

        $data['content'] = gSuiteGetConfigArrayAsArray($styles);
        gSuiteConfigOptionReturn($data);
    }
}

/**
* FUNCTION CreateAccount
* Creates new customer, if not exists
* Creates new subscription
* @param    array   $params     Standard parameters array generated by WHMCS
* @return   string              "success" or error message
*/
function gSuite_CreateAccount($params)
{
    
   
    $customFieldsValues = Utilities::parseCustomFieldsFromParams($params['customfields']);
    if($customFieldsValues['GoogleApps Domain'] == "" && $params['domain'])
    {
        $query="
            SELECT tblcustomfieldsvalues.fieldid
            FROM tblcustomfieldsvalues
            JOIN tblcustomfields
                ON tblcustomfieldsvalues.fieldid = tblcustomfields.id
            WHERE tblcustomfields.type='product'
                AND tblcustomfields.relid={$params['pid']}
                AND tblcustomfields.fieldname LIKE 'GoogleApps Domain|%'
                AND tblcustomfieldsvalues.relid={$params['serviceid']}
            ";
        $result = PDOWrapper::query($query);
        
        $row = PDOWrapper::fetch_assoc($result);
        $fieldid=$row['fieldid'];
                
        PDOWrapper::query("UPDATE tblcustomfieldsvalues SET value=? WHERE fieldid=? AND relid=?",array($params['domain'], $fieldid,$params['serviceid']));
        $customFieldsValues['GoogleApps Domain'] = $params['domain'];
    }
    
    $customerid      = $customFieldsValues['GoogleApps Domain'];
    $purchaseorderid = $customFieldsValues['GoogleApps PurchaseOrderID'] ? $customFieldsValues['GoogleApps PurchaseOrderID'] : 'whmcs_account_'.$params['accountid'];
    $alternateEmail  = $customFieldsValues['GoogleApps AlternateEmail'] ? $customFieldsValues['GoogleApps AlternateEmail'] : $params['clientsdetails']['email'];
    
    $GSUITE = gSuite_constructApi($params);
    $GSUITE->getCustomer($customerid);
    if($GSUITE->isError())
    {
        $error=$GSUITE->getError();
        if($error=='Not Found')
        {
            $GSUITE->refuseError();
            $clientdata=array(
                'id'            => $customerid,
                'domain'        => $customerid,
                'postaladdress' => array(
                    'name'          => $params['clientsdetails']['firstname'].' '.$params['clientsdetails']['lastname'],
                    'organization'  => $params['clientsdetails']['companyname'],
                    'city'          => $params['clientsdetails']['city'],
                    'region'        => $params['clientsdetails']['state'],
                    'postalcode'    => $params['clientsdetails']['postcode'],
                    'countrycode'   => $params['clientsdetails']['country'],
                    'address'       => $params['clientsdetails']['address1'],
                ),
                'phonenumber'   => $params['clientsdetails']['phonenumber'],
                'altemail'      => $alternateEmail
            );

            $GSUITE->insertCustomer($clientdata);
            if($GSUITE->isError())
            {
                return $GSUITE->getError();
            }
        }
        else
        {
            return $error;
        }
    }
    
    $configOptionsValues = Utilities::parseCustomFieldsFromParams($params['configoptions']);
    $skuid                  = $configOptionsValues['Product SKU ID'] ? trim($configOptionsValues['Product SKU ID']) : trim($params['configoption1']);
    $numberofseats          = $configOptionsValues['Number of Seats'] ? trim($configOptionsValues['Number of Seats']) : trim($params['configoption2']);
    $planname               = $params['configoption6'];
    $result                 = PDOWrapper::query("SELECT billingcycle FROM tblhosting WHERE id=?", array($params['accountid']));
    $row                    = PDOWrapper::fetch_assoc($result);
    $billingcycle           = $row['billingcycle'];
    
    if($planname == 'Automatic')
    {
        $planname = $billingcycle == 'Annually' ? 'ANNUAL_YEARLY_PAY' : 'FLEXIBLE';
        }
    
    if($planname == 'ANNUAL' || $planname == 'ANNUAL_YEARLY_PAY' || $planname == 'ANNUAL_MONTHLY_PAY')
    {
        $seats = array('numberofseats' => $numberofseats);
    }
    else
    {
        $seats = array('maximumnumberofseats' => $numberofseats);
    }
    
    $renewaltype = $params['configoption9'] ? $params['configoption9'] : 'AUTO_RENEW';
    
    $subscriptiondata=array(
        'customerid'     => $customerid,
        'skuid'          => $skuid,
        'plan'           => array(
            'planname'           => $planname,
        ),
        'seats'             => $seats,
        'renewalsettings'   => array(
            'renewaltype'       => $renewaltype,
        ),
        'purchaseorderid'   => $purchaseorderid
    );

    $GSUITE->insertSubscription($subscriptiondata);
    if($GSUITE->isError())
    {
        return $GSUITE->getError();
    }
    
    if($customFieldsValues['GoogleApps PurchaseOrderID'] == "")
    {
        PDOWrapper::query("UPDATE tblcustomfieldsvalues JOIN tblcustomfields ON tblcustomfieldsvalues.fieldid=tblcustomfields.id SET tblcustomfieldsvalues.value=? WHERE tblcustomfields.fieldname LIKE 'GoogleApps PurchaseOrderID|%' AND tblcustomfieldsvalues.relid=?",array('whmcs_account_'.$params['accountid'], $params['accountid'])) or die(PDOWrapper::errorInfo());
    }

    //create admin account
    if ($params['configoption11'] == 'on')
    {
        $query="
                SELECT tblcustomfieldsvalues.value
                FROM tblcustomfieldsvalues
                JOIN tblcustomfields
                    ON tblcustomfieldsvalues.fieldid = tblcustomfields.id
                WHERE tblcustomfields.type='product'
                    AND tblcustomfields.relid={$params['pid']}
                    AND tblcustomfields.fieldname LIKE 'Mailbox Name|%'
                    AND tblcustomfieldsvalues.relid={$params['serviceid']}
                ";

        $userResult = PDOWrapper::query($query);
        if ($userResult)
        {
            $row          = PDOWrapper::fetch_assoc($userResult);
            $mailboxName  = $row['value'];
            $primaryEmail = $mailboxName . '@' . $params['domain'];
        }
        else
        {
            $primaryEmail = 'admin@' . $params['domain'];
            if (!empty($params['configoption10']))
            {
                $primaryEmail = $params['configoption10'] . '@' . $params['domain'];
            }
        }        
        
        //set admin email as hosting username
        PDOWrapper::query("UPDATE `tblhosting` SET `username` = ? WHERE id = ? ", array($primaryEmail, $params['serviceid']));
        
        $newAdminParams = array(
            'givenName'    => $params['clientsdetails']['firstname'],
            'familyName'   => $params['clientsdetails']['lastname'],
            'fullName'     => $params['clientsdetails']['firstname'] . ' ' . $params['clientsdetails']['lastname'],
            'primaryEmail' => $primaryEmail,
            'password'     => $params['password']
        );

        $GOOGLEAPPS = gSuite_constructApi($params, true);
        $GOOGLEAPPS->addAdminUser($newAdminParams);
        if ($GOOGLEAPPS->isError())
        {
            return $GOOGLEAPPS->getError();
        }

        $GOOGLEAPPS->makeAdminUserAdmin($primaryEmail);
        if ($GOOGLEAPPS->isError())
        {
            return $GOOGLEAPPS->getError();
        }
    }

    return "success";
}

/**
* FUNCTION TerminateAccount
* Sets subscription status to SUSPEND
* @param    array   $params     Standard parameters array generated by WHMCS
* @return   string              "success" or error message
*/
function gSuite_TerminateAccount($params)
{
    $customFieldsValues = Utilities::parseCustomFieldsFromParams($params['customfields']);        
    $customerid = $customFieldsValues['GoogleApps Domain'];
    $subscriptionid = gSuite_getSubcriptionId($params);
    if(!$subscriptionid)
    {
        return 'Not Found';
    }

	$deletiontype = $params['configoption7'];
	
    $GSUITE = gSuite_constructApi($params);
    $GSUITE->deleteSubscription($customerid, $subscriptionid, $deletiontype);

    if($GSUITE->isError())
    {
        return $GSUITE->getError();
    }
    
    return "success";
}

/**
* FUNCTION SuspendAccount
* Sets subscription renewal type to CANCEL
* @param    array   $params     Standard parameters array generated by WHMCS
* @return   string              "success" or error message
*/
function gSuite_SuspendAccount($params)
{
    $customFieldsValues = Utilities::parseCustomFieldsFromParams($params['customfields']);
    $customerid     = $customFieldsValues['GoogleApps Domain'];
    $subscriptionid = gSuite_getSubcriptionId($params);
    if(!$subscriptionid)
    {
        return 'Not Found';
    }
    
    $GSUITE = gSuite_constructApi($params);
    $GSUITE->suspendLicense($customerid, $subscriptionid, []);

    if($GSUITE->isError())
    {
        return $GSUITE->getError();
    }
    
    return "success";
}

/**
* FUNCTION UnsuspendAccount
* Sets subscription renewal type to AUTO_RENEW
* @param    array   $params     Standard parameters array generated by WHMCS
* @return   string              "success" or error message
*/
function gSuite_UnsuspendAccount($params)
{
    $customFieldsValues = Utilities::parseCustomFieldsFromParams($params['customfields']);
    $customerid = $customFieldsValues['GoogleApps Domain'];
    $subscriptionid = gSuite_getSubcriptionId($params);
    if(!$subscriptionid)
    {
        return 'Not Found';
    }
    
    $GSUITE = gSuite_constructApi($params);
    $GSUITE->unsuspendLicense($customerid, $subscriptionid, []);

    if($GSUITE->isError())
    {
        return $GSUITE->getError();
    }
    
    return "success";
}

/**
* FUNCTION ChangePackage
* Changes subscription.
* @param    array   $params     Standard parameters array generated by WHMCS
* @return   string              "success" or error message
*/
function gSuite_ChangePackage($params)
{
    
    
    $customFieldsValues = Utilities::parseCustomFieldsFromParams($params['customfields']);    
    $customerid = $customFieldsValues['GoogleApps Domain'];
    $subscriptionid = gSuite_getSubcriptionId($params);
    if(!$subscriptionid)
    {
        return 'Not Found';
    }

    $GSUITE = gSuite_constructApi($params);
    $subscriptiondetails = $GSUITE->getSubscription($customerid, $subscriptionid);
    if($GSUITE->isError())
    {
        return $GSUITE->getError();
    }

    $configOptionsValues = Utilities::parseCustomFieldsFromParams($params['configoptions']);
    $numberofseats          = $configOptionsValues['Number of Seats'] ? trim($configOptionsValues['Number of Seats']) : trim($params['configoption2']);
    
    $plan                   = $params['configoption6'];
    $result                 = PDOWrapper::query("SELECT billingcycle FROM tblhosting WHERE id=?",array($params['accountid']));
    $row                    = PDOWrapper::fetch_assoc($result);
    $billingcycle           = $row['billingcycle'];
    
    if($plan == 'Automatic')
    {
        $planname = $billingcycle == 'Annually' ? 'ANNUAL_YEARLY_PAY' : 'FLEXIBLE';
        }
    else
    {
        $planname = $plan;
    }
    
    if($planname == 'ANNUAL' || $planname == 'ANNUAL_YEARLY_PAY' || $planname == 'ANNUAL_MONTHLY_PAY')
    {
        $seats = array('numberofseats' => $numberofseats);
    }
    else
    {
        $seats = array('maximumnumberofseats' => $numberofseats);
    }

    $purchaseorderid = $customFieldsValues['GoogleApps PurchaseOrderID'] ? $customFieldsValues['GoogleApps PurchaseOrderID'] : 'whmcs_account_'.$params['accountid'];

    if(!gSuiteComparePlanNames($subscriptiondetails->plan->planName, $planname))
    {
        $plandata=array(
            "kind"                  => "subscriptions#changePlanRequest",
            "planname"              => $planname,
            "seats"                 => $seats,
            "purchaseorderid"       => $purchaseorderid
        );
        $GSUITE->changePlan($customerid, $subscriptionid, $plandata);
    }
    else
    {
        $GSUITE->changeSeats($customerid, $subscriptionid, $seats);
    }
    
    if($GSUITE->isError())
    {
        return $GSUITE->getError();
    }

    return "success";
}

/**
* FUNCTION ClientArea
* Displays cutomer info in Client area
* @param    array   $params     Standard parameters array generated by WHMCS
* @return   array               variables for smarty template
*/
function gSuite_ClientArea($params)
{
    $LANG = gSuite_getLang();
    $customFieldsValues = Utilities::parseCustomFieldsFromParams($params['customfields']); 
    $customerid = $customFieldsValues['GoogleApps Domain'];
    $GSUITE = gSuite_constructApi($params);
    $customer   = $GSUITE->getCustomer($customerid);
    
    $templateName = $params['clientareatemplate'] == 'six' ? 'clientarea_six' : 'clientarea';
    
    if($GSUITE->isError())
    {
        return array(
            'templatefile'  => $templateName,
            'vars' => array(
                    'error' => $GSUITE->getError()
            )
        );
    } 
    
    return array(
        'templatefile' => $templateName,
        'vars' => array(
                'customer' => $customer,
                'GA_LANG' => $LANG
        )
    );
}

/**
* FUNCTION getSubcriptionId
* Searches for subscription ID based on purchase order ID
* @param    array   $params     Standard parameters array generated by WHMCS
* @return   string|bool         Subscription ID or false
*/
function gSuite_getSubcriptionId($params)
{
    $customFieldsValues = Utilities::parseCustomFieldsFromParams($params['customfields']);     
    $customerid = $customFieldsValues['GoogleApps Domain'];
    $purchaseorderid = $customFieldsValues['GoogleApps PurchaseOrderID'] ? $customFieldsValues['GoogleApps PurchaseOrderID'] : 'whmcs_account_'.$params['accountid'];
    $GSUITE = gSuite_constructApi($params);
    $pagetoken = false;
    do
    {
        $result = $GSUITE->listSubscriptions($customerid,$pagetoken);

        foreach($result->subscriptions as $sub)
        {
            if($sub->purchaseOrderId==$purchaseorderid || strpos($sub->customerId, $customerid) >= 0) // zmieniona wersja
            {
                return $sub->subscriptionId;
            }
        }
        
        if(isset($result->nextPageToken))
        {
            $pagetoken = $result->nextPageToken;
        }
        else
        {
            return false;
        }
    }while($pagetoken);
    
}

/**
* FUNCTION constructApi
* Sets new access token, if not already set in module configuration
* Constructs object of API connection class
* @param array $params
* @return object
*/
function gSuite_constructApi($params, $directoryApi = false)
{
    $tokenModel = new \ModulesGarden\GSuite\App\Models\GSuiteToken();
    $token      = $tokenModel->scopeWhereProductId($params['pid']);
    $tempToken = gSuiteGetAccessToken($token);
    if (!$tempToken) 
    {
        $token  = $tokenModel->scopeWhereProductId($params['pid']);
    }
    
    if (!$token->token)
    {
        if ($token->refresh_token)
        {
            $result         = gSuiteGetOauth2Token($token, "offline");
            $accessToken   = $result->access_token;
            $tokenLife     = $result->expires_in;
            $tokenModel->updateAccessToken($params['pid'], $accessToken, $tokenLife);
        }
    }

    $url = 'https://www.googleapis.com/apps/reseller/v1';
    if($directoryApi)
    {
        $url = 'https://www.googleapis.com/admin/directory/v1';
    }

    $enableLogs = $params['configoption8'] == 'on' ? true : false;
    
    return new GSuiteApi($accessToken ? : $token->token, $url, $enableLogs);
}

/**
* FUNCTION GetAccessToken
* Returns OAuth 2.0 access token if set and not expired
* @return string|bool
*/
function gSuiteGetAccessToken($token)
{
    if ($token->token)
    {
        if (time() - $token->update_time <= $token->token_life)
        {
            return $token->token;
        }

        $tokenModel = new \ModulesGarden\GSuite\App\Models\GSuiteToken();
        $tokenModel->unsetAccessToken($token->product_id);

        return false;
    }

    return false;
}

/**
* FUNCTION gSuiteGetOauth2Token
* Connects to google to retrieve access token from callback code or from refresh token
* @param string $grantCode //$token->refresh_token
* @param string $grantType
* @return object
*/
function gSuiteGetOauth2Token($token, $grantType)
{
    global $CONFIG;
    
    $redirectUri   = $CONFIG['SystemURL'].'/oauth_callback.php';

    $oauth2TokenUrl    = "https://accounts.google.com/o/oauth2/token";
    $clientTokenPost   = [
            "client_id" => $token->oauth_clientid,
            "client_secret" => $token->oauth_clientsecret
        ];
    
    if($grantType === "online")
    {
        $clientTokenPost["code"] = $token->refresh_token;	
        $clientTokenPost["redirect_uri"] = $redirectUri;
        $clientTokenPost["grant_type"] = "authorization_code";
    }

    if($grantType === "offline")
    {
        $clientTokenPost["refresh_token"] = $token->refresh_token;
        $clientTokenPost["grant_type"] = "refresh_token";
    }

    $curl = curl_init($oauth2TokenUrl);

    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $clientTokenPost);
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

    $jsonResponse = curl_exec($curl);
    curl_close($curl);

    $authObj = json_decode($jsonResponse);

    if(isset($authObj->refresh_token))
    {
        $tokenModel = new \ModulesGarden\GSuite\App\Models\GSuiteToken();
        $tokenModel->updateRefreshToken($token->product_id, $authObj->refresh_token);        
    }

    return $authObj;
}

function gSuite_getLang()
{ 
    $mainDir = substr(dirname(__FILE__), 0 , strpos(dirname(__FILE__), 'modules'.DIRECTORY_SEPARATOR.'servers'));
    $languageDir = $mainDir.'modules'.DIRECTORY_SEPARATOR.'servers'.DIRECTORY_SEPARATOR.'gSuite'.DIRECTORY_SEPARATOR.'lang'.DIRECTORY_SEPARATOR;

    $language = !$_SESSION['Language'] || !file_exists($languageDir.$_SESSION['Language'].'.php') ? 'english' : $_SESSION['Language'];
    
    require_once($languageDir.$language.'.php');
    
    return $_LANG;
}

function gSuiteConfigOptionReturn($data)
{
    if(isset($_REQUEST['mode']) && ($_REQUEST['mode'] == "simple")) 
    {//v7
        if(ob_get_level() > 0)
        {
            ob_start();
        ob_clean();
        }
        header('Content-Type: application/json');

        echo json_encode($data);
        die();
    } 
    
    //v6
    echo $data['content'];
}

function gSuiteGetConfigHtml()
{   
    $configHtml = '<tr>
                    <td colspan="4" class="googleAppsTextCenterd">
                        <b>You are authenticated with Google OAuth 2.0</b>
                    </td>
                </tr>';
    $configHtml .= '<tr><td class="fieldlabel" width="20%">Default Product SKU ID</td><td class="fieldarea">';
    $configHtml .= '<select id="inputModule" class="form-control select-inline" name="packageconfigoption[1]">';
    $configHtml .= gSuiteGetPlanHtmlOptions(gSuiteLoadConfigOptionValue(1));
    $configHtml .= '</select>';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="This option will be used when no configurable option is set up for the Product SKU ID"></i>';
    $configHtml .= '</td>';
    $configHtml .= '<td class="fieldlabel" width="20%">Default Number of Seats</td><td class="fieldarea">';
    $configHtml .= '<input class="form-control input-inline input-100 googleAppsTooltipInput" type="text" value="'.gSuiteLoadConfigOptionValue(2).'" name="packageconfigoption[2]">';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="This option will be used when no configurable option is set up for the Number of Seats"></i>';
    $configHtml .= '</td>';
    $configHtml .= '</td>';    
    $configHtml .= '<tr>';
    $configHtml .= '<td class="fieldlabel" width="20%">Plan Name</td>';
    $configHtml .= '<td class="fieldarea">';
    $configHtml .= '<select class="form-control select-inline" name="packageconfigoption[6]">';
    $configHtml .= gSuiteGetPlanTypeHtmlOptions(gSuiteLoadConfigOptionValue(6));
    $configHtml .= '</select>';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="The ANNUAL plan is an ANNUAL_MONTHLY_PAY G Suite plan"></i>';
    $configHtml .= '</td>';
    $configHtml .= '<td class="fieldlabel" width="20%">Action on Termination</td>';
    $configHtml .= '<td class="fieldarea">';
    $configHtml .= '<select class="form-control select-inline" name="packageconfigoption[7]">';
    $configHtml .= gSuiteGetTerminationActionHtmlOptions(gSuiteLoadConfigOptionValue(7));
    $configHtml .= '</select>';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="Select the action that will be performed upon the subscription\'s termination"></i>';
    $configHtml .= '</td>';
    $configHtml .= '</tr>';  
    $configHtml .= '<tr>';    
    $configHtml .= '<td class="fieldlabel" width="20%">Log API Requests</td>';
    $configHtml .= '<td class="fieldarea"><label class="checkbox-inline">';
    $configHtml .= '<input type="hidden" value="'.gSuiteLoadConfigOptionValue(8).'" name="packageconfigoption[8]"><input type="checkbox" '.gSuiteCheckboxStateByConfigOpt(8).' name="packageconfigoption[8]" onclick="googleappsCheckboxUpdate(this);">';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="Tick to record every API request in the WHMCS Module Log"></i>';
    $configHtml .= '</label></td>';
    $configHtml .= '<td class="fieldlabel" width="20%">Renewal Type</td>';
    $configHtml .= '<td class="fieldarea">';
    $configHtml .= '<select class="form-control select-inline" name="packageconfigoption[9]">';
    $configHtml .= gSuiteGetRenewalTypeHtmlOptions(gSuiteLoadConfigOptionValue(9));
    $configHtml .= '</select>';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="Select the renewal settings for the annual commitment plan"></i>';
    $configHtml .= '</td>';    
    $configHtml .= '</tr>';  
    $configHtml .= '<tr>';
    $configHtml .= '<td class="fieldlabel" width="20%">Mailbox Name</td><td class="fieldarea">';
    $configHtml .= '<input class="form-control input-inline input-100 googleAppsTooltipInput" type="text" value="'.gSuiteCheckIfEmpty(gSuiteLoadConfigOptionValue(10)).'" name="packageconfigoption[10]">';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="Enter the name of a mailbox that will be used to create an admin account for the new subscription"></i>';
    $configHtml .= '</td>';
    $configHtml .= '<td class="fieldlabel" width="20%">Create Admin Account</td>';
    $configHtml .= '<td class="fieldarea"><label class="checkbox-inline">';
    $configHtml .= '<input type="hidden" value="'.gSuiteLoadConfigOptionValue(11).'" name="packageconfigoption[11]"><input type="checkbox" '.gSuiteCheckboxStateByConfigOpt(11).' name="packageconfigoption[11]" onclick="googleappsCheckboxUpdate(this);">';
    $configHtml .= '<i class="glyphicon glyphicon-question-sign icon-white" title="" data-toggle="tooltip" data-original-title="Tick to create an admin account for the new subscription"></i>';
    $configHtml .= '</label></td>';    
    $configHtml .= '</tr>';
    $configHtml .= '<tr>';
    $configHtml .= '<td class="googleAppsButtonRow" colspan="4">';
    $configHtml .= '<button id="googleapps_genConfOpts" class="btn btn-primary">Generate Configurable Options</button>';
    $configHtml .= '<button id="googleappsLogoutAndRevoke" class="btn btn-danger" onclick="logoutAndRevokeRedirect();" type="button">Log Out And Revoke</button>';
    $configHtml .= '</td>';
    $configHtml .= '</tr>';      
    $configHtml .= '<input type="hidden" value="" name="packageconfigoption[3]"><input type="hidden" value="" name="packageconfigoption[4]"><input type="hidden" value="" name="packageconfigoption[5]">';    
    $configHtml .= gSuiteGetGenConfOptScript();
    $configHtml .= gSuiteGetLogoutAndRevokeScript();
    $configHtml .= gSuiteGetCheckboxUpdateScriptScript();
    $configHtml .= gSuiteLoadCssStyles();
    
    return $configHtml;
}

function gSuiteLoadCssStyles()
{
    $styles = '<style>
        .googleAppsButtonRow {
            background-color: #EFEFEF;
            text-align: center;
        } 
        
        .googleAppsButtonRow .btn {
            margin-left: 5px; margin-right: 5px;
        } 
        
        .fieldarea .glyphicon {
            margin-left: 5px;
        }
        
        .googleAppsTextCenterd {
            text-align: center;
            background-color: #EFEFEF;
            font-size: 14px;
        }
        
        .googleAppsTooltipInput{
            width: 100px;
            display: inline-block;
        }
        </style>';
    
    return $styles;
}

function gSuiteGenerateOptionsForSelectField($optList, $selectedVal = false)
{
    $cont = '';
    foreach ($optList as $key => $value)
    {
        $cont .= '<option value="' . $key . '" ' . ($key == $selectedVal ? 'selected="selected"' : '') . '>' . $value . '</option>';
    }

    return $cont;
}

function gSuiteGetPlanHtmlOptions($selectedVal = false)
{
    $opts = [
        'Google-Apps-For-Business'   => 'G Suite Basic',
        'Google-Drive-storage-20GB'  => 'Google Drive storage 20 GB',
        'Google-Drive-storage-50GB'  => 'Google Drive storage 50 GB',
        'Google-Drive-storage-200GB' => 'Google Drive storage 200 GB',
        'Google-Drive-storage-400GB' => 'Google Drive storage 400 GB',
        'Google-Drive-storage-1TB'   => 'Google Drive storage 1 TB',
        'Google-Drive-storage-2TB'   => 'Google Drive storage 2 TB',
        'Google-Drive-storage-4TB'   => 'Google Drive storage 4 TB',
        'Google-Drive-storage-8TB'   => 'Google Drive storage 8 TB',
        'Google-Drive-storage-16TB'  => 'Google Drive storage 16 TB',
        'Google-Vault'               => 'Google Vault',
        'Google-Apps-Unlimited'      => 'G Suite Business',
        '1010020020'                 => 'G Suite Enterprise'
    ];

    return gSuiteGenerateOptionsForSelectField($opts, $selectedVal);
}

function gSuiteCheckIfEmpty($value)
{
    if (empty($value))
    {
        return 'admin';
    }
    
    return $value;
}

function gSuiteLoadConfigOptionValue($optionId)
{
    if((int)$optionId > 0)
    {
        $optName = 'configoption'.$optionId;
        $optQuery = PDOWrapper::query("SELECT * FROM  `tblproducts`  WHERE `id`=? ", array($_REQUEST['id']));
        $optResult = PDOWrapper::fetch_assoc($optQuery);
        
        if($optResult[$optName])
        {
            return $optResult[$optName];
        }
        
        return false;
    }
    
    return false;
}

function gSuiteCheckboxStateByConfigOpt($optionId)
{
    $checked = gSuiteLoadConfigOptionValue($optionId);
    
    if($checked && $checked == 'on')
    {
        return 'checked="checked"';
    }
    
    return '';
}

function gSuiteGetTerminationActionHtmlOptions($selectedVal = false)
{
    $opts = [
        'suspend' => 'Suspend',
        'cancel'  => 'Cancel'
    ];

    return gSuiteGenerateOptionsForSelectField($opts, $selectedVal);
}

function gSuiteGetPlanTypeHtmlOptions($selectedVal = false)
{
    $opts = [
        'TRIAL'             => 'TRIAL',
        'ANNUAL'            => 'ANNUAL',
        'ANNUAL_YEARLY_PAY' => 'ANNUAL_YEARLY_PAY',
        'FLEXIBLE'          => 'FLEXIBLE',
        'Automatic'         => 'Automatic'
    ];

    return gSuiteGenerateOptionsForSelectField($opts, $selectedVal);
}

function gSuiteGetRenewalTypeHtmlOptions($selectedVal = false)
{
    $opts = [
        'AUTO_RENEW_MONTHLY_PAY'          => 'AUTO_RENEW_MONTHLY_PAY',
        'AUTO_RENEW_YEARLY_PAY'           => 'AUTO_RENEW_YEARLY_PAY',
        'CANCEL'                          => 'CANCEL',
        'RENEW_CURRENT_USERS_MONTHLY_PAY' => 'RENEW_CURRENT_USERS_MONTHLY_PAY',
        'RENEW_CURRENT_USERS_YEARLY_PAY'  => 'RENEW_CURRENT_USERS_YEARLY_PAY',
        'SWITCH_TO_PAY_AS_YOU_GO'         => 'SWITCH_TO_PAY_AS_YOU_GO'
    ];

    return gSuiteGenerateOptionsForSelectField($opts, $selectedVal);
}

function gSuiteGetGenConfOptScript()
{
    $script = '
        <script>            
            $(document).ready(function(){
                $(\'[data-toggle="tooltip"]\').tooltip();
              
                $("#googleapps_genConfOpts").click(function(e){
                    e.preventDefault();
                    $.post("../clientarea.php?gsuite_ajax=1", {"gsuite_act":"gsuite_setup_configurable_options", "productid":' . (int) $_REQUEST['id'] . '}, function(res){
                    alert(res.result);
                    if($("#tabLink5").size())
                        window.location.href = "configproducts.php?action=edit&id='.$_REQUEST['id'].'&tab=5";
                    else
                        window.location.href = "configproducts.php?action=edit&id='.$_REQUEST['id'].'&tab=3";
                    }, "json");
                    return false;
                });
            });
        </script>       
    ';
    
    return $script;
}

function gSuiteGetLogoutAndRevokeScript()
{
    $logoutPath = str_replace('&amp;', '&', $_SERVER['REQUEST_URI']).($_GET['id'] ? '' : '?action=edit&id='.$_REQUEST['id']).'&logout=1&revoke=1';
    
    $script = '
        <script>
            function logoutAndRevokeRedirect(){
                window.location = \''.$logoutPath.'\'; 
            }    
        </script>
    ';
    
    return $script;
}

function gSuiteGetConfigArrayAsArray($styles)
{
    $configarray = array(
        "Default Product SKU ID" => array(
            "Type"      =>  "dropdown",
            "Options"   => [  
                "Google-Apps-For-Business" => "G Suite Basic",
                "Google-Drive-storage-20GB" => "Google Drive storage 20 GB",
                "Google-Drive-storage-50GB" => "Google Drive storage 50 GB",
                "Google-Drive-storage-200GB" => "Google Drive storage 200 GB",
                "Google-Drive-storage-400GB" => "Google Drive storage 400 GB",
                "Google-Drive-storage-1TB" => "Google Drive storage 1 TB",
                "Google-Drive-storage-2TB" => "Google Drive storage 2 TB",
                "Google-Drive-storage-4TB" => "Google Drive storage 4 TB",
                "Google-Drive-storage-8TB" => "Google Drive storage 8 TB",
                "Google-Drive-storage-16TB" => "Google Drive storage 16 TB",
                "Google-Vault" => "Google Vault",
                "Google-Apps-Unlimited" => "G Suite Business",
                "1010020020" => "G Suite Enterprise"
            ],
            'Description'=> $styles['icon_class1']."Will be used when no Configurable Option is setup for Product SKU ID".$styles['icon_class2']
        ),
        "Default Number of Seats"           => array( "Type" => "text", "Size" => "10", 'Description' => $styles['icon_class1']."Will be used when no Configurable Option is setup for Number of Seats".$styles['icon_class2'] ),
        "Default Max Number of Seats"       => array( "Type" => "text", "Size" => "10", 'Description' => $styles['icon_class1']."This field is depreced.".$styles['icon_class2'] ),
        "Trial Product"                     => array( "Type" => "text", "Description" => $styles['icon_class1']."This field is depreced.".$styles['icon_class2'] ),
        "Test Mode"                         => array( "Type" => "text", "Description" => $styles['icon_class1']."This field is depreced.".$styles['icon_class2'] ),
        "Plan Name" => array(
            "Type"      =>  "dropdown",
            "Options"   =>  "TRIAL,".
                            "ANNUAL,".
                            "ANNUAL_YEARLY_PAY,".
                            "FLEXIBLE,".
                            "Automatic",
            'Description'=> $styles['icon_class1']."ANNUAL plan is an ANNUAL_MONTHLY_PAY G Suite plan.".$styles['icon_class2']
        ),
        "Action on Terminate" => array(
            "Type"      =>  "dropdown",
            "Options"   =>  "suspend,".
                            "cancel",
            'Description'=> $styles['icon_class1']."Deletion type of the subscription".$styles['icon_class2']
        ),
        "Log API Requests" => array( "Type" => "yesno", "Description" => $styles['icon_class1']."Tick to log every request in the Whmcs Module Log".$styles['icon_class2'] ),
        "Renewal Type" => array(
            "Type"      =>  "dropdown",
            "Options"   =>  "AUTO_RENEW_MONTHLY_PAY,".
                            "AUTO_RENEW_YEARLY_PAY,".
                            "CANCEL,".
                            "RENEW_CURRENT_USERS_MONTHLY_PAY,".
                            "RENEW_CURRENT_USERS_YEARLY_PAY,".
                            "SWITCH_TO_PAY_AS_YOU_GO",
            'Description'=> $styles['icon_class1']."Renewal settings for the annual commitment plan.".$styles['icon_class2']
        ),        
        "Mailbox Name" => array( "Type" => "text", "Size" => "10", 'Description' => $styles['icon_class1']."Will be used to generate an admin account for new subscription".$styles['icon_class2'] ),
        "Create Admin Account" => array( "Type" => "yesno", "Description" => $styles['icon_class1']."Tick to create an admin account for new subscription".$styles['icon_class2'] ),
    );
    
    return $configarray;
}

function gSuiteGetAuthContentHtml($client_id, $client_secret, $callback_url, $selfurl, $styles)
{
    $authContent = '
        <tr>
            <td colspan="4" class="googleAppsTextCenterd">
                <b>Oauth 2.0 Authentication Settings</b>
            </td>        
        <tr>
        <tr>
            <td style="font-weight:bold;color:#F00; '.$styles['txt_center'].' " colspan="2">
                Your account is not authenticated with this WHMCS installation yet.
                <br />
                Please fill out the form below with API details available at Google APIs Console → API Access (<a href="https://code.google.com/apis/console">https://code.google.com/apis/console</a>)
            </td>
        </tr>
        <tr>
            <td '.$styles['fieldlabel'].'>Client ID</td>
            <td '.$styles['fieldarea'].'><input type="text" size="60" value="'.$client_id.'" id="oauth_clientid"></td>
        </tr>
        <tr>
            <td '.$styles['fieldlabel'].'>Client Secret</td>
            <td '.$styles['fieldarea'].'><input type="text" size="60" value="'.$client_secret.'" id="oauth_clientsecret"></td>
        </tr>
        <tr>
            <td '.$styles['fieldlabel'].'>Callback URL</td>
            <td '.$styles['fieldarea'].'><input readonly="readonly" type="text" size="60" value="'.$callback_url.'" id="oauth_callbackurl"></td>
        </tr>
        <tr>
            <td colspan="2" '.$styles['style_txt_center'].'><button '.$styles['btn_class'].' onClick="googlelogin(); return false;">Grant Access To Google Account</button></td>
        </tr>
    ';

    $authContent .= gSuiteGetGrantAccessScript($selfurl);
    $authContent .= gSuiteLoadCssStyles();
    
    return $authContent;
}

function gSuiteGetGrantAccessScript($selfurl)
{
    $script = '
        <script>
            function googlelogin(){
                var oauth_clientid = $("#oauth_clientid").val();
                var oauth_clientsecret = $("#oauth_clientsecret").val();
                var oauth_callbackurl = $("#oauth_callbackurl").val();

                window.location="'.$selfurl.'&oauth_clientid="+oauth_clientid+"&oauth_clientsecret="+oauth_clientsecret+"&oauth_callbackurl="+oauth_callbackurl;
            }
        </script>
    ';
    
    return $script;
}

function gSuiteGetInternalStyles($iswhmcs6)
{
    if($iswhmcs6)
    {
        return array(
            'fieldlabel' => 'class="fieldlabel"',
            'fieldarea' => 'class="fieldarea"',      
            'style_txt_center' => 'style = "text-align:center;"',
            'txt_center' => 'text-align:center;',
            'btn_class' => 'class="btn btn-primary"',
            'btn_class2' => 'class="btn btn-danger"',
            'icon_class1' => '<i class = "glyphicon glyphicon-question-sign icon-white" data-toggle="tooltip" title = \'',
            'icon_class2' => '\'></i>'
        );
    }    
    
    return array(
        'btn_class' => 'class="button"',
        'btn_class2' => 'class="button"',
    );
}

function gSuiteGetCheckboxUpdateScriptScript()
{
    $script = '
        <script>            
            function googleappsCheckboxUpdate(el){
                var googleAppsBlockElements = $(el).parent().children();
                var googleAppsHidenCheck = googleAppsBlockElements[0];
                if($(el).is(":checked")){
                    $(googleAppsHidenCheck).val("on");
                }else{
                    $(googleAppsHidenCheck).val("off")
                }
            }
        </script>       
    ';
    
    return $script;
}

//check if gsiute plan is equal whmcs plan
function gSuiteComparePlanNames($plan1, $plan2)
{
    if($plan1 == $plan2)
    {
        return true;
    }
    
    //gsiute can return ANNUAL_MONTHLY_PAY as ANNUAL, only for change package usage.
    $anualPlans = ['ANNUAL', 'ANNUAL_MONTHLY_PAY', 'ANNUAL_YEARLY_PAY'];
    if(in_array($plan1, $anualPlans) && in_array($plan2, $anualPlans))
    {
        return true;
    }
    
    return false;
}
