<?php

namespace ModulesGarden\GSuite\App;

use \ModulesGarden\GSuite\App\PDOWrapper;
 
class Utilities
{
    /**
    * FUNCTION gSuite_updateCustomFields
    * Updates/Creates the values of products custom fields to default values
    * @productId   int  id of given product
    * @return   true|false  true = success/false if there were problems
    */
    public static function gSuite_updateCustomFields($productId)
    {
        $errorOcured = false;
        
        $customfields = array(
            'GoogleApps Domain' => array('fieldtype' => 'text', 'required' => 'on', 'showorder' => '', 'description' => '', 'regexpr' => '', 'friendlyName' => 'G Suite Domain'),
            'GoogleApps PurchaseOrderID' => array('fieldtype' => 'text', 'required' => 'on', 'showorder' => '', 'description' => '', 'regexpr' => '', 'friendlyName' => 'G Suite Purchase Order ID'),
            'GoogleApps AlternateEmail' => array('fieldtype' => 'text', 'required' => '', 'showorder' => 'on', 'description' => '', 'regexpr' => '', 'friendlyName' => 'G Suite Alternate Email'),
            'Mailbox Name' => [
                'fieldtype' => 'text',
                'required' => 'on',
                'showorder' => 'on',
                'description' => 'Please provide only the part before \'@\'',
                'regexpr' => '/^\w*@{0}\w*$/',
                'friendlyName' => 'Mailbox Name']
        );

        foreach($customfields as $option => $values)
        {
            $result = PDOWrapper::query("
                SELECT `id` from `tblcustomfields` where `relid` = ? AND `fieldname` LIKE ?
                ", array($productId, $option . '|%'));
            $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
            
            $row = PDOWrapper::fetch_assoc($result);  
            if(!$row)
            {
                PDOWrapper::query("
                    INSERT INTO `tblcustomfields` (`type`, `relid`, `fieldname`, `fieldtype`, `description`, `regexpr`, `required`, `showorder`) values ('product', ?, ?, ?, ?, ?, ?, ?) ", 
                        array($productId, $option . '|' . $values['friendlyName'], $values['fieldtype'], $values['description'], $values['regexpr'], $values['required'], $values['showorder']));
                $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
            }

            if($errorOcured)
            {
                break;
            }
        }
        
        return  !$errorOcured ? true : false;
    }


    /**
    * FUNCTION gSuite_updateConfigurableOptions
    * Updates/Creates the values of products Configurable Options to default values
    * @productId   int  id of given product
    * @return   crerated/alredyExist/error
    */
    public static function gSuite_updateConfigurableOptions($productId)
    {
        $errorOcured = false;
        //productname
        $result = PDOWrapper::query('SELECT `name` FROM `tblproducts` WHERE `id` = ? ', array($productId));
        $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
        $row = PDOWrapper::fetch_assoc($result);
        $productName = $row['name'];
        
        //check if configuration exist
        $result = PDOWrapper::query('SELECT * FROM `tblproductconfiglinks` WHERE `pid` = ?', array($productId));
        $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
        
        while($row = PDOWrapper::fetch_assoc($result))
        {
            $result = PDOWrapper::query('SELECT `name` FROM `tblproductconfiggroups` WHERE `id` = ?', array($row['gid']));
            $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;    
            $name = PDOWrapper::fetch_assoc($result);
            if($name['name'] == 'GSuite Configuration')
            {
                return 'alredyExist';
            }
        }
        
        //add config options
        PDOWrapper::query('INSERT INTO tblproductconfiggroups(name,description) VALUES(?, ?)', array(
            'GSuite Configuration',
            'Autogenerated By Module for '.$productName.' Product'
            ));
        $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
        $group_id = PDOWrapper::insert_id();
        
        //Assign to product
        PDOWrapper::query('INSERT INTO tblproductconfiglinks(gid,pid) VALUES(?,?)', array($group_id, $productId));   
        $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
        
        //Generate options
        // type 1=dropdawn | 4=quantity
        $options = array(
            'Product SKU ID' => array('type' => 1, 'subOptions' => array(
                    "Google-Apps-For-Business|G Suite Basic",
                    "Google-Drive-storage-20GB|Google Drive storage 20 GB",
                    "Google-Drive-storage-50GB|Google Drive storage 50 GB",
                    "Google-Drive-storage-200GB|Google Drive storage 200 GB",
                    "Google-Drive-storage-400GB|Google Drive storage 400 GB",
                    "Google-Drive-storage-1TB|Google Drive storage 1 TB",
                    "Google-Drive-storage-2TB|Google Drive storage 2 TB",
                    "Google-Drive-storage-4TB|Google Drive storage 4 TB",
                    "Google-Drive-storage-8TB|Google Drive storage 8 TB",
                    "Google-Drive-storage-16TB|Google Drive storage 16 TB",
                    "Google-Vault|Google Vault",                
                    "Google-Apps-Unlimited|G Suite Business",            
                    "1010020020|G Suite Enterprise"
            )),
            'Number of Seats' => array('type' => 4, 'min' => 0, 'max' => 10)
        );
        
        //add options
        foreach ($options as $optName => $optValues)
        {
            switch($optValues['type'])
            {
                case 1:
                    PDOWrapper::query('INSERT INTO tblproductconfigoptions(gid,optionname, optiontype) VALUES(?,?,?)', array($group_id, $optName . '|' . $optName, $optValues['type']));
                    $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
                    $conf_id = PDOWrapper::insert_id();
                    break;
                case 4:
                    PDOWrapper::query('INSERT INTO tblproductconfigoptions(gid,optionname, optiontype, qtyminimum, qtymaximum) VALUES(?,?,?,?,?)', array($group_id, $optName . '|' . $optName, $optValues['type'], $optValues['min'], $optValues['max']));
                    $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
                    $conf_id = PDOWrapper::insert_id();
                    break;
                default:
                    break;
            }
            
            //add suboptions + create pricing
            switch($optValues['type'])
            {
                case 1:
                    $sort = 0;
                    foreach($optValues['subOptions'] as $option_key => $option_name)
                    {
                        PDOWrapper::query("INSERT INTO tblproductconfigoptionssub(configid,optionname,sortorder,hidden) VALUES(?,?,?,0)", array
                        (
                            $conf_id,
                            ((strpos($option_name, '|') > 0) ? $option_name : $option_name.'|'.$option_name),
                            (int)$sort
                        ));
                        $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
                        $opt_id   = PDOWrapper::insert_id();
                        self::createPricing($opt_id);
                        $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
                        $sort++;
                    }
                    break;
                case 4:
                    PDOWrapper::query("INSERT INTO tblproductconfigoptionssub(configid,optionname,sortorder,hidden) VALUES(?,?,?,?)", array(
                        $conf_id,
                        'Seats',
                        1,
                        ''
                    ));
                    $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
                    $opt_id = PDOWrapper::insert_id();
                    self::createPricing($opt_id);
                    $errorOcured = PDOWrapper::errorInfo() ? true : $errorOcured;
                    break;
                default:
                    break;
            }            

        }
        
        return  !$errorOcured ? 'created' : 'error';
    }

    public static function createPricing($option_id)
    {
        $currency = PDOWrapper::fetch_assoc(PDOWrapper::query("SELECT * FROM  `tblcurrencies`  WHERE `default`=? LIMIT 1", array("1")));
        $currency = $currency['id'];
        PDOWrapper::query("INSERT INTO `tblpricing`
                         ( `type` , `currency` , `relid` , `msetupfee` , `qsetupfee` , `ssetupfee` , `asetupfee` , `bsetupfee` , `tsetupfee` , `monthly` , `quarterly` , `semiannually` , `annually` , `biennially` , `triennially`)
                                VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", array("configoptions", $currency, $option_id,"0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00"));    
    }
    
    public static function parseCustomFieldsFromParams($fieldsData)
    {
        $parsed = [];
        foreach($fieldsData as $fieldName => $fieldValue)
        {
            if (strpos($fieldName, '|') !== false)
            {
                $nameParts = explode('|', $fieldName);
                $parsed[$nameParts[0]] = $fieldValue;
                
                continue;
            }
            
            $parsed[$fieldName] = $fieldValue;
        }
        
        return $parsed;
    }
    
    public static function parseConfigOptionsFromParams($optionsData)
    {
        return self::parseCustomFieldsFromParams($optionsData);
    }    
}
