<?php
/**
 * WHMCS First Data Payment Callback File
 *
 * This sample file demonstrates how a payment gateway callback should be
 * handled within WHMCS.
 *
 * It demonstrates verifying that the payment gateway module is active,
 * validating an Invoice ID, checking for the existence of a Transaction ID,
 * Logging the Transaction for debugging and Adding Payment to an Invoice.
 *
 * For more information, please refer to the online documentation.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Developer_Docs
 *
 * @copyright Copyright (c) WHMCS Limited 2015
 * @license http://www.whmcs.com/license/ WHMCS Eula
 * @author Megafu Charles Nonso
 * @link charles.megafu@upperlink.ng
 * 
 */
error_reporting(E_ALL);
use Illuminate\Database\Capsule\Manager as Capsule;

define('DEFAULT_HOST_PATH', 'https://domains.upperlink.ng/clients');
define("PATH_ROOT", dirname(__FILE__));

// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

// Detect module name from filename.
$gatewayModuleName = 'firstdata';

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);

// Die if module is not active.
if (!$gatewayParams['type']) {
    die("Module Not Activated");
}

/**
 * Process all callback requests for first data
 *
 * @return void
 * 
 */
function firstDataProcessCallbackRequests() {
//echo "<pre>";
//print_r($_POST);
   if(count($_POST)) {
       $transaction_ref = trim($_POST['x_fp_sequence']);
       $x_response_reason_text = $_POST['x_response_reason_text'];
       $today = date('Y-m-d H:i:s');
       $exact_string = $_POST['exact_ctr'];
       $x_response_code = $_POST['x_response_code'];
       $transaction_tag = $_POST['x_trans_id'];
       
       //check if this transaction reference number exists in our record
       if(Capsule::schema()->hasTable('tbltransactions')) {
          $transaction = Capsule::table('tbltransactions')->where('transaction_ref', $transaction_ref)->first();
          //print_r($transaction);
          if($transaction) {
          	if($transaction->transaction_status == 'paid' || $transaction->transaction_status == 'failed') {
          		//return feedback
	               $feedback_type = 2;
	               $transaction_details->client_id = $transaction->client_id;
	               $transaction_details->transaction_status = ($transaction->transaction_status == 'paid')?'Success':'failed';
	               $transaction_details->transaction_amount = number_format($transaction->transaction_amount, 2);
	               $transaction_details->transaction_description = $transaction->response_description;
	               $transaction_details->transaction_ref = $transaction->transaction_ref;
	               firstDataFeedback($feedback_type, null, $transactionStatus, $transaction_details, $transaction->invoice_id);
          	}elseif($transaction->transaction_status == 'pending') {
	          	file_put_contents('./debug/whmcs-error-trace.txt', 'About to log first data transactions' . "\n", FILE_APPEND);
	             file_put_contents('./debug/whmcs-error-trace.txt', 'RETURNED FROM First Data: ' . json_encode($_POST) . "\n", FILE_APPEND);
	
	             //requery transaction
	             $requery_result = requeryTransaction($transaction_tag, $transaction->created_at);
	            //print_r($requery_result);
	             $transaction_status = getTransactionStatus($requery_result);
	             $transaction_status = $x_response_code == '1'?'paid':'failed';
	             $log_transaction_status = $transaction_status == 'paid' ? 'Success' : 'Failure';
	             $feedback_transaction_status = $transaction_status == 'paid' ? 'Successful' : 'Failed';
	
	             //update transaction details
	              Capsule::table('tbltransactions')->where('id', $transaction->id)->update(['response_code' => $x_response_code,
	                                                                                        'response_description' => isset($x_response_reason_text) && !empty($x_response_reason_text) ? $x_response_reason_text : null,
	                                                                                        'first_data_response_description' => isset($exact_string) && !empty($exact_string) ? $exact_string : null,
	                                                                                        'first_data_transaction_tag' => isset($transaction_tag) && !empty($transaction_tag) ? $transaction_tag : null,
	                                                                                        'transaction_status' => $transaction_status
	                                                                                       ]);
	              $transaction = Capsule::table('tbltransactions')->where('id', $transaction->id)->first();//fetch the updated record from the database
	
	             if (isset($gatewayParams['gatewayLogs']) && $gatewayParams['gatewayLogs'] == 'on') {
	                  $output = "Transaction Reference: " . $transaction_ref
	                      . "\r\nInvoice ID: " . $transaction->invoice_id
	                      . "\r\nStatus: " . $log_transaction_status;
	                  logTransaction($gatewayModuleName, $output, $log_transaction_status);
	              }
	
	              if($transaction_status == 'paid') {
	                    /**
	                     * Validate Callback Invoice ID.
	                     *
	                     * Checks invoice ID is a valid invoice number. Note it will count an
	                     * invoice in any status as valid.
	                     *
	                     * Performs a die upon encountering an invalid Invoice ID.
	                     *
	                     * Returns a normalised invoice ID.
	                     */
	                    $invoiceId = checkCbInvoiceID($transaction->invoice_id, $gatewayParams['name']);
	
	                    /**
	                     * Add Invoice Payment.
	                     *
	                     * Applies a payment transaction entry to the given invoice ID.
	                     *
	                     * @param int $invoiceId         Invoice ID
	                     * @param string $transactionId  Transaction ID
	                     * @param float $paymentAmount   Amount paid (defaults to full balance)
	                     * @param float $paymentFee      Payment fee (optional)
	                     * @param string $gatewayModule  Gateway module name
	                     */
	                    addInvoicePayment($invoiceId, $transaction->transaction_ref, $transaction->transaction_amount, 0, $gatewayModuleName);
	                    // exit($log_transaction_status);
	              }
	              
	               //return feedback
	               $feedback_type = 2;
	               $transaction_details->client_id = $transaction->client_id;
	               $transaction_details->transaction_status = $feedback_transaction_status;
	               $transaction_details->transaction_amount = number_format($transaction->transaction_amount, 2);
	               $transaction_details->transaction_description = $transaction->response_description;
	               $transaction_details->transaction_ref = $transaction->transaction_ref;
	               firstDataFeedback($feedback_type, null, $transactionStatus, $transaction_details, $transaction->invoice_id);
          	}
          }
          else {
          //echo "Here";
            $feedback_type = 1;
            $message = "This transaction reference number '" . $transaction_ref . "' doesn't exist in our record, please contact our support for assistance.";
            firstDataFeedback($feedback_type, $message);
          }
       }
       else {
          $feedback_type = 1;
          $message = "The transactions table doesn't exist, please contact the administrator for assistance.";
          firstDataFeedback($feedback_type, $message);
       }
   }
   else {
      $feedback_type = 1;
      $message = "Invalid response for this transaction. Please go back and try again.";
      firstDataFeedback($feedback_type, $message);
   }
}

/**
 * Requery First Data Transaction
 *
 * @return string
 * @param string $transaction_tag
 * @param string $start_date
 * 
 */
function requeryTransaction($transaction_tag, $start_date) {
   if($transaction_tag && $start_date) {
      $today = date("Y-m-d");
      //$url = "https://api.globalgatewaye4.firstdata.com/transaction/search?start_date=" . $start_date . "&end_date=" . $today;
      $url = "https://api.globalgatewaye4.firstdata.com/transaction/v1/search?start_date=" . $start_date . "&end_date=" . $today;

      $api_key = base64_encode("festusugwu:read_upperlink2-101");
      $headers = array(
                      'Content-Type:application/json',
                      'Authorization: Basic ' . $api_key
                 );
      try {
          $ch = curl_init();
          curl_setopt($ch, CURLOPT_URL, $url);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
          curl_setopt($ch, CURLOPT_TIMEOUT, 30);
          curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
          curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
          curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
          $result = curl_exec($ch);
          //print_r($result);
          if($result) {
             // log requery data from first data
             file_put_contents('./debug/whmcs-error-trace.txt', 'Result From First Data Requery: ' . json_encode($result) . "\n", FILE_APPEND);
             $lines = str_getcsv($result, '\n');
             $gateway_status = null;
             //loop each returned values
             foreach($lines AS $k => $v) {
                if($k == 0) {
                   continue;
                }
                $str_line = explode(",", $line);
                if($transaction_tag == $str_line[0]) {
                   $gateway_status = $str_line[7];
                   break;
                }
             }

             return (string) $gateway_status;
          }
          else {
             return (bool) false;
          }
      }
      catch(Exception $e) {
         file_put_contents('./debug/whmcs-error-trace.txt', 'CURL ERROR: ' . json_encode($e) . "\n", FILE_APPEND);
      }
   }

   return (bool) false;
}

/**
 * Get transaction status
 *
 * @return boolean
 * @param int $response_code
 * 
 */
function getTransactionStatus($response_status) {
   switch($response_status) {
      case 'Approved':
         return (string) 'paid';
      break;

      case 'Declined':
      case 'Error':
          return (string) 'failed';
      break;

      default:
        return (string) 'failed';
      break;
   }
}

/**
 * Render Feedback to the user after payment
 *
 * @return void
 * @param int $feedback_type
 * @param string $message
 * @param string $transaction_status
 * @param stdClass $transaction_details
 * @param int $invoice_id
 * 
 */
function firstDataFeedback($feedback_type, $message, $transaction_status = null, $transaction_details = null, $invoice_id = null) {
   error_reporting(E_ALL);
   include_once(PATH_ROOT . '/feedback/partials/header.php'); //include the feedback page header
   if($feedback_type == 1) {
      $body = file_get_contents(PATH_ROOT . '/feedback/partials/body-2.php');
      $variables = array("{message}", "{return_feedback}");
      $return_feedback = isset($invoice_id) ? "To try again, please <a href='" . DEFAULT_HOST_PATH . "/viewinvoice.php?id=" . $invoice_id . "'>click here</a> to proceed." : "Please <a href='"  . DEFAULT_HOST_PATH .  "'>click here</a> to go back.";
      $values = array($message, 
                      $return_feedback);
      print str_replace($variables, $values, $body);
   }
   else {
       //page body
       $customer = Capsule::table('tblclients')->where('id', $transaction_details->client_id)->first();
       $body = file_get_contents('feedback/partials/body.php');
       $customer_full_name = ucwords($customer->firstname) . " " . ucwords($customer->lastname);
       $variables = array("{customer_name}", "{message}", "{transaction_status}", "{transaction_amount}", "{transaction_description}", "{transaction_ref}", "{return_feedback}");
       if($transaction_status == 'Success') {
          //render the page for success
          $message = "Congratulations! Your transaction was successful. Please see details below.";
          $return_feedback = "Please <a href='". DEFAULT_HOST_PATH .  "/clientarea.php'>click here</a> to go  to your dashboard.";
       }
       else {
          //render the page for 
          $message = "Your transaction was not successful. Please see details below.";
          $return_feedback = "To try again, please <a href='"  . DEFAULT_HOST_PATH . "/viewinvoice.php?id=" . $invoice_id . "'>click here</a> to proceed.";
       }

       $values = array($customer_full_name, 
                       $message, 
                       $transaction_details->transaction_status,
                       $transaction_details->transaction_amount,
                       $transaction_details->transaction_description,
                       $transaction_details->transaction_ref,
                       $return_feedback);
       print str_replace($variables, $values, $body);
   }

   include_once(PATH_ROOT . '/feedback/partials/footer.php'); //include the feedback page footer
   exit;
}

/**
 * Run the callback request
 *
 * @return void
 * 
 */
function firstDataRun() {
   firstDataProcessCallbackRequests();
}

/** Initialize */
firstDataRun();
