<?php

// error_reporting(E_ALL);
// ini_set('display_errors', true);

if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

function siteprobuilder_config() {
	$config = array(
		'name' => 'upperlinkbuilder',
		'description' => 'upperlinkbuilder',
		'version' => '2.0',
		'author' => 'Site.pro',
		'fields' => array()
	);
	return $config;
}

function siteprobuilder_activate() {
	$tfile = dirname(__FILE__).'/../../../templates';
	$tlist = scandir($tfile);
	foreach ($tlist as $tli) {
		if ($tli == '.' || $tli == '..') continue;
		$dir = $tfile.'/'.$tli;
		if (is_dir($dir) && is_file($dir.'/clientareaproductdetails.tpl')) {
			@copy($dir.'/clientareaproductdetails.tpl', $dir.'/clientareaproductdetails.sbbackup.tpl');
			$content = file_get_contents($dir.'/clientareaproductdetails.tpl');
			$content = preg_replace('#(\{\$moduleclientarea[^\{]*\})#iU', '\1{$siteprobuilder}', $content);
			file_put_contents($dir.'/clientareaproductdetails.tpl', $content);
		}
	}
	if (!is_dir(dirname(__FILE__).'/tmp')) mkdir(dirname(__FILE__).'/tmp', 0755);
	return array('status'=>'success', 'description'=>'');
}

function siteprobuilder_deactivate() {
	$tfile = dirname(__FILE__).'/../../../templates';
	$tlist = scandir($tfile);
	foreach ($tlist as $tli) {
		if ($tli == '.' || $tli == '..') continue;
		$dir = $tfile.'/'.$tli;
		if (is_dir($dir) && is_file($dir.'/clientareaproductdetails.sbbackup.tpl')) {
			@unlink($dir.'/clientareaproductdetails.tpl');
			rename($dir.'/clientareaproductdetails.sbbackup.tpl', $dir.'/clientareaproductdetails.tpl');
		}
	}
	return array('status'=>'success', 'description'=>'');
}

function siteprobuilder_clientarea($vars) {
	$output = ''; $error = null;
	try {
		$data = getRequestVar('data');
		$username = (isset($data->username) && $data->username) ? $data->username : getRequestVar('username');
		$password = (isset($data->password) && $data->password) ? $data->password : getRequestVar('password');
		$domain = (isset($data->domain) && $data->domain) ? $data->domain : getRequestVar('domain');
		$serverData = (isset($data->serverData) && is_object($data->serverData)) ? clone $data->serverData : null;
		$serverId = getRequestVar('server_id');
		if (!$serverData || $serverId) {
			$query = "SELECT * FROM `tblservers` WHERE `id`=:serverId";
			if (class_exists('\WHMCS\Database\Capsule')) {
				$pdo = \WHMCS\Database\Capsule::connection()->getPdo();
				$res = $pdo->prepare($query);
				$res->execute(array(':serverId' => $serverId));
				$serverData = $res->fetch(PDO::FETCH_OBJ);
			} else {
				$res = full_query(str_replace(':serverId', "'".mysql_real_escape_string($serverId)."'", $query));
				$f = mysql_fetch_array($res, MYSQL_ASSOC);
				$serverData = $f ? ((object) $f) : null;
			}
		}
		if (!$username) throw new ErrorException('Error: Unknown username.');
		if (!$domain) throw new ErrorException('Error: Domain is not specified.');
		if (!$serverData) throw new ErrorException('Error: Server data is not specified.');
			
		$adminUser = (function_exists('oneall_social_login_get_admin_username') ? oneall_social_login_get_admin_username() : null);
		$apiResp = localAPI('DecryptPassword', array('password2' => $serverData->password), $adminUser);
		if (isset($apiResp['result']) && $apiResp['result'] == 'success' && isset($apiResp['password']) && $apiResp['password']) {
			$serverData->password = $apiResp['password'];
		} else {
			$serverData->password = null;
		}

		require dirname(__FILE__).'/panels/IPanel.php';
		require dirname(__FILE__).'/panels/Panel.php';
		$cls = Panel::getClass($serverData->type);
		if (!class_exists($cls))
			throw new ErrorException("Error: Required class \"{$cls}\" does not exist.");
			
		$panel = new $cls();
		if (!($panel instanceof IPanel))
			throw new ErrorException("Error: Required class \"{$cls}\" is incorrect.");
			
		$panel->identifyUser($username, $password, $domain, $serverData);
		
		if ($panel instanceof CPanelNew) {
			$output = $panel->process();
		} else {
			if (!$password) throw new ErrorException('Error: Password is not specified.');
			$url = $panel->getUrl();
			if (!$url) {
				throw new ErrorException('Error: Could not get Builder URL');
			}
			header('Location: '.$url);
			exit();
		}
		
	} catch (ErrorException $ex) {
		$error = $ex->getMessage();
	}
	
	return array(
		'pagetitle' => 'upperlinkbuilder',
		'templatefile' => 'siteprobuilder',
		'requirelogin' => true,
		'vars' => array(
			'output' => $output,
			'error' => $error
		)
	);
}

function getRequestVar($name) {
	$var = isset($_POST[$name]) ? $_POST[$name] : null;
	if (!$var && isset($_GET[$name]))
		$var = $_GET[$name];
	if (!$var && isset($_SESSION['siteprobuilder_'.$name]))
		$var = $_SESSION['siteprobuilder_'.$name];
	return $var;
}