<?php

abstract class Panel implements IPanel {
	
	public static $apiUrl = 'http://builder.upperlink.ng/api/';
	public static $apiUsername = 'apikey0';
	public static $apiPassword = '97mh03IYkZ8SWXMUeKgAgeQCwGY9NLd.wf.9p/tQckFlcZnT';
	
	public $username;
	public $password;
	public $domain;
	/** @var ServerData */
	public $server;
	
	protected $tmpDir;
	protected $tmpFile;
	
	private static $panels = array(
		'plesk' => array('class' => 'Plesk'),
		// 'cpanel' => array('class' => 'CPanel'),
		'cpanel' => array('class' => 'CPanelNew'),
		// 'cpanelExtended' => array('class' => 'CPanel'),
		'interworx' => array('class' => 'InterWorx'),
		'directadmin' => array('class' => 'DirectAdmin'),
		'ispmanager' => array('class' => 'ISP5')
	);
	
	public static function getClass($panelId) {
		$panel = isset(self::$panels[$panelId]) ? self::$panels[$panelId] : null;
		if (!$panel) {
			foreach (self::$panels as $pnlId => $pnl) {
				if (strpos(strtolower($panelId), $pnlId) !== false) {
					$panel = self::$panels[$pnlId]; break;
				}
			}
		}
		if ($panel) {
			$file = dirname(__FILE__).'/'.$panel['class'].'.php';
			if (is_file($file)) {
				require $file;
				if (class_exists($panel['class'])) {
					return $panel['class'];
				}
			}
			throw new ErrorException('Error: panel is not implemented');
		} else {
			throw new ErrorException('Error: panel is not supported');
		}
	}
	
	public function __construct() {
		$this->tmpDir = dirname(__FILE__).'/../tmp';
		$this->tmpFile = $this->tmpDir.'/'.md5(microtime());
	}
	
	public function identifyUser($username, $password, $domain, $serverData) {
		$this->username = $username;
		$this->password = $password;
		$this->domain = $domain;
		$this->server = new ServerData($serverData);
	}
	
	public function getUrl() {
		session_write_close();
		$this->beforeCallApi();
		$result = $this->callApi();
		$this->afterCallApi();
		if ($result && $this->checkIsUrl($result)) {
			return $result;
		} else if ($result && $this->checkIsError($result)) {
			throw new ErrorException($result);
		} else {
			throw new ErrorException('Error: bad URL');
		}
	}
	
	protected abstract function callApi();
	
	protected function beforeCallApi() {}
	
	protected function afterCallApi() {
		$this->removeTmpFile();
	}
	
	private function checkIsUrl($url) {
		return (strpos($url, 'login_hash=') !== false);
		/* $parts = parse_url($url);
		if (isset($parts['host']) && $parts['host'] && isset($parts['query']) && $parts['query'] && preg_match('#login_hash=\w{16}#i', $parts['query'])) {
			return true;
		}
		return false; */
	}
	
	private function checkIsError($url) {
		return (strpos(strtolower($url), 'error') !== false);
	}
	
	private function removeTmpFile() {
		if ($this->tmpFile && is_file($this->tmpFile)) {
			@unlink($this->tmpFile);
		}
	}
	
}

class ServerData {
	
	public $id;
	public $name;
	public $ip;
	public $host;
	public $type;
	public $username;
	public $password;
	public $secure;
	public $port;
	public $active;
	public $disabled;
			
	public function __construct(stdclass $data) {
		$this->id = (isset($data->id) && $data->id) ? $data->id : null;
		$this->name = (isset($data->name) && $data->name) ? $data->name : null;
		$this->ip = (isset($data->ipaddress) && $data->ipaddress) ? $data->ipaddress : null;
		$this->host = (isset($data->hostname) && $data->hostname) ? $data->hostname : null;
		$this->type = (isset($data->type) && $data->type) ? $data->type : null;
		$this->username = (isset($data->username) && $data->username) ? $data->username : null;
		$this->password = (isset($data->password) && $data->password) ? $data->password : null;
		$this->secure = (isset($data->secure) && (intval($data->secure) == 1 || strtolower($data->secure == 'on')));
		$this->port = (isset($data->port) && $data->port) ? $data->port : null;
		$this->active = (isset($data->active) && intval($data->active));
		$this->disabled = (isset($data->disabled) && intval($data->disabled));
	}
	
}