<?php

class DirectAdmin extends Panel {
	
	private $userAgent = null;
	
	protected function getBaseUrl() {
		return 'http://'.$this->server->ip.':2222';
	}
	
	protected function callApi() {
		$baseUrl = $this->getBaseUrl();
		$loginUrl = $baseUrl.'/CMD_LOGIN';
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $loginUrl);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_USERAGENT, ($this->userAgent ? $this->userAgent : $_SERVER['HTTP_USER_AGENT']));
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_COOKIEFILE, $this->tmpFile);
		curl_setopt($ch, CURLOPT_COOKIEJAR, $this->tmpFile);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "username={$this->username}&password={$this->password}");
		$r = curl_exec($ch);
		if (preg_match('#name=[\'"]*username[\'"]*#i', $r) && preg_match('#name=[\'"]*password[\'"]*#i', $r)) {
			$lastUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
			if ($loginUrl != $lastUrl) {
				$parts = parse_url($lastUrl);
				$baseUrl = $parts['scheme'].'://'.$parts['host'] . (isset($parts['port']) ? ':'.$parts['port'] : '');
				curl_close($ch);
				return $this->callApi();
			} else if (!$this->userAgent) {
				$this->userAgent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.6) Gecko/20070725 Firefox/2.0.0.6';
				curl_close($ch);
				return $this->callApi();
			}
			throw new ErrorException('Username or password of DirectAdmin panel user is incorrect');
		} else if (preg_match('#your\s+ip\s+is\s+blacklisted#i', $r)) {
			$whmcsIP = (($v = gethostbyname($_SERVER['HTTP_HOST'])) && preg_match('#^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$#', $v)) ? $v : null;
			$directadminIP = (($v = gethostbyname($this->serverIp)) && preg_match('#^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$#', $v)) ? $v : null;
			$error = 'WHMCS cannot connect to DirectAdmin server &mdash; IP of WHMCS'
					.($whmcsIP ? ' ['.$whmcsIP.']' : '')
					.' is blacklisted on DirectAdmin server'
					.($directadminIP ? ' ['.$directadminIP.']' : '');
			throw new ErrorException($error);
		}
		
		curl_setopt($ch, CURLOPT_URL, $baseUrl.'/CMD_PLUGINS/siteprobuilder/index.raw?return_url=1&sbsubdomain='.$this->domain);
		$r = curl_exec($ch);
		
		if (strstr($r, 'plugin does not exist')) {
			throw new ErrorException('Site Builder plugin is not installed on DirectAdmin panel or is not active for current user');
		} else if (strstr($r, 'feature is not available')) {
			throw new ErrorException('Site Builder plugin is not enabled for current user in hosting package of DirectAdmin panel.');
		}
		curl_close($ch);
		return $r;
	}
	
}
