<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-07-04)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\submodules\cpanel;

/**
 * cPanel Api
 *
 * 
 */
class Api
{
    private static $allowedAPIs = array(
        'WHM0', 'WHM1', 'API1', 'API2', 'UAPI'
    );
    private static $instance    = false;
    private $host;
    private $port;
    private $username;
    private $password;
    private $ssl;
    private $authtype;
    private $queryuser;
    private $url;
    private $api                = false;
    private $module             = false;
    private $function           = false;
    private $output             = 'json';
    private $tempout;

    public function __construct($host, $username, $password = null, $queryuser = null, $ssl = true, $hash = null)
    {
        $this->host        = $host;
        $this->username    = $username;
        $this->uapiconnect = Uapi::getInstance($host, $username, $password, $queryuser, $ssl);

        if ($hash)
        {
            $this->authtype = 0;
            $this->password = trim($hash);
        }
        else
        {
            $this->authtype = 1;
            $this->password = $password;
        }

        $this->ssl  = $ssl;
        if ($this->ssl)
            $this->port = '2087';
        else
            $this->port = '2086';

        if ($queryuser)
            $this->queryuser = $queryuser;

        $this->curlCustomConfig = array();
        if (file_exists(dirname(__FILE__) . DS . 'curl_options.ini'))
            $this->curlCustomConfig = parse_ini_file(dirname(__FILE__) . DS . 'curl_options.ini');
    }

    private function __clone()
    {
        
    }

    public static function getInstance()
    {
        if (self::$instance === false)
        {
            throw new CPanelException("API connection is not defined");
        }

        return self::$instance;
    }

    public function __get($name)
    {
        if (in_array(strtoupper($name), self::$allowedAPIs))
            $this->api    = strtoupper($name);
        else
        if ($this->api !== false)
            $this->module = $name;
        else
            throw new CPanelException('API ' . $name . 'is not supported');

        return $this;
    }

    public function __call($name, $arguments)
    {
        if ($this->api === false)
        {
            throw new CPanelException('API is not specified');
        }

        if (($this->api == 'API1' || $this->api == 'API2') && $this->module == false)
        {
            throw new CPanelException('Module is not specified');
        }

        $this->function = $name;
        if (is_null($arguments[1]) || empty($arguments[1]))
            $this->tempout  = $this->output;
        else
            $this->tempout  = $arguments[1];

        $result = null;
        switch ($this->api)
        {
            case 'UAPI':
                $result = $this->sendUAPIRequest($arguments[0]);
                break;
            case 'API1'
                : $result = $this->sendAPI1Request($arguments[0]);
                break;
            case 'API2'
                : $result = $this->sendAPI2Request($arguments[0]);
                break;
            case 'WHM0'
                : $result = $this->sendWHMRequest($arguments[0], 0);
                break;
            case 'WHM1'
                : $result = $this->sendWHMRequest($arguments[0], 1);
                break;
        }


        if ($this->tempout == 'uobj')
        {

            return $this->processUapiResponse($result);
        }

        if (is_null($arguments[2]) || !isset($arguments[2]))
        {
            $this->checkIfThereIsNoErrorInResult($result);
        }
        else
        {
            if ($arguments[2] === true)
            {
                $this->checkIfThereIsNoErrorInResult($result);
            }
        }

        if ($this->tempout == 'array')
        {
            return json_decode($result, TRUE);
        }

        if ($this->tempout == 'obj')
        {
            return $this->processRequest(json_decode($result));
        }

        if ($this->tempout == 'sarray' || $this->tempout == 'sobj')
        {
            $array = json_decode($result, TRUE);

            array_walk_recursive($array, function(&$v)
            {
                $v = htmlspecialchars($v, ENT_QUOTES);
            });

            if ($this->tempout == 'sarray')
                return $array;
            else
                return $this->processRequest(json_decode(json_encode($array)));
        }

        unset($this->tempout);

        return $result;
    }

    private function processUapiResponse($result)
    {
        if (!empty($result->errors))
        {

            throw new CPanelException($result->errors[0]);
        }

        return $result;
    }

    private function processRequest($result)
    {
        if (isset($result->data->status) && $result->data->status != 1)
        {
            $msg = $result->data->statusmsg ? $result->data->statusmsg : $result->data->error;
            throw new CPanelException($msg);
        }
        else if (!empty($result->cpanelresult->error))
        {
            throw new CPanelException((string) $result->cpanelresult->error);
        }
        return $result;
    }

    private function sendUAPIRequest($arguments)
    {
        $end = '/execute/' . rawurlencode($this->module) . '/' . rawurlencode($this->function) . '?' . http_build_query($arguments);
        return $this->uapiconnect->execQuery($end);
    }

    //api1
    private function sendAPI1Request($arguments)
    {
        list($api, $cpuser, $module_type, $func_type, $api_type) = $this->getQueryArray();
        $this->url = ($this->ssl === true ? 'https://' : 'http://') . rawurlencode($this->host) . ':' . rawurlencode($this->port)
                . '/' . $api . '/cpanel?' . $cpuser . '=' . $this->queryuser . '&' . $module_type . '=' . rawurlencode($this->module)
                . '&' . $func_type . '=' . rawurlencode($this->function) . '&' . $api_type . '=1';
        $argcount  = 0;
        foreach ($arguments as $a)
        {
            $this->url.= '&arg-' . $argcount . '=' . rawurlencode(trim($a));
            $argcount++;
        }

        return $this->execRequest();
    }

    private function sendAPI2Request($arguments)
    {
        list($api, $cpuser, $module_type, $func_type, $api_type) = $this->getQueryArray();

        $this->url = ($this->ssl === true ? 'https://' : 'http://') . rawurlencode($this->host) . ':' . rawurlencode($this->port)
                . '/' . $api . '/cpanel?' . $cpuser . '=' . $this->queryuser . '&' . $module_type . '=' . rawurlencode($this->module)
                . '&' . $func_type . '=' . rawurlencode($this->function) . '&' . $api_type . '=2';

        while (list($action, $val) = each($arguments))
        {
            $this->url.= '&' . rawurlencode($action) . '=' . rawurlencode(trim($val));
        }

        return $this->execRequest();
    }

    private function sendWHMRequest($arguments, $apiVersion)
    {
        $this->url = ($this->ssl === true ? 'https://' : 'http://') . rawurlencode($this->host) . ':' . rawurlencode($this->port) . '/json-api/' . $this->function . '?api.version=' . $apiVersion;
        foreach ($arguments as $key => $value)
        {
            $value = rawurlencode($value);
            $this->url .= "&{$key}={$value}";
        }
        $this->url = trim($this->url, '&');

        return $this->execRequest();
    }

    private function getQueryArray()
    {
        if ($this->tempout == 'xml')
            return array('xml-api', 'cpanel_xmlapi_user', 'cpanel_xmlapi_module',
                'cpanel_xmlapi_func', 'cpanel_xmlapi_apiversion');
        else
            return array('json-api', 'cpanel_jsonapi_user', 'cpanel_jsonapi_module',
                'cpanel_jsonapi_func',
                'cpanel_jsonapi_apiversion');
    }

    private function execRequest()
    {
        $open_basedir    = ini_get('open_basedir');
        $is_open_basedir = empty($open_basedir) ? 1 : 0;

        $ch        = curl_init();
        $chOptions = array(
            CURLOPT_URL            => $this->url,
            CURLOPT_PORT           => $this->port,
            CURLOPT_SSL_VERIFYPEER => isset($this->curlCustomConfig['CURLOPT_SSL_VERIFYPEER']) ? $this->curlCustomConfig['CURLOPT_SSL_VERIFYPEER'] : 0,
            CURLOPT_SSL_VERIFYHOST => isset($this->curlCustomConfig['CURLOPT_SSL_VERIFYHOST']) ? $this->curlCustomConfig['CURLOPT_SSL_VERIFYHOST'] : 0,
            CURLOPT_RETURNTRANSFER => isset($this->curlCustomConfig['CURLOPT_RETURNTRANSFER']) ? $this->curlCustomConfig['CURLOPT_RETURNTRANSFER'] : 1,
            CURLOPT_FOLLOWLOCATION => isset($this->curlCustomConfig['CURLOPT_FOLLOWLOCATION']) ? $this->curlCustomConfig['CURLOPT_FOLLOWLOCATION'] : $is_open_basedir,
            CURLOPT_TIMEOUT        => isset($this->curlCustomConfig['CURLOPT_TIMEOUT']) ? $this->curlCustomConfig['CURLOPT_TIMEOUT'] : 90,
        );

        if ($this->authtype)
        {
            $header[0]                     = "Authorization: Basic " . base64_encode($this->username . ":" . $this->password);
            $chOptions[CURLOPT_HTTPHEADER] = $header;
        }
        else
        {
            $header[0]                     = 'Authorization: WHM ' . $this->username . ':' . str_replace(array(
                        "\r", "\n"), "", $this->password);
            $chOptions[CURLOPT_HTTPHEADER] = $header;
        }

        curl_setopt_array($ch, $chOptions);
        $result = curl_exec($ch);

        logModuleCall('DomainEmailForward', $this->api . '::' . ($this->module ? $this->module . '::' : '') . $this->function, $this->url, $result);

        if ($result == false)
        {
            if (curl_error($ch) == 'connect() timed out!')
            {
                throw new CPanelException('Could not connect to the server. Please try again later or contact administrator.');
            }
            throw new CPanelException(curl_error($ch));
        }
        elseif (!is_object($result) && !is_string($result))
        {
            throw new CPanelException(htmlspecialchars($result));
        }

        curl_close($ch);
        return $result;
    }

    private function checkIfThereIsNoErrorInResult($result)
    {
        if ($this->tempout == 'xml')
        {
            $obj = json_decode(json_encode(simplexml_load_string($result, null, LIBXML_NOERROR | LIBXML_NOWARNING)));
        }
        else
        {
            $obj = json_decode($result);
        }

        if (empty($obj))
        {
            throw new \Exception("Please enable SSL Mode for this server and try again.");
        }

        $errormsg = '';

        switch ($this->api)
        {
            case 'WHM0':
                if (isset($obj->status) && $obj->status == 0) //data request
                    $errormsg = $obj->statusmsg;

                if (isset($obj->result->status) && $obj->result->status == 0) //action
                    $errormsg = $obj->result->statusmsg;
                break;
            case 'WHM1':
                if (isset($obj->metadata->result) && $obj->metadata->result == 0)
                    $errormsg = $obj->metadata->reason;
                break;
            case 'API1':
                if (isset($obj->error))
                    $errormsg = $obj->error;
                break;
            case 'API2':
                if (isset($obj->cpanelresult->event->result) && $obj->cpanelresult->event->result == 1)
                { //if result is '1' API request succeeded
                    return;
                }

                if (isset($obj->cpanelresult->error))
                {
                    $errormsg = $obj->cpanelresult->error;
                }
                if (isset($obj->cpanelresult->data->result) && $obj->cpanelresult->data->result == 0)
                {
                    $errormsg = $obj->cpanelresult->data->reason;
                }
                break;
        }

        if (!empty($errormsg))
        {
            throw new CPanelException($errormsg); //htmlspecialchars($errormsg));
        }
    }
}
