<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-07-04)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

use MGModule\DomainAndEmailForwarding as main;

add_hook('ClientAreaPrimarySidebar', 1, function($primaryNavbar)
{
    try
    {
        if (!isset($_REQUEST['action']) || $_REQUEST['action'] != 'domaindetails' || !isset($_REQUEST['id']))
            return;

        require_once 'Loader.php';
        new main\Loader();
        main\Addon::I(true);

        $domain         = new main\models\whmcs\Domain($_REQUEST['id']);
        $domainSettings = new main\repository\DomainSettingRepository();
        $domainSettings->whereDomainPricingId($domain->domainPricing()->getId())
                ->andURLforwardingOrEmailForwarding();

        $manager = new main\service\IntegrationManager();
        if ($manager->getActiveModule($domain) == false)
        {
            return;
        }

        try
        {
            $zone = main\mgLibs\MySQL\Query::query("SELECT z.name
                    FROM dns_manager2_zone AS z
                    LEFT JOIN dns_manager2_server AS s ON z.serverid = s.id
                    WHERE s.module IN('CPanel', 'CPanelOldApi', 'DirectAdmin') AND z.name LIKE '{$domain->getDomain()}'")->fetch();

            if (!empty($zone))
            {
                throw new main\mgLibs\exceptions\System("This domain has enabled DNS Manager zone");
            }
        }
        catch (main\mgLibs\MySQL\Exception $e)
        {
            
        }
        catch (\Exception $e)
        {
            return;
        }

        if ((int) $domainSettings->count() <= 0)
            return;

        $seting = $domainSettings->fetchOne();

        $enabledHosting = false;

        if (\WHMCS\Service\Service::where('domain', $domain->getDomain())->count() > 0)
        {
            $registry       = main\models\Registry::getInstance();
            $enabledHosting = $registry->getEnabledHosting();
        }

        if (!$enabledHosting && $domain->getStatus() == 'Active')
        {
            /** @var \WHMCS\View\Menu\Item $primaryNavbar */
            $newMenu = $primaryNavbar->addChild(
                    'mgDomainForwarding', array(
                'name'  => 'DomainForwarding',
                'label' => main\mgLibs\Lang::absoluteT("Domain Management"),
                'order' => 21,
                'icon'  => 'fa-calendar-o',
                    )
            );


            if ($seting->isUrlForwarding())
            {
                $newMenu->addChild(
                        'mgURLForwarding', array(
                    'name'  => 'URLForwarding',
                    'label' => main\mgLibs\Lang::absoluteT("Domain Redirects"),
                    'uri'   => 'index.php?m=DomainAndEmailForwarding&mg-page=forwardDomains&id=' . $domain->getId(),
                    'order' => 22,
                    'icon'  => 'fa-share',
                        )
                );
            }

            if ($seting->isEmailForwarding())
            {
                $newMenu->addChild(
                        'mgEmailForwarding', array(
                    'name'  => 'EmailForwarding',
                    'label' => main\mgLibs\Lang::absoluteT("Email Redirects"),
                    'uri'   => 'index.php?m=DomainAndEmailForwarding&mg-page=forwardEmail&id=' . $domain->getId(),
                    'order' => 23,
                    'icon'  => 'fa-envelope',
                        )
                );
            }
        }
    }
    catch (\Exception $ex)
    {
        main\mgLibs\error\Register::register($ex);
    }
}
);


add_hook('ClientAreaPage', 1, function($vars)
{
    try
    {
        if (!isset($_REQUEST['action']) || $_REQUEST['action'] != 'domaindetails' || !isset($_REQUEST['id']))
            return;

        require_once 'Loader.php';
        $loader = new main\Loader();
        main\Addon::I(true);

        $domain = new main\models\whmcs\Domain($_REQUEST['id']);

        $nameservers = $domain->domainPricing()->domainSetting()->getNameservers();
        $nameservers = array_filter($nameservers);
        if (empty($nameservers))
        {
            $registry    = main\models\Registry::getInstance();
            $nameservers = $registry->getNameservers();
        }
        $nameservers = array_filter($nameservers);
        if (empty($nameservers))
        {
            return;
        }

        $currentNameservers = main\mgLibs\whmcsAPI\WhmcsAPI::request(
                        "domaingetnameservers", array('domainid' => $_REQUEST['id'])
        );
        if ($currentNameservers['result'] == 'success')
        {
            unset($currentNameservers['result']);
            $common = array_intersect($nameservers, $currentNameservers);
            if (count($common) < 2)
            {
                $nameserversToSet = (array_filter(array_diff($nameservers, $common)));
                return array(
                    'nameservererror' => sprintf(
                            main\mgLibs\Lang::absoluteT("Nameservers for this domain don't fit with current configuration."), implode(", ", $nameserversToSet)
                    )
                );
            }
        }
    }
    catch (\Exception $ex)
    {
        main\mgLibs\error\Register::register($ex);
    }
}
);
