<?php

use \ModulesGarden\GSuite\App\Utilities;
use \ModulesGarden\GSuite\App\Models\GSuiteToken;

if (isset($_GET['gsuite_ajax']))
{
    if (!$_SESSION['adminid'])
    {
        echo 'You need to be administrator';
        die();
    }
    
    if (!defined('DS'))
    {
        define('DS', DIRECTORY_SEPARATOR);
    }

    require_once dirname(__FILE__).DS.'..'.DS.'..'.DS.'modules'.DS.'servers'.DS.'gSuite'.DS. 'vendor' . DS . 'autoload.php';
    
    if ($_REQUEST['gsuite_act'])
    {
        $productId = $_REQUEST['productid'];
        switch ($_REQUEST['gsuite_act'])
        {
            case 'gsuite_setup_configurable_options':
                $result = Utilities::gSuite_updateConfigurableOptions($productId);
                if(ob_get_level() > 0)
                {
                    ob_start();
                    ob_clean();
                }
                switch ($result) {
                    case 'created':
                        echo json_encode(array('result' => 'Configurable options generated successfully.'));
                        die();
                        break;
                    
                    case 'alredyExist':
                        echo json_encode(array('result' => 'Creation failed. Configurable options for this product alredy exist.'));
                        die();
                        break;

                    case 'error':
                        echo json_encode(array('result' => 'Creation failed. Please contact administrator.'));
                        die();
                        break;
                    
                    default:
                        echo json_encode(array('result' => 'Creation failed. Please contact administrator.'));
                        die();
                        break;
                }
                break;
                
            default:
                echo "Undefined act";
                die();
                break;
        }
    }
}
