<?php
/**
 * WHMCS Upperlink Registrar Module
 *
 *
 * @see http://developers.whmcs.com/domain-registrars/
 * @author Babatundedaniel daniel.babatunde@upperlink.ng https://github.com/babatundeodaniel/
 * @copyright Copyright (c) Upperlink Limited 2017
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}
//require_once __DIR__ . '/lib/ApiClient.php';
use WHMCS\Domains\DomainLookup\ResultsList;
use WHMCS\Domains\DomainLookup\SearchResult;
use WHMCS\Module\Registrar\UpperlinkRegistrar\ApiClient;

// Require any libraries needed for the module to function.

//
// Also, perform any initialization required by the service's library.

/**
 * Define module related metadata
 *
 * Provide some module information including the display name and API Version to
 * determine the method of decoding the input values.
 *
 * @return array
 */
function upperlinkregistrar_MetaData()
{
    return array(
        'DisplayName' => 'Upperlink Registrar Module for WHMCS',
        'APIVersion' => '7.1.1'
    );
}

/**
 * Define registrar configuration options.
 *
 * The values you return here define what configuration options
 * we store for the module. These values are made available to
 * each module function.
 *
 * You can store an unlimited number of configuration settings.
 * The following field types are supported:
 *  * Text
 *  * Password
 *  * Yes/No Checkboxes
 *  * Dropdown Menus
 *  * Radio Buttons
 *  * Text Areas
 *
 * @return array
 */
function upperlinkregistrar_getConfigArray()
{
    return array(
        // a text field type allows for single line text input
        'ResellerID' => array(
            'Type' => 'text',
            'Size' => '25',
            'Default' => '1024',
            'Description' => 'Enter your ResellerID',
        ),
        // a password field type allows for masked text input
        'ResellerAccessKey' => array(
            'Type' => 'password',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Enter Reseller Access Key',
        ),
        // the yesno field type displays a single checkbox option
        'Test Mode' => array(
            'Type' => 'yesno',
            'Description' => 'Tick to enable',
        ),
    );
}

/**
 * Register a domain.
 *
 * Attempt to register a domain with the domain registrar.
 *
 * This is triggered when the following events occur:
 * * Payment received for a domain registration order
 * * When a pending domain registration order is accepted
 * * Upon manual request by an admin user
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_RegisterDomain($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];
    //$accountMode = $params['Account Mode'];
    //$emailPreference = $params['Email Preference'];
    //$additionalInfo = $params['Additional Information'];

    // registration parameters
    $sld = $params['sld'];
    $tld = $params['tld'];
    $registrationPeriod = $params['regperiod'];

    /**
     * Nameservers.
     *
     * If purchased with web hosting, values will be taken from the
     * assigned web hosting server. Otherwise uses the values specified
     * during the order process.
     */
    $nameserver1 = $params['ns1'];
    $nameserver2 = $params['ns2'];
    $nameserver3 = $params['ns3'];
    $nameserver4 = $params['ns4'];
    $nameserver5 = $params['ns5'];

    // registrant information
    $firstName = $params["firstname"];
    $lastName = $params["lastname"];
    $fullName = $params["fullname"]; // First name and last name combined
    $companyName = $params["companyname"];
    $email = $params["email"];
    $address1 = $params["address1"];
    $address2 = $params["address2"];
    $city = $params["city"];
    $state = $params["state"]; // eg. TX
    $stateFullName = $params["fullstate"]; // eg. Texas
    $postcode = $params["postcode"]; // Postcode/Zip code
    $countryCode = $params["countrycode"]; // eg. GB
    $countryName = $params["countryname"]; // eg. United Kingdom
    $phoneNumber = $params["phonenumber"]; // Phone number as the user provided it
    $phoneCountryCode = $params["phonecc"]; // Country code determined based on country
    $phoneNumberFormatted = $params["fullphonenumber"]; // Format: +CC.xxxxxxxxxxxx

    /**
     * Admin contact information.
     *
     * Defaults to the same as the client information. Can be configured
     * to use the web hosts details if the `Use Clients Details` option
     * is disabled in Setup > General Settings > Domains.
     */
    $adminFirstName = $params["adminfirstname"];
    $adminLastName = $params["adminlastname"];
    $adminCompanyName = $params["admincompanyname"];
    $adminEmail = $params["adminemail"];
    $adminAddress1 = $params["adminaddress1"];
    $adminAddress2 = $params["adminaddress2"];
    $adminCity = $params["admincity"];
    $adminState = $params["adminstate"]; // eg. TX
    $adminStateFull = $params["adminfullstate"]; // eg. Texas
    $adminPostcode = $params["adminpostcode"]; // Postcode/Zip code
    $adminCountry = $params["admincountry"]; // eg. GB
    $adminPhoneNumber = $params["adminphonenumber"]; // Phone number as the user provided it
    $adminPhoneNumberFormatted = $params["adminfullphonenumber"]; // Format: +CC.xxxxxxxxxxxx

    // domain addon purchase status
    $enableDnsManagement = (bool) $params['dnsmanagement'];
    $enableEmailForwarding = (bool) $params['emailforwarding'];
    $enableIdProtection = (bool) $params['idprotection'];

    /**
     * Premium domain parameters.
     *
     * Premium domains enabled informs you if the admin user has enabled
     * the selling of premium domain names. If this domain is a premium name,
     * `premiumCost` will contain the cost price retrieved at the time of
     * the order being placed. The premium order should only be processed
     * if the cost price now matches the previously fetched amount.
     */
    $premiumDomainsEnabled = (bool) $params['premiumEnabled'];
    $premiumDomainsCost = $params['premiumCost'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'years' => $registrationPeriod,
        'nameservers' => array(
            'ns1' => $nameserver1,
            'ns2' => $nameserver2,
            'ns3' => $nameserver3,
            'ns4' => $nameserver4,
            'ns5' => $nameserver5,
        ),
        'contacts' => array(
            'registrant' => array(
                'firstname' => $firstName,
                'lastname' => $lastName,
                'companyname' => $companyName,
                'email' => $email,
                'address1' => $address1,
                'address2' => $address2,
                'city' => $city,
                'state' => $state,
                'zipcode' => $postcode,
                'country' => $countryCode,
                'phonenumber' => $phoneNumberFormatted,
            ),
            'tech' => array(
                'firstname' => $adminFirstName,
                'lastname' => $adminLastName,
                'companyname' => $adminCompanyName,
                'email' => $adminEmail,
                'address1' => $adminAddress1,
                'address2' => $adminAddress2,
                'city' => $adminCity,
                'state' => $adminState,
                'zipcode' => $adminPostcode,
                'country' => $adminCountry,
                'phonenumber' => $adminPhoneNumberFormatted,
            ),
        ),
        'dnsmanagement' => $enableDnsManagement,
        'emailforwarding' => $enableEmailForwarding,
        'idprotection' => $enableIdProtection,
        'action' => 'Register',
    );

    if ($premiumDomainsEnabled && $premiumDomainsCost) {
        $postfields['accepted_premium_cost'] = $premiumDomainsCost;
    }

    try {
        $api = new ApiClient();
        $api->call($postfields);

        return array(
            'success' => true,
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Initiate domain transfer.
 *
 * Attempt to create a domain transfer request for a given domain.
 *
 * This is triggered when the following events occur:
 * * Payment received for a domain transfer order
 * * When a pending domain transfer order is accepted
 * * Upon manual request by an admin user
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_TransferDomain($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // registration parameters
    $sld = $params['sld'];
    $tld = $params['tld'];
    $registrationPeriod = $params['regperiod'];
    $eppCode = $params['eppcode'];

    /**
     * Nameservers.
     *
     * If purchased with web hosting, values will be taken from the
     * assigned web hosting server. Otherwise uses the values specified
     * during the order process.
     */
    $nameserver1 = $params['ns1'];
    $nameserver2 = $params['ns2'];
    $nameserver3 = $params['ns3'];
    $nameserver4 = $params['ns4'];
    $nameserver5 = $params['ns5'];

    // registrant information
    $firstName = $params["firstname"];
    $lastName = $params["lastname"];
    $fullName = $params["fullname"]; // First name and last name combined
    $companyName = $params["companyname"];
    $email = $params["email"];
    $address1 = $params["address1"];
    $address2 = $params["address2"];
    $city = $params["city"];
    $state = $params["state"]; // eg. TX
    $stateFullName = $params["fullstate"]; // eg. Texas
    $postcode = $params["postcode"]; // Postcode/Zip code
    $countryCode = $params["countrycode"]; // eg. GB
    $countryName = $params["countryname"]; // eg. United Kingdom
    $phoneNumber = $params["phonenumber"]; // Phone number as the user provided it
    $phoneCountryCode = $params["phonecc"]; // Country code determined based on country
    $phoneNumberFormatted = $params["fullphonenumber"]; // Format: +CC.xxxxxxxxxxxx

    /**
     * Admin contact information.
     *
     * Defaults to the same as the client information. Can be configured
     * to use the web hosts details if the `Use Clients Details` option
     * is disabled in Setup > General Settings > Domains.
     */
    $adminFirstName = $params["adminfirstname"];
    $adminLastName = $params["adminlastname"];
    $adminCompanyName = $params["admincompanyname"];
    $adminEmail = $params["adminemail"];
    $adminAddress1 = $params["adminaddress1"];
    $adminAddress2 = $params["adminaddress2"];
    $adminCity = $params["admincity"];
    $adminState = $params["adminstate"]; // eg. TX
    $adminStateFull = $params["adminfullstate"]; // eg. Texas
    $adminPostcode = $params["adminpostcode"]; // Postcode/Zip code
    $adminCountry = $params["admincountry"]; // eg. GB
    $adminPhoneNumber = $params["adminphonenumber"]; // Phone number as the user provided it
    $adminPhoneNumberFormatted = $params["adminfullphonenumber"]; // Format: +CC.xxxxxxxxxxxx

    // domain addon purchase status
    $enableDnsManagement = (bool) $params['dnsmanagement'];
    $enableEmailForwarding = (bool) $params['emailforwarding'];
    $enableIdProtection = (bool) $params['idprotection'];

    /**
     * Premium domain parameters.
     *
     * Premium domains enabled informs you if the admin user has enabled
     * the selling of premium domain names. If this domain is a premium name,
     * `premiumCost` will contain the cost price retrieved at the time of
     * the order being placed. The premium order should only be processed
     * if the cost price now matches that previously fetched amount.
     */
    $premiumDomainsEnabled = (bool) $params['premiumEnabled'];
    $premiumDomainsCost = $params['premiumCost'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'eppcode' => $eppCode,
        'nameservers' => array(
            'ns1' => $nameserver1,
            'ns2' => $nameserver2,
            'ns3' => $nameserver3,
            'ns4' => $nameserver4,
            'ns5' => $nameserver5,
        ),
        'years' => $registrationPeriod,
        'contacts' => array(
            'registrant' => array(
                'firstname' => $firstName,
                'lastname' => $lastName,
                'companyname' => $companyName,
                'email' => $email,
                'address1' => $address1,
                'address2' => $address2,
                'city' => $city,
                'state' => $state,
                'zipcode' => $postcode,
                'country' => $countryCode,
                'phonenumber' => $phoneNumberFormatted,
            ),
            'tech' => array(
                'firstname' => $adminFirstName,
                'lastname' => $adminLastName,
                'companyname' => $adminCompanyName,
                'email' => $adminEmail,
                'address1' => $adminAddress1,
                'address2' => $adminAddress2,
                'city' => $adminCity,
                'state' => $adminState,
                'zipcode' => $adminPostcode,
                'country' => $adminCountry,
                'phonenumber' => $adminPhoneNumberFormatted,
            ),
        ),
        'dnsmanagement' => $enableDnsManagement,
        'emailforwarding' => $enableEmailForwarding,
        'idprotection' => $enableIdProtection,
        'action' => 'Transfer',
    );

    try {
        $api = new ApiClient();
        $api->call('Transfer', $postfields);

        return array(
            'success' => true,
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Renew a domain.
 *
 * Attempt to renew/extend a domain for a given number of years.
 *
 * This is triggered when the following events occur:
 * * Payment received for a domain renewal order
 * * When a pending domain renewal order is accepted
 * * Upon manual request by an admin user
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_RenewDomain($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // registration parameters
    $sld = $params['sld'];
    $tld = $params['tld'];
    $registrationPeriod = $params['regperiod'];

    // domain addon purchase status
    $enableDnsManagement = (bool) $params['dnsmanagement'];
    $enableEmailForwarding = (bool) $params['emailforwarding'];
    $enableIdProtection = (bool) $params['idprotection'];

    /**
     * Premium domain parameters.
     *
     * Premium domains enabled informs you if the admin user has enabled
     * the selling of premium domain names. If this domain is a premium name,
     * `premiumCost` will contain the cost price retrieved at the time of
     * the order being placed. A premium renewal should only be processed
     * if the cost price now matches that previously fetched amount.
     */
    $premiumDomainsEnabled = (bool) $params['premiumEnabled'];
    $premiumDomainsCost = $params['premiumCost'];

    // Build post data.
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'years' => $registrationPeriod,
        'dnsmanagement' => $enableDnsManagement,
        'emailforwarding' => $enableEmailForwarding,
        'idprotection' => $enableIdProtection,
        'action' => 'Renew',
    );

    try {
        $api = new ApiClient();
        $api->call('Renew', $postfields);

        return array(
            'success' => true,
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Fetch current nameservers.
 *
 * This function should return an array of nameservers for a given domain.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_GetNameservers($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];
    //$registrationPeriod = $params['regperiod'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'GetNameservers',
    );

    try {
        $api = new ApiClient();
        $api->call('GetNameservers', $postfields);

        return array(
            'success' => true,
            'ns1' => $api->getFromResponse('ns1'),
            'ns2' => $api->getFromResponse('ns2'),
            'ns3' => $api->getFromResponse('ns3'),
            'ns4' => $api->getFromResponse('ns4'),
            'ns5' => $api->getFromResponse('ns5'),
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Save nameserver changes.
 *
 * This function should submit a change of nameservers request to the
 * domain registrar.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_SaveNameservers($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // submitted nameserver values
    $nameserver1 = $params['ns1'];
    $nameserver2 = $params['ns2'];
    $nameserver3 = $params['ns3'];
    $nameserver4 = $params['ns4'];
    $nameserver5 = $params['ns5'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'nameserver1' => $nameserver1,
        'nameserver2' => $nameserver2,
        'nameserver3' => $nameserver3,
        'nameserver4' => $nameserver4,
        'nameserver5' => $nameserver5,
        'action' => 'SetNameservers',
    );

    try {
        $api = new ApiClient();
        $api->call('SetNameservers', $postfields);

        return array(
            'success' => true,
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Get the current WHOIS Contact Information.
 *
 * Should return a multi-level array of the contacts and name/address
 * fields that be modified.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_GetContactDetails($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'GetWhoisInformation',
    );

    try {
        $api = new ApiClient();
        $api->call('GetWhoisInformation', $postfields);

        return array(
            'Registrant' => array(
                'First Name' => explode(" ",$api->getFromResponse("Registrant")['Contact_Name'])[0],
                'Last Name' => explode(" ",$api->getFromResponse("Registrant")['Contact_Name'])[1],
                'Company Name' => $api->getFromResponse("Registrant")['Company_Name'],
                'Email Address' => $api->getFromResponse("Registrant")['Email'],
                'Address 1' => $api->getFromResponse("Registrant")['Address_1'],
                'Address 2' => $api->getFromResponse("Registrant")['Address_2'],
                'City' => $api->getFromResponse("Registrant")['City'],
                'State' => $api->getFromResponse("Registrant")['State'],
                'Postcode' => $api->getFromResponse("Registrant")['ZIP_code'],
                'Country' => $api->getFromResponse("Registrant['Country']"),
                'Phone Number' => $api->getFromResponse("Registrant")['Phone'],
                'Fax Number' => $api->getFromResponse("Registrant")['Fax'],
            ),
            'Technical' => array(
                'First Name' => explode(" ",$api->getFromResponse("Tech")['Contact_Name'])[0],
                'Last Name' => explode(" ",$api->getFromResponse("Tech")['Contact_Name'])[1],
                'Company Name' => $api->getFromResponse("Tech")['Company_Name'],
                'Email Address' => $api->getFromResponse("Tech")['Email'],
                'Address 1' => $api->getFromResponse("Tech")['Address_1'],
                'Address 2' => $api->getFromResponse("Tech")['Address_2'],
                'City' => $api->getFromResponse("Tech")['City'],
                'State' => $api->getFromResponse("Tech")['State'],
                'Postcode' => $api->getFromResponse("Tech")['ZIP_code'],
                'Country' => $api->getFromResponse("Tech")['Country'],
                'Phone Number' => $api->getFromResponse("Tech")['Phone'],
                'Fax Number' => $api->getFromResponse("Tech")['Fax'],
            ),
            'Billing' => array(
                'First Name' => explode(" ",$api->getFromResponse("Billing")['Contact_Name'])[0],
                'Last Name' => explode(" ",$api->getFromResponse("Billing")['Contact_Name'])[1],
                'Company Name' => $api->getFromResponse("Billing")['Company_Name'],
                'Email Address' => $api->getFromResponse("Billing")['Email'],
                'Address 1' => $api->getFromResponse("Billing")['Address_1'],
                'Address 2' => $api->getFromResponse("Billing")['Address_2'],
                'City' => $api->getFromResponse("Billing")['City'],
                'State' => $api->getFromResponse("Billing")['State'],
                'Postcode' => $api->getFromResponse("Billing")['ZIP_code'],
                'Country' => $api->getFromResponse("Billing")['Country'],
                'Phone Number' => $api->getFromResponse("Billing")['Phone'],
                'Fax Number' => $api->getFromResponse("Billing")['Fax'],
            ),
            'Admin' => array(
                'First Name' => explode(" ",$api->getFromResponse("Admin")['Contact_Name'])[0],
                'Last Name' => explode(" ",$api->getFromResponse("Admin")['Contact_Name'])[1],
                'Company Name' => $api->getFromResponse("Admin")['Company_Name'],
                'Email Address' => $api->getFromResponse("Admin")['Email'],
                'Address 1' => $api->getFromResponse("Admin")['Address_1'],
                'Address 2' => $api->getFromResponse("Admin")['Address_2'],
                'City' => $api->getFromResponse("Admin")['City'],
                'State' => $api->getFromResponse("Admin")['State'],
                'Postcode' => $api->getFromResponse("Admin")['ZIP_code'],
                'Country' => $api->getFromResponse("Admin")['Country'],
                'Phone Number' => $api->getFromResponse("Admin")['Phone'],
                'Fax Number' => $api->getFromResponse("Admin")['Fax'],
            ),
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Update the WHOIS Contact Information for a given domain.
 *
 * Called when a change of WHOIS Information is requested within WHMCS.
 * Receives an array matching the format provided via the `GetContactDetails`
 * method with the values from the users input.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_SaveContactDetails($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // whois information
    $contactDetails = $params['contactdetails'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'contacts' => array(
            'registrant' => array(
                'firstname' => $contactDetails['Registrant']['First Name'],
                'lastname' => $contactDetails['Registrant']['Last Name'],
                'company' => $contactDetails['Registrant']['Company Name'],
                'email' => $contactDetails['Registrant']['Email Address'],
                'address1' => $contactDetails['Registrant']['Address 1'],
                'address2' => $contactDetails['Registrant']['Address 2'],
                'city' => $contactDetails['Registrant']['City'],
                'state' => $contactDetails['Registrant']['State'],
                'zip' => $contactDetails['Registrant']['ZIP code'],
                'country' => $contactDetails['Registrant']['Country'],
                'phone' => $contactDetails['Registrant']['Phone'],
                // etc...
            ),
            'tech' => array(
                'firstname' => $contactDetails['Technical']['First Name'],
                'lastname' => $contactDetails['Technical']['Last Name'],
                'company' => $contactDetails['Technical']['Company Name'],
                'email' => $contactDetails['Technical']['Email Address'],
                'address1' => $contactDetails['Technical']['Address 1'],
                'address2' => $contactDetails['Technical']['Address 2'],
                'city' => $contactDetails['Technical']['City'],
                'state' => $contactDetails['Technical']['State'],
                'zip' => $contactDetails['Technical']['ZIP code'],
                'country' => $contactDetails['Technical']['Country'],
                'phone' => $contactDetails['Technical']['Phone'],
                // etc...
            ),
            'billing' => array(
                'firstname' => $contactDetails['Billing']['First Name'],
                'lastname' => $contactDetails['Billing']['Last Name'],
                'company' => $contactDetails['Billing']['Company Name'],
                'email' => $contactDetails['Billing']['Email Address'],
                'address1' => $contactDetails['Billing']['Address 1'],
                'address2' => $contactDetails['Billing']['Address 2'],
                'city' => $contactDetails['Billing']['City'],
                'state' => $contactDetails['Billing']['State'],
                'zip' => $contactDetails['Billing']['ZIP code'],
                'country' => $contactDetails['Billing']['Country'],
                'phone' => $contactDetails['Billing']['Phone'],
                // etc...
            ),
            'admin' => array(
                'firstname' => $contactDetails['Admin']['First Name'],
                'lastname' => $contactDetails['Admin']['Last Name'],
                'company' => $contactDetails['Admin']['Company Name'],
                'email' => $contactDetails['Admin']['Email Address'],
                'address1' => $contactDetails['Admin']['Address 1'],
                'address2' => $contactDetails['Admin']['Address 2'],
                'city' => $contactDetails['Admin']['City'],
                'state' => $contactDetails['Admin']['State'],
                'zip' => $contactDetails['Admin']['ZIP code'],
                'country' => $contactDetails['Admin']['Country'],
                'phone' => $contactDetails['Admin']['Phone'],
                // etc...
            ),
        ),
        'action' => 'UpdateWhoisInformation',
    );

    try {
        $api = new ApiClient();
        $api->call('UpdateWhoisInformation', $postfields);

        return array(
            'success' => true,
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Check Domain Availability.
 *
 * Determine if a domain or group of domains are available for
 * registration or transfer.
 *
 * @param array $params common module parameters
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @see \WHMCS\Domains\DomainLookup\SearchResult
 * @see \WHMCS\Domains\DomainLookup\ResultsList
 *
 * @throws Exception Upon domain availability check failure.
 *
 * @return \WHMCS\Domains\DomainLookup\ResultsList An ArrayObject based collection of \WHMCS\Domains\DomainLookup\SearchResult results
 */
/*function upperlinkregistrar_CheckAvailability($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // availability check parameters
    $searchTerm = $params['searchTerm'];
    $punyCodeSearchTerm = $params['punyCodeSearchTerm'];
    $tldsToInclude = $params['tldsToInclude'];
    $isIdnDomain = (bool) $params['isIdnDomain'];
    $premiumEnabled = (bool) $params['premiumEnabled'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'searchTerm' => $searchTerm,
        'tldsToSearch' => $tldsToInclude,
        'includePremiumDomains' => $premiumEnabled,
        'action' => 'CheckAvailability',
    );

    try {
        $api = new ApiClient();
        $api->call('CheckAvailability', $postfields);

        $results = new ResultsList();
        foreach ($api->getFromResponse('domains') as $domain) {

            // Instantiate a new domain search result object
            $searchResult = new SearchResult($domain['sld'], $domain['tld']);

            // Determine the appropriate status to return
            if ($domain['status'] == 'available') {
                $status = SearchResult::STATUS_NOT_REGISTERED;
            } elseif ($domain['statis'] == 'registered') {
                $status = SearchResult::STATUS_REGISTERED;
            } elseif ($domain['statis'] == 'reserved') {
                $status = SearchResult::STATUS_RESERVED;
            } else {
                $status = SearchResult::STATUS_TLD_NOT_SUPPORTED;
            }
            $searchResult->setStatus($status);

            // Return premium information if applicable
            if ($domain['isPremiumName']) {
                $searchResult->setPremiumDomain(true);
                $searchResult->setPremiumCostPricing(
                    array(
                        'register' => $domain['premiumRegistrationPrice'],
                        'renew' => $domain['premiumRenewPrice'],
                        'CurrencyCode' => 'NGN',
                    )
                );
            }

            // Append to the search results list
            $results->append($searchResult);
        }

        return $results;

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}*/

/**
 * Domain Suggestion Settings.
 *
 * Defines the settings relating to domain suggestions (optional).
 * It follows the same convention as `getConfigArray`.
 *
 * @see http://developers.whmcs.com/domain-registrars/check-availability/
 *
 * @return array of Configuration Options
 */
/*function upperlinkregistrar_DomainSuggestionOptions() {
    return array(
        'includeCCTlds' => array(
            'FriendlyName' => 'Include Country Level TLDs',
            'Type' => 'yesno',
            'Description' => 'Tick to enable',
        ),
    );
}*/

/**
 * Get Domain Suggestions.
 *
 * Provide domain suggestions based on the domain lookup term provided.
 *
 * @param array $params common module parameters
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @see \WHMCS\Domains\DomainLookup\SearchResult
 * @see \WHMCS\Domains\DomainLookup\ResultsList
 *
 * @throws Exception Upon domain suggestions check failure.
 *
 * @return \WHMCS\Domains\DomainLookup\ResultsList An ArrayObject based collection of \WHMCS\Domains\DomainLookup\SearchResult results
 */
/*function upperlinkregistrar_GetDomainSuggestions($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // availability check parameters
    $searchTerm = $params['searchTerm'];
    $punyCodeSearchTerm = $params['punyCodeSearchTerm'];
    $tldsToInclude = $params['tldsToInclude'];
    $isIdnDomain = (bool) $params['isIdnDomain'];
    $premiumEnabled = (bool) $params['premiumEnabled'];
    $suggestionSettings = $params['suggestionSettings'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'searchTerm' => $searchTerm,
        'tldsToSearch' => $tldsToInclude,
        'includePremiumDomains' => $premiumEnabled,
        'includeCCTlds' => $suggestionSettings['includeCCTlds'],
        'action' => 'GetSuggestions',
    );

    try {
        $api = new ApiClient();
        $api->call('GetSuggestions', $postfields);

        $results = new ResultsList();
        foreach ($api->getFromResponse('domains') as $domain) {

            // Instantiate a new domain search result object
            $searchResult = new SearchResult($domain['sld'], $domain['tld']);

            // All domain suggestions should be available to register
            $searchResult->setStatus(SearchResult::STATUS_NOT_REGISTERED);

            // Used to weight results by relevance
            $searchResult->setScore($domain['score']);

            // Return premium information if applicable
            if ($domain['isPremiumName']) {
                $searchResult->setPremiumDomain(true);
                $searchResult->setPremiumCostPricing(
                    array(
                        'register' => $domain['premiumRegistrationPrice'],
                        'renew' => $domain['premiumRenewPrice'],
                        'CurrencyCode' => 'NGN',
                    )
                );
            }

            // Append to the search results list
            $results->append($searchResult);
        }

        return $results;

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}*/

/**
 * Get registrar lock status.
 *
 * Also known as Domain Lock or Transfer Lock status.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return string|array Lock status or error message
 */
function upperlinkregistrar_GetRegistrarLock($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'GetLockStatus',
    );

    try {
        $api = new ApiClient();
        $api->call('GetLockStatus', $postfields);

        if ($api->getFromResponse('lockstatus') == 'locked') {
            return 'locked';
        } else {
            return 'unlocked';
        }

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Set registrar lock status.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_SaveRegistrarLock($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // lock status
    $lockStatus = $params['lockenabled'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'registrarlock' => ($lockStatus == 'locked') ? 1 : 0,
        'action' => 'SetLockStatus',
    );

    try {
        $api = new ApiClient();
        $api->call('SetLockStatus', $postfields);

        return array(
            'success' => 'success',
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Get DNS Records for DNS Host Record Management.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array DNS Host Records
 */
/*function upperlinkregistrar_GetDNS($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'GetDNSHostRecords',

    );

    try {
        $api = new ApiClient();
        $api->call('GetDNSHostRecords', $postfields);

        $hostRecords = array();
        foreach ($api->getFromResponse('records') as $record) {
            $hostRecords[] = array(
                "hostname" => $record['name'], // eg. www
                "type" => $record['type'], // eg. A
                "address" => $record['address'], // eg. 10.0.0.1
                "priority" => $record['mxpref'], // eg. 10 (N/A for non-MX records)
            );
        }
        return $hostRecords;

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}*/

/**
 * Update DNS Host Records.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
/*function upperlinkregistrar_SaveDNS($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // dns record parameters
    $dnsrecords = $params['dnsrecords'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'records' => $dnsrecords,
        'action' => 'GetDNSHostRecords',
    );

    try {
        $api = new ApiClient();
        $api->call('GetDNSHostRecords', $postfields);

        return array(
            'success' => 'success',
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}*/

/**
 * Enable/Disable ID Protection.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_IDProtectToggle($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // id protection parameter
    $protectEnable = (bool) $params['protectenable'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'GetDNSHostRecords',
    );
    if ($protectEnable) {
        $postfields['action'] = 'EnableIDProtection';
    } else {
        $postfields['action'] = 'DisableIDProtection';
    }

    try {
        $api = new ApiClient();

        if ($protectEnable) {
            $api->call('EnableIDProtection', $postfields);
        } else {
            $api->call('DisableIDProtection', $postfields);
        }

        return array(
            'success' => 'success',
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Request EEP Code.
 *
 * Supports both displaying the EPP Code directly to a user or indicating
 * that the EPP Code will be emailed to the registrant.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 *
 */
function upperlinkregistrar_GetEPPCode($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'RequestEPPCode',
    );

    try {
        $api = new ApiClient();
        $api->call('RequestEPPCode', $postfields);

        if ($api->getFromResponse('eppcode')) {
            // If EPP Code is returned, return it for display to the end user
            return array(
                'eppcode' => $api->getFromResponse('eppcode'),
            );
        } else {
            // If EPP Code is not returned, it was sent by email, return success
            return array(
                'success' => 'success',
            );
        }

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Release a Domain.
 *
 * Used to initiate a transfer out such as an IPSTAG change for .UK
 * domain names.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_ReleaseDomain($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // transfer tag
    $transferTag = $params['transfertag'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'newtag' => $transferTag,
        'action' => 'ReleaseDomain',
    );

    try {
        $api = new ApiClient();
        $api->call('ReleaseDomain', $postfields);

        return array(
            'success' => 'success',
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Delete Domain.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_RequestDelete($params)
{
    // user defined configuration values
    $userIdentifier = $params['API Username'];
    $apiKey = $params['API Key'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'DeleteDomain',
    );

    try {
        $api = new ApiClient();
        $api->call('DeleteDomain', $postfields);

        return array(
            'success' => 'success',
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Sync Domain Status & Expiration Date.
 *
 * Domain syncing is intended to ensure domain status and expiry date
 * changes made directly at the domain registrar are synced to WHMCS.
 * It is called periodically for a domain.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_Sync($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'GetDomainInfo',
    );

    try {
        $api = new ApiClient();
        $api->call('GetDomainInfo', $postfields);

        return array(
            'expirydate' => $api->getFromResponse('expirydate'), // Format: YYYY-MM-DD
            'active' => (bool) $api->getFromResponse('active'), // Return true if the domain is active
            'expired' => (bool) $api->getFromResponse('expired'), // Return true if the domain has expired
            'transferredAway' => (bool) $api->getFromResponse('transferredaway'), // Return true if the domain is transferred out
        );

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}

/**
 * Incoming Domain Transfer Sync.
 *
 * Check status of incoming domain transfers and notify end-user upon
 * completion. This function is called daily for incoming domains.
 *
 * @param array $params common module parameters
 *
 * @see http://developers.whmcs.com/domain-registrars/module-parameters/
 *
 * @return array
 */
function upperlinkregistrar_TransferSync($params)
{
    // user defined configuration values
    $userIdentifier = $params['ResellerID'];
    $apiKey = $params['ResellerAccessKey'];
    $testMode = $params['Test Mode'];

    // domain parameters
    $sld = $params['sld'];
    $tld = $params['tld'];

    // Build post data
    $postfields = array(
        'username' => $userIdentifier,
        'password' => $apiKey,
        'testmode' => $testMode,
        'domain' => $sld . '.' . $tld,
        'action' => 'CheckDomainTransfer',
    );

    try {
        $api = new ApiClient();
        $api->call('CheckDomainTransfer', $postfields);

        if ($api->getFromResponse('transfercomplete')) {
            return array(
                'completed' => true,
                'expirydate' => $api->getFromResponse('expirydate'), // Format: YYYY-MM-DD
            );
        } elseif ($api->getFromResponse('transferfailed')) {
            return array(
                'failed' => true,
                'reason' => $api->getFromResponse('failurereason'), // Reason for the transfer failure if available
            );
        } else {
            // No status change, return empty array
            return array();
        }

    } catch (\Exception $e) {
        return array(
            'error' => $e->getMessage(),
        );
    }
}


/**
use Illuminate\Database\Capsule\Manager as Capsule;
require_once __DIR__ . '/../../init.php';


function getserverdetails($server_ip){
    if(!Capsule::schema()->hasTable('tblservers')) {
        $server = Capsule::table('tblservers')->where('ipaddress', $server_ip)->first();
    }
    $server_details['ipaddress'] = $server['ipaddress'];
    $server_details['ns1'] = $server['nameserver1'];
    $server_details['hostname'] = $server['hostname'];
    $server_details['username'] = $server['username'];
    $server_details['accesshash'] = $server['accesshash'];
    return $server_details;
}
*/