<?php
//phpinfo();
/**
 * Upperlink Interswitch WebPay Payment Gateway Module 
 *
 * Payment Gateway modules allow you to integrate payment solutions with the
 * WHMCS platform.
 *
 * This sample file demonstrates how a payment gateway module for WHMCS should
 * be structured and all supported functionality it can contain.
 *
 * Within the module itself, all functions must be prefixed with the module
 * filename, followed by an underscore, and then the function name. For this
 * example file, the filename is "gatewaymodule" and therefore all functions
 * begin "gatewaymodule_".
 *
 * If your module or third party API does not support a given function, you
 * should not define that function within your module. Only the _config
 * function is required.
 *
 * For more information, please refer to the online documentation.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Developer_Docs
 *
 * @copyright Copyright (c) WHMCS Limited 2015
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */

use Illuminate\Database\Capsule\Manager as Capsule;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Define module related meta data.
 *
 * Values returned here are used to determine module related capabilities and
 * settings.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Meta_Data_Parameters
 *
 * @return array
 */
function interswitchwebpaynew_MetaData()
{
    return array(
        'DisplayName' => 'Interswitch WebPay Gateway Module',
        'APIVersion' => '1.0', // Use API Version 1.1
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

/**
 * Define gateway configuration options.
 *
 * The fields you define here determine the configuration options that are
 * presented to administrator users when activating and configuring your
 * payment gateway module for use.
 *
 * Supported field types include:
 * * text
 * * password
 * * yesno
 * * dropdown
 * * radio
 * * textarea
 *
 * Examples of each field type and their possible configuration parameters are
 * provided in the sample function below.
 *
 * @return array
 */
function interswitchwebpaynew_config()
{
    return array(
        // the friendly display name for a payment gateway should be
        // defined here for backwards compatibility
        'FriendlyName' => array(
            'Type' => 'System',
            'Value' => 'Interswitch WebPay New',
        ),
        /*
        // a text field type allows for single line text input
        'merchantID' => array(
            'FriendlyName' => 'Merchant ID',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Enter your merchant ID here',
        ),
        // a text field type allows for single line text input
        'cadPID' => array(
            'FriendlyName' => 'CADPID',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '',
            'Description' => 'Enter your CADPID here',
        ),
        // a text field type allows for single line text input
        'tranType' => array(
            'FriendlyName' => 'TRANTYPE',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '00',
            'Description' => 'Enter your TRANTYPE here',
        ),*/
        // a text field type allows for single line text input
        'productID' => array(
            'FriendlyName' => 'PRODUCT ID',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '1076',
            'Description' => 'Enter your PRODUCT ID here',
        ),
        // a text field type allows for single line text input
        'payItemID' => array(
            'FriendlyName' => 'PAY ITEM ID',
            'Type' => 'text',
            'Size' => '25',
            'Default' => '101',
            'Description' => 'Enter your PAY ITEM ID here',
        ),
        // a text field type allows for single line text input
        'hashKey' => array(
            'FriendlyName' => 'HASH KEY',
            'Type' => 'text',
            'Size' => '255',
            'Default' => '101',
            'Description' => 'Enter your PAY ITEM ID here',
        ),
        // a text field type allows for single line text input
        'redirectUrl' => array(
            'FriendlyName' => 'REDIRECT URL',
            'Type' => 'text',
            'Size' => '256',
            'Default' => 'https://domains.upperlink.ng/clients/modules/gateways/callback/interswitchwebpaynew.php',
            'Description' => 'Enter your REDIRECT URL here',
        ),
        // the yesno field type displays a single checkbox option
        'testMode' => array(
            'FriendlyName' => 'Test Mode',
            'Type' => 'yesno',
            'Description' => 'Tick to enable test mode',
        ),
    );
}

/**
 * Payment link.
 *
 * Required by third party payment gateway modules only.
 *
 * Defines the HTML output displayed on an invoice. Typically consists of an
 * HTML form that will take the user to the payment gateway endpoint.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see http://docs.whmcs.com/Payment_Gateway_Module_Parameters
 *
 * @return string
 */
function interswitchwebpaynew_link($params)
{
    // Gateway Configuration Parameters
    $merchantId = $params['merchantID'];
    //$cadPid = $params['cadPID'];
    //$tranType = $params['tranType'];
    $productID = $params['productID'];
    $payItemID = $params['payItemID'];
    $redirectUrl = $params['redirectUrl'];
    $hash_key = $params['hashKey'];
    $testMode = $params['testMode'];
    $url = 'https://webpay.interswitchng.com/collections/w/pay';
    $demoUrl = 'https://sandbox.interswitchng.com/collections/w/pay';
    
   

    /** Log this transaction */
    // Check if the tbltransactions table exists
    if(!Capsule::schema()->hasTable('tbltransactions')) {
       try {
            Capsule::schema()->create(
                'tbltransactions',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->integer('client_id')->unsigned();
                    $table->string('invoice_id', 50);
                    $table->string('transaction_ref', 50);
                    $table->string('response_code', 10)->nullable();
                    $table->string('response_description', 10)->nullable();
                    $table->string('first_data_response_description')->nullable();
                    $table->decimal('transaction_rate', 10, 5)->unsigned();
                    $table->string('transaction_description')->nullable();
                    $table->string('transaction_currency', 50);
                    $table->decimal('transaction_amount', 20, 5)->unsigned();
                    $table->string('first_data_transaction_tag', 50)->nullable();
                    $table->enum('transaction_status', ['pending', 'paid', 'failed'])->default("pending");
                    $table->string('payment_method', 50);
                    $table->string('whmcs_version', 10);
                    $table->timestamps();
                }
            );
        } catch (\Exception $e) {
            echo "Unable to create transactions table, please contact the administrator: {$e->getMessage()}";
        }
    }
    
    

    // Invoice Parameters
    $amount_multiplier = 100;
    $invoiceId = $params['invoiceid'];
    $description = $params["description"];
    $amount = $params['amount'] * $amount_multiplier;
    $db_amount = $params['amount'];
    $currencyCode = $params['currency'];
    $transaction_ref = "WHM" . interswitchWebPayNewGenerateTransactionNumber();

    // System Parameters
    $moduleName = $params['paymentmethod'];
    $whmcsVersion = $params['whmcsVersion'];

    //log the transaction in the database 
    try {
       $id = Capsule::table('tbltransactions')->insert([ "client_id" => $params['clientdetails']['userid'],
                                                         "invoice_id" => $invoiceId,
                                                         "transaction_ref" => $transaction_ref,
                                                         "transaction_description" => $description,
                                                         "transaction_currency" => $currencyCode,
                                                         "transaction_amount" => $db_amount,
                                                         "payment_method" => $moduleName,
                                                         "whmcs_version" => $whmcsVersion,
                                                         "created_at" => date('Y-m-d H:i:s'),
                                                         "updated_at" => date('Y-m-d H:i:s')
                                                      ]);
    }
    catch(\Exception $e) {
        echo "Unable to log transaction details, please try again: {$e->getMessage()}";
    }

    //log parameters
    try {
        file_put_contents('./debug/whmcs-error-trace.txt', 'Interswitch New Form Parameters: ' . json_encode($params) . "\n", FILE_APPEND);
    }
    catch(Exception $e) {
        echo "Unable to log form parameters";
    }

    $postfields = array();
    //$postfields['CADPID'] = $cadPid;
    //$postfields['MERTID'] = $merchantId;
    //$postfields['TXNREF'] = $transaction_ref;
    //$postfields['AMT'] = $amount;
    $postfields['currency'] = '566';
    $postfields['site_redirect_url'] = $redirectUrl;
    $postfields['site_name'] = 'https://domains.upperlink.ng';
    $postfields['txn_ref'] = $transaction_ref;
    $postfields['cust_name'] = $params['clientdetails']['firstname'];
    $postfields['cust_id'] = $params['clientdetails']['userid'];
    $postfields['cust_name_desc'] = $params['clientdetails']['firstname']." ".$params['clientdetails']['lastname'];
    $meth = 'get';
    //$postfields['TRANTYPE'] = $tranType;
    if($testMode == 'on'){
    	//$postfields = array();
    	$url = $demoUrl;
    	$meth = 'post';
    	$postfields['product_id'] = '1076';
    	$postfields['amount'] = $amount;
    	$postfields['pay_item_id'] = '101';
    	$hash_key = 'D3D1D05AFE42AD50818167EAC73C109168A0F108F32645C8B59E897FA930DA44F9230910DAC9E20641823799A107A02068F7BC0F4CC41D2952E249552255710F';
    }else{
        $url = $url;
    	$meth = 'post';
    	$postfields['product_id'] = $productID;
    	$postfields['amount'] = $amount;
    	$postfields['pay_item_id'] = $payItemID;
    	$hash_key = "E242A70C109012E6C5EC988EA32845DA195A5F616105E8016F99BB04C79704A6E3021987AC1872827AD6E58AB3EC9F9E8BE315E8FF0A94D13280576F992532E3";
    }
    
	$hash_v = $postfields['txn_ref'].$postfields['product_id'].$postfields['pay_item_id'].$postfields['amount'].$postfields['site_redirect_url'].$hash_key;
    	$postfields['hash'] = hash('sha512',$hash_v);
    $langPayNow = "Pay with WebPay";

    $htmlOutput = '<form method="'.$meth.'" action="' . $url . '">';
    $htmlOutput .= '<input type="hidden" name="hash_v" value="' .$hash_v. '" />';
    foreach ($postfields as $k => $v) {
        $htmlOutput .= '<input type="hidden" name="' . $k . '" value="' .$v. '" />';
    }
    $htmlOutput .= '<input class="btn btn-danger btn-block" type="submit" value="' . $langPayNow . '" />';
    $htmlOutput .= '</form>';
    file_put_contents('./debug/whmcs-error-trace.txt', 'Interswitch New Form Details: ' .  $htmlOutput . "\n", FILE_APPEND);
    return $htmlOutput;
}

/**
 * Generate Transaction
 *
 * @return string
 * @param int $randStringLength
 * 
 */
function interswitchWebPayNewGenerateTransactionNumber($randStringLength = 12) {
    $timestring = microtime();
    $secondsSinceEpoch=(integer) substr($timestring, strrpos($timestring, " "), 100);
    $microseconds=(double) $timestring;
    $seed = mt_rand(0,1000000000) + 10000000 * $microseconds + $secondsSinceEpoch;
    mt_srand($seed);
    $randstring = "";

    for($i=0; $i < $randStringLength; $i++){
    $randstring .= mt_rand(0, 9);
    }
    
    //return code
    return (string) $randstring;
}
