<?php
/**
 * Created by PhpStorm.
 * User: Babatunde Daniel
 * Date: 19/10/2017
 * Time: 10:01 AM
 */
set_time_limit(3600);
use WHMCS\Database\Capsule;

function consolidateinvoices_config() {
    $configarray = array(
        "name" => "Consolidate Invoices",
        "description" => "This module adjust the expiry dates of domain and hosting to same dates so the can be invoiced together",
        "version" => "1.0",
        "author" => "Babatude Daniel"
    );
    return $configarray;
}

function consolidateinvoices_activate() {

    # Create Custom DB Table
    //$query = "CREATE TABLE `mod_consolidateinvoices` (`id` INT( 10 ) NOT NULL AUTO_INCREMENT ... ";
    $query = "CREATE TABLE `mod_consolidateinvoices` (
                    `id` INT NOT NULL AUTO_INCREMENT,
                    `domain` VARCHAR(255) NOT NULL,
                    `created_at` DATETIME NOT NULL,
                    `updated_at` DATETIME NOT NULL
                )
                COLLATE='latin1_swedish_ci'
                ENGINE=InnoDB;";
    $result = full_query($query);

    # Return Result
    return array('status'=>'success','description'=>'This is an demo module only. In a real
           module you might instruct a user how to get started with it here...');
    return array('status'=>'error','description'=>'You can use the error status return to
           indicate there was a problem activating the module');
    return array('status'=>'info','description'=>'You can use the info status return to display
           a message to the user');

}

function consolidateinvoices_deactivate() {

    # Remove Custom DB Table
    $query = "DROP TABLE `mod_consolidateinvoices`";
    $result = full_query($query);

    # Return Result
    return array('status'=>'success','description'=>'If successful, you can return a message
           to show the user here');
    return array('status'=>'error','description'=>'If an error occurs you can return an error
           message for display here');
    return array('status'=>'info','description'=>'If you want to give an info message to a user
           you can return it here');

}

function consolidateinvoices_clientarea($vars) {

    $modulelink = $vars['modulelink'];
    $version = $vars['version'];
    $clientid = $_SESSION['uid'];
    //dd($vars);
    /*$option1 = $vars['option1'];
    $option2 = $vars['option2'];
    $option3 = $vars['option3'];
    $option4 = $vars['option4'];
    $option5 = $vars['option5'];
    $option6 = $vars['option6'];*/
    $LANG = $vars['_lang'];

    $invoices = Capsule::table('tbldomains')->distinct()->join('tblhosting','tbldomains.domain','=','tblhosting.domain')
        ->where('tbldomains.userid','=',$clientid)
        ->get();
    return array(
        'pagetitle' => 'Consolidate Invoices',
        'breadcrumb' => array('index.php?m=consolidateinvoices'=>'Consoldiate Invoices'),
        'templatefile' => 'consolidateinvoices',
        'requirelogin' => true, # accepts true/false
        'forcessl' => false, # accepts true/false
        'vars' => array(
            'invoices' => $invoices,
        ),
    );

}