{**********************************************************************
* MGMF product developed. (2016-02-09)
* *
*
*  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
*  CONTACT                        ->       contact@modulesgarden.com
*
*
* This software is furnished under a license and may be used and copied
* only  in  accordance  with  the  terms  of such  license and with the
* inclusion of the above copyright notice.  This software  or any other
* copies thereof may not be provided or otherwise made available to any
* other person.  No title to and  ownership of the  software is  hereby
* transferred.
*
*
**********************************************************************}

{**
* @author Paweł Kopeć <pawelk@modulesgarden.com>
*}

<div class="module-main-header">
    <h3 style="line-height: 36px;">{$MGLANG->T('Domain')} -  {$domain.domain}</h3>
</div>
<div class="module-body" id="mg-forwards-content">
    <div class="section">
        {if $nameserversToSet}
            <div class="alert alert-danger">
                <strong>{$MGLANG->absoluteT('forwarddomains', 'wrong_nameservers')}</strong>
                <ul style="margin-left: 20px;">
                    {foreach $nameserversToSet as $nameserver}
                        <li>{$nameserver}</li>
                        {/foreach}
                </ul>
            </div>
        {else}

            {if $features['emailForward']['single']}
                <div class="module-header">
                    <i class="icon-header icon-emailsforwarders"></i>
                    <h1>{$MGLANG->T('Email Forwarders')}</h1>
                    <p>{$MGLANG->T('descriptionSingle')}</p>
                </div>
                <h4>{$MGLANG->T('Add Email Forwarder')}</h4>

                <div class="well">
                    <form class="form-horizontal" id="mg-email-single-forward-form">
                        <input type="hidden" name="id" value="{$domain.id}">
                        <div class="form-group">
                            <label class="control-label col-md-3">{$MGLANG->T('Address To Forward:')}</label>
                            <div class="col-md-9">
                                <div class="input-group">
                                    <input class="form-control first" type="text" name="forward[source_email]" pattern="^[a-z0-9_\+-]+(\.[a-z0-9_\+-]+)*$" data-error="" required>
                                    <span class="input-group-addon">@</span>
                                    <input class="form-control first" type="text" name="forward[domain]" data-no-validate value="{$domain.domain}"  readonly="">
                                    {*                            <select class="form-control last" name="domain" data-no-validate>
                                    {if $domainlist|@count > 0}
                                    {section name=s loop=$domainlist}  
                                    <option value="{$domainlist[s]->domain}">{$domainlist[s]->domain}</option>
                                    {/section}
                                    {else}
                                    <option value="{$domain}">{$domain}</option>
                                    {/if}
                                    </select>*}
                                </div>
                            </div>
                            <div class="col-md-9 col-md-offset-3">
                                <div class="help-block with-errors"></div>
                            </div>
                        </div>        

                        <div class="form-group">
                            <label class="control-label col-sm-3">{$MGLANG->T('Destination:')}</label>
                            <div class="col-sm-9">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <input class="form-control" type="text" {literal}pattern="^[a-z0-9_\+-]+(\.[a-z0-9_\+-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*\.([a-z]{2,4})$"{/literal} name="forward[dest_email]" required="">
                                    </div>
                                    <div class="col-sm-6">

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-9 col-md-offset-3">
                                <div class="help-block with-errors"></div>
                            </div>   
                        </div>

                        <div class="form-actions">
                            <button type="submit" class="btn btn-inverse btn-success"> {$MGLANG->T('Add')}</button>
                        </div>
                    </form>
                </div>
                <div class="table-header">
                    <div class="header-title">
                        <h4>{$MGLANG->T('Email Forwarders')}</h4>
                    </div>
                    <div class="header-actions">
                        <div class="header-search">
                            <div class="input-icon">
                                <i class="fa fa-search"></i>
                                <input class="form-control" type="text" placeholder="{$MGLANG->absoluteT('forwarddomains', 'search_placeholder')}" id="mg-input-datatable-single-search">
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table" id="email-forwarders-single-table">
                    <thead>
                        <tr>
                            <th>{$MGLANG->T('Email')}</th>
                            <th>{$MGLANG->T('Forward To')}</th>
                            <th style="width:60px">{$MGLANG->absoluteT('forward', 'modify_forward_tblhead_actions')}{$lang.modify_forward_tblhead_actions}</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
                <br />
            {/if}
            {if $features['emailForward']['domain']}    
                <div class="module-header">
                    <i class="icon-header icon-emailsforwarders"></i>
                    <h1>{$MGLANG->T('Email Domain Forwarders')}</h1>
                    <p>{$MGLANG->T('descriptionDomain')}</p>
                </div>
                <div class="alert alert-warning">
                    {$MGLANG->T('warning')} 
                </div>
                <h4>{$MGLANG->T('Add Email Domain Forwarder')}</h4>

                <div class="well">
                    <form class="form-horizontal" id="mg-email-forward-form">
                        <input type="hidden" name="id" value="{$domain.id}">
                        <div class="form-group">
                            <label class="control-label col-md-3">{$MGLANG->T('Domain To Forward:')}</label>
                            <div class="col-md-9">
                                <div class="input-group">
                                    <input class="form-control first" type="text" name="forward[domain]" data-no-validate value="{$domain.domain}"  readonly="">
                                    <span class="input-group-addon">{$MGLANG->T('to')}</span>
                                    <input name="forward[destdomain]" type="text" class="form-control last" required pattern={literal}"^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}$"{/literal} data-error="" >
                                </div>
                                <div class="col-md-9 col-md-offset-3">
                                    <div class="help-block with-errors"></div>
                                </div>                           
                            </div>
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="btn btn-inverse btn-success"> {$MGLANG->T('Add')}</button>
                        </div>
                    </form>
                </div>
                <div class="table-header">
                    <div class="header-title">
                        <h4>{$MGLANG->T('Email Domain Forwarders')}</h4>
                    </div>
                    <div class="header-actions">
                        <div class="header-search">
                            <div class="input-icon">
                                <i class="fa fa-search"></i>
                                <input class="form-control" type="text" placeholder="{$MGLANG->absoluteT('forwarddomains', 'search_placeholder')}" id="mg-input-datatable-search">
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table" id="domain-forwarders-table">
                    <thead>
                        <tr>
                            <th>{$MGLANG->T('Domain')}</th>
                            <th>{$MGLANG->T('Forward To')}</th>
                            <th style="width:60px">{$MGLANG->absoluteT('forward', 'modify_forward_tblhead_actions')}{$lang.modify_forward_tblhead_actions}</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            {/if}
        </div>
    {/if}
    {*Modal mg-modal-forward-delete *}
    <form id="mg-form-forward-delete">
        <div class="modal fade bs-example-modal-lg" id="mg-modal-forward-delete"  tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                        <h4 class="modal-title">{$MGLANG->T('Delete Confirmation')} <strong data-modal-var="tlds"></strong></h4>
                    </div>

                    <div class="modal-body">
                        <input type="hidden" name="id"  value="{$domain.id}">
                        <input type="hidden" name="forward[dest]" id="mg-modal-forward-delete-dest"  value="">
                        <input type="hidden" name="forward[sourceurl]"  id="mg-modal-forward-delete-sourceurl"  value="">

                        <div class="modal-alerts">
                            <div style="display:none;" data-prototype="error">
                                <div class="note note-danger">
                                    <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                    <strong></strong>
                                    <a style="display:none;" class="errorID" href=""></a>
                                </div>
                            </div>
                            <div style="display:none;" data-prototype="success">
                                <div class="note note-success">
                                    <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"></span></button>
                                    <strong></strong>
                                </div>
                            </div>
                        </div>
                        <div style="margin: 30px; text-align: center;">
                            <div>{$MGLANG->T('Are you sure that you want to remove this forwarder?')} </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-inverse btn-default" data-dismiss="modal">{$MGLANG->T('modal','close')}</button>
                        <button type="button" class="btn btn-inverse btn-danger" id="mg-modal-button-delete">{$MGLANG->T('modal','confirm')}</button>
                    </div>
                </div>
            </div>
        </div>
    </form>  
</div>

{literal}
    <script>
        jQuery(document).ready(function () {
            var mgDataTable;

            mgDataTable = $('#domain-forwarders-table').dataTable({
                processing: false,
                searching: true,
                autoWidth: false,
                "serverSide": false,
                "order": [[0, "desc"]],
                ajax: function (data, callback, settings) {

                    JSONParser.request(
                            'list'
                            , {
                                id: "{/literal}{$domain.id}{literal}"
                                , limit: data.length
                                , offset: data.start
                                , order: data.order
                                , search: data.search
                            }
                    , function (data) {
                        callback(data);
                    }
                    );
                },
                'columns': [
                    null,
                    null,
                    {orderable: false}

                ],
                'aoColumnDefs': [{
                        'bSortable': false,
                        'aTargets': ['nosort']
                    }, {"sClass": "center", "aTargets": [2]}],
                language: {
                    "lengthMenu": "{/literal}{$MGLANG->absoluteT('Show _MENU_ entries')}{literal}",
                    "info": "{/literal}{$MGLANG->absoluteT('Showing _START_ to _END_ of _TOTAL_ entries')}{literal}",
                    "zeroRecords": "{/literal}{$MGLANG->absoluteT('Nothing to display')}{literal}",
                    "infoEmpty": "",
                    "search": "{/literal}{$MGLANG->absoluteT('Search')}{literal}",
                    "paginate": {
                        "previous": "{/literal}{$MGLANG->absoluteT('Previous')}{literal}"
                        , "next": "{/literal}{$MGLANG->absoluteT('Next')}{literal}"
                    }
                }
            });

            var mgDataTableEmail;

            mgDataTableEmail = $('#email-forwarders-single-table').dataTable({
                processing: false,
                searching: true,
                autoWidth: false,
                "serverSide": false,
                "order": [[0, "desc"]],
                ajax: function (data, callback, settings) {

                    JSONParser.request(
                            'listEmails'
                            , {
                                id: "{/literal}{$domain.id}{literal}"
                                , limit: data.length
                                , offset: data.start
                                , order: data.order
                                , search: data.search
                            }
                    , function (data) {
                        callback(data);
                    }
                    );
                },
                'columns': [
                    null,
                    null,
                    {orderable: false}

                ],
                'aoColumnDefs': [{
                        'bSortable': false,
                        'aTargets': ['nosort']
                    }, {"sClass": "center", "aTargets": [2]}],
                language: {
                    "lengthMenu": "{/literal}{$MGLANG->absoluteT('Show _MENU_ entries')}{literal}",
                    "info": "{/literal}{$MGLANG->absoluteT('Showing _START_ to _END_ of _TOTAL_ entries')}{literal}",
                    "zeroRecords": "{/literal}{$MGLANG->absoluteT('Nothing to display')}{literal}",
                    "infoEmpty": "",
                    "search": "{/literal}{$MGLANG->absoluteT('Search')}{literal}",
                    "paginate": {
                        "previous": "{/literal}{$MGLANG->absoluteT('Previous')}{literal}"
                        , "next": "{/literal}{$MGLANG->absoluteT('Next')}{literal}"
                    }
                }
            });
            //Add Domain Forwarder
            $("#mg-email-forward-form").submit(function (e) {
                e.preventDefault();
                JSONParser.request(
                        'create'
                        , $("#mg-email-forward-form").serialize()
                        , function (data) {
                            if (!data.error) {
                                mgDataTable.api().ajax.reload();
                            }
                        }
                );
            });

            //Add Domain Forwarder
            $("#mg-email-single-forward-form").submit(function (e) {
                e.preventDefault();
                JSONParser.request(
                        'createSingleEmail'
                        , $(this).serialize()
                        , function (data) {
                            if (!data.error) {
                                mgDataTableEmail.api().ajax.reload();
                            }
                        }
                );
            });

            //Delete 
            $('#mg-forwards-content').on('click', ".mg-delete", function (e) {
                e.preventDefault();
                var modalId = "#" + $(this).attr('data-modal-id');
                $("#mg-modal-forward-delete-dest").val($(this).attr('data-dest'));
                $("#mg-modal-forward-delete-sourceurl").val($(this).attr('data-sourceurl'));
                $(modalId).modal();
            });

            $("#mg-modal-button-delete").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        'delete'
                        , $("#mg-form-forward-delete").serialize()
                        , function (data) {
                            $("#mg-modal-forward-delete").modal('hide');
                            mgDataTable.api().ajax.reload();
                            mgDataTableEmail.api().ajax.reload();
                        }
                );
            });

            //Search
            $("#domain-forwarders-table_filter, #email-forwarders-single-table_filter").hide();
            $('#mg-input-datatable-search').on('keyup', function () {
                mgDataTable.api().search(this.value).draw();
            });
            $('#mg-input-datatable-single-search').on('keyup', function () {
                mgDataTableEmail.api().search(this.value).draw();
            });

        });
    </script>
{/literal}