<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-06-29)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\submodules;

use MGModule\DomainAndEmailForwarding\service\IntegrationModule;
use MGModule\DomainAndEmailForwarding\service\IntegrationAdapter;
use MGModule\DomainAndEmailForwarding\service\InterfaceDomainForward;
use MGModule\DomainAndEmailForwarding\service\InterfaceEmailSingleForward;

/**
 * DirectAdmin Submodule. Allow you to automatically set domain forwarding into DirectAdmin.
 * @author Mateusz Tomaszewski <mateusz.to@modulesgarden.com>
 * @version 1.2.0
 */
class DirectAdmin extends IntegrationModule implements IntegrationAdapter, InterfaceDomainForward, InterfaceEmailSingleForward
{
    /**
     * Module Options
     * @var array
     */
    protected $options;
    private $api;

    public function getName()
    {
        return 'DirectAdmin';
    }

    public function getDescription()
    {

        return 'Leverage DirectAdmin server to handle domain and email forwarding created by your clients.';
    }

    public function getVersion()
    {
        return '1.0.0';
    }

    public function getFeatures()
    {
        return array(
            "domainForward" => array(
                "type"     => true,
                "rdwww"    => false,
                "wildcard" => false,
            ),
            "emailForward"  => array(
                "domain" => false,
                "single" => true,
            )
        );
    }

    public function getTypes()
    {
        return array(
            301 => 'lbl_pernament',
            302 => 'lbl_temporary',
            303 => 'lbl_replaced',
        );
    }

    public function getOptions()
    {
        return array(
            "host"     => array(
                "type"          => "text",
                "label"         => "Host",
                "default"       => "",
                "description"   => "Provide your URL, i.e: example.com",
                'labelcolWidth' => 3,
                'colWidth'      => 9,
            ),
            "port"=> array (
                       "type"=> "text",
                       "label" => "Port",
                       "default" => "2222",
                       "description" => "Provide your Port, default is 2222",
                        'labelcolWidth' => 3,
                        'colWidth' => 5,
                       ),
            "ssl"=> array (
                "type" => 'checkbox',
                "label" => "SSL Mode",
                'options' => array('on'),
                'value' => array(),
                'default' => 1,
                'labelcolWidth' => 3,
                'colWidth' => 9,
            ),
            "username" => array(
                "type"          => "text",
                "label"         => "Admin Username",
                "default"       => "",
                "description"   => "Enter your username here",
                'labelcolWidth' => 3,
                'colWidth'      => 9,
            ),
            "password" => array(
                "type"          => "password",
                "label"         => "Admin Password",
                "default"       => "",
                "description"   => "Enter your password here",
                'labelcolWidth' => 3,
                'colWidth'      => 8,
            ),
            "reseller" => array(
                "type"          => "text",
                "label"         => "Account",
                "default"       => "",
                "description"   => "Enter your account username here",
                "enableTooltip" => true,
                'labelcolWidth' => 3,
                'colWidth'      => 9,
            ),         
        );
    }

    public function activate()
    {
        return true;
    }

    public function deactivate()
    {
        
    }

    public function testConnection(array $options)
    {

        $this->options = $options;

        $users = new DirectAdmin\Models\Users($this->api());
        $users->checkLogin();

        return true;
    }

    /**
     * 
     * @return \MGModule\DomainAndEmailForwarding\submodules\DirectAdmin\HTTPSocket;
     */
    private function api()
    {
        if (!empty($this->api))
        {
            return $this->api;
        }

        $this->api = new DirectAdmin\HTTPSocket();
        $this->api->connect($this->options['host'], $this->options['port'], isset($this->options['ssl']));
        $username  = $this->options['reseller'] ?
                $this->options['username'] . "|" . $this->options['reseller'] :
                $this->options['username'];

        $this->api->set_login($username, $this->options['password']);

        return $this->api;
    }

    public function createDomainRedirect($params)
    {

        $args   = array(
            'src'      => '/' . $params['forward']['src'],
            'type'     => $params['forward']['type'],
            'url'      => (preg_match('/^(http|https):\/\//', $params['forward']['url']) ? '' : 'http://') . $params['forward']['url'],
            'domain'   => $params['forward']['domain'],
            'wildcard' => (int) $params['forward']['wildcard'],
            'rdwww'    => $params['forward']['rdwww']
        );
        $domain = new DirectAdmin\Models\Domains($this->api(), $args['domain']);
        if (!$domain->checkStatusParkDomain())
        {
            $domain->parkDomain();
        }
        $domain->addForward($args);
    }

    public function deleteDomainRedirect($params)
    {

        $domain = new DirectAdmin\Models\Domains($this->api(), $params['domain']['domain']);
        $domain->deleteForward($params['forward']['sourceurl']);
    }

    public function listDomainRedirects($params)
    {

        $domain = new DirectAdmin\Models\Domains($this->api(), $params['domain']['domain']);
        $result = $domain->listForward();

        $values = array();
        if (!isset($result['error']))
        {
            foreach ($result as $src => $response)
            {
                parse_str($response, $redirect);
                $values[] = array(
                    'sourceurl' => $src,
                    'targeturl' => $redirect['to'],
                    'domain'    => $params['domain']['domain'],
                    'type'      => $redirect['type'],
                );
            }
        }
        return $values;
    }

    public function createEmailSingleRedirect($params)
    {

        if (!$this->getStatusParkDomain($params['domain']['domain']))
        {
            $this->parkDomain($params['domain']['domain']);
        }

        $email = new DirectAdmin\Models\Emails($this->api(), $params['domain']['domain']);
        $email->create($params['forward']['source_email'], $params['forward']['dest_email']);
    }

    public function deleteEmailSingleRedirect($params)
    {

        $email = new DirectAdmin\Models\Emails($this->api(), $params['domain']['domain']);
        list($user, ) = explode('@', $params['forward']['dest']);
        $email->delete($user);
    }

    public function listEmailSingleRedirects($params)
    {

        $email  = new DirectAdmin\Models\Emails($this->api(), $params['domain']['domain']);
        $result = $email->fetch();

        $values = array();
        if (!isset($result['error']))
        {
            foreach ($result as $key => $data)
            {
                $values[] = array(
                    'dest'    => $key . '@' . $params['domain']['domain'],
                    'forward' => $data
                );
            }
        }
        return $values;
    }

    public function parkDomain($domainName)
    {

        $domain = new DirectAdmin\Models\Domains($this->api(), $domainName);
        $domain->parkDomain();
    }

    public function unparkDomain($domainName)
    {

        $domain = new DirectAdmin\Models\Domains($this->api(), $domainName);
        $domain->unparkDomain();
    }

    public function getStatusParkDomain($domainName)
    {
        $domain = new DirectAdmin\Models\Domains($this->api(), $domainName);
        return $domain->checkStatusParkDomain();
    }
}
