<?php

Class MyTransactions {

    public function PrepareXMLRequest($action, $params) {
        $clTRID = $this->GetclTRID();
        $name = $params['name'];
        $userID = $params['userID'];
        $keyId = $params['keyId'];
        $ipAddress = $params['ipAddress'];
        $request = $params['request'];

        $tld = $params['tld'];
        $type = $params['type'];
        $org = $params['org'];
        $street1 = $params['street1'];
        $street2 = $params['street2'];
        $pc = $params['pc'];
        $city = $params['city'];
        $cc = $params['cc'];
        $email = $params['email'];
        $voice = $params['voice'];
        $fax = $params['fax'];
        $contact_id = $this->GetContactID();

        $clid = $params['clid'];
        $contactType = $params['contactType'];

        $registrant = $params['registrant'];
        $admin = $params['admin'];
        $billing = $params['billing'];
        $tech = $params['tech'];
        $period = $params['period'];
        $authCode = $params['authCode'];

        $hostname = $params['hostname'];
        $ipv4 = $params['ipv4'];
        $ipv6 = $params['ipv6'];

        $locked = $params['locked'];
        if ($locked == 1) {
            $lock_upd = '
			<domain:add>
				<domain:status s="clientTransferProhibited"/>
			</domain:add>';
        } else {
            $lock_upd = '
			<domain:rem>
				<domain:status s="clientTransferProhibited"/>
			</domain:rem>';
        }

        $uparams = $params['fields'];
        $uname = $uparams['name'];
        $uorg = $uparams['org'];
        $ustreet1 = $uparams['street1'];
        $ustreet2 = $uparams['street2'];
        $upc = $uparams['pc'];
        $usp = $uparams['sp'];
        $ucity = $uparams['city'];
        $ucc = $uparams['cc'];
        $uemail = $uparams['email'];
        $uvoice = $uparams['voice'];
        $ufax = $uparams['fax'];
//echo 'u';
//print_r($uparams);
//echo 'u';

        $flag_params_add = $params['add'];
        $flag_params_rem = $params['remove'];


        if (is_array($flag_params_add)) {
            foreach ($flag_params_add as $value1) {
                $addflags .= "<domain:status s=\"$value1\"/>
				";
            }
            $flags_upd .= "
			<domain:add>
				$addflags
			</domain:add>";
        }

        if (is_array($flag_params_rem)) {
            foreach ($flag_params_rem as $value2) {
                $removeflags .= "<domain:status s=\"$value2\"/>
				";
            }
            $flags_upd .= "
			<domain:rem>
				$removeflags
			</domain:rem>";
        }


        $ns_params = $params['ns'];

        if (is_array($ns_params)) {
            foreach ($ns_params as $value3) {
                $upd_ns .= "<domain:hostObj>$value3</domain:hostObj>
				";
            }
        }

        if ($registrant) {
            $reg_dm .= "
			<domain:registrant>$registrant</domain:registrant>";
        }

        if ($admin) {
            $reg_dm .= "
			<domain:contact type=\"admin\">$admin</domain:contact>";
        }

        if ($billing) {
            $reg_dm .= "
			<domain:contact type=\"billing\">$billing</domain:contact>";
        }

        if ($tech) {
            $reg_dm .= "
			<domain:contact type=\"tech\">$tech</domain:contact>";
        }

        $pw = $this->randomString(12);

        switch ($action) {
            case 'getDomainInfo':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
  <command>
    <info>
      <domain:info xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
        <domain:name hosts="all">$name</domain:name>
      </domain:info>
    </info>
    <clTRID>$clTRID</clTRID>
  </command>
</epp>
XML;
                break;

            case 'checkDomain':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
   <epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
     <command>
       <check>
         <domain:check xmlns:domain="urn:ietf:params:xml:ns:domain-1.0">
           <domain:name>$name</domain:name>
         </domain:check>
       </check>
       <clTRID>$clTRID</clTRID>
     </command>
   </epp>
XML;
                break;

            case 'createContact':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
<create>
<contact:create xmlns:contact="urn:ietf:params:xml:ns:contact-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd">
<contact:id>$contact_id</contact:id>
	<contact:postalInfo type="int">
		<contact:name>$name</contact:name>
		<contact:org>$org</contact:org>
		<contact:addr>
			<contact:street>$street1</contact:street>
			<contact:street>$street2</contact:street>
			<contact:city>$city</contact:city>
			<contact:pc>$pc</contact:pc>
			<contact:sp>$sp</contact:sp>
			<contact:cc>$cc</contact:cc>
		</contact:addr>
	</contact:postalInfo>
	<contact:postalInfo type="loc">
		<contact:name>$name</contact:name>
		<contact:org>$org</contact:org>
		<contact:addr>
			<contact:street>$street1</contact:street>
			<contact:street>$street2</contact:street>
			<contact:city>$city</contact:city>
			<contact:pc>$pc</contact:pc>
			<contact:sp>$sp</contact:sp>
			<contact:cc>$cc</contact:cc>
		</contact:addr>
	</contact:postalInfo>
	<contact:voice>$voice</contact:voice>
	<contact:fax>$fax</contact:fax>
	<contact:email>$email</contact:email>
	<contact:authInfo>
		<contact:pw>dummy</contact:pw>
	</contact:authInfo>
</contact:create>
</create>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;

            case 'getContactInfo':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
<info>
<contact:info xmlns:contact="urn:ietf:params:xml:ns:contact-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd">
<contact:id>$clid</contact:id>
</contact:info>
</info>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;

            case 'updateContact':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
<update>
	<contact:update xmlns:contact="urn:ietf:params:xml:ns:contact-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd">
		<contact:id>$clid</contact:id>
		<contact:chg>
			<contact:postalInfo type="int">
				<contact:name>$uname</contact:name>
				<contact:org>$uorg</contact:org>
				<contact:addr>
					<contact:street>$ustreet1</contact:street>
					<contact:street>$ustreet2</contact:street>
					<contact:city>$ucity</contact:city>
					<contact:pc>$upc</contact:pc>
					<contact:sp>$usp</contact:sp>
					<contact:cc>$ucc</contact:cc>
				</contact:addr>
			</contact:postalInfo>
			<contact:postalInfo type="loc">
				<contact:name>$uname</contact:name>
				<contact:org>$uorg</contact:org>
				<contact:addr>
					<contact:street>$ustreet1</contact:street>
					<contact:street>$ustreet2</contact:street>
					<contact:city>$ucity</contact:city>
					<contact:pc>$upc</contact:pc>
					<contact:sp>$usp</contact:sp>
					<contact:cc>$ucc</contact:cc>
				</contact:addr>
			</contact:postalInfo>
			<contact:voice>$uvoice</contact:voice>
			<contact:fax>$ufax</contact:fax>
			<contact:email>$uemail</contact:email>
    	</contact:chg>
	</contact:update>
</update>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;

            case 'updateDomainContact':
                $gfc = new Client();
                $gresult = $gfc->GetThisDomainInfo($name);
                libxml_use_internal_errors(true);
                $doc = simplexml_load_string($gresult);
                if ($doc) {
                    $dmn_obj_arr = new SimpleXMLElement($gresult);
                    if ($contactType == 'registrant') {
                        $myregcontactType = 'registrant';
                        $old_registrant = $dmn_obj_arr->contacts->registrant;
                    } elseif ($contactType == 'admin') {
                        $mycontactType = 'admin';
                        $old_contact = $dmn_obj_arr->contacts->admin;
                    } elseif ($contactType == 'tech') {
                        $mycontactType = 'tech';
                        $old_contact = $dmn_obj_arr->contacts->tech;
                    } elseif ($contactType == 'billing') {
                        $mycontactType = 'billing';
                        $old_contact = $dmn_obj_arr->contacts->billing;
                    } else {
                        $old_contact = '';
                    }



                    if ($contactType == 'registrant') {
                        $rem_upd_cnt = "
			<domain:chg>
				<domain:registrant>$clid</domain:registrant>
			</domain:chg>";
                    } else {

                        if (!(empty($old_contact))) {
                            $rem_upd_cnt = "
				<domain:add>
					<domain:contact type=\"$contactType\">$clid</domain:contact>
				</domain:add>
				<domain:rem>
					<domain:contact type=\"$mycontactType\">$old_contact</domain:contact>
				</domain:rem>";
                        } else {
                            $rem_upd_cnt = "
				<domain:add>
					<domain:contact type=\"$contactType\">$clid</domain:contact>
				</domain:add>";
                        }
                    }
                }
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
	<update>
		<domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
		<domain:name>$name</domain:name>$rem_upd_cnt
		</domain:update>
	</update>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;

            case 'removeDomainContact':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
	<update>
		<domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
		<domain:name>$name</domain:name>
			<domain:rem>
				<domain:contact type="$contactType">$clid</domain:contact>
			</domain:rem>
		</domain:update>
	</update>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;

            case 'updateDomainLock':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
	<update>
		<domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
		<domain:name>$name</domain:name>$lock_upd
		</domain:update>
	</update>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;

            case 'updateDomainFlags':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
	<update>
		<domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
		<domain:name>$name</domain:name>$flags_upd
		</domain:update>
	</update>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;

            case 'updateDomainNameservers':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
  <command>
    <info>
      <domain:info xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
        <domain:name hosts="all">$name</domain:name>
      </domain:info>
    </info>
    <clTRID>$clTRID</clTRID>
  </command>
</epp>
XML;
                break;

            case 'createDomain':
                if (($period == 0) OR empty($period)) {
                    $message = 'Registration period cannot be zero or empty';
                    $res = <<<XML
<?xml version="1.0"?>
<error>
  <message>$message</message>
  <transactionId>$clTRID</transactionId>
</error>
XML;
                    echo $res;
                    exit;
                }
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
  <epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
    <command>
     <create>
		<domain:create xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
			<domain:name>$name</domain:name>
			<domain:period unit="y">$period</domain:period>
			<domain:ns>$upd_ns
			</domain:ns>$reg_dm
			<domain:authInfo>
				<domain:pw>$pw</domain:pw>
			</domain:authInfo>
		</domain:create>
	 </create>
	<clTRID>$clTRID</clTRID>
    </command>
  </epp>
XML;
                break;

            case 'renewDomain':
                if (($period == 0) OR empty($period)) {
                    $message = 'Renewal period cannot be zero or empty';
                    $res = <<<XML
<?xml version="1.0"?>
<error>
  <message>$message</message>
  <transactionId>$clTRID</transactionId>
</error>
XML;
                    echo $res;
                    exit;
                }

                $gfc = new Client();
                $gresult = $gfc->GetThisDomainInfo($name);
                libxml_use_internal_errors(true);
                $doc = simplexml_load_string($gresult);
//print_r($doc);
                if ($doc) {
                    $dmn_obj_arr = new SimpleXMLElement($gresult);
                    $curExpDate = $dmn_obj_arr->expireDate;
                } else {
                    $message = 'Renewal Error: Error getting expiry date parameter needed';
                    $res = <<<XML
<?xml version="1.0"?>
<error>
  <message>$message</message>
  <transactionId>$clTRID</transactionId>
</error>
XML;
                    echo $res;
                    exit;
                }
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
  <command>
    <renew>
      <domain:renew xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
        <domain:name>$name</domain:name>
        <domain:curExpDate>$curExpDate</domain:curExpDate>
        <domain:period unit="y">$period</domain:period>
      </domain:renew>
    </renew>
    <clTRID>$clTRID</clTRID>
  </command>
</epp>
XML;
                break;

            case 'transferDomain':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
<transfer op="request">
	<domain:transfer xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
		<domain:name>$name</domain:name>
		<domain:authInfo>
			<domain:pw>$authCode</domain:pw>
		</domain:authInfo>
	</domain:transfer>
</transfer>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;


            case 'getEPPCode':
                $this->theAuthCode = $this->randomString(10);
                $myAuthCode = $this->theAuthCode;
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
	<update>
		<domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
		<domain:name>$name</domain:name>
			<domain:chg>
             <domain:registrant>$registrant</domain:registrant>
             <domain:authInfo>
               <domain:pw>$myAuthCode</domain:pw>
             </domain:authInfo>
           </domain:chg>
		</domain:update>
	</update>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;
                break;


            case 'addHostName':
                if (!empty($ipv6)) {
                    $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
	<epp xmlns ="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
		<command>
			<create>
				<host:create xmlns:host="urn:ietf:params:xml:ns:host-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd">
				<host:name>$hostname</host:name>
				<host:addr ip="v6">$ipv6</host:addr>
				</host:create>
			</create>
			<clTRID>$clTRID</clTRID>
		</command>
	</epp>
XML;
                } else {
                    $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
	<epp xmlns ="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
		<command>
			<create>
				<host:create xmlns:host="urn:ietf:params:xml:ns:host-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd">
				<host:name>$hostname</host:name>
				<host:addr ip="v4">$ipv4</host:addr>
				</host:create>
			</create>
			<clTRID>$clTRID</clTRID>
		</command>
	</epp>	
XML;
                }
                break;


            case 'updateHostName':
                if (!empty($ipv6)) {
                    $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
	<epp xmlns ="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
		<command>
			<update>
				<host:update xmlns:host="urn:ietf:params:xml:ns:host-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd">
				<host:name>$hostname</host:name>
				<host:addr ip="v6">$ipv6</host:addr>
				</host:update>
			</update>
			<clTRID>$clTRID</clTRID>
		</command>
	</epp>
XML;
                } else {
                    $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
	<epp xmlns ="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
		<command>
			<update>
				<host:update xmlns:host="urn:ietf:params:xml:ns:host-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd">
				<host:name>$hostname</host:name>
				<host:addr ip="v4">$ipv4</host:addr>
				</host:update>
			</update>
			<clTRID>$clTRID</clTRID>
		</command>
	</epp>	
XML;
                }
                break;

            case 'deleteDomain':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
	<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
		<command>
			<delete>
				<domain:delete xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
				<domain:name>$name</domain:name>
				</domain:delete>
			</delete>
		<clTRID>$clTRID</clTRID>
		</command>
	</epp>
XML;
                break;

            case 'deleteContact':
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
	<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
		<command>
			<delete>
				<contact:delete xmlns:contact="urn:ietf:params:xml:ns:contact-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd">
				<contact:id>$clid</contact:id>
				</contact:delete>
			</delete>
		<clTRID>$clTRID</clTRID>
		</command>
	</epp>
XML;
                break;


            default:
                $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
  <command>
    <info>
      <domain:info xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
        <domain:name hosts="all">$nil</domain:name>
      </domain:info>
    </info>
    <clTRID>$clTRID</clTRID>
  </command>
</epp>
XML;
                break;
        }

        return $xml_request;
    }

    public function PrepareXMLRequestSpecial($action, $params) {
        $clTRID = $this->GetclTRID();
        $name = $params['name'];
        $userID = $params['userID'];
        $keyId = $params['keyId'];
        $ipAddress = $params['ipAddress'];
        $request = $params['request'];

        $tld = $params['tld'];
        $type = $params['type'];
        $org = $params['org'];
        $street1 = $params['street1'];
        $street2 = $params['street2'];
        $pc = $params['pc'];
        $city = $params['city'];
        $cc = $params['cc'];
        $email = $params['email'];
        $voice = $params['voice'];
        $fax = $params['fax'];
        $contact_id = $this->GetContactID();

        $clid = $params['clid'];
        $contactType = $params['contactType'];

        $locked = $params['locked'];
        if ($locked == 1) {
            $lock_upd = '
			<domain:add>
				<domain:status s="clientTransferProhibited"/>
			</domain:add>';
        } else {
            $lock_upd = '
			<domain:rem>
				<domain:status s="clientTransferProhibited"/>
			</domain:rem>';
        }

        $uparams = $params['fields'];
        $uname = $uparams['name'];
        $uorg = $uparams['org'];
        $ustreet1 = $uparams['street1'];
        $ustreet2 = $uparams['street2'];
        $upc = $uparams['pc'];
        $usp = $uparams['sp'];
        $ucity = $uparams['city'];
        $ucc = $uparams['cc'];
        $uemail = $uparams['email'];
        $uvoice = $uparams['voice'];
        $ufax = $uparams['fax'];
//echo 'u';
//print_r($uparams);
//echo 'u';

        $flag_params_add = $params['add'];
        $flag_params_rem = $params['remove'];


        if (is_array($flag_params_add)) {
            foreach ($flag_params_add as $value1) {
                $addflags .= "<domain:status s=\"$value1\"/>
				";
            }
            $flags_upd .= "
			<domain:add>
				$addflags
			</domain:add>";
        }

        if (is_array($flag_params_rem)) {
            foreach ($flag_params_rem as $value2) {
                $removeflags .= "<domain:status s=\"$value2\"/>
				";
            }
            $flags_upd .= "
			<domain:rem>
				$removeflags
			</domain:rem>";
        }


        $ns_params = $params['ns'];

        if (is_array($ns_params)) {
            foreach ($ns_params as $value3) {
                $upd_ns .= "<domain:hostObj>$value3</domain:hostObj>
				";
            }
        }

        $ns_upd = "
			<domain:add>
				<domain:ns>
				$upd_ns
				</domain:ns>
			</domain:add>";

        $xml_request = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
<command>
	<update>
		<domain:update xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
		<domain:name>$name</domain:name>$ns_upd {respx}
		</domain:update>
	</update>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;

        return $xml_request;
    }

    public function EchoError($action, $params) {
        echo $this->PrepareXMLRequest($action, $params);
    }

    public function ProcessXMLRequest($action, $params) {

        $name = $params['name'];
        $userID = $params['userID'];
        $keyId = $params['keyId'];
        $ipAddress = $params['ipAddress'];
        $request = $params['request'];

        $host = '41.222.79.26';
        $port = 700;
        $timeout = 10;
        $ssl = true;

        $clTRID = $this->GetclTRID();
        $clID = $this->clID;
        $pw = $this->pw;

        $epp = new Net_EPP_Client;

        try {
            $greeting = $epp->connect($host, $port, $timeout, $ssl);
        } catch (Exception $e) {
            $message = $e->getMessage();
            $res = <<<XML
<?xml version="1.0"?>
<error>
  <message>$message</message>
  <transactionId>$transactionId</transactionId>
</error>
XML;
            echo $res;
            exit;
        }

        $stringXMLLogin = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<epp xmlns="urn:ietf:params:xml:ns:epp-1.0">
<command>
<login>
<clID>$clID</clID>
<pw>$pw</pw>
<options>
<version>1.0</version>
<lang>en</lang>
</options>
<svcs>
<objURI>urn:ietf:params:xml:ns:contact-1.0</objURI>
<objURI>urn:ietf:params:xml:ns:domain-1.0</objURI>
<objURI>urn:ietf:params:xml:ns:host-1.0</objURI>
</svcs>
</login>
<clTRID>$clTRID</clTRID>
</command>
</epp>
XML;

        $stringXMLLogOut = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
   <epp xmlns="urn:ietf:params:xml:ns:epp-1.0">
     <command>
       <logout/>
       <clTRID>$clTRID</clTRID>
     </command>
   </epp>
XML;

        $epp->sendFrame($stringXMLLogin);
        $epp->getFrame();

        $stringXML = $this->PrepareXMLRequest($action, $params);
        if ($action == updateDomainNameservers) {
            $epp->sendFrame($stringXML);
            $xml_response = $epp->getFrame();

            $transactionId = $this->generateTransactionID();
            $esp = new EppToMyXML();
            $respx = $esp->getDomainInfoSpecial($transactionId, $xml_response);

            $dsds = "
			<domain:rem>
				<domain:ns>
				$respx
				</domain:ns>
			</domain:rem>";

            $stringXML1 = $this->PrepareXMLRequestSpecial($action, $params);
            $stringXML = str_replace("{respx}", $dsds, $stringXML1);

            $div_ns = $params['ns'];
            foreach ($div_ns as $value) {
                $dsclTRID = $this->GetclTRID();
                $stringXMLcreate = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <epp xmlns ="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
   <command>
    <create>
      <host:create xmlns:host="urn:ietf:params:xml:ns:host-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd">
        <host:name>$value</host:name>
      </host:create>
    </create>
    <clTRID>$dsclTRID</clTRID>
   </command>
  </epp>
XML;
                $epp->sendFrame($stringXMLcreate);
                $epp->getFrame();
            }


            $epp->sendFrame($stringXML);
            $xml_response = $epp->getFrame();

            $epp->sendFrame($stringXMLLogOut);
            $epp->getFrame();

            $xmlRequest = $stringXML;

            $name = $params['name'];
            $userID = $params['userID'];
            $keyId = $params['keyId'];
            $ipAddress = $params['ipAddress'];
            $request = $params['request'];

            $data = array('name' => $name, 'userID' => $userID, 'keyId' => $keyId, 'ipAddress' => $ipAddress, 'request' => $request, 'xmlRequest' => $xmlRequest, 'special' => 1);
//echo "($action, $data, $xml_response)";
            return $this->OutputXMLResponse($action, $data, $xml_response);
        } elseif ($action == createDomain) {

            $div_ns = $params['ns'];
//print_r($div_ns);
            foreach ($div_ns as $value) {
                $dsclTRID = $this->GetclTRID();
                $stringXMLcreate = <<<XML
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <epp xmlns ="urn:ietf:params:xml:ns:epp-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
   <command>
    <create>
      <host:create xmlns:host="urn:ietf:params:xml:ns:host-1.0" xsi:schemaLocation="urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd">
        <host:name>$value</host:name>
      </host:create>
    </create>
    <clTRID>$dsclTRID</clTRID>
   </command>
  </epp>
XML;
                $epp->sendFrame($stringXMLcreate);
                $epp->getFrame();
            }

            $epp->sendFrame($stringXML);
            $xml_response = $epp->getFrame();

            $epp->sendFrame($stringXMLLogOut);
            $epp->getFrame();

            $xmlRequest = $stringXML;

            $name = $params['name'];
            $userID = $params['userID'];
            $keyId = $params['keyId'];
            $ipAddress = $params['ipAddress'];
            $request = $params['request'];

            $data = array('name' => $name, 'userID' => $userID, 'keyId' => $keyId, 'ipAddress' => $ipAddress, 'request' => $request, 'xmlRequest' => $xmlRequest, 'special' => 1);
//echo "($action, $data, $xml_response)";
            return $this->OutputXMLResponse($action, $data, $xml_response);
        } else {
            $epp->sendFrame($stringXML);
            $xml_response = $epp->getFrame();

            $epp->sendFrame($stringXMLLogOut);
            $epp->getFrame();

            $xmlRequest = $stringXML;

            $name = $params['name'];
            $userID = $params['userID'];
            $keyId = $params['keyId'];
            $ipAddress = $params['ipAddress'];
            $request = $params['request'];

            $data = array('name' => $name, 'userID' => $userID, 'keyId' => $keyId, 'ipAddress' => $ipAddress, 'request' => $request, 'xmlRequest' => $xmlRequest);

            return $this->OutputXMLResponse($action, $data, $xml_response);
        }
    }

    public function OutputXMLResponse($action, $data, $xml_response) {
        $params = $data;
//print_r($params);
        $transactionId = $this->generateTransactionID();

        if (empty($xml_response)) {
            $message = "Error: No response";
            $res = <<<XML
<?xml version="1.0"?>
<error>
  <message>$message</message>
  <transactionId>$transactionId</transactionId>
</error>
XML;
            return $res;
            exit;
        }

        $es = new EppToMyXML();
        switch ($action) {
            case 'getDomainInfo':
                $res = $es->getDomainInfo($transactionId, $xml_response);
                break;

            case 'checkDomain':
                $res = $es->checkDomain($transactionId, $xml_response);
                break;

            case 'createContact':
                $res = $es->createContact($transactionId, $xml_response);
                break;

            case 'getContactInfo':
                $res = $es->getContactInfo($transactionId, $xml_response);
                break;

            case 'updateContact':
                $res = $es->updateContact($transactionId, $xml_response);
                break;

            case 'updateDomainContact':
                $res = $es->updateDomainContact($transactionId, $xml_response);
                break;

            case 'removeDomainContact':
                $res = $es->removeDomainContact($transactionId, $xml_response);
                break;

            case 'updateDomainLock':
                $res = $es->updateDomainLock($transactionId, $xml_response);
                break;

            case 'updateDomainFlags':
                $res = $es->updateDomainFlags($transactionId, $xml_response);
                break;

            case 'updateDomainNameservers':
                $res = $es->updateDomainNameservers($transactionId, $xml_response);
                break;

            case 'createDomain':
                $res = $es->createDomain($transactionId, $xml_response);
                break;

            case 'renewDomain':
                $res = $es->renewDomain($transactionId, $xml_response);
                break;

            case 'transferDomain':
                $res = $es->transferDomain($transactionId, $xml_response);
                break;

            case 'getEPPCode':
                $eppCode = $this->theAuthCode;
                $res = $es->getEPPCode($transactionId, $xml_response, $eppCode);
                break;

            case 'addHostName':
                $res = $es->addHostName($transactionId, $xml_response);
                break;

            case 'updateHostName':
                $res = $es->updateHostName($transactionId, $xml_response);
                break;

            case 'deleteDomain':
                $res = $es->deleteDomain($transactionId, $xml_response);
                break;

            case 'deleteContact':
                $res = $es->deleteContact($transactionId, $xml_response);
                break;


            default:
                $message = "Missing/Wrong parameter...";
                $res = <<<XML
<?xml version="1.0"?>
<error>
  <message>$message</message>
  <transactionId>$transactionId</transactionId>
</error>
XML;
                break;
        }


        $name = $params['name'];
        $userID = $params['userID'];
        $keyId = $params['keyId'];
        $ipAddress = $params['ipAddress'];
        $request = $params['request'];
        $xmlRequest = $params['xmlRequest'];


        $transactionID = $transactionId;
        $action = $action;

        $xmlResponse = $res;
        $xmlResponseEpp = $xml_response;
        $message = $message;
        $domain = $domain_name;

        $data = array('userID' => $userID, 'keyId' => $keyId, 'transactionID' => $transactionID, 'action' => $action, 'ipAddress' => $ipAddress, 'request' => $request, 'xmlRequest' => $xmlRequest, 'xmlResponse' => $xmlResponse, 'xmlResponseEpp' => $xmlResponseEpp, 'message' => $message, 'domain' => $domain);

        $this->logAPI($data);

        return $res;
    }

}

?>