<?php
/**
 * Created by PhpStorm.
 * User: Daniel Babatunde
 * Date: 4/20/2017
 * Time: 9:15 AM
 */
use WHMCS\ClientArea;
use WHMCS\Database\Capsule as Capsule;

define('CLIENTAREA', true);
define('SITEBUILDER_API_URL', 'http://websitebuilder.ng/api/');
require __DIR__ . '/init.php';

$ca = new ClientArea();

$ca->setPageTitle('Website Builder');

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb('websitebuilder.php', 'Website Builder');

$ca->initPage();

$ca->requireLogin(); // Uncomment this line to require a login to access this page

// To assign variables to the template system use the following syntax.
// These can then be referenced using {$variablename} in the template.

//$ca->assign('variablename', $value);

// Check login status
if ($ca->isLoggedIn()) {

    /**
     * User is logged in - put any code you like here
     *
     * Here's an example to get the currently logged in clients first name
     */
    //file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder Page userID: ' . json_encode($ca->getUserID()) . "\n", FILE_APPEND);
//file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder REQYEST: ' . json_encode($_POST) . "\n", FILE_APPEND);

    $client = Capsule::table('tblclients')
        ->where('id', $ca->getUserID())->first();
    //file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder Page client: ' . json_encode($client) . "\n", FILE_APPEND);


    //$ca->assign('clientname', $clientName);

    if(isset($_POST)){
        if(isset($_POST['domain'])){
            $domain = Capsule::table('tbldomains')->where('id', $_POST['domain'])->first();
//file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder Page getDomain: ' . json_encode($domain) . "\n", FILE_APPEND);
            $hosting = Capsule::table('tblhosting')->where('domain', '=', $domain->domain)->first();
//file_put_contents('./debug/whmcs-error-trace.txt', 'Websitebuilder PagegetHosting: ' . json_encode($hosting ) . "\n", FILE_APPEND);
            $user_details = ["userlog_email"=>$client->email,
                "userlog_password"=>$client->password,
                "user_firstname"=>$client->firstname,
                "user_surname"=>$client->lastname];
                $command = 'GetClientsProducts';
                $postData = array(
                    'clientid' => $client->id,
                    'serviceid' => $hosting->id,
                    'stats' => true,
                    'responsetype' => 'json',
                );
                file_put_contents('./debug/whmcs-error-trace.txt', 'Sitebuilder Local Api Request: ' . json_encode($postData) . "\n", FILE_APPEND);
                $adminUsername = 'dab'; // Optional for WHMCS 7.2 and later
        
            $results = localAPI($command, $postData, $adminUsername);
            //var_dump($results);
            $result = json_decode(json_encode($results));
            file_put_contents('./debug/whmcs-error-trace.txt', 'Sitebuilder Local Api Response: ' . json_encode($results) . "\n", FILE_APPEND);
            
            file_put_contents('./debug/whmcs-error-trace.txt', 'Sitebuilder Local Api Result: ' . json_encode($result->products) . "\n", FILE_APPEND);
            $domain_details = ["domain_name"=>$domain->domain,
                                "cpanel_username"=>$hosting->username,
                                "cpanel_password"=>$result->products->product[0]->password];
            $query = json_encode(['user_details'=>$user_details, 'domain_details'=>$domain_details]);
            $response = make_call($query, 'login');
//echo"<pre>";
            //print_r($response);
  // This will remove unwanted characters.
// Check http://www.php.net/chr for details
for ($i = 0; $i <= 31; ++$i) { 
    $response= str_replace(chr($i), "", $response); 
}
$response= str_replace(chr(127), "", $response);

// This is the most common part
// Some file begins with 'efbbbf' to mark the beginning of the file. (binary level)
// here we detect it and we remove it, basically it's the first 3 characters 
if (0 === strpos(bin2hex($response), 'efbbbf')) {
   $response= substr($response, 3);
}

$response = json_decode(stripslashes($response));
            //print json_last_error_msg();
            //print_r($response);

            $ca->assign('sitebuilder_flag', $response->ResponseData);
        }
    }

} else {

    // User is not logged in
    $ca->assign('clientname', 'Random User');

}

/**
 * Set a context for sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
Menu::addContext();

/**
 * Setup the primary and secondary sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
Menu::primarySidebar('announcementList');
Menu::secondarySidebar('announcementList');

# Define the template filename to be used without the .tpl extension

$ca->setTemplate('websitebuilder');

$ca->output();

function make_call($query,$action=''){
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, SITEBUILDER_API_URL.$action);

    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");

    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt($ch, CURLOPT_POSTFIELDS, $query);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authentication: 9135RpZvEd2tY100790k62G2FiOzVm9Q','Content-Type:application/json'));

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    file_put_contents('./debug/whmcs-error-trace.txt', 'Sitembuilder Api Request: ' . json_encode($query) . "\n", FILE_APPEND);
    $xml = curl_exec($ch);
    file_put_contents('./debug/whmcs-error-trace.txt', 'Sitembuilder Api Reseponse: ' . json_encode($xml) . "\n", FILE_APPEND);
file_put_contents('./debug/whmcs-error-trace.txt', 'Sitembuilder CURl Info: ' . json_encode() . "\n", FILE_APPEND);

    $response_info = $xml;
    return $response_info;
}