<?php
/**
 * Created by PhpStorm.
 * User: Daniel Babatunde
 * Date: 3/23/2017
 * Time: 8:45 AM
 */
use WHMCS\ClientArea;
use WHMCS\Database\Capsule;

define('CLIENTAREA', true);

require __DIR__ . '/init.php';

$ca = new ClientArea();

$ca->setPageTitle('Recover your email using old credientials');

$ca->addToBreadCrumb('index.php', Lang::trans('globalsystemname'));
$ca->addToBreadCrumb('recoveraccountemail.php', 'Recover your email');
$ca->initPage();
//if(isset($_POST)){
    //print_r($_POST);
//}
//$ca->requireLogin(); // Uncomment this line to require a login to access this page

// To assign variables to the template system use the following syntax.
// These can then be referenced using {$variablename} in the template.

//$ca->assign('variablename', $value);

// Check login status
if ($ca->isLoggedIn()) {

    /**
     * User is logged in - put any code you like here
     *
     * Here's an example to get the currently logged in clients first name
     */

    $clientName = Capsule::table('tblclients')
        ->where('id', '=', $ca->getUserID())->value('firstname');
    // 'pluck' was renamed within WHMCS 7.0.  Replace it with 'value' instead.
    // ->where('id', '=', $ca->getUserID())->value('firstname');
    $ca->assign('clientname', $clientName);

} else {
    $ca->assign('incorrect', null);

    // User is not logged in
    if(isset($_POST)){
        $password = hash('sha256', $_POST['password']);
        $clientEmail = Capsule::table('users_login')
            ->where([
                ['userlog_username', '=', $_POST['username']],
                ['userlog_password','=', $password]
            ])
            ->value('userlog_email');
        // 'pluck' was renamed within WHMCS 7.0.  Replace it with 'value' instead.
        // ->where('id', '=', $ca->getUserID())->value('firstname');
        //print_r($clientEmail);
        if($clientEmail){
            $ca->assign('clientemail', $clientEmail);
        }else{
            $ca->assign('incorrect', true);
        }

    }

    //$ca->assign('clientname', 'Random User');

}

/**
 * Set a context for sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
//Menu::addContext();

/**
 * Setup the primary and secondary sidebars
 *
 * @link http://docs.whmcs.com/Editing_Client_Area_Menus#Context
 */
//Menu::primarySidebar('announcementList');
//Menu::secondarySidebar('announcementList');

# Define the template filename to be used without the .tpl extension

$ca->setTemplate('recoveraccountemail');

$ca->output();