<?php

namespace ModulesGarden\GSuite\App;
 
use Illuminate\Database\Capsule\Manager as DB;

class PDOWrapper
{
    public static function query($query, $params = array())
    {
        $statement = DB::connection()
                ->getPdo()
                ->prepare($query);
        $statement->execute($params);

        return $statement;
    }

    public static function real_escape_string($string)
    {  
        return substr(DB::connection()->getPdo()->quote($string),1,-1);
    }

    public static function fetch_assoc($query)
    {
        return $query->fetch(\PDO::FETCH_ASSOC);
    }

    public static function fetch_array($query)
    {
        return $query->fetch(\PDO::FETCH_BOTH);
    }

    public static function fetch_object($query)
    {
        return $query->fetch(\PDO::FETCH_OBJ);
    }

    public static function num_rows($query)
    {
        $query->fetch(\PDO::FETCH_BOTH);

        return $query->rowCount();
    }

    public static function insert_id()
    {
        return DB::connection()
                ->getPdo()
                ->lastInsertId();
    }

    public static function errorInfo()
    {
        $errInfo = DB::connection()
                ->getPdo()
                ->errorInfo();

        if($errInfo[0] !== '00000')
        {
            return $errInfo;
        }

        return false;
    }

    public static function mysql_get_array($query, $params = array())
    {
        $qRes = self::query($query, $params);
        $arr = array();
        while($row = self::fetch_assoc($qRes))
        {
            $arr[] = $row;
        }

        return $arr;
    }

    public static function mysql_get_row($query, $params = array())
    {
        $qRes = self::query($query, $params);

        return self::fetch_assoc($qRes);            
    }
}

