<?php
/**********************************************************************
 *  GSuite Reseller API Connection class for WHMCS  (21.11.12)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->        http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 **********************************************************************/
/**
 * @version 1.0.1 (19.03.2013)
 * @author <pawel@modulesgarden.com>
 */

namespace ModulesGarden\GSuite\App;

class GSuiteApi
{
    private $is_error = 0;
    private $error;
    private $http_response_code;
    private $enable_logs;

    private $url;
    private $access_token;


    public function isError() {
        return $this->is_error;
    }

    public function getError() {
        return $this->error;
    }

    public function getHttpResponseCode() {
        return $this->http_response_code;
    }

    public function addError($e) {
        $this->error = $e;
        $this->is_error = 1;
    }

    public function setHttpResponseCode($code) {
        $this->http_response_code = $code;
    }

    public function refuseError() {
        $this->error = false;
        $this->is_error = 0;
    }

    
    public function  __construct($access_token, $url, $enable_logs=false) {

        $this->url = $url;
        $this->access_token = $access_token;
        $this->enable_logs = $enable_logs;

    }
    
    public function getCustomer($customerid){
        
        if(!$customerid){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        $requesturl="/customers/{$customerid}";
        $result = $this->connect($requesturl);
        
        return $result;
    }
    
    public function getSubscription($customerid,$subscriptionid){
        
        if(!$customerid){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if(!$subscriptionid){
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        $requesturl="/customers/{$customerid}/subscriptions/{$subscriptionid}";
        $result = $this->connect($requesturl);
        
        return $result;
    }
    
    public function startPaidService($customerid,$subscriptionid){
        
        if(!$customerid){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if(!$subscriptionid){
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        $method='POST';
        $requesturl="/customers/{$customerid}/subscriptions/{$subscriptionid}/startPaidService";
        $result = $this->connect($requesturl,$method);
        
        return $result;
    }
    
    public function changeSeats($customerid,$subscriptionid,$data){
        
        if(!$customerid){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if(!$subscriptionid){
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        
        $seats = array("kind" => "subscriptions#seats");
        if(isset($data['numberofseats']))
            $seats['numberOfSeats'] = $data['numberofseats'];
        if(isset($data['maximumnumberofseats']))
            $seats['maximumNumberOfSeats'] = $data['maximumnumberofseats'];
        
        $method='POST';
        $requesturl="/customers/{$customerid}/subscriptions/{$subscriptionid}/changeSeats";
        
        $params = $seats;
        $result = $this->connect($requesturl,$method,$params);
        
        return $result;
    }
    public function changeRenewalSettings($customerid,$subscriptionid,$data){
        
        if(!$customerid){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if(!$subscriptionid){
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        $method='POST';
        $requesturl="/customers/{$customerid}/subscriptions/{$subscriptionid}/changeRenewalSettings";
        $params=array(
            "kind" => "subscriptions#renewalSettings",
            "renewalType" => $data['renewaltype'],
        );
        $result = $this->connect($requesturl,$method,$params);
        
        return $result;
    }
    
    public function suspendLicense($customerid, $subscriptionid, $data)
    {
        if (!$customerid)
        {
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if (!$subscriptionid)
        {
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        
        $method     = 'POST';
        $requesturl = "/customers/{$customerid}/subscriptions/{$subscriptionid}/suspend";
        $params     = [];
        $result     = $this->connect($requesturl, $method, $params);

        return $result;
    }

    public function unsuspendLicense($customerid, $subscriptionid, $data)
    {
        if (!$customerid)
        {
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if (!$subscriptionid)
        {
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        
        $method     = 'POST';
        $requesturl = "/customers/{$customerid}/subscriptions/{$subscriptionid}/activate";
        $params     = [];
        $result     = $this->connect($requesturl, $method, $params);

        return $result;
    }    
    
    public function changePlan($customerid,$subscriptionid,$data){
        
        if(!$customerid){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if(!$subscriptionid){
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        
        $seats = array("kind" => "subscriptions#seats");
        if(isset($data['seats']['numberofseats']))
            $seats['numberOfSeats'] = $data['seats']['numberofseats'];
        if(isset($data['seats']['maximumnumberofseats']))
            $seats['maximumNumberOfSeats'] = $data['seats']['maximumnumberofseats'];
        
        $method='POST';
        $requesturl="/customers/{$customerid}/subscriptions/{$subscriptionid}/changePlan";
        $params=array(
            "kind"                  => "subscriptions#changePlanRequest",
            "planName"              => $data['planname'],
            "seats"                 => $seats,
            "purchaseOrderId"       => $data['purchaseorderid']
        );
        $result = $this->connect($requesturl,$method,$params);
        
        return $result;
    }
    
    public function deleteSubscription($customerid,$subscriptionid,$deletiontype){
        
        if(!$customerid){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        if(!$subscriptionid){
            $this->addError('Missing parameter: Subscription ID');
            return false;
        }
        $method='DELETE';
        $requesturl="/customers/{$customerid}/subscriptions/{$subscriptionid}?deletionType=transfer_to_direct";
        $result = $this->connect($requesturl,$method);
        
        return $result;
    }
    
    public function listSubscriptions($prefix=false,$pagetoken=false,$maxresults=100){
        
        //$requesturl="/subscriptions?customerNamePrefix={$prefix}&maxResults={$maxresults}";
        $requesturl="/subscriptions?customerId={$prefix}&maxResults={$maxresults}";
      
        if($pagetoken)
            $requesturl.="&pageToken={$pagetoken}";
        
        $result = $this->connect($requesturl);
        return $result;
    }
    
    public function insertCustomer($data){
        
        $method='POST';
        $requesturl="/customers";
        
        $params=array(
            "kind"              => "reseller#customer",
            "customerId"        => $data['id'],
            "customerDomain"    => $data['domain'],
            "postalAddress"     => array(
                "kind"              => "customers#address",
                "contactName"       => $data['postaladdress']['name'],
                "organizationName"  => $data['postaladdress']['organization'],
                "locality"          => $data['postaladdress']['city'],
                "region"            => $data['postaladdress']['region'],
                "postalCode"        => $data['postaladdress']['postalcode'],
                "countryCode"       => $data['postaladdress']['countrycode'],
                "addressLine1"      => $data['postaladdress']['address']
            ),
            "phoneNumber"       => $data['phonenumber'],
            "alternateEmail"    => $data['altemail']
        );
        
        $result=$this->connect($requesturl,$method,$params);
        
        return $result;
    }
    
    public function patchCustomer($data){
        
        if(!$data['id']){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }

        $method='PATCH';
        $requesturl="/customers/".$data['id'];
        
        $params=array(
            "kind"              => "reseller#customer",
            "customerId"        => $data['id'],
            "customerDomain"    => $data['domain'],
            "postalAddress"     => array(
                "kind"              => "customers#address",
                "contactName"       => $data['postaladdress']['name'],
                "organizationName"  => $data['postaladdress']['organization'],
                "locality"          => $data['postaladdress']['city'],
                "region"            => $data['postaladdress']['region'],
                "postalCode"        => $data['postaladdress']['postalcode'],
                "countryCode"       => $data['postaladdress']['countrycode'],
                "addressLine1"      => $data['postaladdress']['address']
            ),
            "phoneNumber"       => $data['phonenumber'],
            "alternateEmail"    => $data['altemail']
        );
        
        $result=$this->connect($requesturl,$method,$params);
        
        return $result;
    }
    
    public function updateCustomer($data){
        
        if(!$data['id']){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        $method='PUT';
        $requesturl="/customers/".$data['id'];
        
        $params=array(
            "kind"              => "reseller#customer",
            "customerId"        => $data['id'],
            "customerDomain"    => $data['domain'],
            "postalAddress"     => array(
                "kind"              => "customers#address",
                "contactName"       => $data['postaladdress']['name'],
                "organizationName"  => $data['postaladdress']['organization'],
                "locality"          => $data['postaladdress']['city'],
                "region"            => $data['postaladdress']['region'],
                "postalCode"        => $data['postaladdress']['postalcode'],
                "countryCode"       => $data['postaladdress']['countrycode'],
                "addressLine1"      => $data['postaladdress']['address']
            ),
            "phoneNumber"       => $data['phonenumber'],
            "alternateEmail"    => $data['altemail']
        );
        
        $result=$this->connect($requesturl,$method,$params);
        
        return $result;
    }
    
    public function insertSubscription($data){
        
        if(!$data['customerid']){
            $this->addError('Missing parameter: Customer ID (Domain)');
            return false;
        }
        $seats = array("kind" => "subscriptions#seats");
        if(isset($data['seats']['numberofseats']))
            $seats['numberOfSeats'] = $data['seats']['numberofseats'];
        if(isset($data['seats']['maximumnumberofseats']))
            $seats['maximumNumberOfSeats'] = $data['seats']['maximumnumberofseats'];
        
        $method='POST';
        $requesturl="/customers/{$data['customerid']}/subscriptions";
        
        $params = array(
            "kind"              => "reseller#subscription",
            "customerId"        => $data['customerid'],
            "skuId"             => $data['skuid'],
            "plan"              => array(
                "planName"              => $data['plan']['planname'],
            ),
            "seats"             => $seats,
            "renewalSettings"   => array(
                "kind"              => "subscriptions#renewalSettings",
                "renewalType"       => $data['renewalsettings']['renewaltype']
            ),
            "purchaseOrderId"   => $data['purchaseorderid']
        );

        $result=$this->connect($requesturl,$method,$params);
        
        return $result;
    }
    
    private function connect($requesturl, $method='GET', $params = array()) {

        $url = $this->url.$requesturl;
        if(!is_array($params))
            $params = array();
        
        $ch = curl_init();

        $header=array("Authorization: Bearer ".$this->access_token);
        
        if(!empty($params)){
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
            $header[]='Content-type: application/json';
        }
        else if($method=='POST'){
            curl_setopt($ch, CURLOPT_POST, 1);
            $header[]='Content-length: 0';
        }

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        
        $out = curl_exec($ch);
        $http_response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        if($this->enable_logs){
            logModuleCall('GSuite', "METHOD: {$method}\n URL: {$url} \n", "HEADER: \n".json_encode($header)."\n RAW INPUT: \n".json_encode($params)."\n" , "HTTP RESPONSE CODE: {$http_response_code}\nRAW OUTPUT:\n{$out}\n\n\n" ,'',''); 
        }
        
        $this->setHttpResponseCode($http_response_code);
        curl_close($ch);
        if($out === false) {
            $this->addError(ucwords(curl_error($ch)));
            return false;
        }
        if($http_response_code=='204'){
            return true;
        }
        
        $ret = json_decode($out);
        if(!$ret) {
            $this->addError('Unable to parse response (JSON)');
            return false;
        }
        
        if (isset($ret->error)) {
          
            $this->addError($ret->error->message);
            return false;
        }
        else{
            return $ret;
        }
    }

    public function addAdminUser($adminParams)
    {
        $method='POST';
        $requesturl="/users";
        
        $params=array(
            "kind"              => "admin#directory#user",
            "primaryEmail" => $adminParams['primaryEmail'],
            "password" => $adminParams['password'],
            "name" => array(
                "familyName" => $adminParams['familyName'],
                "givenName" => $adminParams['givenName'],
                "fullName" => $adminParams['fullName']
            ));
        
        $result=$this->connect($requesturl,$method,$params);
        
        return $result;        
    }
    
    public function makeAdminUserAdmin($email)
    {
        $method='POST';
        $requesturl="/users/".$email."/makeAdmin";
        
        $params=array(
            'status' => true
        );
        
        $result=$this->connect($requesturl,$method,$params);
        
        return $result;        
    }    
}
