<?php

/**
 * Upperlink WHMCS Wallet Payment Callback
 *
 * Payment Gateway modules allow you to integrate payment solutions with the
 * WHMCS platform.
 *
 *
 * @copyright Copyright (c) WHMCS Limited 2015
 * @license http://www.whmcs.com/license/ WHMCS Eula
 * @author Bankole Olaoluwa
 * @link olaoluwa.bankole@upperlink.ng
 * 
 */
use Illuminate\Database\Capsule\Manager as Capsule;

// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

define('DEFAULT_HOST_PATH', 'https://domains.upperlink.ng/clients');

// Detect module name from filename.
$gatewayModuleName = basename(__FILE__, '.php');

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);

// Die if module is not active.
if (!$gatewayParams['type']) {
    die("Module Not Activated");
}

/**
 * Process all callback requests for first data
 *
 * @return void
 * 
 */
function uplWalletProcessCallbackRequests() {
    if (count($_POST)) {

        $transaction_ref = trim($_POST['x_fp_sequence']);
        //$invoiceid = $_POST['x_invoiceid'];
        $amount = $_POST['x_amount'];
        
        $today = date('Y-m-d H:i:s');
        
//       
        //check if this transaction reference number exists in our record
        if (Capsule::schema()->hasTable('tbltransactions')) {
            $transaction = Capsule::table('tbltransactions')->where('transaction_ref', $transaction_ref)->where('transaction_status', 'pending')->first();
            if ($transaction) {
                file_put_contents('./debug/whmcs-error-trace.txt', 'About to log first data transactions' . "\n", FILE_APPEND);
                file_put_contents('./debug/whmcs-error-trace.txt', 'RETURNED FROM Wallet: ' . json_encode($_POST) . "\n", FILE_APPEND);

                //---- apply credit to invoice --------- //
                $results = applyCreditInvoice($transaction->invoice_id, $amount);
                
                $transaction_status = getTransactionStatus($results['result']);
                $x_response_code = $results['result'] == 'success' ? "00" : "01";
                $x_response_reason_text = $results['result'] == 'success' ? "Invoice paid" : $results['message'];
                $log_transaction_status = $transaction_status == 'paid' ? 'Success' : 'Failure';
                $feedback_transaction_status = $transaction_status == 'paid' ? 'Successful' : 'Failed';
                
                
                
                //update transaction details
                Capsule::table('tbltransactions')->where('id', $transaction->id)->update(['response_code' => $x_response_code,
                    'response_description' => isset($x_response_reason_text) && !empty($x_response_reason_text) ? $x_response_reason_text : null,
                    'transaction_status' => $transaction_status
                ]);
                $transaction = Capsule::table('tbltransactions')->where('id', $transaction->id)->first(); //fetch the updated record from the database

                if (isset($gatewayParams['gatewayLogs']) && $gatewayParams['gatewayLogs'] == 'on') {
                    $output = "Transaction Reference: " . $transaction_ref
                            . "\r\nInvoice ID: " . $transaction->invoice_id
                            . "\r\nStatus: " . $log_transaction_status;
                    logTransaction($gatewayModuleName, $output, $log_transaction_status);
                }

                if ($transaction_status == 'paid') {
                    /**
                     * Validate Callback Invoice ID.
                     *
                     * Checks invoice ID is a valid invoice number. Note it will count an
                     * invoice in any status as valid.
                     *
                     * Performs a die upon encountering an invalid Invoice ID.
                     *
                     * Returns a normalised invoice ID.
                     */
                    $invoiceId = checkCbInvoiceID($transaction->invoice_id, $gatewayParams['name']);

                    /**
                     * Add Invoice Payment.
                     *
                     * Applies a payment transaction entry to the given invoice ID.
                     *
                     * @param int $invoiceId         Invoice ID
                     * @param string $transactionId  Transaction ID
                     * @param float $paymentAmount   Amount paid (defaults to full balance)
                     * @param float $paymentFee      Payment fee (optional)
                     * @param string $gatewayModule  Gateway module name
                     */
                    //addInvoicePayment($invoiceId, $transaction->transaction_ref, $transaction->transaction_amount, 0, $gatewayModuleName);
                    // exit($log_transaction_status);
                }

                //return feedback
                $feedback_type = 2;
                $transaction_details->client_id = $transaction->client_id;
                $transaction_details->transaction_status = $feedback_transaction_status;
                $transaction_details->transaction_amount = number_format($transaction->transaction_amount, 2);
                $transaction_details->transaction_description = $transaction->response_description;
                $transaction_details->transaction_ref = $transaction->transaction_ref;
                echo "";
                uplWalletFeedback($feedback_type, null, $log_transaction_status, $transaction_details, $transaction->invoice_id);
            } else {
                $feedback_type = 1;
                $message = "This transaction reference number '" . $transaction_ref . "' doesn't exist in our record, please contact our support for assistance.";
                uplWalletFeedback($feedback_type, $message);
            }
        } else {
            $feedback_type = 1;
            $message = "The transactions table doesn't exist, please contact the administrator for assistance.";
            uplWalletFeedback($feedback_type, $message);
        }
    } else {
        $feedback_type = 1;
        $message = "Invalid response for this transaction. Please go back and try again.";
        uplWalletFeedback($feedback_type, $message);
    }
}

/**
 * Requery First Data Transaction
 *
 * @return string
 * @param string $transaction_tag
 * @param string $start_date
 * 
 */
function applyCreditInvoice($invoiceid, $amount) {
    //---------------- apply credit to invoice ---------- //
    
    $command = "ApplyCredit";
    $adminuser = "bankork";
    $values["invoiceid"] = $invoiceid;
    $values["amount"] = $amount;
    $values['action'] = $command;
    $values['responsetype'] = 'json';
    //print_r($values);
    //$results = localAPI($command,$values,$adminuser);
    $results = (array)makeCall($values);
	//print_r($results);
	//die();
    return $results;
}

/**
 * Get transaction status
 *
 * @return boolean
 * @param int $response_code
 * 
 */
function getTransactionStatus($response_status) {
    switch ($response_status) {
        case 'success':
            return (string) 'paid';
            break;

        case 'Declined':
        case 'error':
            return (string) 'failed';
            break;

        default:
            return (string) 'failed';
            break;
    }
}

/**
 * Render Feedback to the user after payment
 *
 * @return void
 * @param int $feedback_type
 * @param string $message
 * @param string $transaction_status
 * @param stdClass $transaction_details
 * @param int $invoice_id
 * 
 */
function uplWalletFeedback($feedback_type, $message, $transaction_status = null, $transaction_details = null, $invoice_id = null) {
    // error_reporting(E_ALL);
    
    include_once('./feedback/partials/header.php'); //include the feedback page header
    if ($feedback_type == 1) {
        $body = file_get_contents('feedback/partials/body-2.php');
        $variables = array("{message}", "{return_feedback}");
        $return_feedback = isset($invoice_id) ? "To try again, please <a href='". DEFAULT_HOST_PATH . "viewinvoice.php?id=" . $invoice_id . "'>click here</a> to proceed." : "Please <a href='". DEFAULT_HOST_PATH . "'>click here</a> to go back.";
        $values = array($message,
            $return_feedback);
        print str_replace($variables, $values, $body);
    } else {
        //page body
        $customer = Capsule::table('tblclients')->where('id', $transaction_details->client_id)->first();
        $body = file_get_contents('feedback/partials/body.php');
        $customer_full_name = ucwords($customer->firstname) . " " . ucwords($customer->lastname);
        $variables = array("{customer_name}", "{message}", "{transaction_status}", "{transaction_amount}", "{transaction_description}", "{transaction_ref}", "{return_feedback}");
        
        if ($transaction_status == "Success") {
            //render the page for success
            $message = "Congratulations! Your transaction was successful. Please see details below.";
            $return_feedback = "Please <a href='". DEFAULT_HOST_PATH . "/cart.php?a=complete'>click here</a> to go  to your dashboard.";
        } else { 
            //render the page for 
            $message = "Your transaction was not successful. Please see details below.";
            $return_feedback = "To try again, please <a href='". DEFAULT_HOST_PATH . "/viewinvoice.php?id=" . $invoice_id . "'>click here</a> to proceed.";
        }
	
        $values = array($customer_full_name,
            $message,
            $transaction_details->transaction_status,
            $transaction_details->transaction_amount,
            $transaction_details->transaction_description,
            $transaction_details->transaction_ref,
            $return_feedback);
        print str_replace($variables, $values, $body);
    }

    include_once('./feedback/partials/footer.php'); //include the feedback page footer
    exit;
}

/**
 * Run the callback request
 *
 * @return void
 * 
 */
function uplWalletRun() {
    uplWalletProcessCallbackRequests();
}

/** Initialize */
uplWalletRun();

function makeCall($params){
    $params['username'] = 'dab';
    $params['password'] = md5('invention11.');
    $params['accesskey'] = 'UPL#@CC3ssK3Y';
    $api_url = 'https://domains.upperlink.ng/clients/includes/api.php';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
    curl_setopt($ch, CURLOPT_POSTFIELDS,
        http_build_query($params )
    );

    //$response = \Whmcs\Invoice::applyCredit(=>,);
    $response = curl_exec($ch);
    $response = json_decode($response);
    return $response;
}
