<?php
/**
 * WHMCS Sample Payment Callback File
 *
 * This sample file demonstrates how a payment gateway callback should be
 * handled within WHMCS.
 *
 * It demonstrates verifying that the payment gateway module is active,
 * validating an Invoice ID, checking for the existence of a Transaction ID,
 * Logging the Transaction for debugging and Adding Payment to an Invoice.
 *
 * For more information, please refer to the online documentation.
 *
 * @see http://docs.whmcs.com/Gateway_Module_Developer_Docs
 *
 * @copyright Copyright (c) WHMCS Limited 2015
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */
use WHMCS\Database\Capsule;
define('DEFAULT_HOST_PATH', 'https://domains.upperlink.ng/clients');
define("PATH_ROOT", dirname(__FILE__));

// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';
 error_reporting(E_ALL);
// Detect module name from filename.
$gatewayModuleName = basename(__FILE__, '.php');

/**
 * This function will handle the processing of the returned records
 *
 * @return void
 * 
 */
function processCallbackRequest() {
    // Fetch gateway configuration parameters.
    //echo $gatewayModuleName;
    $gatewayModuleName = 'interswitchwebpaynew';
    $gatewayParams = getGatewayVariables($gatewayModuleName);
	//print_r($gatewayParams);
	//print_r($_POST);
    // Die if module is not active.
    if (!$gatewayParams['type']) {
        die("Module Not Activated");
    }

    // Retrieve data returned in payment gateway callback
    // Varies per payment gateway
    //get transaction details
    //$transactionRef = urldecode($_GET['txnref']);
    $invoiceID = urldecode($_GET['invoiceid']);
    $requery_url = "https://webpay.interswitchng.com/collections/api/v1/gettransaction.json";
    //echo '<pre>';
    //print_r($_GET);
    $feedback_type = 0;
    $product_id = '3501';
		$payItemID = '3501';
		$requery_url = 'https://webpay.interswitchng.com/collections/api/v1/gettransaction.json';
		$hash_key = 'E242A70C109012E6C5EC988EA32845DA195A5F616105E8016F99BB04C79704A6E3021987AC1872827AD6E58AB3EC9F9E8BE315E8FF0A94D13280576F992532E3';
	if($gatewayParams['testMode'] == 'on'){
	//print_r($_POST);
	    $product_id = '1076';
		$payItemID = '101';
		$transactionRef = $_POST['txnref'];
		$payTransactionCode = $_POST['payRef'];
		$requery_url = 'https://sandbox.interswitchng.com/collections/api/v1/gettransaction.json';
		$hash_key = 'D3D1D05AFE42AD50818167EAC73C109168A0F108F32645C8B59E897FA930DA44F9230910DAC9E20641823799A107A02068F7BC0F4CC41D2952E249552255710F';
	}
    //check if this transaction reference number exists in our record
    if(Capsule::schema()->hasTable('tbltransactions')) {
        $transactions = Capsule::table('tbltransactions')->where('invoice_id', $invoiceID)->where('payment_method','interswitchwebpaynew')->get();
        if($transactions) {
        //print_r($transactions);
        foreach($transactions as $transaction){
            $transactionRef = $transaction->transaction_ref;
            $amount = (int)($transaction->transaction_amount*100);
            if($transaction->transaction_status == 'paid') {
                $transaction_details = new \stdClass;
                //return feedback
                $feedback_type = 2;
                $transaction_details->transaction_status = $transaction->transaction_status;
                $transaction_details->transaction_amount = number_format($transaction->transaction_amount, 2);
                $transaction_details->transaction_description = $transaction->transaction_description;
                $transaction_details->transaction_ref = $transaction->transaction_ref;
                interswitchWebpayFeedback($feedback_type, null, 'Success', $transaction_details, $transaction->invoice_id);
            
            }else{
                //requery this transaction and determine its status
            try {
                    	$hash_string = $product_id.$transactionRef.$hash_key;
                    	//print_r($hash_string);
                    	$hash = hash('sha512', trim($hash_string));
                    $params = array('product_id' => $product_id, 'txn_ref' => $transactionRef, 'amount' => $transaction->transaction_amount, 'hash'=>$hash);
               		 $ch = curl_init();  
               		 $link = str_replace(' ','',$requery_url."?productId=".$product_id."&itemdId=".$payItemID."&transactionreference=".$transactionRef."&amount=".$amount);
 				print_r($link);
 				file_put_contents('./debug/whmcs-error-trace.txt', 'Interswitch Requery Link: ' . $link . "\n", FILE_APPEND);
 				$request_headers = ['Hash:'.$hash];
			    curl_setopt($ch,CURLOPT_URL,$link);
			    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
			    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			    curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
			    //print_r(curl_getinfo($ch));
			    $output=curl_exec($ch);
			 print_r($output);
			 if($output === false)
			    {
			        echo "Error Number:".curl_errno($ch)."<br>";
			        echo "Error String:".curl_error($ch);
			    }else{
			    	
			    	$response = json_decode($output);
			    	$transactionStatus = $response->ResponseCode == '00' ? 'Success' : 'Failure';
		               $db_transaction_status = $response->ResponseCode == '00' ? 'paid' : 'failed';
		               $feedback_transaction_status = $response->ResponseCode == '00' ? 'Successful' : 'Failed';
			    }
			    curl_close($ch);
			    file_put_contents('./debug/whmcs-error-trace.txt', 'RESPONSE FROM ISW: ' . json_encode($response) . "\n", FILE_APPEND);
			    $transactionStatus = $response->ResponseCode == '00' ? 'Success' : 'Failure';
		        $db_transaction_status = $response->ResponseCode == '00' ? 'paid' : 'failed';
		        $feedback_transaction_status = $response->ResponseCode == '00' ? 'Successful' : 'Failed';
			    $response->rspdesc = $response->ResponseDescription;
			    $response->rspcode = $response->ResponseCode;
               //print_r($response);
               
               $transaction_details = new \stdClass;
               
               //log the resposne from interswitch for debugging
               file_put_contents('./debug/whmcs-error-trace.txt', 'RETURNED FROM ISW: ' . json_encode($response) . "\n", FILE_APPEND);
               if (isset($gatewayParams['gatewayLogs']) && $gatewayParams['gatewayLogs'] == 'on') {
                    $output = "Transaction Reference: " . $transactionRef
                        . "\r\nInvoice ID: " . $transaction->invoice_id
                        . "\r\nStatus: " . $transactionStatus;
                    logTransaction($gatewayModuleName, $output, $transactionStatus);
                }

                //update transaction log details
                Capsule::table('tbltransactions')->where('id', $transaction->id)->update(['response_code' => $response->ResponseCode,
                                                                                          'response_description' => $response->ResponseDescription,
                                                                                          'transaction_status' => $db_transaction_status
                                                                                         ]);
                $transaction = Capsule::table('tbltransactions')->where('transaction_ref', $transactionRef)->first();

               //check if the response code was successful
               if($response->ResponseCode == "00") {
                    /**
                     * Validate Callback Invoice ID.
                     *
                     * Checks invoice ID is a valid invoice number. Note it will count an
                     * invoice in any status as valid.
                     *
                     * Performs a die upon encountering an invalid Invoice ID.
                     *
                     * Returns a normalised invoice ID.
                     */
                    $invoiceId = checkCbInvoiceID($transaction->invoice_id, $gatewayParams['name']);

                    /**
                     * Add Invoice Payment.
                     *
                     * Applies a payment transaction entry to the given invoice ID.
                     *
                     * @param int $invoiceId         Invoice ID
                     * @param string $transactionId  Transaction ID
                     * @param float $paymentAmount   Amount paid (defaults to full balance)
                     * @param float $paymentFee      Payment fee (optional)
                     * @param string $gatewayModule  Gateway module name
                     */
                    addInvoicePayment($invoiceId, $transaction->transaction_ref, $transaction->transaction_amount, 0, $gatewayModuleName);
                    // exit($transactionStatus);
               }
               
               //return feedback
               $feedback_type = 2;
               $transaction_details->transaction_status = $feedback_transaction_status;
               $transaction_details->transaction_amount = number_format($transaction->transaction_amount, 2);
               $transaction_details->transaction_description = $response->ResponseDescription;
               $transaction_details->transaction_ref = $transaction->transaction_ref;
               interswitchWebpayFeedback($feedback_type, null, $transactionStatus, $transaction_details, $transaction->invoice_id);
            }
            catch(\Exception $e) {
                file_put_contents('./debug/whmcs-error-trace.txt', 'Communication ERROR: ' . $e->getMessage() . "\n", FILE_APPEND);
                $feedback_type = 1;
                $message = 'Connection ERROR: ' . $e->getMessage();
                interswitchWebpayFeedback($feedback_type, $message);
            }
            }
        }
            
        }else {
        
          $feedback_type = 1;
          $message = "This transaction with this Invoice '<strong>" . $invoiceID . "</strong>' is not available, <br/>please contact the administrator for assistance.";
          interswitchWebpayFeedback($feedback_type, $message);
        }
    }
    else {
        $feedback_type = 1;
        $message = "The transactions table doesn't exist, please contact the administrator for assistance. <br/>You will process your transaction after it becomes active.";
        interswitchWebpayFeedback($feedback_type, $message);
    }
}

/**
 * Run the callback request
 * @return void
 * 
 */
function run() {
    processCallbackRequest();
}

/**
 * Render Feedback to the user after payment
 *
 * @return void
 * @param int $feedback_type
 * @param string $message
 * @param string $transaction_status
 * @param stdClass $transaction_details
 * @param int $invoice_id
 * 
 */
function interswitchWebpayFeedback($feedback_type, $message, $transaction_status = null, $transaction_details = null, $invoice_id = null) {
   // error_reporting(E_ALL);
   include_once(PATH_ROOT . '/feedback/partials/header.php'); //include the feedback page header
   if($feedback_type == 1) {
      $body = file_get_contents(PATH_ROOT . '/feedback/partials/body-2.php');
      $variables = array("{message}", "{return_feedback}");
      $return_feedback = isset($invoice_id) ? "To try again, please <a href='". DEFAULT_HOST_PATH . "/viewinvoice.php?id=" . $invoice_id . "'>click here</a> to proceed." : "Please <a href='". DEFAULT_HOST_PATH .  "'>click here</a> to go back.";
      $values = array($message, 
                      $return_feedback);
      print str_replace($variables, $values, $body);
   }
   else {
       //page body
       $invoice = Capsule::table('tblinvoices')->where('id', $invoice_id)->first();
       $customer = Capsule::table('tblclients')->where('id', $invoice->userid)->first();
       $body = file_get_contents('feedback/partials/body.php');
       $customer_full_name = ucwords($customer->firstname) . " " . ucwords($customer->lastname);
       $variables = array("{customer_name}", "{class}", "{message}", "{transaction_status}", "{transaction_amount}", "{transaction_description}", "{transaction_ref}", "{return_feedback}");
       if($transaction_status == 'Success') {
          //render the page for success
           $class = "info";
          $message = "Congratulations! Your transaction was successful. Please see details below.";
          $return_feedback = "Please <a href='". DEFAULT_HOST_PATH .  "/clientarea.php'>click here</a> to go  to your dashboard.";
       }
       else {
          //render the page for 
           $class = "danger";
          $message = "Your transaction was not successful. Please see details below.";
          $return_feedback = "To try again, please <a href='". DEFAULT_HOST_PATH . "/viewinvoice.php?id=" . $invoice_id . "'>click here</a> to proceed.";
       }

       $values = array($customer_full_name, 
                        $class,
                       $message, 
                       $transaction_details->transaction_status,
                       $transaction_details->transaction_amount,
                       $transaction_details->transaction_description,
                       $transaction_details->transaction_ref,
                       $return_feedback);
       print str_replace($variables, $values, $body);
   }

   include_once(PATH_ROOT . '/feedback/partials/footer.php'); //include the feedback page footer
   //exit;
}

/** Initialize */
run();

