{if $dnsservice}
{include file="$template/pageheader.tpl" title=$lang.bz_subtitle desc="List all domains"}
<table class="table table-striped table-framed">
    <thead>
        <tr>
            <th class="textcenter"><input type="checkbox"
onclick="toggleCheckboxes('domids')"></th>
            <th class="headerSortasc">Domain</th>
            <th>Created On</th>
            <th>&nbsp;</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="7" class="textcenter">No Records Found</td>
        </tr>
    </tbody>
</table>
{elseif $domainnotfound}
<h1>{$lang.bz_addon_name}</h1>
<form name="br-dnsrecord-manager" method="POST" action="">
<p class="alert alert-block alert-danger">{$lang.bz_warning_before_creating}</p>
<a href="clientarea.php?action=domains" class="btn btn-info">{$lang.bz_button_cancel}</a>
<input type="submit" name="btnCreateZone" class="btn btn-danger" value="{$lang.bz_button_create}"/>
</form>
{elseif $terminated_domain}
{include file="$template/pageheader.tpl" title=$lang.bz_addon_name desc=`$lang.bz_subtitle`&nbsp;`$domain`}
<h1>{$lang.bz_addon_name} <small>{$lang.bz_subtitle} {$domain}</small></h1>
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Terminated DNS zone {$domain}  successfully!</p>
</div>
{elseif $domain}
{include file="$template/pageheader.tpl" title=$lang.bz_addon_name desc=`$lang.bz_subtitle`&nbsp;`$domain`}
{if $update_results}
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Updated DNS record(s) successfully!</p>
</div>
{/if}
{if $delete_results}
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Deleted DNS record(s) successfully!</p>
</div>
{/if}
{if $add_results}
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Added DNS record(s) successfully!</p>
</div>
{/if}
{if $error}
<div class="alert alert-block alert-error">
<p class="textcenter fontsize3">Failed to modify DNS record(s)!</p>
</div>
{/if}
<form name="br-dnsrecord-manager" method="POST" action="">
    <table class="table table-striped table-framed">
    <thead>
        <tr>
            <th>{$lang.bz_hostname}</th>
            <th>{$lang.bz_ttl}</th>
            <th class="textcenter">{$lang.bz_type}</th>
            <th class="textcenter">{$lang.bz_value}</th>
            <th>{$lang.bz_delete}</th>
            <th class="textcenter"><input type="checkbox" onclick="toggleCheckboxes('records')"></th>
        </tr>
    </thead>
    <tbody>
    {foreach from=$dnsrecords item=record}
        <tr>
            <td><input type="text" class="form-control" name="name[]" value="{$record.name}"/></td>
            <td><input style="width:100px;" type="text" class="form-control" name="ttl[]" value="{$record.ttl}"/></td>
            <td class="textcenter"><input type="hidden" name="type[]" value="{$record.type}"/><strong>{$record.type}</strong></td>
            <td style="text-align:right;">
                {if $record.type=='A' || $record.type=='AAAA' || $record.type=='NS' || $record.type=='CNAME' || $record.type=='TXT'}
                Address: <input type="text" class="form-control" name="value[]" value="{$record.value}"/>
                <input type="hidden" class="form-control" name="priority[]" value=""/>
                <input type="hidden" class="form-control" name="port[]" value=""/>
                <input type="hidden" class="form-control" name="weight[]" value=""/>
                {/if}
                {if $record.type=='MX'}
                Address: <input type="text" class="form-control" name="value[]" value="{$record.value}"/><br/>
                Priority: <input type="text" class="form-control" name="priority[]" value="{$record.priority}"/>
                <input type="hidden" class="form-control" name="port[]" value=""/>
                <input type="hidden" class="form-control" name="weight[]" value=""/>
                {/if}
                {if $record.type=='SRV'}
                Address: <input type="text" class="form-control" name="value[]" value="{$record.value}"/><br/>
                Priority: <input type="text" class="form-control" name="priority[]" value="{$record.priority}"/><br/>
                Port: <input type="text" class="form-control" name="port[]" value="{$record.port}"/><br/>
                Weight: <input type="text" class="form-control" name="weight[]" value="{$record.weight}"/>
                {/if}
            </td>
            <td><input type="hidden" name="line[]" value="{$record.Line}"/></td>
            <td class="textcenter"><input class="records" type="checkbox" value="{$record.Line}" name="records[]"></td>
        </tr>
    {/foreach}
    </tbody>
    </table>

    <p class="textcenter">
        <input type="submit" class="btn btn-primary" id="btnSave" name="btnSave" value="{$lang.bz_save_changes}">
        <input type="submit" class="btn btn-primary" id="btnGoogle" name="btnGoogle" value="{$lang.bz_configure_google_apps}">
        <input type="submit" class="btn btn-warning" id="btnRecreateZone" name="btnRecreateZone" value="{$lang.bz_recreate_zone}">
        <input type="submit" class="btn btn-danger" id="btnDeleteZone" name="btnDeleteZone" value="{$lang.bz_delete_zone}"
        onclick="return confirm('{$lang.bz_delete_zone_confirm}');">
    </p>
    <input type="hidden" name="__codename__" value="busyrack"/>

    {literal}
    <script>
        function showDNSOption(value) {
            document.getElementById('br-dnsmanager-priority').style.display = 'none';
            document.getElementById('br-dnsmanager-port').style.display = 'none';
            document.getElementById('br-dnsmanager-weight').style.display = 'none';
            if (value == 'MX') {
                document.getElementById('br-dnsmanager-priority').style.display = '';
            } else if (value == 'SRV') {
                document.getElementById('br-dnsmanager-priority').style.display = '';
                document.getElementById('br-dnsmanager-port').style.display = '';
                document.getElementById('br-dnsmanager-weight').style.display = '';
            }
        }
    </script>
    {/literal}

    <h2>{$lang.bz_add_new_dns_record}</h2>
    <table class="table table-framed">
    <thead>
        <tr>
            <th>{$lang.bz_hostname}</th>
            <th>{$lang.bz_ttl}</th>
            <th>{$lang.bz_type}</th>
            <th class="textcenter">{$lang.bz_value}</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><input style="width:120px;" type="text" class="form-control" name="add_name" value=""/>.{$domain}.</td>
            <td><input style="width:100px;" type="text" class="form-control" name="add_ttl" value="14440"/></td>
            <td>
                <select name="add_type" onchange="showDNSOption(this.value);">
                    <option value="A" selected="selected">A</option>
                    <option value="AAAA">AAAA</option>
                    <option value="MX">MX</option>
                    <option value="CNAME">CNAME</option>
                    <option value="NS">NS</option>
                    <option value="TXT">TXT</option>
                    <option value="SRV">SRV</option>
                </select>
            </td>
            <td style="text-align:right">
            <div>{$lang.bz_address}: <input type="text" name="add_value" value=""/></div>
            <div id="br-dnsmanager-priority" style="display:none;">{$lang.bz_priority}: <input type="text" class="form-control" name="add_priority" value=""/></div>
            <div id="br-dnsmanager-port" style="display:none;">{$lang.bz_port}: <input type="text" class="form-control" name="add_port" value=""/></div>
            <div id="br-dnsmanager-weight" style="display:none;">{$lang.bz_weight}: <input type="text" class="form-control" name="add_weight" value=""/></div>
            </td>
        </tr>
    </tbody>
    </table>

    <p class="textcenter"><input type="submit" class="btn btn-primary" name="btnSave" value="{$lang.bz_save_changes}"></p>

</form>

{else}
<h1>{$lang.bz_addon_name}</h1>
<p class="textcenter">{$lang.bz_domain_invalid}</p>
{/if}

