{literal}
<script>
if (typeof toggleCheckboxes === 'undefined') {
    function toggleCheckboxes(id, value) {
        var items = document.getElementsByName(id);
        for (var i = 0; i < items.length; ++i) {
            items[i].checked = value;
        }
    }
}
if (typeof deleteRecord === 'undefined') {
    function deleteRecord(line) {
        var id = 'records[]';
        var items = document.getElementsByName(id);
        for (var i = 0; i < items.length; ++i) {
            if (items[i].value == line) {
                items[i].checked = true;
            } else {
                items[i].checked = false;
            }
        }
        document.forms["br-dnsrecord-manager"].submit();
        return true;
    }
}
</script>
{/literal}
{if $dnsservice}
<h1>{$lang.bz_addon_name} <small>{$lang.bz_subtitle} List all domains</small></h1>
<table class="table table-striped table-framed">
    <thead>
        <tr>
            <th class="textcenter"><input type="checkbox" onclick="toggleCheckboxes('domids[]')"></th>
            <th class="headerSortasc">Domain</th>
            <th>Created On</th>
            <th>&nbsp;</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="7" class="textcenter">No Records Found</td>
        </tr>
    </tbody>
</table>
{elseif $domainnotfound}
<h1>{$lang.bz_addon_name}</h1>
<form name="br-dnsrecord-manager" method="POST" action="">
<p class="alert alert-block alert-danger">{$lang.bz_warning_before_creating}</p>
<a href="clientarea.php?action=domains" class="btn btn-info">{$lang.bz_button_cancel}</a>
<input type="submit" name="btnCreateZone" class="btn btn-danger" value="{$lang.bz_button_create}"/>
</form>
{elseif $terminated_domain}
<h1>{$lang.bz_addon_name} <small>{$lang.bz_subtitle} {$domain}</small></h1>
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Terminated DNS zone {$domain}  successfully!</p>
</div>
{elseif $domain}
<h1>{$lang.bz_addon_name} <small>{$lang.bz_subtitle} {$domain}</small></h1>
{if $update_results}
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Updated DNS record(s) successfully!</p>
</div>
{/if}
{if $delete_results}
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Deleted DNS record(s) successfully!</p>
</div>
{/if}
{if $add_results}
<div class="alert alert-block alert-success">
<p class="textcenter fontsize3">Added DNS record(s) successfully!</p>
</div>
{/if}
{if $error}
<div class="alert alert-block alert-error">
<p class="textcenter fontsize3">Failed to modify DNS record(s)!</p>
</div>
{/if}
{if $using_outside_dns}
<div class="alert alert-block alert-warning">
<p class="textcenter fontsize3">WARNING!!! Your domain name doesn't have the same nameservers as NS records in this zone.</p>
</div>
{/if}
<form name="br-dnsrecord-manager" method="POST" action="">
    <table class="table table-striped table-framed">
    <thead>
        <tr>
            <th>{$lang.bz_hostname}</th>
            <th>{$lang.bz_ttl}</th>
            <th class="textcenter">{$lang.bz_type}</th>
            <th class="textcenter">{$lang.bz_value}</th>
            <th>{$lang.bz_delete}</th>
            <th class="textcenter"><input type="checkbox" onclick="toggleCheckboxes('records[]', this.checked)"></th>
        </tr>
    </thead>
    <tbody>
    {foreach from=$dnsrecords item=record}
        <tr>
            <td><input class="form-control" style="display: inline;width:auto;" type="text" name="name[]" value="{$record.name}"/></td>
            <td><input class="form-control" style="display: inline;width:auto;" style="width:100px;" type="text" name="ttl[]" value="{$record.ttl}"/></td>
            <td class="textcenter"><input type="hidden" name="type[]" value="{$record.type}"/><strong>{$record.type}</strong></td>
            <td style="text-align:right;">
                {if $record.type=='A' || $record.type=='AAAA' || $record.type=='NS' || $record.type=='CNAME' || $record.type=='TXT' || $record.type=='PTR' || $record.type=='DNAME'}
                Address: <input class="form-control" style="display: inline;width:auto;" type="text" name="value[]" value="{$record.value}"/>
                <input type="hidden" name="priority[]" value=""/>
                <input type="hidden" name="port[]" value=""/>
                <input type="hidden" name="weight[]" value=""/>
                <input type="hidden" name="flag[]" value=""/>
                <input type="hidden" name="tag[]" value=""/>
                {/if}
                {if $record.type=='MX'}
                Address: <input class="form-control" style="display: inline;width:auto;" type="text" name="value[]" value="{$record.value}"/><br/>
                Priority: <input class="form-control" style="display: inline;width:auto;" type="text" name="priority[]" value="{$record.priority}"/>
                <input type="hidden" name="port[]" value=""/>
                <input type="hidden" name="weight[]" value=""/>
                <input type="hidden" name="flag[]" value=""/>
                <input type="hidden" name="tag[]" value=""/>
                {/if}
                {if $record.type=='SRV'}
                Address: <input class="form-control" style="display: inline;width:auto;" type="text" name="value[]" value="{$record.value}"/><br/>
                Priority: <input class="form-control" style="display: inline;width:auto;" type="text" name="priority[]" value="{$record.priority}"/><br/>
                Port: <input class="form-control" style="display: inline;width:auto;" type="text" name="port[]" value="{$record.port}"/><br/>
                Weight: <input class="form-control" style="display: inline;width:auto;" type="text" name="weight[]" value="{$record.weight}"/>
                <input type="hidden" name="flag[]" value=""/>
                <input type="hidden" name="tag[]" value=""/>
                {/if}
                {if $record.type=='CAA'}
                <input type="hidden" name="priority[]" value=""/>
                <input type="hidden" name="port[]" value=""/>
                <input type="hidden" name="weight[]" value=""/>
                Flags: <input class="form-control" style="display: inline;width:auto;" type="text" name="flag[]" value="{$record.flag}"/><br/>
                Tag: <input class="form-control" style="display: inline;width:auto;" type="text" name="tag[]" value="{$record.tag}"/><br/>
                Issuer: <input class="form-control" style="display: inline;width:auto;" type="text" name="value[]" value="{$record.value}"/>
                {/if}
            </td>
            <td>
                <input type="hidden" name="line[]" value="{$record.Line}"/>
                <button type="button" class="btn btn-danger btn-sm" name="btnSave" value="{$lang.bz_save_changes}" onclick="return deleteRecord({$record.Line})">[x]</button>
            </td>
            <td class="textcenter"><input class="records" type="checkbox" value="{$record.Line}" name="records[]"></td>
        </tr>
    {/foreach}
    </tbody>
    </table>

    <p class="textcenter">
        <input type="submit" class="btn btn-primary" id="btnSave" name="btnSave" value="{$lang.bz_save_changes}">
        {if $settings.one_click_apps_google}
        <input type="submit" class="btn btn-info" id="btnGoogle" name="btnGoogle" value="{$lang.bz_configure_google_apps}">
        {/if}
        {if $settings.one_click_apps_office365}
        <input type="submit" class="btn btn-info" id="btnOffice365" name="btnOffice365" value="{$lang.bz_configure_office365}">
        {/if}
        <input type="submit" class="btn btn-warning" id="btnRecreateZone" name="btnRecreateZone" value="{$lang.bz_recreate_zone}"
        onclick="return confirm('{$lang.bz_recreate_zone_confirm}');">
        <input type="submit" class="btn btn-danger" id="btnDeleteZone" name="btnDeleteZone" value="{$lang.bz_delete_zone}"
        onclick="return confirm('{$lang.bz_delete_zone_confirm}');">
    </p>
    <input type="hidden" name="__codename__" value="busyrack"/>

    {literal}
    <script>
        function showDNSOption(value) {
            document.getElementById('br-dnsmanager-priority').style.display = 'none';
            document.getElementById('br-dnsmanager-port').style.display = 'none';
            document.getElementById('br-dnsmanager-weight').style.display = 'none';
            document.getElementById('br-dnsmanager-flag').style.display = 'none';
            document.getElementById('br-dnsmanager-tag').style.display = 'none';
            if (value == 'MX') {
                document.getElementById('br-dnsmanager-priority').style.display = '';
            } else if (value == 'SRV') {
                document.getElementById('br-dnsmanager-priority').style.display = '';
                document.getElementById('br-dnsmanager-port').style.display = '';
                document.getElementById('br-dnsmanager-weight').style.display = '';
            } else if (value == 'CAA') {
                document.getElementById('br-dnsmanager-flag').style.display = '';
                document.getElementById('br-dnsmanager-tag').style.display = '';
            }
        }
    </script>
    {/literal}

    <h2>{$lang.bz_add_new_dns_record}</h2>
    <table class="table table-framed">
    <thead>
        <tr>
            <th>{$lang.bz_hostname}</th>
            <th>{$lang.bz_ttl}</th>
            <th>{$lang.bz_type}</th>
            <th class="textcenter">{$lang.bz_value}</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><input class="form-control" style="display: inline;width:auto;" style="width:120px;" type="text" name="add_name" value=""/>.{$domain}.</td>
            <td><input class="form-control" style="display: inline;width:auto;" style="width:100px;" type="text" name="add_ttl" value="14440"/></td>
            <td>
                <select name="add_type" onchange="showDNSOption(this.value);">
                    <option value="A" selected="selected">A</option>
                    <option value="AAAA">AAAA</option>
                    <option value="MX">MX</option>
                    <option value="CAA">CAA</option>
                    <option value="CNAME">CNAME</option>
                    <option value="DNAME">DNAME</option>
                    <option value="NS">NS</option>
                    <option value="TXT">TXT</option>
                    <option value="SRV">SRV</option>
                    <option value="PTR">PTR</option>
                </select>
            </td>
            <td style="text-align:right">
            <div>{$lang.bz_address}: <input class="form-control" style="display: inline;width:auto;" type="text" name="add_value" value=""/></div>
            <div id="br-dnsmanager-priority" style="display:none;">{$lang.bz_priority}: <input class="form-control" style="display: inline;width:auto;" type="text" name="add_priority" value=""/></div>
            <div id="br-dnsmanager-port" style="display:none;">{$lang.bz_port}: <input class="form-control" style="display: inline;width:auto;" type="text" name="add_port" value=""/></div>
            <div id="br-dnsmanager-weight" style="display:none;">{$lang.bz_weight}: <input class="form-control" style="display: inline;width:auto;" type="text" name="add_weight" value=""/></div>
            <div id="br-dnsmanager-flag" style="display:none;">{$lang.bz_flag}: <input class="form-control" style="display: inline;width:auto;" type="text" name="add_flag" value=""/></div>
            <div id="br-dnsmanager-tag" style="display:none;">{$lang.bz_tag}: <input class="form-control" style="display: inline;width:auto;" type="text" name="add_tag" value=""/></div>
            </td>
        </tr>
    </tbody>
    </table>

    <p class="textcenter"><input type="submit" class="btn btn-primary" name="btnSave" value="{$lang.bz_save_changes}"></p>

</form>

{else}
<h1>{$lang.bz_addon_name}</h1>
<p class="textcenter">{$lang.bz_domain_invalid}</p>
{/if}
