<?php

namespace MGModule\DomainAndEmailForwarding\submodules\DirectAdmin\Models;

use MGModule\DomainAndEmailForwarding\submodules\DirectAdmin\Api as Api;

class Emails extends Api
{

    /**
     * Fetch all the forwarders
     * @param string $domain
     * @return array array(array('user' => 'destination email'))
     */
    public function fetch($domain = null)
    {
        $domain = $this->getDomain($domain);
        $this->sock->query('/CMD_API_EMAIL_FORWARDERS', array(
            'action' => 'list',
            'domain' => $domain
        ));
        $rows   = $this->sock->fetch_parsed_body();
        return $rows;
    }

    /**
     * Create a forwarder
     * @param string $user
     * @param string $email
     * @param string $domain
     * @return bool
     */
    public function create($user, $email, $domain = null)
    {
        $domain = $this->getDomain($domain);
        $this->sock->query('/CMD_API_EMAIL_FORWARDERS', array(
            'action' => 'create',
            'domain' => $domain,
            'user'   => $user,
            'email'  => $email,
        ));
        $ret    = $this->sock->fetch_parsed_body();
        return isset($ret['error']) && $ret['error'] == 0;
    }

    /**
     * Delete an user
     * @param string $user
     * @param string $domain
     * @return bool
     */
    public function delete($user, $domain = null)
    {
        $domain = $this->getDomain($domain);
        $this->sock->query('/CMD_API_EMAIL_FORWARDERS', array(
            'action'  => 'delete',
            'domain'  => $domain,
            'user'    => $user,
            'select0' => $user
        ));
        $ret    = $this->sock->fetch_parsed_body();
        return isset($ret['error']) && $ret['error'] == 0;
    }
}
