<?php

namespace MGModule\DomainAndEmailForwarding\submodules\DirectAdmin\Models;

use MGModule\DomainAndEmailForwarding\submodules\DirectAdmin\Api as Api;

class Domains extends Api
{

    /**
     * Add domain forward
     * @param type $params
     */
    public function addForward($params)
    {
        $domain = $this->getDomain($domain);
        
        
        $this->sock->query('/CMD_API_REDIRECT', array(
            'action' => 'add',
            'domain' => $domain,
            'from'   => $params['src'],
            'to'     => $params['url'],
            'type'   => $params['type']
        ));

        $this->sock->fetch_parsed_body();
    }

    /**
     * List domain forwarding
     * @return array
     */
    public function listForward()
    {
        $domain = $this->getDomain($domain);

        $this->sock->query('/CMD_API_REDIRECT', array(
            'domain'     => $domain,
            'apitype'    => 'yes',
            'urlencoded' => 'yes'
        ));

        $list = $this->sock->fetch_parsed_body();
        return $list;
    }

    /**
     * Delete existing domain forward.
     * @param type $redirect
     */
    public function deleteForward($redirect)
    {
        $domain = $this->getDomain($domain);

        $request = array(
            'action' => 'delete',
            'domain' => $domain
        );

        $request['select0'] = $redirect;

        $this->sock->query('/CMD_API_REDIRECT', $request);
        $this->sock->fetch_parsed_body();
    }

    /**
     * Park domain.
     */
    public function parkDomain()
    {
        $domain = $this->getDomain($domain);

        $request = array(
            'action' => 'create',
            'domain' => $domain,
            'uquota'        => 'unlimited',
            'ubandwidth'    => 'unlimited'

        );

        $this->sock->query('/CMD_API_DOMAIN', $request);
        $this->sock->fetch_parsed_body();
    }

    /**
     * Unpark domain.
     */
    public function unparkDomain()
    {
        $domain = $this->getDomain($domain);

        $request = array(
            'delete'    => 'yes',
            'confirmed' => 'Confirm',
            'select0'   => $domain,
        );

        $this->sock->query('/CMD_API_DOMAIN', $request);
        $result = $this->sock->fetch_parsed_body();
        if (strpos($result['details'], 'You do not own') !== false)
        {
            throw new \Exception($result['details']);
        }
    }

    /**
     * Check domain parked
     */
    public function checkStatusParkDomain()
    {
        $domain = $this->getDomain($domain);

        $request = array(
            'action' => 'view',
            'domain' => $domain,
        );

        $this->sock->query('/CMD_API_ADDITIONAL_DOMAINS', $request);
        $result = $this->sock->fetch_parsed_body();
        if (!empty($result) && $result['domain'] == $domain)
        {
            return true;
        }
        return false;
    }
}
