<?php

/* * ********************************************************************
 * DomainAndEmailForwarding product developed. (2016-06-30)
 * *
 *
 *  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
 *  CONTACT                        ->       contact@modulesgarden.com
 *
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software  or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 *
 * ******************************************************************** */

namespace MGModule\DomainAndEmailForwarding\service;

use MGModule\DomainAndEmailForwarding as main;

/**
 * Description of IntegrationManager
 *
 * @author Pawel Kopec <pawelk@modulesgarden.com>
 */
class IntegrationManager
{

    public function scanModules()
    {

        $data  = [];
        $dir   = dirname(__FILE__) . DS . ".." . DS . 'submodules';
        $files = scandir($dir);
        foreach ($files as $file)
        {
            if (preg_match("/.php$/", $file))
            {
                $className = str_replace(".php", "", $file);
                $data[]    = $className;
            }
        }
        return $data;
    }

    /**
     *
     * @return IntegrationAdapter[]
     */
    public function getModules()
    {
        $data = [];
        foreach ($this->scanModules() as $className)
        {
            $data[] = $this->getModule($className);
        }
        return $data;
    }

    /**
     *
     * @return array
     */
    public function getAssocModules()
    {
        $data = [];
        foreach ($this->scanModules() as $className)
        {
            $submodule                 = $this->getSubmoduleConfiguration($className);
            $data[$submodule->getId()] = $submodule->getClassName();
        }
        return $data;
    }

    /**
     *
     * @return IntegrationModule
     */
    public function getModule($className)
    {
        $fullName = "MGModule\DomainAndEmailForwarding\submodules\\" . $className;
        $entity   = new $fullName();
        $entity->setClassName($className);
        $entity->loadOptions($this->getSubmoduleConfiguration($className));
        return $entity;
    }

    /**
     *
     * @param string $className
     * @return \MGModule\DomainAndEmailForwarding\models\SubmoduleConfiguration
     */
    public function getSubmoduleConfiguration($className)
    {
        $repository = new main\repository\SubmoduleConfigurationRepository();
        $repository->whereClass($className);
        if ($repository->count())
        {
            return $repository->fetchOne();
        }
        return new main\models\SubmoduleConfiguration();
    }

    public function activate(IntegrationModule $module)
    {

        $submodule = $this->getSubmoduleConfiguration($module->getClassName());
        $submodule->setName($module->getName())
            ->setClassName($module->getClassName())
            ->setVersion($module->getVersion())
            ->setActive("1")
            ->save();

        return $submodule;
    }

    public function deactivate(IntegrationModule $module)
    {

        $submodule = $this->getSubmoduleConfiguration($module->getClassName());
        $submodule->setName($module->getName())
            ->setClassName($module->getClassName())
            ->setVersion($module->getVersion())
            ->setActive("0")
            ->save();

        return $submodule;
    }

    /**
     *
     * @param \MGModule\DomainAndEmailForwarding\models\whmcs\Domain $domain
     * @return IntegrationModule
     */
    public function getActiveModule(main\models\whmcs\Domain $domain)
    {
        $repository    = new main\repository\SubmoduleConfigurationRepository();
        $submoduleId   = $domain->domainPricing()->domainSetting()->getSubmodule();
        if(!$submoduleId)
        {
            return;
        }
        $submoduleConf = new main\models\SubmoduleConfiguration($submoduleId);

        if (!$submoduleConf->isActive())
        {
            return;
        }
        $conf = $repository->findActive($domain->domainPricing()->domainSetting()->getSubmodule())->fetchOne();
        return $this->getModule($conf->getClassName());
    }
}
