<?php

namespace MGModule\DomainAndEmailForwarding\mgLibs\helpers;

use MGModule\DomainAndEmailForwarding\models\whmcs\clients\Client;
use MGModule\DomainAndEmailForwarding\models\whmcs\Domain;

/**
 * Class Logger
 *
 * @author Artur Pilch <artur.pi@modulesgarden.com>
 */
class Logger
{
    public static function getUserUrl($userId)
    {
        $client = new Client($userId);

        return sprintf('<a href="clientssummary.php?userid=%s">#%s %s</a>', $userId, $userId, $client->getFullName());
    }

    public static function getDomainUrl($userId, $domainId)
    {
        $domain = new Domain($domainId);
        return sprintf('<a href="clientsdomains.php?userid=%s&id=%s">#%s %s</a>', $userId, $domainId, $domainId, $domain->getDomain());
    }


}