<?php

namespace api\controller;

use \MGModule\DomainAndEmailForwarding as main;
use api\helper\ApiHelper as Helper;
use MGModule\DomainAndEmailForwarding\mgLibs\MySQL\Query;
use MGModule\DomainAndEmailForwarding\mgLibs\process\MainInstance;

require_once dirname(dirname(dirname(dirname(dirname(__DIR__))))) . '/init.php';
require_once dirname(__DIR__) . '/helper/ApiHelper.php';



class Api
{
    static private $_instance;
    private        $_api;
    public static  $router;

    static function I()
    {
        Query::useCurrentConnection();
        MainInstance::setInstanceName('MGModule\DomainAndEmailForwarding\Addon');
        if (empty(self::$_instance))
        {
            self::$_instance       = new self();
            self::$_instance->_api = new \api\controller\Api();
        }

        return self::$_instance;
    }

    function displayJsonFromArray($ArrayToJson)
    {
        $JSONDisplay = json_encode($ArrayToJson, JSON_PRETTY_PRINT);
        header('Content-Type: application/json');
        print_r($JSONDisplay);
        die;
    }

    function API($method, $params = [])
    {
        $check = $this->authenticate();
        if (isset($check['error']))
        {
            $this->displayJsonFromArray($check);
        }
        $apiHelper = new Helper();
        $this->displayJsonFromArray($apiHelper->{$method}($params));
    }

    private function authenticate()
    {
        $token = $this->getHeaderToken();
        $ip    = $this->getRealIpAddr();

        $token = Query::select(['token', 'ips'], 'mgdomforw_tokenAccess', ['token' => $token])->fetch();
        if (!$token)
        {
            return ['error' => 'You have no access to this site!'];
        }
        if (!$this->checkForIpExist($ip, $token['ips']))
        {
            return ['error' => 'You have no access to this site! Contact admin to add your ip into your token!'];
        }
        return;

    }

    private function checkForIpExist($ip, $tokenIPs)
    {
        $exploded = $this->multiexplode(["\n", ","], $tokenIPs);
        return in_array($ip, $exploded);
    }

    private function getHeaderToken()
    {
        $headers = $this->getHeaders();
        return $headers['Token'];
    }

    private function getHeaders()
    {
        if (!is_array($_SERVER))
        {
            return [];
        }
        $headers = [];
        foreach ($_SERVER as $name => $value)
        {
            if (substr($name, 0, 5) == 'HTTP_')
            {
                $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
            }
        }
        return $headers;
    }

    function multiexplode($delimiters, $string)
    {
        $ready  = str_replace($delimiters, $delimiters[0], $string);
        $launch = explode($delimiters[0], $ready);
        return $launch;
    }

    private function getRealIpAddr()
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
        {
            return $_SERVER['HTTP_CLIENT_IP'];
        }
        else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
        {
            return $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        return $_SERVER['REMOTE_ADDR'];
    }



}