<?php
/**
 * Primary Navigation Bar Customisation 
 *
 * Please refer to the documentation @ http://docs.whmcs.com/Hooks for more information
 * The code in this hook is commented out by default. Uncomment to use.
 *
 * @package    WHMCS
 * @author     Megafu Charles Nonso <charles.megafu@upperlink.ng>
 * @copyright  Copyright (c) WHMCS Limited 2005-2013
 * @license    http://www.whmcs.com/license/ WHMCS Eula
 * @version    $Id$
 * @link       http://www.whmcs.com/
 */


if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

use WHMCS\View\Menu\Item as MenuItem;
 
add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar)
{
	$client = Menu::context('client');

	if(!$client) {
       //remove items 
	    if(!is_null($primaryNavbar->getChild('Announcements'))) {
	    	$primaryNavbar->removeChild('Announcements');
	    }

	    if($primaryNavbar->getChild('Knowledgebase')) {
	    	$primaryNavbar->removeChild('Knowledgebase');
	    }

	    if($primaryNavbar->getChild('Network Status')) {
	    	$primaryNavbar->removeChild('Network Status');
	    }

	    $homeItem = $primaryNavbar->getChild('Home');
	    if (!is_null($homeItem)) {
	        //set a new icon for the home link
	        $homeItem->setIcon('fa-home');
	        $homeItem->setOrder(1);
	    }

	    //add hosting and services 
	    $primaryNavbar->addChild('Hosting & Services')
	        ->setUri('#')
	        ->setOrder(2)
	        ->setIcon('fa-server');

	    if (!is_null($primaryNavbar->getChild('Hosting & Services'))) {
	        $primaryNavbar->getChild('Hosting & Services')
	            ->addChild('My Hosting & Services', array(
	                'label' => 'My Hosting & Services',
	                'uri' => 'clientarea.php?action=products',
	                'order' => '100',
	            ));
	        $primaryNavbar->getChild('Hosting & Services')->addChild('Order New Hosting/Services', array(
	            	'label' => 'Order New Hosting/Services',
	            	'uri' => 'cart.php',
	            	'order' => '200',
	            ));
	        $primaryNavbar->getChild('Hosting & Services')->addChild('View Available Addons', array(
	            	'label' => 'View Available Addons',
	            	'uri' => 'cart.php?gid=addons',
	            	'order' => '300',
	            ));
	    }

	    //add Domains
	    $primaryNavbar->addChild('Domains')
	        ->setUri('#')
	        ->setOrder(3)
	        ->setIcon('fa-globe');

	    if (!is_null($primaryNavbar->getChild('Domains'))) {
	        $primaryNavbar->getChild('Domains')
	            ->addChild('My Domains', array(
	                'label' => 'My Domains',
	                'uri' => 'clientarea.php?action=domains',
	                'order' => '400',
	            ));
	        $primaryNavbar->getChild('Domains')->addChild('Renew Domains', array(
	            	'label' => 'Renew Domains',
	            	'uri' => 'cart.php?gid=renewals',
	            	'order' => '500',
	            ));
	        $primaryNavbar->getChild('Domains')->addChild('View Available Addons', array(
	            	'label' => 'Register a New Domain',
	            	'uri' => 'cart.php?a=add&domain=register',
	            	'order' => '600',
	            ));

	        $primaryNavbar->getChild('Domains')->addChild('Domain Search', array(
	            	'label' => 'Domain Search',
	            	'uri' => 'domainchecker.php',
	            	'order' => '700',
	            ));
	    }

	        //add Billing
	    $primaryNavbar->addChild('Billing')
	        ->setUri('#')
	        ->setOrder(4)
	        ->setIcon('fa-money');

	    if (!is_null($primaryNavbar->getChild('Billing'))) {
	        $primaryNavbar->getChild('Billing')
	            ->addChild('My Invoices', array(
	                'label' => 'My Invoices',
	                'uri' => 'clientarea.php?action=invoices',
	                'order' => '100',
	            ));
	        $primaryNavbar->getChild('Billing')->addChild('My Quotes', array(
	            	'label' => 'My Quotes',
	            	'uri' => 'clientarea.php?action=quotes',
	            	'order' => '200',
	            ));
	        $primaryNavbar->getChild('Billing')->addChild('Add Funds', array(
	            	'label' => 'Add Funds',
	            	'uri' => 'clientarea.php?action=addfunds',
	            	'order' => '300',
	            ));

	    

	        // $primaryNavbar->getChild('Billing')->addChild('Domain Search', array(
	        //     	'label' => 'Domain Search',
	        //     	'uri' => 'domainchecker.php',
	        //     	'order' => '700',
	        //     ));

	        // $primaryNavbar->getChild('Hosting & Services')->addChild('Manage DNS', array(
	        //     	'label' => 'Manage DNS',
	        //     	'uri' => 'index.php?',
	        //     	'order' => '800',
	        //     ));


	    }

	    $primaryNavbar->addChild('Support')
	        ->setUri('javascript:void(0)')
	        ->setOrder(5)
	        ->setIcon('fa-support');

	    if (!is_null($primaryNavbar->getChild('Support'))) {
	        $primaryNavbar->getChild('Support')
	            ->addChild('Tickets', array(
	                'label' => 'Tickets',
	                'uri' => 'supporttickets.php',
	                'order' => '100',
	            ));
	        $primaryNavbar->getChild('Support')->addChild('Knowledgebase', array(
	            	'label' => 'Knowledgebase',
	            	'uri' => 'knowledgebase.php',
	            	'order' => '200',
	            ));
	        $primaryNavbar->getChild('Support')->addChild('Announcements', array(
	            	'label' => 'Announcements',
	            	'uri' => 'announcements.php',
	            	'order' => '300',
	            ));
	        $primaryNavbar->getChild('Support')->addChild('Downloads', array(
	            	'label' => 'Downloads',
	            	'uri' => 'downloads.php',
	            	'order' => '400',
	            ));

	        $primaryNavbar->getChild('Support')->addChild('Network Status', array(
	            	'label' => 'Network Status',
	            	'uri' => 'serverstatus.php',
	            	'order' => '500',
	            ));
             $primaryNavbar->getChild('Support')->addChild('Reseller API Key', array(
            	'label' => 'Reseller API Key',
            	'uri' => 'reseller_api.php',
            	'order' => '600',
            ));
	    }

	    $primaryNavbar->addChild('Open Ticket')
	        ->setUri('submitticket.php')
	        ->setOrder(6)
	        ->setIcon('fa-folder-open-o');
	}
	else {
		//add folder icon to the open ticket 
		$openTicketItem = $primaryNavbar->getChild('Open Ticket');
	    if($openTicketItem) {
	    	$openTicketItem->setIcon('fa-folder-open-o');
	    }

	    //edit the services section
	    $servicesItem = $primaryNavbar->getChild('Services');
	    if($servicesItem) {
	    	$servicesItem->setLabel('Hosting & Services');
	    	$servicesItem->setIcon('fa-server');
	    	$myServicesItem = $servicesItem->getChild('My Services');
	    	if($myServicesItem) {
	    		$myServicesItem->setLabel('My Hosting & Services');
	    	}
	    }

	    //edit domains section
	    $domainsItem = $primaryNavbar->getChild('Domains');
	    if($domainsItem) {
	    	$domainsItem->setIcon('fa-globe');
	    }

	    $homeItem = $primaryNavbar->getChild('Home');
	    if($homeItem) {
	    	$homeItem->setIcon('fa-home');
	    }

	    $billingItem = $primaryNavbar->getChild('Billing');
	    if($billingItem) {
	    	$billingItem->setIcon('fa-money');
	    }

	    $supportItem = $primaryNavbar->getChild('Support');
	    if($supportItem) {
	    	$supportItem->setIcon('fa-support');
	    	
	    	$primaryNavbar->getChild('Support')->addChild('Reseller API Key', array(
            	'label' => 'Reseller API Key',
            	'uri' => 'reseller_api.php',
            	'order' => '600',
            ));
	    }
	}
});