<?php



/**

 * WHMCS API Wrapper PHP Library

 *

 * @author      Bankole Olaoluwa

 * @copyright   2016 Bankork

 * @link        olaoluwa.bankole@upperlink.ng

 * @license     MIT LICENSE

 * @version     1.0.0

 * @package     Whmcs

 * 

 */



namespace Whmcs;



class Domain extends \Whmcs\Api {



    /**

     * Sends a register command to the registrar

     *

     * @see http://docs.whmcs.com/API:Register_Domain

     */

    public static function registerDomain($params = array()) {

        $params['action'] = 'DomainRegister';

        return self::sendRequest($params);

    }



    /**

     * Sends a renew command to the registrar

     *

     * @see http://docs.whmcs.com/API:Renew_Domain

     */

    public static function renewDomain($params = array()) {

        $params['action'] = 'DomainRenew';

        return self::sendRequest($params);

    }



    /**

     * Sends a transfer command to the registrar

     *

     * @see http://docs.whmcs.com/API:Transfer_Domain

     */

    public static function transferDomain($params = array()) {

        $params['action'] = 'DomainTransfer';

        return self::sendRequest($params);

    }



    /**

     * Sends a release command to the registrar

     *

     * @see http://docs.whmcs.com/API:Release_Domain

     * @see http://www.nominet.org.uk/registrars/becomeregistrar/taglist/

     */

    public static function releaseDomain($params = array()) {

        $params['action'] = 'DomainRelease';

        return self::sendRequest($params);

    }



    /**

     * Obtain the lock state of a domain name

     *

     * @see http://docs.whmcs.com/API:Domain_Locking_Status

     */

    public static function getDomainLock($params = array()) {

        $params['action'] = 'DomainGetLockingStatus';

        return self::sendRequest($params);

    }



    /**

     * Obtain the nameservers of a domain name

     *

     * @see http://docs.whmcs.com/API:Domain_Nameservers

     */

    public static function getNameservers($params = array()) {

        $params['action'] = 'DomainGetNameservers';

        return self::sendRequest($params);

    }



    /**

     * Obtain the whois of a domain name

     *

     * @see http://docs.whmcs.com/API:Get_Domain_WHOIS

     */

    public static function getWhois($params = array()) {

        $params['action'] = 'DomainGetWhoisInfo';

        return self::sendRequest($params);

    }



    /**

     * Obtain the EPP Code of a domain name

     *

     * @see http://docs.whmcs.com/API:Domain_EPP

     */

    public static function requestEpp($params = array()) {

        $params['action'] = 'DomainRequestEpp';

        return self::sendRequest($params);

    }



    /**

     * Toggle ID protect for a domain name

     *

     * @see http://docs.whmcs.com/API:Toggle_ID_Protect

     */

    public static function toggleIdProtect($params = array()) {

        $params['action'] = 'DomainToggleIdProtect';

        return self::sendRequest($params);

    }



    /**

     * Update the lock state of a domain name

     *

     * @see http://docs.whmcs.com/API:Domain_Update_Lock

     */

    public static function updateLock($params = array()) {

        $params['action'] = 'DomainUpdateLockingStatus';
        return self::sendRequest($params);

    }



    /**

     * Update the nameservers of a domain name

     *

     * @see http://docs.whmcs.com/API:Domain_Update_Nameservers

     */

    public static function updateNameservers($params = array()) {

        $params['action'] = 'DomainUpdateNameservers';

        return self::sendRequest($params);

    }



    /**

     * Update the contact information on a domain name

     *

     * @see http://docs.whmcs.com/API:Domain_Update_WHOIS

     */

    public static function updateWhois($params = array()) {
        $xml = new \SimpleXMLElement('contactdetails');
        switch($params['contactType']){
            case 'registrant':
                $contact = \Whmcs\Client::getContacts(['contactid', $params['clid']]);
                $xml->addChild('Registrant','' );
                break;
            case 'admin':

                break;
            case 'billing':

                break;
            case 'tech';

            break;
        }
        $params['action'] = 'DomainUpdateWhoisInfo';

        return self::sendRequest($params);

    }



    /**

     * Perform a whois lookup for a domain name

     *

     * @see http://docs.whmcs.com/API:Domain_WHOIS

     */

    public static function domainWhois($params = array()) {

        $params['action'] = 'DomainWhois';
        $params['domain'] = $params['name'];

        return self::sendRequest($params);

    }

    public static function getDomainInfo($params = array()){
        if(is_array($params)){
            $params['action'] = 'GetClientsDomains';
            $params['domain'] = $params['name'];
            $userDomain = self::sendRequest($params);
            if($userDomain['WHMCSAPI']['RESULT'] == 'success'){
                $domainid = $userDomain['WHMCSAPI']['DOMAINS']['DOMAIN']['ID'];
                $new_params = array('action'=>'DomainGetWhoisInfo','domainid'=>$domainid);
                return self::getWhois($new_params);
            }

        }
    }



}

