<?php



/**

 * WHMCS API Wrapper PHP Library

 *

 * @author      Bankole Olaoluwa

 * @copyright   2016 Bankork

 * @link        olaoluwa.bankole@upperlink.ng

 * @license     MIT LICENSE

 * @version     1.0.0

 * @package     Whmcs

 * 

 */



namespace Whmcs;


use SimpleXMLElement;
define("API_KEY_ID", "fQvDxwUGXmA=");

define("API_SECRET_KEY", "4RLnRGEZnoRipgvzbe5HQ+JK0quJU60xwl/N/I9a7/GhM0M3PIuNgU6BHKcq0VWTlm8j4qbtG17TMexQKRlbjA==");

define("API_VERSION", "20161220");

define("USER_KEY_ID", "RUQ4OEM3QVI5R0tHNjM3NDlM");



define("API_URL", "https://domains.upperlink.ng/clients/includes/api.php"); # URL to WHMCS API file goes here

define("API_USERNAME", "bankork"); # Admin username goes here

define("API_PASSWORD", "B@#k0rk"); # Admin password goes here

define("API_ACCESSKEY", "UPL#@CC3ssK3Y"); # Access key goes here



/**

 * Api

 */

class Api {



    /**

     * @var The URL to the WHMCS API

     */

    public static $api_url;



    /**

     * @var The username for the authentication to the WHMCS API

     */

    public static $api_username;



    /**

     * @var The password for the authentication to the WHMCS API

     */

    public static $api_password;



    /**

     * @var The access key to use for WHMCS API calls

     */

    public static $api_access_key;



    /**

     * @var The response type to use for WHMCS API calls

     */

    public static $responsetype;



    /**

     * Sets the WHMCS API settings

     *

     * @param string $api_url        The url to the WHMCS API

     * @param string $api_username   The username for the API to authenticate using

     * @param string $api_password   The password for the API to authenticate using

     * @param string $api_access_key The access key for the API to use

     *

     * @throws Exception

     * @return void

     */

    public static function init($api_username, $api_password, $api_access_key = null) {

        if (empty($api_username) || empty($api_password)) {

            throw new \Whmcs\Exception('Must set WHMCS API username, and password settings.');

        }



        self::$api_url = API_URL;

        self::$api_username = $api_username;

        self::$api_password = md5($api_password);

        self::$responsetype = "xml";
        //self::$responsetype = "json";



        if (!empty($api_access_key)) {

            self::$api_access_key = $api_access_key;

        } else {

            self::$api_access_key = API_ACCESSKEY;

        }

    }



    /**

     * Sends an API request to the WHMCS API

     *

     * @param array $params The parameters to pass to WHMCS

     * 

     * @throws Exception

     * @return mixed

     */

    public static function sendRequest($params = array()) {

        if (empty(self::$api_url) || empty(self::$api_username) || empty(self::$api_password)) {

            throw new \Whmcs\Exception('Must set WHMCS API username, and password settings.');

        }



        if (empty($params['action'])) {

            throw new \Whmcs\Exception('No API action set.');

        }



        if (!empty(self::$api_access_key)) {

            $params['accesskey'] = self::$api_access_key;

        }



        //add constants

        $params['version'] = API_VERSION;

        $params['keyId'] = API_KEY_ID;

        $params['username'] = self::$api_username;

        $params['password'] = self::$api_password;

        //$params["accesskey"] = API_ACCESSKEY;

        $params["responsetype"] = self::$responsetype;





        // Sort arguments

        ksort($params);

        // Generate string for sign

        $string2sign = "";

        foreach ($params as $k => $v) {

            $string2sign .= @"{$k}{$v}";

        }



        // Generate signature

        $params['signature'] = base64_encode(hash_hmac('sha1', $string2sign, API_SECRET_KEY, 1));



        // Build query

        $query = http_build_query($params);

        //$params = http_build_query($params, null, '&');

        //echo "<br> -------------------- <br>";

        //print_r($query);

        return self::ExecuteURLQuery($query);

    }



    //============= Execute URL Query ======================== //

    private static function ExecuteURLQuery($query) {



        try {

            $secretKey = API_SECRET_KEY;

            $url = self::$api_url; //API_URL;


            //print_r($query);
            parse_str($query);

            $sign = trim($signature);

            $hashval = $sign . "" . $secretKey;

            $dhash = hash('sha512', $hashval);



            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, $url);

            curl_setopt($ch, CURLOPT_POST, 1);

            curl_setopt($ch, CURLOPT_TIMEOUT, 30);

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

            curl_setopt($ch, CURLOPT_POSTFIELDS, $query);

            curl_setopt($ch, CURLOPT_HTTPHEADER, array('UpperlinkAuth: ' . $dhash));

            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

            $xml = curl_exec($ch);

            $response_info = curl_getinfo($ch);
            print_r($xml);
            print_r(curl_error($ch));
            //$xml = json_decode($xml);
            //----- if there is error ------------ //
            file_put_contents('../debug/whmcs-error-trace.txt', 'API Response: ' . json_encode($response_info) . "\n", FILE_APPEND);
            if (curl_error($ch) || !$xml) {

                $xml = '<whmcsapi><result>error</result>' .

                    '<message>Connection Error</message><curlerror>' .

                    curl_errno($ch) . ' - ' . curl_error($ch) . '</curlerror></whmcsapi>';


            }elseif ($response_info['http_code'] >= 400) {

                $xml = '<whmcsapi><result>error</result>' .

                    '<message>Unknown error with request</message><curlerror>' .

                    $response_info["http_code"] . '</curlerror></whmcsapi>';
            }

            curl_close($ch);

            //print $xml;
            //print_r(self::array_to_xml($xml));
            $arr = self::whmcsapi_xml_parser($xml); # Parse XML


            //print_r($xml);

            //echo "<br>---------------<br>";

            print_r($arr); 

            //return $xml;

            return $arr; # Output XML Response as Array

        } catch (Exception $e) {

            $errorMsg = $e->getMessage();

        }

    }



    /*

      Debug Output - Uncomment if needed to troubleshoot problems

      echo "<textarea rows=50 cols=100>Request: ".print_r($postfields,true);

      echo "\nResponse: ".htmlentities($xml)."\n\nArray: ".print_r($arr,true);

      echo "</textarea>";

     */



    private static function whmcsapi_xml_parser($rawxml) {

        $xml_parser = xml_parser_create();

        xml_parse_into_struct($xml_parser, $rawxml, $vals, $index);

        xml_parser_free($xml_parser);

        $params = array();

        $level = array();

        $alreadyused = array();

        $x = 0;

        foreach ($vals as $xml_elem) {

            if ($xml_elem['type'] == 'open') {

                if (in_array($xml_elem['tag'], $alreadyused)) {

                    $x++;

                    $xml_elem['tag'] = $xml_elem['tag'] . $x;

                }

                $level[$xml_elem['level']] = $xml_elem['tag'];

                $alreadyused[] = $xml_elem['tag'];

            }

            if ($xml_elem['type'] == 'complete') {

                $start_level = 1;

                $php_stmt = '$params';

                while ($start_level < $xml_elem['level']) {

                    $php_stmt .= '[$level[' . $start_level . ']]';

                    $start_level++;

                }

                $php_stmt .= '[$xml_elem[\'tag\']] = $xml_elem[\'value\'];';

                @eval($php_stmt);

            }

        }

        return($params);

    }



    /**

     * Validate Header information

     * @param type $sign

     * @param type $secretKey

     * @return type

     */

    public function validateHeaderVal($sign, $secretKey) {

        if (!function_exists('apache_request_headers')) {



            function apache_request_headers() {

                $arh = array();

                $rx_http = '/\AHTTP_/';

                foreach ($_SERVER as $key => $val) {

                    if (preg_match($rx_http, $key)) {

                        $arh_key = preg_replace($rx_http, '', $key);

                        $rx_matches = array();

                        // do some nasty string manipulations to restore the original letter case

                        // this should work in most cases

                        $rx_matches = explode('_', $arh_key);

                        if (count($rx_matches) > 0 and strlen($arh_key) > 2) {

                            foreach ($rx_matches as $ak_key => $ak_val)

                                $rx_matches[$ak_key] = ucfirst(strtolower($ak_val));

                            $arh_key = implode('-', $rx_matches);

                        }

                        $arh[$arh_key] = $val;

                    }

                }

                return($arh);

            }

        }

        

        $headers = apache_request_headers();



        $result = array('status' => 0, 'Message' => 'Invalid Security Key');

        $hashval = $sign . "" . $secretKey;

        $expected_hashValue = hash('sha512', $hashval);

        $found = false;

        foreach ($headers as $header => $value) {

            if (!$found) {

                if (strtolower($header) == strtolower("UpperlinkAuth")) {

                    $sent_hashValue = $value;

                    $found = true;

                }

            }

        }

        

        if (!$found) {

            $result = array('status' => 0, 'Message' => 'Unknown/Empty Security Key');

        } else {

            if ($expected_hashValue == $sent_hashValue) {

                $result = array('status' => 1);

            }

        }

        return($result);

    }


    public static function array_to_xml($student_info, &$xml_student_info=null) {
        $xml_student_info = new SimpleXMLElement("<?xml version=\"1.0\"?><student_info></student_info>");
        //print_r($student_info);
        foreach($student_info as $key => $value) {
            if(is_array($value)) {
                $key = is_numeric($key) ? "item$key" : $key;
                $subnode = $xml_student_info->addChild("$key");
                //$this->array_to_xml($value, $subnode);
            }
            else {
                $key = is_numeric($key) ? "item$key" : $key;
                $xml_student_info->addChild("$key","$value");
            }
        }
        return $xml_student_info;
    }

    public static function verify_signature($params, $signature){

    }
}



