{include file="$template/includes/tablelist.tpl" tableName="ServicesList" filterColumn="1" noSortColumns="0,5"}
<script type="text/javascript">
    jQuery(document).ready( function ()
    {
        var table = jQuery('#tableServicesList').removeClass('hidden').DataTable();
        {if $orderby == 'product'}
            table.order([1, '{$sort}'], [4, 'asc']);
        {elseif $orderby == 'amount' || $orderby == 'billingcycle'}
            table.order(2, '{$sort}');
        {elseif $orderby == 'nextduedate'}
            table.order(3, '{$sort}');
        {elseif $orderby == 'domainstatus'}
            table.order(4, '{$sort}');
        {/if}
        table.draw();
        jQuery('#tableLoading').addClass('hidden');
    });
</script>

{include file="$template/pageheader.tpl" title=$LANG.clientareaproducts desc=$LANG.clientareaproductsintro icon=layers}

<div class="panel panel-default panel-datatable">

  <div class="panel-heading clearfix"> {include file="$template/includes/sidebar.tpl" sidebar=$primarySidebar}</div>

    <table id="tableServicesList" class="table table-list hidden">
        <thead>
            <tr>
                <th></th>
                <th>{$LANG.clientareastatus}</th>
                <th>{$LANG.orderproduct}</th>
                <th class="hidden-xs">{$LANG.clientareaaddonpricing}</th>
                <th class="hidden-sm hidden-xs">{$LANG.clientareahostingnextduedate}</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            {foreach key=num item=service from=$services}
                <tr>
                    <td class="ssl {if $service.sslStatus} ssl-info{/if}" data-element-id="{$service.id}" data-type="service"{if $service.domain} data-domain="{$service.domain}"{/if}>
                    {if $service.sslStatus}
                    <img src="{$service.sslStatus->getImagePath()}" data-toggle="tooltip" title="{$service.sslStatus->getTooltipContent()}" class="{$service.sslStatus->getClass()}"/>
                    {elseif !$service.isActive}
                    <img src="{$BASE_PATH_IMG}/ssl/ssl-inactive-domain.png" data-toggle="tooltip" title="{lang key='sslState.sslInactiveService'}">
                    {/if}
                    </td>
       	            <td><span class="label status status-{$service.status|strtolower}">{$service.statustext}</span></td>
                    <td><a href="clientarea.php?action=productdetails&amp;id={$service.id}">{$service.product}</a>{if $service.domain}<br><a href="http://{$service.domain}" target="_blank">{$service.domain}</a>{/if}
                    <ul class="cell-inner-list visible-sm visible-xs">
                    <li><span class="item-title">{$LANG.orderbillingcycle} : </span>{$service.billingcycle}</li>
                    <li><span class="item-title">{$LANG.clientareahostingnextduedate}</span> : {$service.nextduedate}</li>
                    <li class="hidden-sm"><span class="item-title">{$LANG.orderprice} : </span>{$service.amount}</li>
                    </ul>
                    </td>
                    <td data-order="{$service.amountnum}" class="hidden-xs">{$service.amount}<br>{$service.billingcycle}</td>
                    <td class="hidden-sm hidden-xs"><span class="hidden">{$service.normalisedNextDueDate}</span>{$service.nextduedate}</td>
                    <td class="text-right"><a class="btn btn-link" href="clientarea.php?action=productdetails&amp;id={$service.id}"><i class="fas fa-chevron-right fa-lg pull-right flip"></i></a>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
    <div class="text-center" id="tableLoading">
        <p><i class="fas fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>
    <div class="clearfix"></div>
</div>
